/*RPCemu v0.5 by Tom Walker
  System coprocessor + MMU emulation*/
#include "rpcemu.h"

int indumpregs;
//unsigned long oldpc,oldpc2,oldpc3;
int timetolive;

uint32_t ins;
uint32_t tlbcache[16384],tlbcache2[64];
int tlbcachepos;
int tlbs,flushes;
uint32_t pccache,readcache,writecache;
uint32_t opcode;
struct cp15
{
        uint32_t tlbbase,dacr;
        uint32_t far,fsr,ctrl;
} cp15;

void resetcp15(void)
{
        int c;
        prog32=1;
        mmu=0;
        memset(tlbcache,0xFF,16384*4);
        for (c=0;c<64;c++)
            tlbcache2[c]=0xFFFFFFFF;
        tlbcachepos=0;
        for (c=0;c<256;c++)
            raddrl[c]=0xFFFFFFFF;
        waddrl=0xFFFFFFFF;
}

int translations=0;
uint32_t lastcache;
static uint32_t *tlbram;
uint32_t tlbrammask;

void writecp15(uint32_t addr, uint32_t val)
{
        int c;
        switch (addr&15)
        {
                case 1: /*Control*/
                cp15.ctrl=val;
                mmu=val&1;
                if (!mmu)
                {
                        for (c=0;c<256;c++)
                            raddrl[c]=0xFFFFFFFF;
                        waddrl=0xFFFFFFFF;
                }
                prog32=val&0x10;
                if (!prog32 && (mode&16))
                {
                        updatemode(mode&15);
                }
                printf("CP15 control write %08X %08X\n",val,PC);
                return; /*We can probably ignore all other bits*/
                case 2: /*TLB base*/
                cp15.tlbbase=val&~0x3FFF;
                memset(raddrl,0xFF,1024);
//                for (c=0;c<256;c++)
//                    raddrl[c]=0xFFFFFFFF;
                waddrl=0xFFFFFFFF;
                switch (cp15.tlbbase&0x1F000000)
                {
                        case 0x02000000: /*VRAM - yes RiscOS 3.7 does put the TLB in VRAM at one point*/
                        tlbram=vram; tlbrammask=vrammask>>2; break;
                        case 0x10000000: /*SIMM 0 bank 0*/
                        case 0x11000000:
                        case 0x12000000:
                        case 0x13000000:
                        tlbram=ram; tlbrammask=rammask>>2; break;
                        case 0x14000000: /*SIMM 0 bank 1*/
                        case 0x15000000:
                        case 0x16000000:
                        case 0x17000000:
                        tlbram=ram2; tlbrammask=rammask>>2; break;
                }
//                printf("CP15 tlb base now %08X\n",cp15.tlbbase);
                return;
                case 3: /*Domain access control*/
                cp15.dacr=val;
//                printf("CP15 DACR now %08X\n",cp15.dacr);
                return;
                case 8: /*Flush TLB (SA110)*/
//                if (model==3) rpclog("TLB purge %08X %01X %i\n",val,opcode&0xF,(opcode>>5)&7);
                case 6: /*Purge TLB*/
                case 5: /*Flush TLB*/
//                rpclog("TLB flush %08X %08X %07X %i %i %08X\n",addr,val,PC,ins,translations,lastcache);
                clearmemcache();
                pccache=readcache=writecache=0xFFFFFFFF;
                memset(raddrl,0xFF,1024);
//                for (c=0;c<256;c++)
//                    raddrl[c]=0xFFFFFFFF;
                waddrl=0xFFFFFFFF;
                for (c=0;c<64;c++)
                {
                        if (tlbcache2[c]!=0xFFFFFFFF)
                           tlbcache[tlbcache2[c]]=0xFFFFFFFF;
                }
                memset(tlbcache2,0xFF,256);
//                for (c=0;c<64;c++)
//                    tlbcache2[c]=0xFFFFFFFF;
                flushes++;
                tlbcachepos=0;
/*                if (!translations) return;
                if (translations==1)
                   tlbcache[lastcache>>12]=0xFFFFFFFF;
                else
                {
                        memset(tlbcache,0xFF,16384*4);
                        flushes++;
                }
                translations=0;
//                for (c=0;c<16384;c++)
//                    tlbcache[c]=0xFFFFFFFF;*/
                return;
                case 7: /*Invalidate cache*/
//                rpclog("Cache invalidate %08X\n",PC);
                pccache=readcache=writecache=0xFFFFFFFF;
                memset(raddrl,0xFF,1024);
//                for (c=0;c<256;c++)
//                    raddrl[c]=0xFFFFFFFF;
                waddrl=0xFFFFFFFF;
                return;
        }
//        error("Bad write CP15 %08X %08X %07X\n",addr,val,PC);
//        dumpregs();
//        exit(-1);
}

uint32_t readcp15(uint32_t addr)
{
        switch (addr&15)
        {
                case 0: /*ARM ID*/
                switch (model)
                {
                        case 0: return 0x41007100; /*ARM7500*/
                        case 1: return 0x41560610; /*ARM610*/
                        case 2: return 0x41567100; /*ARM710*/
                        case 3: /*if (PC>0x10000000) output=1; */return 0x4401A100; /*SA110*/
//                      case 3: return 0x4456A100; /*StrongARM*/
                }
                break;
                case 1: /*Control*/
                return cp15.ctrl;
                case 2: /*???*/
                return cp15.tlbbase;
                case 3: /*DACR*/
                return cp15.dacr;
                case 5: /*Fault status*/
                printf("Fault status read %08X\n",cp15.fsr);
                return cp15.fsr;
                case 6: /*Fault address*/
                printf("Fault address read %08X\n",cp15.far);
                return cp15.far;
        }
        error("Bad read CP15 %08X %07X\n",addr,PC);
        dumpregs();
        exit(-1);
}

/*DOMAIN -
  No access - fault
  Client - checkpermissions
  Manager - always allow*/
//54F13001
//1010042e
//databort=1;
#define FAULT()         armirq|=0x40;        \
                        if (!prefetch) \
                        { \
                                cp15.far=addr;       \
                                cp15.fsr=fsr;        \
                        } \
                        if (0) printf("PERMISSIONS FAULT! %08X %07X %08X %08X %08X %08X %i %03X %08X %08X %08X %08X\n",addr,PC,opcode,oldpc,oldpc2,oldpc3,p,cp15.ctrl&0x300,fld,sld,armregs[16],cp15.dacr);  \
                        return 0xFFFFFFFF

int checkpermissions(int p, int fsr, int rw, uint32_t addr, uint32_t fld, uint32_t sld, int prefetch)
{
        switch (p)
        {
                case 0:
                switch (cp15.ctrl&0x300)
                {
                        case 0x000: /*No access*/
                        case 0x300: /*Unpredictable*/
                        if (output) rpclog("Always fault\n");
                        FAULT();
                        case 0x100: /*Supervisor read-only*/
//                        break; /*delibrately broken for Linux*/
                        /*Linux will crash very early on if this is implemented properly*/
                        if (!memmode || rw) { if (output) rpclog("Supervisor read only\n"); FAULT(); }
                        break;
                        case 0x200: /*Read-only*/
                        if (rw) { if (output) rpclog("Read only\n"); FAULT(); }
                        break;
                }
                break;
                case 1: /*Supervisor only*/
//                break;
                if (!memmode) { if (output) rpclog("Supervisor only\n"); FAULT(); }
                break;
                case 2: /*User read-only*/
                if (!memmode && rw) { if (output) rpclog("Read only\n"); FAULT(); }
                break;
        }
        return 0;
}

int checkdomain(uint32_t addr, int domain, int type, int prefetch)
{
        int temp=cp15.dacr>>(domain<<1);
        if (!(temp&3))
        {
                armirq|=0x40;
//                printf("Domain fault! %08X %i %i %i %08X\n",addr,domain,type,prefetch,temp);
                if (prefetch) return 0;
                cp15.far=addr;
                cp15.fsr=(type==1)?11:9;
//                rpclog("Domain fault\n");
        }
        return temp&3;
}

uint32_t translateaddress2(uint32_t addr, int rw, int prefetch)
{
        uint32_t vaddr=((addr>>18)&~3)|cp15.tlbbase;
        uint32_t fld;
        uint32_t sldaddr,sld; //,taddr;
        uint32_t oa=addr;
        int temp,temp2,temp3;
//        rpclog("Translate %08X ",addr);
/*        if (!(addr&0xFC000000) && !(tlbcache[(addr>>12)&0x3FFF]&0xFFF))
        {
//                rpclog("Cached %08X\n",tlbcache[addr>>12]);
                return tlbcache[addr>>12]|(addr&0xFFF);
        }*/
        translations++;
//        rpclog("Uncached ");
        tlbs++;

        rw = rw;
        fld=tlbram[(vaddr>>2)&tlbrammask];
        if (fld&3) temp3=checkdomain(addr,(fld>>5)&15,fld&3,prefetch);
        switch (fld&3)
        {
                case 0: /*Fault*/
                armirq|=0x40;
                if (prefetch) return 0;
                cp15.far=addr;
                cp15.fsr=5;
//                printf("Fault! %08X %07X %i\n",addr,PC,rw);
//                exit(-1);
                return 0;
                case 1: /*Page table*/
                if (!temp3) return 0;
                sldaddr=((addr&0xFF000)>>10)|(fld&0xFFFFFC00);
                if ((sldaddr&0x1F000000)==0x02000000)
                   sld=vram[(sldaddr&vrammask)>>2];
                else if (sldaddr&0x4000000)
                   sld=ram2[(sldaddr&rammask)>>2];
                else
                   sld=ram[(sldaddr&rammask)>>2];
                if (!(sld&3)) /*Unmapped*/
                {
                        armirq|=0x40;
                        if (prefetch) return 0;
                        cp15.far=addr;
                        cp15.fsr=7|((fld>>1)&0xF0);
//                        printf("Unmapped! %08X %07X %i\n",addr,PC,ins);
//                        output=1;
//                        timetolive=100;
//                        dumpregs();
//                        exit(-1);
                        return 0;
                }
                temp=(addr&0xC00)>>9;
                temp2=sld&(0x30<<temp);
                temp2>>=(4+temp);
                if (temp3!=3)
                {
                        if (checkpermissions(temp2,15,rw,addr,fld,sld,prefetch))
                           return 0xFFFFFFFF;
                }
                addr=(sld&0xFFFFF000)|(addr&0xFFF);
                if (!(oa&0xFC000000))
                {
                        if (tlbcache2[tlbcachepos]!=0xFFFFFFFF)
                           tlbcache[tlbcache2[tlbcachepos]]=0xFFFFFFFF;
                        tlbcache2[tlbcachepos]=oa>>12;
                        tlbcache[oa>>12]=sld&0xFFFFF000;
                        lastcache=oa>>12;
//                        rpclog("Cached to %08X %08X %08X %i  ",oa>>12,tlbcache[oa>>12],tlbcache2[tlbcachepos],tlbcachepos);
                        tlbcachepos=(tlbcachepos+1)&63;
                }
//                rpclog("%08X %08X %08X %08X\n",addr,sld,oa,tlbcache[oa>>12]);
                return addr;
                case 2: /*Section*/
                if (!temp3) return 0;
                if (temp3!=3)
                {
                        if (checkpermissions((fld&0xC00)>>10,13,rw,addr,fld,0xFFFFFFFF,prefetch))
                           return 0xFFFFFFFF;
                }
                addr=(addr&0xFFFFF)|(fld&0xFFF00000);
                if (!(oa&0xFC000000))
                {
                        if (tlbcache2[tlbcachepos]!=0xFFFFFFFF)
                           tlbcache[tlbcache2[tlbcachepos]]=0xFFFFFFFF;
                        tlbcache2[tlbcachepos]=oa>>12;
                        tlbcache[oa>>12]=addr&0xFFFFF000;//sld&0xFFFFF000;
                        lastcache=oa>>12;
                        tlbcachepos=(tlbcachepos+1)&63;
//                        rpclog("Cached to %08X %08X %08X %i  ",oa>>12,tlbcache[oa>>12],tlbcache2[tlbcachepos],tlbcachepos);
/*                        tlbcache[oa>>12]=addr&0xFFFFF000;
                        lastcache=oa>>12;*/
                }
//                rpclog("%08X %08X %08X %08X\n",addr,oa,tlbcache[oa>>12],fld);
                return addr;
                default:
                error("Bad descriptor type %i %08X\n",fld&3,fld);
                error("Address %08X\n",addr);
                dumpregs();
                exit(-1);
        }
        exit(-1);
}

/*uint32_t translateaddress(uint32_t addr, int rw)
{
        if (!(addr&0xFC000000) && !(tlbcache[(addr>>12)&0x3FFF]&0xFFF))
        {
//                rpclog("Cached %08X\n",tlbcache[addr>>12]);
                return tlbcache[addr>>12]|(addr&0xFFF);
        }
        return translateaddress2(addr,rw);
}*/


uint32_t *getpccache(uint32_t addr)
{
        uint32_t addr2;
        addr&=~0xFFF;
        if (mmu)
        {
//                if (indumpregs) rpclog("Translate prefetch %08X %02X ",addr,armirq);
                addr2=translateaddress(addr,0,1);
                if (armirq&0x40)
                {
//                        if (indumpregs) rpclog("Abort!\n");
                        armirq&=~0x40;
                        armirq|=0x80;
//                        databort=0;
//                        prefabort=1;
                        return (uint32_t *)0xFFFFFFFF;
                }
//                if (indumpregs) rpclog("\n");
        }
        else     addr2=addr;
        switch (addr2&0x1F000000)
        {
                case 0x00000000: /*ROM*/
                return &rom[((long)(addr2&0x7FF000)-(long)addr)>>2];
                case 0x02000000: /*VRAM*/
                return &vram[((long)(addr2&0x1FF000)-(long)addr)>>2];
                case 0x10000000: /*SIMM 0 bank 0*/
                case 0x11000000:
                case 0x12000000:
                case 0x13000000:
//                printf("SIMM0 r %08X %08X %07X\n",addr,ram[(addr&0x3FFFFF)>>2],PC);
                return &ram[((long)(addr2&rammask)-(long)addr)>>2];
                case 0x14000000: /*SIMM 0 bank 1*/
                case 0x15000000:
                case 0x16000000:
                case 0x17000000:
//                printf("SIMM0 r %08X %08X %07X\n",addr,ram[(addr&0x3FFFFF)>>2],PC);
                return &ram2[((long)(addr2&rammask)-(long)addr)>>2];
        }
        error("Bad PC %08X %08X\n",addr,addr2);
        dumpregs();
        exit(-1);
}
