/*RPCemu v0.5 by Tom Walker
  FPA emulation
  Not enabled by default due to incompleteness*/

#include "rpcemu.h"

double fparegs[8]; /*No C variable type for 80-bit floating point, so use 64*/
unsigned long fpsr,fpcr;

void resetfpa()
{
        fpsr=0x81000000; /*FPA system*/
        fpcr=0;
}

#define FD ((opcode>>12)&7)
#define RD ((opcode>>12)&0xF)
#define RN ((opcode>>16)&0xF)
#define RM (opcode&0xF)

/*Instruction types :
  Opcodes Cx/Dx, CP1 - LDF/STF
  Opcodes Cx/Dx, CP2 - LFM/SFM
  Opcodes Ex, bit 4 clear - Data processing
  Opcodes Ex, bit 4 set   - Register transfer
  Opcodex Ex, bit 4 set, RD=15 - Compare*/
void fpaopcode(unsigned long opcode)
{
        unsigned long temp[3];
        double *tf;
        int len;
        unsigned long addr,offset;
        tf=(double *)&temp[0];
        rpclog("FPA op %08X %08X\n",opcode,PC);
        switch ((opcode>>24)&0xF)
        {
                case 0xC: case 0xD:
                if (opcode&0x100) /*LDF/STF*/
                {
                        switch (opcode&0x408000)
                        {
                                case 0x400000: /*Long*/
                                *tf=fparegs[FD];
                                temp[2]=0;
                                len=3;
                                break;
                                default:
                                error("Bad LDF/STF size %08X %08X\n",opcode&0x408000,opcode);
                                exit(-1);
                        }
                        addr=armregs[RN];
                        offset=(opcode&0xFF)<<2;
                        if (opcode&0x1000000)
                        {
                                if (opcode&0x800000) addr+=offset;
                                else                 addr-=offset;
                        }
                        if (opcode&0x100000)
                        {
                                temp[0]=readmeml(addr);
                                if (len>1) temp[1]=readmeml(addr+4);
                                if (len>2) temp[2]=readmeml(addr+8);
                                switch (opcode&0x408000)
                                {
                                        case 0x400000: /*Long*/
                                        fparegs[FD]=*tf;
                                        rpclog("F%i = %f\n",FD,(double)fparegs[FD]);
                                        break;
                                }
                        }
                        else
                        {
                                writememl(addr,temp[0]);
                                if (len>1) writememl(addr+4,temp[1]);
                                if (len>2) writememl(addr+8,temp[2]);
                        }
                        if (!(opcode&0x1000000))
                        {
                                if (opcode&0x800000) addr+=offset;
                                else                 addr-=offset;
                                armregs[RN]=addr;
                        }
                        else if (addr&0x200000) armregs[RN]=addr;
                        return;
                }
                /*LFM/SFM*/
                error("LDM/STM opcode %08X\n",opcode);
                exit(-1);
                return;
                case 0xE:
                if (opcode&0x10)
                {
                        if (RD==15 && opcode&0x100000) /*Compare*/
                        {
                                error("Compare opcode %08X\n",opcode);
                                exit(-1);
                                return;
                        }
                        /*Register transfer*/
                        switch ((opcode>>20)&0xF)
                        {
                                case 2: /*WFS*/
                                fpsr=(armregs[RD]&0xFFFFFF)|(fpsr&0xFF000000);
                                return;
                                case 3: /*RFS*/
                                armregs[RD]=fpsr;
                                return;
                                case 4: /*WFC*/
                                fpcr=(fpcr&~0xD00)|(armregs[RD]&0xD00);
                                return;
                                case 5: /*RFC*/
                                armregs[RD]=fpcr;
                                return;
                        }
                        error("Register opcode %08X\n",opcode);
                        exit(-1);
                        return;
                }
                /*Data processing*/
                error("Data opcode %08X\n",opcode);
                exit(-1);
                return;
        }
}
