/*RPCemu v0.5 by Tom Walker
  Main loop*/

#include <allegro.h>
#include "rpcemu.h"

#define MB_OK 1
static void MessageBox(void *param, const char *message, 
		       const char *title, int type) {
  printf("MessageBox: %s %s\n", title, message);
}



int mousecapture=0;
float mips;
int updatemips=0;

static uint32_t mipscount;
float mipstotal;

static void domips(void)
{
        mips=(float)inscount/1000000.0f;
	mipscount += 1;
	if (mipscount > 10)
	  mipstotal += mips;
        inscount=0;
        updatemips=1;
}

void error(const char *format, ...)
{
   char buf[256];

   va_list ap;
   va_start(ap, format);
   vsprintf(buf, format, ap);
   va_end(ap);
   MessageBox(NULL,buf,"RPCemu error",MB_OK);;
}

FILE *arclog;
void rpclog(const char *format, ...)
{
   char buf[256];
return;
   va_list ap;
   va_start(ap, format);
   vsprintf(buf, format, ap);
   va_end(ap);
   fputs(buf,arclog);
}

int drawscre=0,flyback;

void sndupdate(void)
{
        iomd.state|=0x10;
        updateirqs();
        iomd.sndstat ^= 1;
        iomd.sndstat |= 6;
}

void vblupdate(void)
{
        drawscre=1;
//        iomdvsync();
        flyback=20;
}
void vblupdate2(void)
{
//        drawscre=1;
//        flyback=0;
}

void updatewindowsize(uint32_t x, uint32_t y)
{
  printf("updatewindowsize: %u %u\n", x, y);

  set_gfx_mode(GRAPHICS_TYPE, x, y, 0, 0);
}

void releasemousecapture()
{
}

char discname[2][260];

void updatemenu()
{
}

void resetrpc()
{
        memset(ram,0,rammask+1);
        resetcp15();
        resetarm();
        resetkeyboard();
        resetiomd();
        reseti2c();
        resetide();
        reset82c711();
}

int main (void) 

{
        int quited=0;
        char s[128];
        const char *p;
        char fn[512];

        allegro_init();
        install_keyboard();
        install_timer();
        install_mouse();
	if (startrpcemu())
	   return -1;
        install_int_ex(domips,MSEC_TO_TIMER(1000));
        install_int_ex(vblupdate,BPS_TO_TIMER(60));
        install_int_ex(sndupdate,BPS_TO_TIMER(100));
        while (!quited)
        {
		execrpcemu();
                        if (updatemips && mipscount > 10)
                        {                           
			  printf("MIPS: %f (AVG: %f)\n", mips, mipstotal / (mipscount - 10));
                                updatemips=0;
                        }
        }
	endrpcemu();
        return 0;
}


void changedisc(int drive)
{
	puts("changedisc");
}

