/*RPCemu v0.2 by Tom Walker
  VIDC20 emulation*/
#include <allegro.h>
#include "rpc.h"

int readflash;
int palchange;
float mips;
BITMAP *b;
int deskdepth;
int oldsx,oldsy;
RGB cursor[3];
void initvideo()
{
        int depth;
        depth=deskdepth=desktop_color_depth();
        if (depth==16)
        {
                set_color_depth(16);
                if (set_gfx_mode(GFX_AUTODETECT_WINDOWED,1024,768,0,0))
                {
                        set_color_depth(15);
                        depth=15;
                        set_gfx_mode(GFX_AUTODETECT_WINDOWED,1024,768,0,0);
                }
        }
        else if (depth)
        {
                set_color_depth(depth);
                set_gfx_mode(GFX_AUTODETECT_WINDOWED,1024,768,0,0);
        }
        else
           set_gfx_mode(GFX_AUTODETECT_WINDOWED,1024,768,0,0);
        set_color_depth(8);
//        if (depth!=15) set_color_depth(16);
//        else           set_color_depth(15);
        b=create_bitmap(1024,768);
        oldsx=640;
        oldsy=480;
}

int palindex;
PALETTE pal;

unsigned long hdsr,hcsr,hder;
unsigned long vdsr,vcsr,vcer,vder;
int bit8;

void resizedisplay(int x, int y)
{
        if (x<16) x=16;
        if (y<16) y=16;
        if (x>1024) x=1024;
        if (y>768) y=768;
        oldsx=x;
        oldsy=y;
        updatewindowsize(x,y);
}

int ony,ocy;
void drawscr()
{
        int x,y,xx;
        int xs=hder-hdsr;
        int ys=vder-vdsr;
        int addr=iomd.vidinit&0xFFFFF;
        int cx=hcsr-hdsr;
        int cy=vcsr-vdsr,ny=vcer-vcsr;
        int ac=0;
        int drawit=0;
        int yl=-1,yh;
        if (xs<2) xs=2;
        if (ys<1) ys=1;
        if (ys!=oldsy || xs!=oldsx) resizedisplay(xs,ys);
        int cursorcol[3];
        drawit=dirtybuffer[addr>>10];
        dirtybuffer[addr>>10]=0;
        if (drawit) yl=0;
        switch (bit8)
        {
                case 1: /*2 bpp*/
                for (y=0;y<ys;y++)
                {
                        if (y<(ony+ocy) && (y>=(ocy-2))) 
                        {
                                drawit=1;
                                yh=y+8;
                                if (yl==-1)
                                   yl=y;
                        }
                        for (x=0;x<xs;x+=64)
                        {
                                if (drawit)
                                {
                                for (xx=0;xx<64;xx+=16)
                                {
                                        b->line[y][x+xx]=ramb[addr]&3;
                                        b->line[y][x+xx+1]=(ramb[addr]>>2)&3;
                                        b->line[y][x+xx+2]=(ramb[addr]>>4)&3;
                                        b->line[y][x+xx+3]=(ramb[addr]>>6)&3;
                                        b->line[y][x+xx+4]=ramb[addr+1]&3;
                                        b->line[y][x+xx+5]=(ramb[addr+1]>>2)&3;
                                        b->line[y][x+xx+6]=(ramb[addr+1]>>4)&3;
                                        b->line[y][x+xx+7]=(ramb[addr+1]>>6)&3;
                                        b->line[y][x+xx+8]=ramb[addr+2]&3;
                                        b->line[y][x+xx+9]=(ramb[addr+2]>>2)&3;
                                        b->line[y][x+xx+10]=(ramb[addr+2]>>4)&3;
                                        b->line[y][x+xx+11]=(ramb[addr+2]>>6)&3;
                                        b->line[y][x+xx+12]=ramb[addr+3]&3;
                                        b->line[y][x+xx+13]=(ramb[addr+3]>>2)&3;
                                        b->line[y][x+xx+14]=(ramb[addr+3]>>4)&3;
                                        b->line[y][x+xx+15]=(ramb[addr+3]>>6)&3;
                                        addr+=4;
                                }
                                }
                                else
                                   addr+=16;
                                if (addr>iomd.vidend) addr=iomd.vidstart;
                                if (!(addr&0x3FF))
                                {
                                        drawit=dirtybuffer[(addr>>10)];
                                        if (y<(ony+ocy) && (y>=(ocy-2))) drawit=1;
                                        dirtybuffer[(addr>>10)]=0;
                                        if (drawit) yh=y+8;
                                        if (yl==-1 && drawit)
                                           yl=y;
                                }
                        }
                }
                break;
                case 3: /*8 bpp*/
                for (y=0;y<ys;y++)
                {
                        if (y<(ony+ocy) && (y>=(ocy-2))) 
                        {
                                drawit=1;
                                yh=y+8;
                                if (yl==-1)
                                   yl=y;
                        }
                        for (x=0;x<xs;x+=16)
                        {
                                if (drawit)
                                {
                                for (xx=0;xx<16;xx+=4)
                                {
                                        b->line[y][x+xx]=ramb[addr]&0xFF;
                                        b->line[y][x+xx+1]=ramb[addr+1]&0xFF;
                                        b->line[y][x+xx+2]=ramb[addr+2]&0xFF;
                                        b->line[y][x+xx+3]=ramb[addr+3]&0xFF;
                                        addr+=4;
                                }
                                }
                                else
                                   addr+=16;
                                if (addr>iomd.vidend) addr=iomd.vidstart;
                                if (!(addr&0x3FF))
                                {
                                        drawit=dirtybuffer[(addr>>10)];
                                        if (y<(ony+ocy) && (y>=(ocy-2))) drawit=1;
                                        dirtybuffer[(addr>>10)]=0;
                                        if (drawit) yh=y+8;
                                        if (yl==-1 && drawit)
                                           yl=y;
                                }
                        }
                }
                break;
                default:
                for (y=0;y<ys;y++)
                {
                        if (y<(ony+ocy) && (y>=(ocy-2))) 
                        {
                                drawit=1;
                                yh=y+8;
                                if (yl==-1)
                                   yl=y;
                        }
                        for (x=0;x<xs;x+=32)
                        {
                                if (drawit)
                                {
                                for (xx=0;xx<32;xx+=8)
                                {
                                        b->line[y][x+xx]=ramb[addr]&0xF;
                                        b->line[y][x+xx+1]=(ramb[addr]>>4)&0xF;
                                        b->line[y][x+xx+2]=ramb[addr+1]&0xF;
                                        b->line[y][x+xx+3]=(ramb[addr+1]>>4)&0xF;
                                        b->line[y][x+xx+4]=ramb[addr+2]&0xF;
                                        b->line[y][x+xx+5]=(ramb[addr+2]>>4)&0xF;
                                        b->line[y][x+xx+6]=ramb[addr+3]&0xF;
                                        b->line[y][x+xx+7]=(ramb[addr+3]>>4)&0xF;
                                        addr+=4;
                                }
                                }
                                else
                                   addr+=16;
                                if (addr>iomd.vidend) addr=iomd.vidstart;
                                if (!(addr&0x3FF))
                                {
                                        drawit=dirtybuffer[(addr>>10)];
                                        if (y<(ony+ocy) && (y>=(ocy-2))) drawit=1;
                                        dirtybuffer[(addr>>10)]=0;
                                        if (drawit) yh=y+8;
                                        if (yl==-1 && drawit)
                                           yl=y;
                                }
                        }
                }
                break;
        }
        if (ny>1)
        {
                addr=cinit&0xFFFFF0;
                cursorcol[1]=makecol(cursor[0].r,cursor[0].g,cursor[0].b);
                cursorcol[2]=makecol(cursor[1].r,cursor[1].g,cursor[1].b);
                cursorcol[3]=makecol(cursor[2].r,cursor[2].g,cursor[2].b);
                for (y=0;y<ny;y++)
                {
                        if (y>=ys) break;
                        for (x=0;x<32;x+=4)
                        {
                                if (ramb[addr]&3)      b->line[y+cy][x+cx]=cursorcol[ramb[addr]&3];
                                if ((ramb[addr]>>2)&3) b->line[y+cy][x+cx+1]=cursorcol[(ramb[addr]>>2)&3];
                                if ((ramb[addr]>>4)&3) b->line[y+cy][x+cx+2]=cursorcol[(ramb[addr]>>4)&3];
                                if ((ramb[addr]>>6)&3) b->line[y+cy][x+cx+3]=cursorcol[(ramb[addr]>>6)&3];
                                addr++;
                        }
                }
                if (yl>cy) yl=cy;
                if (yl==-1) yl=cy;
                if (cy<0) yl=0;
                if (yh<(ny+cy)) yh=ny+cy;
        }
        if (readflash)
        {
                rectfill(screen,xs-40,4,xs-8,11,readflash);
                readflash=0;
        }
        else
           blit(b,screen,xs-40,4,xs-40,4,xs-8,11);
        if (yh>ys) yh=ys;
//        printf("Cursor %i %i %i\n",cx,cy,ny);
//        textprintf(b,font,0,472,makecol(255,255,255),"%f MIPS     ",mips);
        blit(b,screen,0,yl,0,yl,xs,yh-yl);
        if (palchange)
        {
                if (bit8!=3)
                {
                        pal[16]=cursor[0];
                        pal[17]=cursor[1];
                        pal[18]=cursor[2];                                                
                }
                set_palette(pal);
        }
        ony=ny;
        ocy=cy;
//        printf("%i %i %i - ",hdsr,hder,hder-hdsr);
//        printf("%i %i %i\n",vdsr,vder,vder-vdsr);
}

void writevidc20(unsigned long val)
{
        switch (val>>24)
        {
                case 0:
//                printf("Palette %i = %08X\n",palindex,val);
                pal[palindex].r=(val&0xFF)>>2;
                pal[palindex].g=(val&0xFF00)>>10;
                pal[palindex].b=(val&0xFF0000)>>18;
                palindex++;
                palindex&=255;
                palchange=1;
                break;
                case 0x10:
                palindex=val&255;
                break;
                case 0x50: case 0x51: case 0x52: case 0x53:
                case 0x54: case 0x55: case 0x56: case 0x57:
                case 0x58: case 0x59: case 0x5A: case 0x5B:
                case 0x5C: case 0x5D: case 0x5E: case 0x5F:
                cursor[0].r=val&0xFF;
                cursor[0].g=(val>>8)&0xFF;
                cursor[0].b=(val>>16)&0xFF;
                palchange=1;
                break;
                case 0x60: case 0x61: case 0x62: case 0x63:
                case 0x64: case 0x65: case 0x66: case 0x67:
                case 0x68: case 0x69: case 0x6A: case 0x6B:
                case 0x6C: case 0x6D: case 0x6E: case 0x6F:
                cursor[1].r=val&0xFF;
                cursor[1].g=(val>>8)&0xFF;
                cursor[1].b=(val>>16)&0xFF;
                palchange=1;                
                break;
                case 0x70: case 0x71: case 0x72: case 0x73:
                case 0x74: case 0x75: case 0x76: case 0x77:
                case 0x78: case 0x79: case 0x7A: case 0x7B:
                case 0x7C: case 0x7D: case 0x7E: case 0x7F:
                cursor[2].r=val&0xFF;
                cursor[2].g=(val>>8)&0xFF;
                cursor[2].b=(val>>16)&0xFF;
                palchange=1;                
                break;
                case 0x83:
                hdsr=val&0xFFE;
                break;
                case 0x84:
                hder=val&0xFFE;
                break;
                case 0x86:
                hcsr=val&0xFFE;
                break;
                case 0x93:
                vdsr=val&0xFFF;
                break;
                case 0x94:
                vder=val&0xFFF;
                break;
                case 0x96:
                vcsr=val&0xFFF;
                break;
                case 0x97:
                vcer=val&0xFFF;
                break;
                case 0xE0:
                bit8=(val>>5)&7;
//                if (((val>>5)&7)==3) bit8=1;
//                else                 bit8=0;
                memset(dirtybuffer,1,1024);
                palchange=1;
                break;
                case 0x40:
//                printf("Border colour %08X\n",val);
                break;
        }
}

void resetbuffer()
{
        memset(dirtybuffer,1,1024);
}

void dumpscreen()
{
        save_pcx("scrshot.pcx",b,pal);
}

