/*RPCemu v0.2 by Tom Walker
  System coprocessor + MMU emulation*/
#include "rpc.h"

unsigned long pccache,readcache,writecache;
struct cp15
{
        unsigned long tlbbase,dacr;
} cp15;

void resetcp15()
{
        prog32=1;
        mmu=0;
}

void writecp15(unsigned long addr, unsigned long val)
{
        switch (addr&15)
        {
                case 1: /*Control*/
/*                if (val&1)
                {
                        printf("MMU enabled\n");
                        dumpregs();
                        exit(-1);
                }*/
                mmu=val&1;
//                printf("CP15 control : %08X\n",val);
//                printf("MMU %s\n",(mmu)?"enabled":"disabled");
                prog32=val&0x10;
                if (!prog32 && (mode&16))
                {
                        updatemode(mode&15);
//                        printf("Forced to 26-bit mode\n");
                }
                return; /*We can probably ignore all other bits*/
                case 2: /*TLB base*/
                cp15.tlbbase=val&~0x3FFF;
//                printf("CP15 tlb base now %08X\n",cp15.tlbbase);
                return;
                case 3: /*Domain access control*/
                cp15.dacr=val;
//                printf("CP15 DACR now %08X\n",cp15.dacr);
                return;
                case 5: /*Flush TLB*/
                case 6: /*Purge TLB*/
                case 7: /*??*/
                pccache=readcache=writecache=0xFFFFFFFF;
                return;
        }
        error("Bad write CP15 %08X %08X %07X\n",addr,val,PC);
        dumpregs();
        exit(-1);
}

unsigned long readcp15(unsigned long addr)
{
        switch (addr&15)
        {
                case 0: /*ARM ID*/
                return 0x41007100;
                case 2: /*???*/
                return cp15.tlbbase;
        }
        error("Bad read CP15 %08X %07X\n",addr,PC);
        dumpregs();
        exit(-1);
}

unsigned long translateaddress(unsigned long addr, int rw)
{
        unsigned long vaddr=((addr>>18)&~3)|cp15.tlbbase;
        unsigned long fld=ram[(vaddr>>2)&0x3FFFFF];
        unsigned long sldaddr,sld;
//        printf("Initial address %08X\n",addr);
//        printf("First level descriptor %08X\n",fld);
        switch (fld&3)
        {
                case 1: /*Page table*/
                sldaddr=((addr&0xFF000)>>10)|(fld&0xFFFFFC00);
//                printf("Second level descriptor address %08X\n",sldaddr);
                sld=ram[(sldaddr>>2)&0x3FFFFF];
//                printf("Second level descriptor %08X\n",sld);
                addr=(sld&0xFFFFF000)|(addr&0xFFF);
//                printf("Final address %08X\n",addr);
                return addr;
                case 2: /*Section*/
/*                if (!(fld&0xC00))
                {
                        error("Permissions denied\n");
                        dumpregs();
                        exit(-1);
                }
                else switch (fld&0xC00)
                {
                        case 1:
                        if (!memmode)
                        {
                                printf("Access denied\n");
                                dumpregs();
                                exit(-1);
                        }
                        break;
                        case 2:
                        if (!memmode && rw)
                        {
                                printf("Access denied w\n");
                                dumpregs();
                                exit(-1);
                        }
                        break;
                }*/
                addr=(addr&0xFFFFF)|(fld&0xFFF00000);
//                printf("Final address %08X\n",addr);
                return addr;
                default:
                error("Bad descriptor type %i %08X\n",fld&3,fld);
                error("Address %08X\n",addr);
                dumpregs();
                exit(-1);
        }
        exit(-1);
}

unsigned long getpccache(unsigned long addr)
{
        unsigned long addr2;
        if (mmu) addr2=translateaddress(addr,0);
        else     addr2=addr;
        switch (addr2&0x1F000000)
        {
                case 0x00000000: /*ROM*/
                return &rom[(addr2&0x3FF000)>>2];
                case 0x02000000: /*VRAM*/
                return &vram[(addr2&0x1FF000)>>2];
                case 0x10000000: /*SIMM 0 bank 0*/
                case 0x11000000:
                case 0x12000000:
                case 0x13000000:
//                printf("SIMM0 r %08X %08X %07X\n",addr,ram[(addr&0x3FFFFF)>>2],PC);
                return &ram[(addr2&0xFFF000)>>2];
        }
        error("Bad PC %08X %08X\n",addr,addr2);
        dumpregs();
        exit(-1);
}
