#include <allegro.h>
#include "rpc.h"

int readflash;
int palchange;
float mips;
BITMAP *b;
int deskdepth;
int oldsx,oldsy;
void initvideo()
{
        int depth;
        allegro_init();
        depth=deskdepth=desktop_color_depth();
        if (depth==16)
        {
                set_color_depth(16);
                if (set_gfx_mode(GFX_AUTODETECT_WINDOWED,1024,768,0,0))
                {
                        set_color_depth(15);
                        depth=15;
                        set_gfx_mode(GFX_AUTODETECT_WINDOWED,1024,768,0,0);
                }
        }
        else if (depth)
        {
                set_color_depth(depth);
                set_gfx_mode(GFX_AUTODETECT_WINDOWED,1024,768,0,0);
        }
        else
           set_gfx_mode(GFX_AUTODETECT_WINDOWED,1024,768,0,0);
        set_color_depth(8);
//        if (depth!=15) set_color_depth(16);
//        else           set_color_depth(15);
        b=create_bitmap(1024,768);
        oldsx=640;
        oldsy=480;
}

int palindex;
PALETTE pal;

unsigned long hdsr,hcsr,hder;
unsigned long vdsr,vcsr,vcer,vder;
int bit8;

void resizedisplay(int x, int y)
{
        if (x<16) x=16;
        if (y<16) y=16;
        if (x>1024) x=1024;
        if (y>768) y=768;
        oldsx=x;
        oldsy=y;
        updatewindowsize(x,y);
}

void drawscr()
{
        int x,y,xx;
        int xs=hder-hdsr;
        int ys=vder-vdsr;
        int addr=iomd.vidinit&0xFFFFF;
        int cx=hcsr-hdsr;
        int cy=vcsr-vdsr,ny=vcer-vcsr;
        if (xs<2) xs=2;
        if (ys<1) ys=1;
        if (ys!=oldsy || xs!=oldsx) resizedisplay(xs,ys);
        if (!bit8)
        {
                for (y=0;y<ys;y++)
                {
                        for (x=0;x<xs;x+=32)
                        {
                                for (xx=0;xx<32;xx+=8)
                                {
                                        b->line[y][x+xx]=ramb[addr]&0xF;
                                        b->line[y][x+xx+1]=(ramb[addr]>>4)&0xF;
                                        b->line[y][x+xx+2]=ramb[addr+1]&0xF;
                                        b->line[y][x+xx+3]=(ramb[addr+1]>>4)&0xF;
                                        b->line[y][x+xx+4]=ramb[addr+2]&0xF;
                                        b->line[y][x+xx+5]=(ramb[addr+2]>>4)&0xF;
                                        b->line[y][x+xx+6]=ramb[addr+3]&0xF;
                                        b->line[y][x+xx+7]=(ramb[addr+3]>>4)&0xF;
                                        addr+=4;
                                }
                                if (addr>iomd.vidend) addr=iomd.vidstart;
                        }
                }
        }
        else
        {
                for (y=0;y<ys;y++)
                {
                        for (x=0;x<xs;x+=16)
                        {
                                for (xx=0;xx<16;xx+=4)
                                {
                                        b->line[y][x+xx]=ramb[addr]&0xFF;
                                        b->line[y][x+xx+1]=ramb[addr+1]&0xFF;
                                        b->line[y][x+xx+2]=ramb[addr+2]&0xFF;
                                        b->line[y][x+xx+3]=ramb[addr+3]&0xFF;
                                        addr+=4;
                                }
                                if (addr>iomd.vidend) addr=iomd.vidstart;
                        }
                }
        }
        if (ny>1)
        {
        addr=cinit&0xFFFFF0;
        for (y=0;y<ny;y++)
        {
                if (y>479) break;
                for (x=0;x<32;x+=4)
                {
                        if (ramb[addr]&3)      b->line[y+cy][x+cx]=ramb[addr]&3;
                        if ((ramb[addr]>>2)&3) b->line[y+cy][x+cx+1]=(ramb[addr]>>2)&3;
                        if ((ramb[addr]>>4)&3) b->line[y+cy][x+cx+2]=(ramb[addr]>>4)&3;
                        if ((ramb[addr]>>6)&3) b->line[y+cy][x+cx+3]=(ramb[addr]>>6)&3;
                        addr++;
                }
        }
        }
        if (readflash)
        {
                rectfill(b,xs-40,4,xs-8,11,readflash);
                readflash=0;
        }
//        printf("Cursor %i %i %i\n",cx,cy,ny);
//        textprintf(b,font,0,472,makecol(255,255,255),"%f MIPS     ",mips);
        blit(b,screen,0,0,0,0,xs,ys);
        if (palchange)
        {
                set_palette(pal);
                palchange=0;
        }
//        printf("%i %i %i - ",hdsr,hder,hder-hdsr);
//        printf("%i %i %i\n",vdsr,vder,vder-vdsr);
}

void writevidc20(unsigned long val)
{
        switch (val>>24)
        {
                case 0:
//                printf("Palette %i = %08X\n",palindex,val);
                pal[palindex].r=(val&0xFF)>>2;
                pal[palindex].g=(val&0xFF00)>>10;
                pal[palindex].b=(val&0xFF0000)>>18;
                palindex++;
                palindex&=255;
                palchange=1;
                break;
                case 0x10:
                palindex=val&255;
                break;
                case 0x83:
                hdsr=val&0xFFE;
                break;
                case 0x84:
                hder=val&0xFFE;
                break;
                case 0x86:
                hcsr=val&0xFFE;
                break;
                case 0x93:
                vdsr=val&0xFFF;
                break;
                case 0x94:
                vder=val&0xFFF;
                break;
                case 0x96:
                vcsr=val&0xFFF;
                break;
                case 0x97:
                vcer=val&0xFFF;
                break;
                case 0xE0:
                if (((val>>5)&7)==3) bit8=1;
                else                 bit8=0;
                break;
                case 0x40:
//                printf("Border colour %08X\n",val);
                break;
        }
}

void dumpscreen()
{
        save_pcx("scrshot.pcx",b,pal);
}
