#include "rpc.h"

int timetolive;
void initmem()
{
        ram=(unsigned long *)malloc(16*1024*1024);
        rom=(unsigned long *)malloc(4*1024*1024);
        vram=(unsigned long *)malloc(2*1024*1024);
        ramb=(unsigned char *)ram;
        romb=(unsigned char *)rom;
        vramb=(unsigned char *)vram;
}

unsigned long readmeml(unsigned long addr)
{
//        if (!addr && !timetolive) timetolive=250;
        if (mmu) addr=translateaddress(addr,0);
        switch (addr&0x1F000000)
        {
                case 0x00000000: /*ROM*/
                return rom[(addr&0x3FFFFF)>>2];
                case 0x02000000: /*VRAM*/
                return vram[(addr&0x1FFFFF)>>2];
                case 0x03000000: /*IO*/
                if ((addr&0xFFF000)==0x200000)
                   return readiomd(addr);
                if (addr==0x3310000) return 0;
                if ((addr&0xFFF000)==0x10000) /*82c711*/
                   return read82c711(addr);
                break;
                case 0x10000000: /*SIMM 0 bank 0*/
                case 0x11000000:
                case 0x12000000:
                case 0x13000000:
//                printf("SIMM0 r %08X %08X %07X\n",addr,ram[(addr&0x3FFFFF)>>2],PC);
                return ram[(addr&0xFFFFFF)>>2];
                case 0x14000000: /*SIMM 0 bank 1*/
                case 0x18000000: /*SIMM 1 bank 0*/
                case 0x1C000000: /*SIMM 1 bank 1*/
                return 0;
        }
        printf("Bad readmeml %08X at %07X\n",addr,PC);
        dumpregs();
        exit(-1);
}

unsigned long readmemb(unsigned long addr)
{
        if (mmu) addr=translateaddress(addr,0);
        switch (addr&0x1F000000)
        {
                case 0x00000000: /*ROM*/
                return romb[addr&0x3FFFFF];
                case 0x02000000: /*VRAM*/
                return vramb[addr&0x1FFFFF];
                case 0x03000000: /*IO*/
                if ((addr&0xFFF000)==0x200000)
                   return readiomd(addr);
                if (addr==0x3310000) return 0;
                if (addr>=0x3012000 && addr<=0x302A000)
                   return readfdcdma(addr);
                if ((addr&0xFFF000)==0x10000) /*82c711*/
                   return read82c711(addr);
                if ((addr&0xFF0000)==0x20000) /*82c711*/
                   return read82c711(addr);
                if ((addr&0xF00000)==0x300000) /*IO*/
                   return 0;
                break;
                case 0x10000000: /*SIMM 0 bank 0*/
                return ramb[addr&0xFFFFFF];
        }
        printf("Bad readmemb %08X at %07X\n",addr,PC);
        dumpregs();
        exit(-1);
}

unsigned long writememl(unsigned long addr, unsigned long val)
{
//        if (addr>0x2104F1E && addr<0x2104F28) printf("Writel %08X %08X %08X\n",addr,val,PC);
//        if (addr>0x214EF03 && addr<0x214EF24) printf("Writel %08X %08X %08X\n",addr,val,PC);
//        if (addr==0x2104F08) printf("Write 2104F08 %08X %08X\n",val,PC);
//        if (addr==0x24) printf("Write 24 %08X %08X\n",val,PC);
//        if (addr>=0x2154BC4 && addr<=(0x2154BC4+0x3C)) printf("Write %08X %08X %07X\n",addr,val,PC);
        if (mmu) addr=translateaddress(addr,1);
        switch (addr&0x1F000000)
        {
                case 0x02000000: /*VRAM*/
                vram[(addr&0x1FFFFF)>>2]=val;
                return;
                case 0x03000000: /*IO*/
                if ((addr&0xFFF000)==0x200000)
                {
                        writeiomd(addr,val);
                        return;
                }
                if (addr==0x3400000) /*VIDC20*/
                {
                        writevidc20(val);
                        return;
                }
                if ((addr&0xFFF000)==0x10000) /*82c711*/
                {
                        write82c711(addr,val);
                        return;
                }
                break;
                case 0x10000000: /*SIMM 0 bank 0*/
                case 0x11000000:
                case 0x12000000:
                case 0x13000000:
//                printf("SIMM0 w %08X %08X %07X\n",addr,val,PC);
                ram[(addr&0xFFFFFF)>>2]=val;
                return;
                case 0x14000000: /*SIMM 0 bank 1*/
                case 0x18000000: /*SIMM 1 bank 0*/
                case 0x1C000000: /*SIMM 1 bank 1*/
                return;
        }
        printf("Bad writememl %08X %08X at %07X\n",addr,val,PC);
        dumpregs();
        exit(-1);
}

unsigned long writememb(unsigned long addr, unsigned char val)
{
/*        if (addr>0x2104F1E && addr<0x2104F28)
        {
                printf("Writeb %08X %02X %08X\n",addr,val,PC);
//                timetolive=300;
        }
        if (addr>0x214EF03 && addr<0x214EF24) printf("Writeb %08X %02X %08X\n",addr,val,PC);*/
//        if (addr==0x2104F08) printf("Writeb 2104F08 %02X %08X\n",val,PC);
//        if (addr==0x2104F2D) printf("Writeb 2104F2D %02X %08X\n",val,PC);
        if (mmu) addr=translateaddress(addr,1);
        switch (addr&0x1F000000)
        {
                case 0x02000000: /*VRAM*/
                vramb[addr&0x1FFFFF]=val;
                return;
                case 0x03000000: /*IO*/
                if ((addr&0xFF0000)==0x200000)
                {
                        writeiomd(addr,val);
                        return;
                }
                if (addr==0x3310000) return;
                if ((addr&0xFC0000)==0x240000) return;
                if (addr>=0x3012000 && addr<=0x302A000)
                {
                        writefdcdma(addr,val);
                        return;
                }
                if ((addr&0xFF0000)==0x10000) /*82c711*/
                {
                        write82c711(addr,val);
                        return;
                }
                if ((addr&0xFF0000)==0x20000) /*82c711*/
                {
                        write82c711(addr,val);
                        return;
                }
                break;
                case 0x10000000: /*SIMM 0 bank 0*/
                ramb[addr&0xFFFFFF]=val;
                return;
        }
        printf("Bad writememb %08X %02X at %07X\n",addr,val,PC);
        dumpregs();
        exit(-1);
}

