#include <allegro.h>
#include "rpc.h"

int flyback=0;
int timetolive;
int output;
int irq;
void updateirqs()
{
        if ((iomd.stata&iomd.maska) || (iomd.statb&iomd.maskb) || (iomd.statd&iomd.maskd))
           irq=1;
        else
           irq=0;
        if (iomd.statf&iomd.maskf) irq|=2;
        if (!irq) armirq=0;
//        printf("Update IRQs - %02X %02X %02X %02X %i %08X %08X %02X %02X\n",iomd.stata,iomd.maska,iomd.statb,iomd.maskb,irq,armregs[15],armregs[16],iomd.statf,iomd.maskf);
}

void timerairq()
{
        iomd.stata|=0x20;
        updateirqs();
}

void settimera(unsigned short latch)
{
        latch++;
        if ((latch/2000)==0)
           install_int_ex(timerairq,latch/2);
        else
           install_int_ex(timerairq,MSEC_TO_TIMER(latch/2000));
//        printf("Timer set to %i MSECs %i cycles %f seconds\n",latch/2000,latch,1193181.0f/(float)(latch/2));
}

void timerbirq()
{
        iomd.stata|=0x40;
        updateirqs();
}

void settimerb(unsigned short latch)
{
        latch++;
        if ((latch/2000)==0)
           install_int_ex(timerbirq,latch/2);
        else
           install_int_ex(timerbirq,MSEC_TO_TIMER(latch/2000));
//        printf("Timer set to %i MSECs %i cycles %f seconds\n",latch/2000,latch,1193181.0f/(float)(latch/2));
}

void writeiomd(unsigned long addr, unsigned long val)
{
        switch (addr&0x1FC)
        {
                case 0: /*Control*/
                cmosi2cchange(val&2,val&1);
                iomd.ctrl=val;
//                printf("Write control %i %i %08X\n",val&2,val&1,armregs[3]);
                return;
                case 0x04: /*Keyboard data*/
//                printf("Keyboard data write %02X %07X\n",val,PC);
                writekbd(val);
                return;
                case 0x08: /*Keyboard control*/
//                printf("Keyboard control write %02X %07X\n",val,PC);
                writekbdenable(val&8);
                return;
                case 0x0C: /*IO port control*/
                return;
                case 0xA8: /*Mouse data*/
                writems(val);
                return;
                case 0xAC: /*Mouse control*/
                writemsenable(val);
                return;
                case 0x14: /*Int A clear*/
//                printf("IRQ A clear %02X\n",val);
//-                if (val==4) output=0;
                iomd.stata&=~val;
                updateirqs();
                return;
                case 0x18: /*Int A mask*/
//                printf("INT A mask now %02X %07X\n",val,PC);
                iomd.maska=val;
                updateirqs();
                return;
                case 0x28: /*Int B mask*/
//                printf("INT B mask now %02X %07X\n",val,PC);
                iomd.maskb=val;
                updateirqs();
                return;
                case 0x38: /*Int F mask*/
//                printf("FIQ mask %02X\n",val);
                iomd.maskf=val;
                return;
                case 0x3C: /*Clock control*/
                return;
                case 0x40: iomd.t0l=(iomd.t0l&0xFF00)|(val&0xFF); break;
                case 0x44: iomd.t0l=(iomd.t0l&0xFF)|((val&0xFF)<<8); break;
                case 0x48: iomd.t0c=iomd.t0l; settimera(iomd.t0l); break;
                case 0x4C: iomd.t0r=iomd.t0c--; break;
                case 0x50: iomd.t1l=(iomd.t1l&0xFF00)|(val&0xFF); break;
                case 0x54: iomd.t1l=(iomd.t1l&0xFF)|((val&0xFF)<<8); break;
                case 0x58: iomd.t1c=iomd.t1l; settimerb(iomd.t1l); break;
                case 0x5C: iomd.t1r=iomd.t1c--; break;
                case 0x68: /*Int C mask*/
                iomd.maskc=val;
                return;
                case 0x74:
                return;
                case 0x78: /*Int D mask*/
//                printf("Write mask D %02X\n",val);
                iomd.maskd=val;
                return;
                case 0x80: iomd.romcr0=val; return; /*ROM control*/
                case 0x84: iomd.romcr1=val; return;
                case 0x6C: /*VIDMUX*/
                case 0x8C: /*VRAM refresh control*/
                return;
                case 0x90: /*Flyback line size*/
                case 0xC4: /*IO timing control*/
                case 0xC8: /*IO expansion timing control*/
                case 0xD0: /*DRAM width*/
                return;
                case 0x180: /*Sound DMA current A*/
                case 0x184: /*Sound DMA end A*/
                case 0x188: /*Sound DMA current B*/
                case 0x18C: /*Sound DMA end B*/
                iomd.sndstat=0;
                return;
                case 0x190: /*Sound DMA control*/
                return;
                case 0x1C0: /*Cursor DMA*/
                return;
                case 0x1C4:
                cinit=val&0x1FFFFFF0;
                return;
                case 0x1D0: /*Video DMA current*/
                iomd.vidcur=val&0xFFFFF;
                return;
                case 0x1D4: /*Video DMA end*/
                iomd.vidend=val&0xFFFFF;
                return;
                case 0x1D8: /*Video DMA start*/
                iomd.vidstart=val&0xFFFFF;
                return;
                case 0x1DC: /*Video DMA init*/
                iomd.vidinit=val&0xFFFFF;
//                printf("VIDinit %08X\n",val);
                return;
                case 0x1E0: /*Video DMA control*/
                iomd.vidcr=val;
                return;
                case 0x1F0: case 0x1F4: case 0x1F8: /*Sound interrupt status*/
                return;
                default:
                return;
                printf("Bad IOMD write register %03X %08X\n",addr&0x1FC,val);
                dumpregs();
                exit(-1);
        }
}

int keytemp=0;
unsigned long readiomd(unsigned long addr)
{
        switch (addr&0x1FC)
        {
                case 0x00: /*printf("Read control %i %i %07X %08X\n",i2cclock,i2cdata,PC,armregs[3]);*/ return ((i2cclock)?2:0)|((i2cdata)?1:0)|(iomd.ctrl&0x7C)|4|flyback; /*Control*/
                case 0x04: return readkeyboarddata(); /*Keyboard data*/
                case 0x08: return getkeyboardstat(); /*Keyboard control*/
                case 0x0C: return 0;
                case 0x10: /*IRQ status A*/
                return iomd.stata;
                case 0x14: /*Int A pending*/
                return iomd.stata&iomd.maska;
                case 0x18: /*Int A mask*/
                return iomd.maska;
                case 0x24: /*Int B pending*/
                return iomd.statb&iomd.maskb;
                case 0x28: /*Int B mask*/
                return iomd.maskb;
                case 0x38: /*Int F mask*/
                return iomd.maskf;
                case 0x40: return iomd.t0r&0xFF;
                case 0x44: return iomd.t0r>>8;
                case 0x50: return iomd.t1r&0xFF;
                case 0x54: return iomd.t1r>>8;
                case 0x60: return iomd.statc;
                case 0x64: /*Int C pending*/
                return iomd.statc&iomd.maskc;
                case 0x68: /*Int C mask*/
                return iomd.maskc;
                case 0x70: /*Int D status*/
//                printf("Read D stat %02X\n",iomd.statd);
                return iomd.statd;
                case 0x74: /*Int D pending*/
//                printf("Read D pending %02X %02X\n",iomd.statd&iomd.maskd,iomd.statd);
                return iomd.statd&iomd.maskd;
                case 0x78: /*Int D mask*/
//                printf("Read D mask %02X\n",iomd.maskd);
                return iomd.maskd;
                case 0x80: return iomd.romcr0; /*ROM control*/
                case 0x84: return iomd.romcr1;
                case 0x94: return 0x98; /*Chip ID registers*/
                case 0x98: return 0x5B; /*Identify as ARM7500*/
                case 0x9C: return 0; /*Chip version*/
                case 0xA8: return readmousedata(); /*Mouse data*/
                case 0xAC: return getmousestat(); /*Mouse control*/
                case 0x180: case 0x184: case 0x188: case 0x18C: return 0;
                case 0x194: /*Sound DMA stat*/
                return iomd.sndstat;
                case 0x1D4: /*Video DMA end*/
                return iomd.vidend&~15;
                case 0x1D8: /*Video DMA start*/
                return iomd.vidstart&~15;
                case 0x1E0: /*Video DMA control*/
                return iomd.vidcr|0x50;
                case 0x1F0: case 0x1F4: case 0x1F8: /*Sound interrupt status*/
                return 0;
        }
        return 0;
        printf("Bad IOMD read register %03X\n",addr&0x1FC);
        dumpregs();
        exit(-1);
}

void resetiomd()
{
        iomd.stata=0;//0x10;
        iomd.romcr0=iomd.romcr1=0x40;
        iomd.sndstat=6;
        iomd.statb=iomd.statc=iomd.statd=0;
}

void updateiomdtimers()
{
        if (iomd.t0c<0)
        {
                iomd.t0c+=iomd.t0l;
                iomd.stata|=0x20;
                updateirqs();
        }
        if (iomd.t1c<0)
        {
                iomd.t1c+=iomd.t1l;
                iomd.stata|=0x40;
                updateirqs();
        }
}

void iomdvsync()
{
        iomd.stata|=8;
        updateirqs();
        flyback=0x80;
}

void dumpiomdregs()
{
        printf("IRQ STAT A %02X B %02X D %02X F %02X\n",iomd.stata,iomd.statb,iomd.statd,iomd.statf);
        printf("IRQ MASK A %02X B %02X D %02X F %02X\n",iomd.maska,iomd.maskb,iomd.maskd,iomd.maskf);
}
