/*Arculator 0.4 by Tom Walker
  ArculFS - Access files from the windows file system
  Relies on ArcFS module (not supplied)
  NOT WORKING YET!*/

#include <unistd.h>
#include <allegro.h>
#include <winalleg.h>
#include <stdio.h>
#include "arc.h"

#define VFLAG 0x10000000
#define AL_ID(a,b,c,d)     (((a)<<24) | ((b)<<16) | ((c)<<8) | (d))
FILE *arculf;
char arcfsdir[512];
FILE *arculfiles[64];
int arculfileid[64];

int readflash[4];

void closearculfs()
{
        int c;
        for (c=0;c<64;c++)
        {
                if (arculfiles[c])
                {
                        fclose(arculfiles[c]);
                        arculfiles[c]=NULL;
                }
        }
}
        
void initarculfs()
{
        int c;
        sprintf(arcfsdir,"%sfs",exname);
        for (c=0;c<64;c++)
            arculfiles[c]=NULL;
        atexit(closearculfs);
}

int lcase(int in)
{
        if (in<=64 || in>=91) return in;
        return in+32;
}

/*Tries to find a match for a filename in a path*/
int matchfilename(char *path, char *fn, char *dest)
{
        int c,d;
        char temps[512],temps2[512];
        struct al_ffblk ffblk;
        int success=0;
        sprintf(temps,"%s\\*",path);
        sprintf(temps2,"Trying to match %s in %s\n",fn,temps);
        fputs(temps2,arculf);
        if (al_findfirst(temps, &ffblk, -1))
        {
                fputs("Failed\n",arculf);
                return 0;
        }
        do
        {
                c=0;
                while (lcase(fn[c])==lcase(ffblk.name[c])) c++;
                sprintf(temps2,"Testing %s broke at %i\n",ffblk.name,c);
                fputs(temps2,arculf);
                if ((ffblk.name[c]==0 || ffblk.name[c]=='.' || ffblk.name[c]==',') && c>1)
                {
                        success=1;
                        strcpy(dest,ffblk.name);
                }
        }
        while (!success && !al_findnext(&ffblk));
        al_findclose(&ffblk);
        if (success) sprintf(temps,"Found match in %s\n",dest);
        else         sprintf(temps,"Failed to match\n");
        fputs(temps,arculf);
        return success;
}
        
/*Removes filename from s and puts it in s2*/
void stripfilename(char *s, char *s2)
{
        int c=0,lastsep=0,d=0;
        char temps[512];
        char s3[2]="\\";
        sprintf(temps,"Stripping %s\n",s);
        fputs(temps,arculf);
//        putc(s3[0],arculf);
        while (s[c])
        {
//                putc(s[c],arculf);
                if (s[c]==s3[0]) lastsep=c;
                c++;
        }
        if (!lastsep)
        {
                s2[0]=0;
                return;
        }
        c=lastsep+1;
        while (s[c])
              s2[d++]=s[c++];
        s[lastsep]=0;
        s2[d]=0;
        sprintf(temps,"Stripped to %s and %s\n",s,s2);
        fputs(temps,arculf);
}

/*returns file type*/
int parsefilename(char *s, char *s2)
{
        int c=0,d=0,type;
        char t[4];
        char temps[128];
        while (s[c] && s[c]!='.' && s[c]!=',')
              s2[d++]=s[c++];
        s2[d]=0;
        if (!s[c]) /*Generic data file*/
        {
                sscanf(t,"%x",&type);
                sprintf(temps,"File %s type FFF\n",s2);
                fputs(temps,arculf);
                return 0xFFF;
        }
        if (s[c]==',') /*hex value contains filetype*/
        {
                t[0]=s[c+1];
                t[1]=s[c+2];
                t[2]=s[c+3];
                t[3]=0;
                sscanf(t,"%x",&type);
                sprintf(temps,"File %s type %03X\n",s2,type);
                fputs(temps,arculf);
                return type;
        }
        return 0xFFF;
}

/*assume absolute pathname*/
void parsepathname(char *s, char *s2)
{
        int c=0,d=0,e;
        char temp[128];
        fputs("Parsing pathname : ",arculf);
        fputs(s,arculf);
        fputs("\n",arculf);
        sprintf(s2,"%s",arcfsdir);
        while (s[c] && s[c]!='$') c++;
        if (!s[c])
        {
                fputs("Bad pathname\n",arculf);
                exit(-1);
        }
        if (!s[c+1])
        {
                fputs("Final pathname : ",arculf);
                fputs(s2,arculf);
                fputs("\n",arculf);
                return;
        }
        c+=2;
        while (1 && s[c])
        {
                strcat(s2,"\\");
                e=0;
                while (s[c] && s[c]!='.')
                {
                        temp[e++]=s[c++];
                }
                temp[e]=0;
                strcat(s2,temp);
                if (!s[c]) break;
                c++;
        }
        fputs("Final pathname : ",arculf);
        fputs(s2,arculf);
        fputs("\n",arculf);
}
        
void arculfs(int call)
{
        int c,d,e,ff=0,start,filetype;
        FILE *f;
        unsigned char lastbyte;
        char s[512],s2[512];
        char path[512];
        struct al_ffblk ffblk;
        if (!arculf) arculf=fopen("arculfs.txt","wt");
        sprintf(s,"ARCULFS call %i %08X %08X %08X %08X %07X\n",call,armregs[0],armregs[1],armregs[2],armregs[3],PC);
        fputs(s,arculf);
        switch (call)
        {
                case 0: /*FSEntry_Open*/
                switch (armregs[0])
                {
                        case 0: /*Open for read*/
                        fputs("Open file : ",arculf);
                        c=armregs[1];
                        d=0;
                        while (readmemb(c))
                        {
                                lastbyte=readmemb(c);
                                s[d++]=lastbyte;
                                putc(lastbyte,arculf);
                                c++;
                        }
                        s[d]=0;
                        fputs("\n",arculf);
                        parsepathname(s,s2);
                        filetype=0xFFF;
                        if (!file_exists(s2,-1,&e))
                        {
                                stripfilename(s2,s);
                                if (!matchfilename(s2,s,path))
                                {
                                        fputs("File not found FSEntry_Open\n",arculf);
                                        exit(-1);
                                }
                                fputs("Found path ",arculf);
                                sprintf(s,"%s\\%s",s2,path);
                                fputs(s,arculf);
                                fputs("\n",arculf);
                                if (!file_exists(s,-1,&e))
                                {
                                        fputs("File not found FSEntry_Open\n",arculf);
                                        exit(-1);
                                }
                                strcpy(s2,s);
                                filetype=parsefilename(path,s);
                        }
                        fputs("Opening file : ",arculf);
                        fputs(s2,arculf);
                        fputs("\n",arculf);
                        c=0;
                        while (arculfiles[c] && c<64) c++;
                        if (c==64)
                        {
                                fputs("Out of file handles\n",arculf);
                                exit(-1);
                        }
                        arculfileid[c]=armregs[3];
                        arculfiles[c]=fopen(s2,"rb");
                        if (!arculfiles[c])
                        {
                                fputs("Failed to open file\n",arculf);
                                exit(-1);
                        }
                        armregs[1]=c+1;
                        armregs[2]=0;
                        armregs[0]=1<<30;
                        if (e&FA_DIREC)     armregs[0]|=(1<<29);
                        if (!(e&FA_RDONLY)) armregs[0]|=(1<<31);
                        armregs[15]&=~VFLAG;
                        break;
                                
                        default:
                        sprintf(s,"Bad FSEntry_Open call %i %08X %08X %08X %08X\n",call,armregs[0],armregs[1],armregs[2],armregs[3]);
                        MessageBox(NULL,s,s,MB_OK);
                        dumpregs();
                        exit(-1);
                }
                break;

                case 1: /*FSEntry_GetBytes*/
                readflash[0]=1;
                if (!arculfiles[armregs[1]-1])
                {
                        fputs("Bad file number\n",arculf);
                        exit(-1);
                }
                c=armregs[1]-1;
                fseek(arculfiles[c],armregs[4],SEEK_SET);
                sprintf(s,"Seeked file %i to %08X\n",c,armregs[4]);
                fputs(s,arculf);
                for (d=0;d<armregs[3];d++)
                {
                        lastbyte=getc(arculfiles[c]);
                        writememb(d+armregs[2],lastbyte);
                        sprintf(s,"Written %02X to %08X %i\n",lastbyte,d+armregs[2],d);
                        fputs(s,arculf);
                }
                armregs[15]&=~VFLAG;
                break;

                case 3: /*FSEntry_Args*/
                switch (armregs[0])
                {
                        case 1: /*Write sequential pointer*/
                        fputs("Write sequential pointer\n",arculf);
                        if (!arculfiles[armregs[1]-1])
                        {
                                fputs("Bad file number\n",arculf);
                                exit(-1);
                        }
                        c=armregs[1]-1;
                        fseek(arculfiles[c],armregs[2],SEEK_SET);
                        sprintf(s,"Seeked to %i\n",armregs[2]);
                        fputs(s,arculf);
                        armregs[15]&=~VFLAG;
                        break;
                        
                        case 5: /*EOF check*/
                        if (!arculfiles[armregs[1]-1])
                        {
                                fputs("Bad file number\n",arculf);
                                exit(-1);
                        }
                        c=armregs[1]-1;
                        if (feof(arculfiles[c])) armregs[2]=-1;
                        else                     armregs[2]=0;
                        armregs[15]&=~VFLAG;
                        break;
                        
                        case 6: /*Flush buffers*/
                        armregs[2]=armregs[3]=0;
                        armregs[15]&=~VFLAG;
                        break;
                        
                        default:
                        sprintf(s,"Bad FSEntry_Args call %i %08X %08X %08X %08X\n",call,armregs[0],armregs[1],armregs[2],armregs[3]);
                        MessageBox(NULL,s,s,MB_OK);
                        dumpregs();
                        exit(-1);
                }
                break;
                
                case 4: /*FSEntry_Close*/
                if (!arculfiles[armregs[1]-1])
                {
                        fputs("Bad file number\n",arculf);
                        exit(-1);
                }
                c=armregs[1]-1;
                fclose(arculfiles[c]);
                arculfiles[c]=NULL;
                sprintf(s,"Closed file %i\n",c);
                fputs(s,arculf);
                armregs[15]&=~VFLAG;
                break;
                
                case 5: /*FSEntry_File*/
                switch (armregs[0])
                {
                        case 5: /*Read catalogue information*/
                        fputs("Read catalogue information : ",arculf);
                        c=armregs[1];
                        d=0;
                        while (readmemb(c))
                        {
                                lastbyte=readmemb(c);
                                s[d++]=lastbyte;
                                putc(lastbyte,arculf);
                                c++;
                        }
                        s[d]=0;
                        fputs("\n",arculf);
                        if (lastbyte=='$') /*Root directory*/
                        {
                                armregs[0]=2;
                        }
                        else
                        {
                                parsepathname(s,s2);
                                filetype=0xFFF;
                                if (!file_exists(s2,-1,&e))
                                {
                                        stripfilename(s2,s);
                                        if (!matchfilename(s2,s,path))
                                        {
                                                armregs[0]=0;
                                                return;
                                        }
                                        fputs("Found path ",arculf);
                                        sprintf(s,"%s\\%s",s2,path);
                                        fputs(s,arculf);
                                        fputs("\n",arculf);
                                        if (!file_exists(s,-1,&e))
                                        {
                                                armregs[0]=0;
                                                return;
                                        }
                                        filetype=parsefilename(path,s);
                                }
                                sprintf(s,"File type %03X\ne=%08X\n",filetype,e);
                                fputs(s,arculf);
                                if (e&FA_DIREC)
                                {
                                        fputs("Directory\n",arculf);
                                        armregs[0]=2;
                                        return;
                                }
                                armregs[0]=1;
                                armregs[2]=0xFFF00000|(filetype<<8);
                                armregs[3]=0;
                                armregs[4]=file_size(s2);
                                armregs[5]=0x11; /*Read access*/
                                if (!(e&FA_RDONLY))
                                   armregs[5]=0x33; /*R/W access*/
                                armregs[15]&=~VFLAG;
                                return;
                        }
                        armregs[15]&=~VFLAG;
                        break;
                        case 0xFF: /*Load file*/
                        fputs("Load file : ",arculf);
                        c=armregs[1];
                        d=0;
                        while (readmemb(c))
                        {
                                lastbyte=readmemb(c);
                                s[d++]=lastbyte;
                                putc(lastbyte,arculf);
                                c++;
                        }
                        s[d]=0;
                        c=armregs[2];
                        fputs("\n",arculf);
                        parsepathname(s,s2);
                        if (!file_exists(s2,-1,&e))
                        {
                                        stripfilename(s2,s);
                                        if (!matchfilename(s2,s,path))
                                        {
                                fputs("File not found\n",arculf);
                                exit(-1);
                                                armregs[0]=0;
                                                return;
                                        }
                                        fputs("Found path ",arculf);
                                        sprintf(s,"%s\\%s",s2,path);
                                        fputs(s,arculf);
                                        fputs("\n",arculf);
                                        if (!file_exists(s,-1,&e))
                                        {
                                fputs("File not found\n",arculf);
                                exit(-1);
                                                armregs[0]=0;
                                                return;
                                        }
                                        f=fopen(s,"rb");
                                armregs[4]=file_size(s);
                                        filetype=parsefilename(path,s);
                        }
                        else
                        {
                                armregs[4]=file_size(s2);
                                f=fopen(s2,"rb");
                        }
                        armregs[2]=0xFFFFFA00;
                        armregs[3]=0;
//                        armregs[4]=file_size(s2);
                        if (!(e&FA_RDONLY))
                           armregs[5]=0x33; /*R/W access*/
                        
                        if (!f)
                        {
                                fputs("File error\n",arculf);
                                exit(-1);
                        }
                        for (d=0;d<armregs[4];d++)
                        {
                                lastbyte=getc(f);
                                writememb(d+c,lastbyte);
                        }
                        fclose(f);
                        armregs[15]&=~VFLAG;
                        return;
                        
                        default:
                        sprintf(s,"Bad FSEntry_File call %i %08X %08X %08X %08X\n",call,armregs[0],armregs[1],armregs[2],armregs[3]);
                        MessageBox(NULL,s,s,MB_OK);
                        dumpregs();
                        exit(-1);
                }
                break;
                case 6: /*FSEntry_Func*/
                switch (armregs[0])
                {
                        case 0: /*Set current directory*/
                        fputs("Set current directory : ",arculf);
                        c=armregs[1];
                        while (readmemb(c) && c<16)
                        {
                                putc(readmemb(c),arculf);
                                c++;
                        }
                        fputs("\n",arculf);
                        armregs[15]&=~VFLAG;
                        break;
                        case 0xB: /*Read name and boot (*OPT 4) option of disc*/
                        fputs("Set name/opt\n",arculf);
                        c=armregs[2];
                        writememb(c,3);
                        writememb(c+1,'H');
                        writememb(c+2,'D');
                        writememb(c+3,'4');
                        writememb(c+4,0);
                        writememb(c+5,0);
                        armregs[15]&=~VFLAG;
                        break;
                        case 0xF: /*Read directory entries and information*/
                        fputs("Read directory entries\n",arculf);
                        sprintf(s,"Maximum entries : %i  Length of buffer : %i\n",armregs[3],armregs[5]);
                        fputs(s,arculf);
                        c=armregs[1];
                        d=0;
                        while (readmemb(c))
                        {
                                lastbyte=readmemb(c);
                                s[d++]=lastbyte;
                                putc(lastbyte,arculf);
                                c++;
                        }
                        s[d]=0;
                        parsepathname(s,s2);
                        sprintf(path,"%s\\*",s2);
                        fputs(path,arculf);
                        fputs("\n",arculf);
                        if (al_findfirst(path, &ffblk, -1) != 0) /*No files in directory*/
                        {
                                fputs("No entries\n",arculf);
                                armregs[3]=0;
                                armregs[4]=0xFFFFFFFF;
                                return;
                        }
                        start=armregs[4];
                        for (c=0;c<start+2;c++)
                            al_findnext(&ffblk);
                        c=armregs[2];
                        armregs[3]=0;
                        do
                        {
                                if (ffblk.name[0]=='.') continue;
                                filetype=parsefilename(ffblk.name,s);
                                d=0;
                                while (s[d] && d<11)
                                      d++;
                                if ((ff+d)>=armregs[5])
                                {
                                        armregs[4]=start+armregs[3];
                                        return;
                                }
                                fputs("Writing entry ",arculf);
                                fputs(s,arculf);
                                fputs("\n",arculf);
                                writememl(c,0xFFFFFA00);
                                writememl(c+4,0);
                                writememl(c+8,ffblk.size);
                                writememl(c+12,0x33);
                                if (ffblk.attrib&FA_DIREC) { writememl(c+16,2); }
                                else                       { writememl(c+16,1); }
                                d=0;
                                while (s[d] && d<11)
                                {
                                        writememb(c+d+20,s[d]);
                                        d++;
                                }
                                writememb(c+d+20,0);
                                d++;
                                d+=20;
                                while (d&3)
                                {
                                        writememb(c+d,0);
                                        d++;
                                }
                                for (e=0;e<d;e+=4)
                                {
                                        sprintf(s,"%08X ",readmeml(e+c));
                                        fputs(s,arculf);
                                }
                                fputs("\n",arculf);
                                for (e=0;e<d;e++)
                                    putc(readmemb(e+c),arculf);
                                fputs("\n",arculf);
                                c+=d;
                                ff+=d;
/*                                sprintf(s,"%08X %08X %08X %08X %08X %08X %08X %08X\n",readmeml(c),readmeml(c+4),readmeml(c+8),readmeml(c+12),readmeml(c+16),readmeml(c+20),readmeml(c+24),readmeml(c+28));
                                fputs(s,arculf);
                                for (d=0;d<32;d++)
                                    putc(readmemb(d+c),arculf);
                                fputs("\n",arculf);
                                c+=32;*/
                                armregs[3]++;
                        } while (al_findnext(&ffblk) == 0);
                        al_findclose(&ffblk);
                        armregs[15]&=~VFLAG;
                        armregs[4]=0xFFFFFFFF;
                        break;
                        default:
                        sprintf(s,"Bad FSEntry_Func call %i %08X %08X %08X %08X\n",call,armregs[0],armregs[1],armregs[2],armregs[3]);
                        MessageBox(NULL,s,s,MB_OK);
                        dumpregs();
                        exit(-1);
                }
                break;

                default:
                sprintf(s,"Bad ArculFS call %i %08X %08X %08X %08X\n",call,armregs[0],armregs[1],armregs[2],armregs[3]);
                MessageBox(NULL,s,s,MB_OK);
                dumpregs();
                exit(-1);
        }
}
