/*Arculator 0.35 by Tom Walker
  Main loop + Windows interfacing*/
#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include <winalleg.h>
#include "arc.h"

int disccint;
BITMAP *b;
int firstfull=1;
int memsize=4096;
int wmx,wmy;
unsigned long memctrl;
char bigs[256];
FILE *olog;
float sampdiff;
int output;
float inssec;
int inscount,updatemips;
unsigned long sdif;

void updateins()
{
        inssec=(float)inscount/1000000;
        inscount=0;
        updatemips=1;
}

END_OF_FUNCTION(updateins);

int spdcount=0;

void updatespd()
{
        spdcount++;
}

END_OF_FUNCTION(updatespd);

void installins()
{
        LOCK_FUNCTION(updateins);
        LOCK_VARIABLE(inssec);
        LOCK_VARIABLE(inscount);
        install_int_ex(updateins,MSEC_TO_TIMER(1000));
        inscount=0;
        LOCK_FUNCTION(updatespd);
        LOCK_VARIABLE(spdcount);
        install_int_ex(updatespd,MSEC_TO_TIMER(20));
}

char bigs[256];
FILE *olog;

void loadfile(FILE *f)
{
        int c;
        unsigned char temp;
        c=0x8000;
        while (!feof(f))
        {
                temp=getc(f);
                writememb(c,temp);
                c++;
        }
}

/*  Declare Windows procedure  */
LRESULT CALLBACK WindowProcedure (HWND, UINT, WPARAM, LPARAM);

/*  Make the class name into a global variable  */
char szClassName[ ] = "WindowsApp";
HWND ghwnd;
int infocus;
int quitting=0;
HMENU menu;
int fastvsync=0,limitspeed=0,logsound=0;
int vsyncbreak;
int soundtime;

#define IDM_FILE_RESET    40000
#define IDM_FILE_EXIT     40001
#define IDM_DISC_CHANGE0  40010
#define IDM_DISC_CHANGE1  40011
#define IDM_DISC_CHANGE2  40012
#define IDM_DISC_CHANGE3  40013
#define IDM_DISC_REMOVE0  40014
#define IDM_DISC_REMOVE1  40015
#define IDM_DISC_REMOVE2  40016
#define IDM_DISC_REMOVE3  40017
#define IDM_OPTIONS_SOUND 40020
#define IDM_OPTIONS_FAST  40021
#define IDM_OPTIONS_LIMIT 40022
#define IDM_OPTIONS_MOUSE 40023
#define IDM_OPTIONS_HACK  40024
#define IDM_MEMSIZE_4M    40030
#define IDM_MEMSIZE_8M    40031
#define IDM_MEMSIZE_16M   40032
#define IDM_VIDEO_FULLSCR 40040
#define IDM_VIDEO_FULLBOR 40041
#define IDM_CPU_ARM2      40050
#define IDM_CPU_ARM3      40051

void makemenu()
{
        HMENU hpop,hpop2;
        menu=CreateMenu();
        hpop=CreateMenu();
        AppendMenu(hpop,MF_STRING,IDM_FILE_RESET,"&Reset");
        AppendMenu(hpop,MF_SEPARATOR,0,NULL);
        AppendMenu(hpop,MF_STRING,IDM_FILE_EXIT,"E&xit");
        AppendMenu(menu,MF_POPUP,hpop,"&File");
        hpop=CreateMenu();
        hpop2=CreateMenu();
        AppendMenu(hpop2,MF_STRING,IDM_DISC_CHANGE0,"Drive &0...");
        AppendMenu(hpop2,MF_STRING,IDM_DISC_CHANGE1,"Drive &1...");
        AppendMenu(hpop2,MF_STRING,IDM_DISC_CHANGE2,"Drive &2...");
        AppendMenu(hpop2,MF_STRING,IDM_DISC_CHANGE3,"Drive &3...");
        AppendMenu(hpop,MF_POPUP,hpop2,"&Change Disc");
        hpop2=CreateMenu();
        AppendMenu(hpop2,MF_STRING,IDM_DISC_REMOVE0,"Drive &0...");
        AppendMenu(hpop2,MF_STRING,IDM_DISC_REMOVE1,"Drive &1...");
        AppendMenu(hpop2,MF_STRING,IDM_DISC_REMOVE2,"Drive &2...");
        AppendMenu(hpop2,MF_STRING,IDM_DISC_REMOVE3,"Drive &3...");
        AppendMenu(hpop,MF_POPUP,hpop2,"&Remove Disc");
        AppendMenu(menu,MF_POPUP,hpop,"&Disc");
        hpop=CreateMenu();
        AppendMenu(hpop,MF_STRING,IDM_OPTIONS_SOUND,"&Sound Enable");
//        AppendMenu(hpop,MF_STRING,IDM_OPTIONS_FAST, "&Fast Vsync");
        AppendMenu(hpop,MF_STRING,IDM_OPTIONS_LIMIT,"&Limit Speed");
//        AppendMenu(hpop,MF_STRING,IDM_OPTIONS_MOUSE,"&Mouse Hack");
        AppendMenu(hpop,MF_STRING,IDM_OPTIONS_HACK, "&OS Hack");
        AppendMenu(menu,MF_POPUP,hpop,"&Options");
        hpop=CreateMenu();
        hpop2=CreateMenu();
        AppendMenu(hpop2,MF_STRING,IDM_CPU_ARM2,"ARM&2");
        AppendMenu(hpop2,MF_STRING,IDM_CPU_ARM3,"ARM&3");
        AppendMenu(hpop,MF_POPUP,hpop2,"&CPU type");
        hpop2=CreateMenu();
        AppendMenu(hpop2,MF_STRING,IDM_MEMSIZE_4M,"&4 megabytes");
        AppendMenu(hpop2,MF_STRING,IDM_MEMSIZE_8M,"&8 megabytes");
        AppendMenu(hpop2,MF_STRING,IDM_MEMSIZE_16M, "&16 megabytes");
        AppendMenu(hpop,MF_POPUP,hpop2,"&RAM size");
        AppendMenu(menu,MF_POPUP,hpop,"&Machine");
        hpop=CreateMenu();
        AppendMenu(hpop,MF_STRING,IDM_VIDEO_FULLSCR,"&Fullscreen");
        AppendMenu(hpop,MF_STRING,IDM_VIDEO_FULLBOR,"Full &borders");
        AppendMenu(menu,MF_POPUP,hpop,"&Video");
}

void updatewindowsize(int x, int y)
{
        RECT r;
        GetWindowRect(ghwnd,&r);
        MoveWindow(ghwnd,r.left,r.top,
                     x+(GetSystemMetrics(SM_CXFIXEDFRAME)*2),
                     y+(GetSystemMetrics(SM_CYFIXEDFRAME)*2)+GetSystemMetrics(SM_CYMENUSIZE)+GetSystemMetrics(SM_CYCAPTION)+1,
                     TRUE);
}

int deskdepth;

int mousecapture=0;
RECT oldclip,arcclip;

int WINAPI WinMain (HINSTANCE hThisInstance,
                    HINSTANCE hPrevInstance,
                    LPSTR lpszArgument,
                    int nFunsterStil)

{
        int quited=0,c;
        unsigned char d;
        FILE *f;
        char *p,s[80];
        char fn[512];
        int framenum=0;
        /* This is the handle for our window */
        MSG messages;            /* Here messages to the application are saved */
        WNDCLASSEX wincl;        /* Data structure for the windowclass */

        /* The Window structure */
        wincl.hInstance = hThisInstance;
        wincl.lpszClassName = szClassName;
        wincl.lpfnWndProc = WindowProcedure;      /* This function is called by windows */
        wincl.style = CS_DBLCLKS;                 /* Catch double-clicks */
        wincl.cbSize = sizeof (WNDCLASSEX);

        /* Use default icon and mouse-pointer */
        wincl.hIcon = LoadIcon (NULL, IDI_APPLICATION);
        wincl.hIconSm = LoadIcon (NULL, IDI_APPLICATION);
        wincl.hCursor = LoadCursor (NULL, IDC_ARROW);
        wincl.lpszMenuName = NULL;                 /* No menu */
        wincl.cbClsExtra = 0;                      /* No extra bytes after the window class */
        wincl.cbWndExtra = 0;                      /* structure or the window instance */
        /* Use Windows's default color as the background of the window */
        wincl.hbrBackground = (HBRUSH) COLOR_BACKGROUND;

        /* Register the window class, and if it fails quit the program */
        if (!RegisterClassEx (&wincl))
           return 0;

        makemenu();
        /* The class is registered, let's create the program*/
        ghwnd = CreateWindowEx (
           0,                   /* Extended possibilites for variation */
           szClassName,         /* Classname */
           "Arculator v0.3",    /* Title Text */
           WS_OVERLAPPEDWINDOW&~(WS_MAXIMIZEBOX|WS_SIZEBOX), /* default window */
           CW_USEDEFAULT,       /* Windows decides the position */
           CW_USEDEFAULT,       /* where the window ends up on the screen */
           672+(GetSystemMetrics(SM_CXFIXEDFRAME)*2),/* The programs width */
           544+(GetSystemMetrics(SM_CYFIXEDFRAME)*2)+GetSystemMetrics(SM_CYMENUSIZE)+GetSystemMetrics(SM_CYCAPTION)+1,/* and height in pixels */
           HWND_DESKTOP,        /* The window is a child-window to desktop */
           menu,                /* No menu */
           hThisInstance,       /* Program Instance handler */
           NULL                 /* No Window Creation data */
           );

        /* Make the window visible on the screen */
        ShowWindow (ghwnd, nFunsterStil);
        win_set_window(ghwnd);

        initvid();
        get_executable_name(exname,511);
        p=get_filename(exname);
        *p=0;
        append_filename(fn,exname,"arc.cfg",511);
        set_config_file(fn);
        for (c=0;c<4;c++)
        {
                sprintf(s,"disc_name_%i",c);
                p=get_config_string(NULL,s,NULL);
                if (!p) discchangeint(0,c);
                else
                {
                        strcpy(discname[c],p);
                        p=get_extension(discname[c]);
                        if (p[0]=='i' || p[0]=='I')
                           loaddisc(discname[c],1,c);
                        else
                           loaddisc(discname[c],0,c);
                }
        }
        p=get_config_string(NULL,"mem_size",NULL);
        if (!p || !strcmp(p,"4096")) memsize=4096;
        else if (!strcmp(p,"8192"))  memsize=8192;
        else                         memsize=16384;

        initmem(memsize);
        if (loadrom()==-2)
        {
                MessageBox(NULL,"RiscOS ROMs missing!","Arculator",MB_OK|MB_ICONSTOP);
                return 0;
        }
        resetarm();
        loadcmos();
        resetioc();
        install_keyboard();
        install_mouse();
        initkeyboard();
        install_timer();
        installins();
        resetmouse();
        MoveWindow(ghwnd,100,100,640+(GetSystemMetrics(SM_CXFIXEDFRAME)*2),512+(GetSystemMetrics(SM_CYFIXEDFRAME)*2)+GetSystemMetrics(SM_CYMENUSIZE)+GetSystemMetrics(SM_CYCAPTION)+1,TRUE);

/*        p=get_config_string(NULL,"fast_vsync",NULL);
        if (!p || strcmp(p,"1")) fastvsync=0;
        else                     fastvsync=1;*/
        p=get_config_string(NULL,"limit_speed",NULL);
        if (!p || strcmp(p,"0")) limitspeed=1;
        else                     limitspeed=0;
        p=get_config_string(NULL,"sound_enable",NULL);
        if (!p || strcmp(p,"0")) soundena=1;
        else                     soundena=0;
        p=get_config_string(NULL,"os_hack",NULL);
        if (!p || strcmp(p,"1")) oshack=0;
        else                     oshack=1;
        p=get_config_string(NULL,"full_borders",NULL);
        if (!p || strcmp(p,"1")) fullborders=0;
        else                     fullborders=1;
        p=get_config_string(NULL,"cpu_type",NULL);
        if (!p || strcmp(p,"1")) arm3=0;
        else                     arm3=1;
        p=get_config_string(NULL,"first_fullscreen",NULL);
        if (!p || strcmp(p,"0")) firstfull=1;
        else                     firstfull=0;
        fullscreen=0;
        mousehack=0;
//        arm3=0;

        initsound();
        reinitvideo();

//        limitspeed=1;
//        if (fastvsync)  CheckMenuItem(menu,IDM_OPTIONS_FAST, MF_CHECKED);
        if (limitspeed) CheckMenuItem(menu,IDM_OPTIONS_LIMIT,MF_CHECKED);
        if (soundena)   CheckMenuItem(menu,IDM_OPTIONS_SOUND,MF_CHECKED);
        if (mousehack)  CheckMenuItem(menu,IDM_OPTIONS_MOUSE,MF_CHECKED);
        if (oshack)     CheckMenuItem(menu,IDM_OPTIONS_HACK, MF_CHECKED);
        if (fullborders)
        {
                updatewindowsize(800,600);
                CheckMenuItem(menu,IDM_VIDEO_FULLBOR, MF_CHECKED);
        }
        switch (memsize)
        {
                case 4096:  CheckMenuItem(menu,IDM_MEMSIZE_4M, MF_CHECKED); break;
                case 8192:  CheckMenuItem(menu,IDM_MEMSIZE_8M, MF_CHECKED); break;
                case 16384: CheckMenuItem(menu,IDM_MEMSIZE_16M,MF_CHECKED); break;
        }
        timeBeginPeriod(1);
        /* Run the message loop. It will run until GetMessage() returns 0 */
        while (!quited)
        {
                if (framenum==5)
                {
                        framenum=0;
                        mixsound();
//                      spdcount=1;
                }
                if (infocus && (!limitspeed || spdcount))
                {
//                        set_mouse_range(0, 0, SCREEN_W-1, SCREEN_H-1);
//                        if (!vsyncbreak)
//                        {
                                if (!speed)        execarm(160000);
                                else if (speed==1) execarm(240000);
                                else               execarm(480000);
                                cmostick();
//                        }
//                        vsyncbreak=0;
                        updatekeys();
                        doosmouse();
                        if (limitspeed)
                        {
//                                drawvid();
                                spdcount=0;
                                if (updatemips)
                                {
                                        sprintf(s,"Arculator v0.3 - %f MIPS - %s",inssec,(mousecapture)?"Press CTRL-END to release mouse":"Click to capture mouse");
//                                        readflash=0;
                                        if (!fullscreen) SetWindowText(ghwnd, s);
                                        updatemips=0;
                                }
                        }
                        framenum++;
//                        if (!speed)        execarm(40000);
//                        else if (speed==1) execarm(60000);
//                        else               execarm(120000);
//                        updatepal();
                        if (disccint)
                        {
                                discchangecint();
                                disccint=0;
                        }
                }
                if (updatemips && !limitspeed)
                {
//                        drawvid();
                        sprintf(s,"Arculator v0.3 - %f MIPS - %s",inssec,(mousecapture)?"Press CTRL-END to release mouse":"Click to capture mouse");
//                        readflash=0;
                        if (!fullscreen) SetWindowText(ghwnd, s);
                        spdcount=0;
                        updatemips=0;
                }
/*                if (key[KEY_HOME])
                {
                        f=fopen("phaethon.zip","rb");
                        c=0x8000;
                        while (!feof(f))
                        {
                                d=getc(f);
                                writememb(c,d);
                                c++;
                        }
                        fclose(f);
                }*/
                if ((key[KEY_LCONTROL] || key[KEY_RCONTROL]) && key[KEY_END] && !fullscreen && mousecapture)
                {
                        ClipCursor(&oldclip);
                        mousecapture=0;
                        updatemips=1;
                }
                if ((key[KEY_LCONTROL] || key[KEY_RCONTROL]) && key[KEY_END] && fullscreen)
                {
                        fullscreen=0;
                        reinitvideo();
                        if (fullborders) updatewindowsize(800,600);
                        else             updatewindowsize(672,544);
                }
                if (PeekMessage(&messages,NULL,0,0,PM_REMOVE))
                {
                        if (messages.message==WM_QUIT)
                           quited=1;
                        /* Translate virtual-key messages into character messages */
                        TranslateMessage(&messages);
                        /* Send message to WindowProcedure */
                        DispatchMessage(&messages);
                }
                sleep(1);
        }
        timeEndPeriod(1);        
        set_config_string(NULL,"disc_name_0",discname[0]);
        set_config_string(NULL,"disc_name_1",discname[1]);
        set_config_string(NULL,"disc_name_2",discname[2]);
        set_config_string(NULL,"disc_name_3",discname[3]);
/*        sprintf(s,"%i",fastvsync);
        set_config_string(NULL,"fast_vsync",s);*/
        sprintf(s,"%i",limitspeed);
        set_config_string(NULL,"limit_speed",s);
        sprintf(s,"%i",soundena);
        set_config_string(NULL,"sound_enable",s);
        sprintf(s,"%i",oshack);
        set_config_string(NULL,"os_hack",s);
        sprintf(s,"%i",memsize);
        set_config_string(NULL,"mem_size",s);
        sprintf(s,"%i",arm3);
        set_config_string(NULL,"cpu_type",s);
        sprintf(s,"%i",fullborders);
        set_config_string(NULL,"full_borders",s);
        sprintf(s,"%i",firstfull);
        set_config_string(NULL,"first_fullscreen",s);
        savecmos();
        updatedisc(discname[0],0);
        updatedisc(discname[1],1);
        updatedisc(discname[2],2);
        updatedisc(discname[3],3);
//        dumpregs();
        if (mousecapture) ClipCursor(&oldclip);
        return 0;
}

void changedisc(HWND hwnd, int drive)
{
        char *p;
        char fn[512];
        char start[512];
        OPENFILENAME ofn;
        fn[0]=0;
        start[0]=0;
        ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hwnd;
	ofn.hInstance = NULL;
	ofn.lpstrFilter = "ADFS Disc Image\0*.adf\0DOS Disc Image\0*.img\0All Files\0*.*\0";
	ofn.lpstrCustomFilter = NULL;
	ofn.nMaxCustFilter = 0;
	ofn.nFilterIndex = 1;
	ofn.lpstrFile = fn;
	ofn.nMaxFile = sizeof(fn);
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = discname[drive];
	ofn.lpstrTitle = NULL;
	ofn.Flags = OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY;
	ofn.nFileOffset = 0;
	ofn.nFileExtension = 0;
	ofn.lpstrDefExt = NULL;
	ofn.lCustData = 0;
	ofn.lpfnHook = NULL;
	ofn.lpTemplateName = NULL;
        if (GetOpenFileName(&ofn))
        {
                updatedisc(discname[drive],drive);
                strcpy(discname[drive],fn);
                p=get_extension(fn);
                if (p[0]=='i' || p[0]=='I')
                   loaddisc(fn,1,drive);
                else
                   loaddisc(fn,0,drive);
                discchangeint(1,drive);
        }
}

/*  This function is called by the Windows function DispatchMessage()  */
LRESULT CALLBACK WindowProcedure (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
        HMENU hmenu;
        switch (message)                  /* handle the messages */
        {
                case WM_COMMAND:
                hmenu=GetMenu(hwnd);
                switch (LOWORD(wParam))
                {
                        case IDM_DISC_CHANGE0:
                        changedisc(ghwnd,0);
                        return 0;
                        case IDM_DISC_CHANGE1:
                        changedisc(ghwnd,1);
                        return 0;
                        case IDM_DISC_CHANGE2:
                        changedisc(ghwnd,2);
                        return 0;
                        case IDM_DISC_CHANGE3:
                        changedisc(ghwnd,3);
                        return 0;
                        case IDM_DISC_REMOVE0:
                        discchangeint(0,0);
                        updatedisc(discname[0],0);
                        discname[0][0]=0;
                        return 0;
                        case IDM_DISC_REMOVE1:
                        discchangeint(0,1);
                        updatedisc(discname[1],1);
                        discname[1][0]=0;
                        return 0;
                        case IDM_DISC_REMOVE2:
                        discchangeint(0,2);
                        updatedisc(discname[2],2);
                        discname[2][0]=0;
                        return 0;
                        case IDM_DISC_REMOVE3:
                        discchangeint(0,3);
                        updatedisc(discname[3],3);
                        discname[3][0]=0;
                        return 0;
                        case IDM_FILE_RESET:
                        resetarm();
                        memset(ram,0,4*1024*1024);
                        resetmouse();
                        initkeyboard();
                        return 0;
                        case IDM_FILE_EXIT:
                        PostQuitMessage(0);
                        return 0;
/*                        case IDM_OPTIONS_FAST:
                        fastvsync^=1;
                        if (fastvsync) CheckMenuItem(hmenu,IDM_OPTIONS_FAST,MF_CHECKED);
                        else           CheckMenuItem(hmenu,IDM_OPTIONS_FAST,MF_UNCHECKED);
                        return 0;*/
                        case IDM_OPTIONS_SOUND:
                        soundena^=1;
                        if (soundena)
                        {
                                CheckMenuItem(hmenu,IDM_OPTIONS_SOUND,MF_CHECKED);
                                initsound();
                                if (!soundena) CheckMenuItem(hmenu,IDM_OPTIONS_SOUND,MF_UNCHECKED);
                        }
                        else
                        {
                                CheckMenuItem(hmenu,IDM_OPTIONS_SOUND,MF_UNCHECKED);
                                deinitsound();
                        }
                        return 0;
                        case IDM_OPTIONS_LIMIT:
                        limitspeed^=1;
                        if (limitspeed) CheckMenuItem(hmenu,IDM_OPTIONS_LIMIT,MF_CHECKED);
                        else            CheckMenuItem(hmenu,IDM_OPTIONS_LIMIT,MF_UNCHECKED);
                        return 0;
                        case IDM_OPTIONS_MOUSE:
                        mousehack^=1;
                        if (mousehack) CheckMenuItem(hmenu,IDM_OPTIONS_MOUSE,MF_CHECKED);
                        else           CheckMenuItem(hmenu,IDM_OPTIONS_MOUSE,MF_UNCHECKED);
                        return 0;
                        case IDM_OPTIONS_HACK:
                        oshack^=1;
                        if (oshack) CheckMenuItem(hmenu,IDM_OPTIONS_HACK,MF_CHECKED);
                        else        CheckMenuItem(hmenu,IDM_OPTIONS_HACK,MF_UNCHECKED);
                        return 0;
/*                        case IDM_OPTIONS_LOG:
                        logsound^=1;
                        if (logsound) CheckMenuItem(hmenu,IDM_OPTIONS_LOG,MF_CHECKED);
                        else          CheckMenuItem(hmenu,IDM_OPTIONS_LOG,MF_UNCHECKED);
                        if (logsound)
                        {
                                ioc.irqb|=2;
                                updateirqs();
                        }
                        return 0;*/
                        case IDM_MEMSIZE_4M:
                        resizemem(4096);
                        resetarm();
                        resetmouse();
                        if (memsize==8192) CheckMenuItem(hmenu,IDM_MEMSIZE_8M,MF_UNCHECKED);
                        else               CheckMenuItem(hmenu,IDM_MEMSIZE_16M,MF_UNCHECKED);
                        CheckMenuItem(hmenu,IDM_MEMSIZE_4M,MF_CHECKED);
                        memsize=4096;
                        return 0;
                        case IDM_MEMSIZE_8M:
                        resizemem(8192);
                        resetarm();
                        resetmouse();
                        if (memsize==4096) CheckMenuItem(hmenu,IDM_MEMSIZE_4M,MF_UNCHECKED);
                        else               CheckMenuItem(hmenu,IDM_MEMSIZE_16M,MF_UNCHECKED);
                        CheckMenuItem(hmenu,IDM_MEMSIZE_8M,MF_CHECKED);
                        memsize=8192;
                        return 0;
                        case IDM_MEMSIZE_16M:
                        resizemem(16384);
                        resetarm();
                        resetmouse();
                        if (memsize==8192) CheckMenuItem(hmenu,IDM_MEMSIZE_8M,MF_UNCHECKED);
                        else               CheckMenuItem(hmenu,IDM_MEMSIZE_4M,MF_UNCHECKED);
                        CheckMenuItem(hmenu,IDM_MEMSIZE_16M,MF_CHECKED);
                        memsize=16384;
                        return 0;
                        case IDM_VIDEO_FULLSCR:
                        fullscreen=1;
                        if (firstfull)
                        {
                                firstfull=0;
                                MessageBox(hwnd,"Use CTRL + END to return to windowed mode","Arculator",MB_OK);
                        }
                        if (mousecapture)
                        {
                                ClipCursor(&oldclip);
                                mousecapture=0;
                        }
                        reinitvideo();
                        return 0;
                        case IDM_VIDEO_FULLBOR:
                        fullborders^=1;
                        if (fullborders) updatewindowsize(800,600);
                        else             updatewindowsize(672,544);
                        if (fullborders) CheckMenuItem(hmenu,IDM_VIDEO_FULLBOR,MF_CHECKED);
                        else             CheckMenuItem(hmenu,IDM_VIDEO_FULLBOR,MF_UNCHECKED);
                        return 0;
                        case IDM_CPU_ARM2:
                        speed=arm3=0;
                        resetarm();
                        memset(ram,0,4*1024*1024);
                        resetmouse();
                        CheckMenuItem(hmenu,IDM_CPU_ARM2,MF_CHECKED);
                        CheckMenuItem(hmenu,IDM_CPU_ARM3,MF_UNCHECKED);
                        resetioc();
                        initkeyboard();
                        return 0;
                        case IDM_CPU_ARM3:
                        speed=arm3=1;
                        resetarm();
                        memset(ram,0,4*1024*1024);
                        resetmouse();
                        CheckMenuItem(hmenu,IDM_CPU_ARM3,MF_CHECKED);
                        CheckMenuItem(hmenu,IDM_CPU_ARM2,MF_UNCHECKED);
                        resetioc();
                        initkeyboard();
                        return 0;
                }
                break;
                case WM_SETFOCUS:
                infocus=1;
                break;
                case WM_KILLFOCUS:
                infocus=0;
                if (mousecapture)
                {
                        ClipCursor(&oldclip);
                        mousecapture=0;
                }
                break;
                case WM_LBUTTONUP:
                if (!mousecapture && !fullscreen)
                {
                        GetClipCursor(&oldclip);
                        GetWindowRect(hwnd,&arcclip);
                        arcclip.left+=GetSystemMetrics(SM_CXFIXEDFRAME)+10;
                        arcclip.right-=GetSystemMetrics(SM_CXFIXEDFRAME)+10;
                        arcclip.top+=GetSystemMetrics(SM_CXFIXEDFRAME)+GetSystemMetrics(SM_CYMENUSIZE)+GetSystemMetrics(SM_CYCAPTION)+10;
                        arcclip.bottom-=GetSystemMetrics(SM_CXFIXEDFRAME)+10;
                        ClipCursor(&arcclip);
                        mousecapture=1;
                        updatemips=1;
                }
                break;
                case WM_DESTROY:
                PostQuitMessage (0);       /* send a WM_QUIT to the message queue */
                break;
                default:                      /* for messages that we don't deal with */
                return DefWindowProc (hwnd, message, wParam, lParam);
        }
        return 0;
}
