/*Arculator 0.35 by Tom Walker
  ARM2 emulation*/
#include <stdio.h>
#include "arc.h"
#include <allegro.h>
#include <winalleg.h>

int cycles;
int prefabort;
int disciint=400000,discrint;
unsigned long oldr2,oldr1,opc,oopc;
void refillpipeline();
void refillpipeline2();
char bigs[256];
int bigcyc;
int times=0;
FILE *olog,*alog;
unsigned char flaglookup[16][16];
unsigned long rotatelookup[4096];
int dischack,fastvsync,vsyncbreak;
int disccint=0;
int pc38dd=0;
unsigned long oldpc,oldoldpc,oldr11;
int timetolive=0;
int inscount;
int soundtime;
int discint;
unsigned char cmosram[256];
int cccount=0;
int keydelay,keydelay2;
int armirq=0;
int output=0;
int firstins;

#define USER       0
#define FIQ        1
#define IRQ        2
#define SUPERVISOR 3

#define NFSET ((armregs[15]&0x80000000)?1:0)
#define ZFSET ((armregs[15]&0x40000000)?1:0)
#define CFSET ((armregs[15]&0x20000000)?1:0)
#define VFSET ((armregs[15]&0x10000000)?1:0)

#define NFLAG 0x80000000
#define ZFLAG 0x40000000
#define CFLAG 0x20000000
#define VFLAG 0x10000000
#define IFLAG 0x08000000

#define RD ((opcode>>12)&0xF)
#define RN ((opcode>>16)&0xF)
#define RM (opcode&0xF)

#define MULRD ((opcode>>16)&0xF)
#define MULRN ((opcode>>12)&0xF)
#define MULRS ((opcode>>8)&0xF)
#define MULRM (opcode&0xF)

#define GETADDR(r) ((r==15)?(armregs[15]&0x3FFFFFC):armregs[r])
#define LOADREG(r,v) if (r==15) { armregs[15]=(armregs[15]&0xFC000003)|((v+4)&0x3FFFFFC); refillpipeline(); } else armregs[r]=v;
#define GETREG(r) ((r==15) ? armregs[15]+4 : armregs[r])
#define LDRRESULT(a,v) ((a&3)?(v>>((a&3)<<3))|(v<<(((a&3)^3)<<3)):v)

int ins=0;

/*0=i/o, 1=all, 2=r/o, 3=os r/o, 4=super only, 5=read mem, write io*/
/*0=user, 1=os, 2=super*/
int modepritabler[3][6]=
{
        {0,1,1,0,0,1},
        {0,1,1,1,0,1},
        {0,1,1,1,1,1}
};
int modepritablew[3][6]=
{
        {0,1,0,0,0,0},
        {0,1,1,0,0,0},
        {0,1,1,1,1,0}
};

int mode;
int osmode=0;

void updatemode(int m)
{
        int c;
        usrregs[15]=&armregs[15];
        switch (mode) /*Store back registers*/
        {
                case USER:
                for (c=8;c<15;c++) userregs[c]=armregs[c];
                break;
                case IRQ:
                for (c=8;c<13;c++) userregs[c]=armregs[c];
                irqregs[0]=armregs[13];
                irqregs[1]=armregs[14];
                break;
                case FIQ:
                for (c=8;c<15;c++) fiqregs[c]=armregs[c];
                break;
                case SUPERVISOR:
                for (c=8;c<13;c++) userregs[c]=armregs[c];
                superregs[0]=armregs[13];
                superregs[1]=armregs[14];
                break;
        }
        mode=m;
        switch (m)
        {
                case USER:
                for (c=8;c<15;c++) armregs[c]=userregs[c];
                memmode=osmode;
                for (c=0;c<15;c++) usrregs[c]=&armregs[c];
                break;
                case IRQ:
                for (c=8;c<13;c++) armregs[c]=userregs[c];
                armregs[13]=irqregs[0];
                armregs[14]=irqregs[1];
                for (c=0;c<13;c++) usrregs[c]=&armregs[c];
                for (c=13;c<15;c++) usrregs[c]=&userregs[c];
                memmode=2;
                break;
                case FIQ:
                for (c=8;c<15;c++) armregs[c]=fiqregs[c];
                for (c=0;c<8;c++)  usrregs[c]=&armregs[c];
                for (c=8;c<15;c++) usrregs[c]=&userregs[c];
                memmode=2;
                break;
                case SUPERVISOR:
                for (c=8;c<13;c++) armregs[c]=userregs[c];
                armregs[13]=superregs[0];
                armregs[14]=superregs[1];
                for (c=0;c<13;c++) usrregs[c]=&armregs[c];
                for (c=13;c<15;c++) usrregs[c]=&userregs[c];
                memmode=2;
                break;
        }
}

unsigned long pccache,*pccache2;
void resetarm()
{
        int c,d,exec,data;
        unsigned long rotval,rotamount;
//        if (!olog)
//           olog=fopen("armlog.txt","wt");
        pccache=0xFFFFFFFF;
        updatemode(SUPERVISOR);
        for (c=0;c<16;c++)
        {
                for (d=0;d<16;d++)
                {
                        armregs[15]=d<<28;
                        switch (c)
                        {
                                case 0:  /*EQ*/ exec=ZFSET; break;
                                case 1:  /*NE*/ exec=!ZFSET; break;
                                case 2:  /*CS*/ exec=CFSET; break;
                                case 3:  /*CC*/ exec=!CFSET; break;
                                case 4:  /*MI*/ exec=NFSET; break;
                                case 5:  /*PL*/ exec=!NFSET; break;
                                case 6:  /*VS*/ exec=VFSET; break;
                                case 7:  /*VC*/ exec=!VFSET; break;
                                case 8:  /*HI*/ exec=(CFSET && !ZFSET); break;
                                case 9:  /*LS*/ exec=(!CFSET || ZFSET); break;
                                case 10: /*GE*/ exec=(NFSET == VFSET); break;
                                case 11: /*LT*/ exec=(NFSET != VFSET); break;
                                case 12: /*GT*/ exec=(!ZFSET && (NFSET==VFSET)); break;
                                case 13: /*LE*/ exec=(ZFSET || (NFSET!=VFSET)); break;
                                case 14: /*AL*/ exec=1; break;
                                case 15: /*NV*/ exec=0; break;
                        }
                        flaglookup[c][d]=exec;
                }
        }

        for (data=0;data<4096;data++)
        {
                rotval=data&0xFF;
                rotamount=((data>>8)&0xF)<<1;
                rotval=(rotval>>rotamount)|(rotval<<(32-rotamount));
                rotatelookup[data]=rotval;
        }

        armregs[15]=0x0C00000B;
        mode=3;
        memmode=2;
        firstins=1;
        memstat[0]=1;
        mempoint[0]=rom;
        refillpipeline2();
        resetcp15();
}

void dumpregs()
{
        int c;
        char s[1024];
        FILE *f;
        char *t;
//        t=0;
//        *t=0xFF;
/*        f=fopen("ram2.dmp","wb");
        for (c=0x0000;c<0x8000;c++)
            putc(readmemb(c),f);
        fclose(f);
        f=fopen("modules.dmp","wb");
        for (c=0x0000;c<0x8000;c++)
            putc(readmemb(c+0x1800000),f);
        fclose(f);
        f=fopen("heap.dmp","wb");
        for (c=0x0000;c<0x8000;c++)
            putc(readmemb(c+0x1C00000),f);
        fclose(f);*/
        f=fopen("ram.dmp","wb");
        for (c=0x0000;c<0x70000;c++)
            putc(readmemb(c+0x8000),f);
        fclose(f);
//        fclose(olog);
        sprintf(s,"R 0=%08X R 4=%08X R 8=%08X R12=%08X\nR 1=%08X R 5=%08X R 9=%08X R13=%08X\nR 2=%08X R 6=%08X R10=%08X R14=%08X\nR 3=%08X R 7=%08X R11=%08X R15=%08X\n%i %08X %08X",armregs[0],armregs[4],armregs[8],armregs[12],armregs[1],armregs[5],armregs[9],armregs[13],armregs[2],armregs[6],armregs[10],armregs[14],armregs[3],armregs[7],armregs[11],armregs[15],ins,oldpc,oldoldpc);
        MessageBox(NULL,s,"ARM register dump",MB_OK);
        printf("f12=%08X %08X %08X  ",fiqregs[12],oldpc,oldoldpc);
        printf("PC =%07X ins=%i\n",PC,ins);
//        for (c=0;c<0x80000;c++)
//            putc(((unsigned char *)ram)[c],f);
//        fclose(f);
//        f=fopen("zeropage.dmp","wb");
//        fwrite(ram,0x8000,1,f);
//        fclose(f);
//        f=fopen("cmos.bin","wb");
//        fwrite(cmosram,256,1,f);
//        fclose(f);*/
/*        f=fopen("highpage.dmp","wb");
        for (c=0x1F00000;c<0x1F08000;c++)
            putc(readmemb(c),f);
        fclose(f);
        f=fopen("midpage.dmp","wb");
        for (c=0x1810000;c<0x1818000;c++)
            putc(readmemb(c),f);
        fclose(f);*/
//        dumpvid();
//        printf("VIDC=%08X\n",vidcr[0xE0>>2]);
}

int loadrom()
{
        FILE *f;
        int c;
        f=fopen("cmos.bin","rb");
        if (!f) return -1;
        fread(cmosram,256,1,f);
        fclose(f);
//        memset(cmosram,0,256);
/*        f=fopen("arthur.rom","rb");
        fread(rom,0x80000,1,f);
        fclose(f);*/
        memset(ram,0,4*1024*1024);
        f=fopen("rom.rom","rb");
        if (f)
        {
                fread(rom,0x200000,1,f);
                fclose(f);
                return 0;
        }
        f=fopen("ic24.rom","rb");
        if (!f) return -2;
        fread(rom,0x80000,1,f);
        fclose(f);
        f=fopen("ic25.rom","rb");
        if (!f) return -2;
        fread(&rom[0x20000], 0x80000,1,f);
        fclose(f);
        f=fopen("ic26.rom","rb");
        if (!f) return -2;
        fread(&rom[0x40000],0x80000,1,f);
        fclose(f);
        f=fopen("ic27.rom","rb");
        if (!f) return -2;
        fread(&rom[0x60000],0x80000,1,f);
        fclose(f);
        return 0;
}

#define checkneg(v) (v&0x80000000)
#define checkpos(v) !(v&0x80000000)

inline void setadd(unsigned long op1, unsigned long op2, unsigned long res)
{
        armregs[15]&=0xFFFFFFF;
        if ((checkneg(op1) && checkneg(op2)) ||
            (checkneg(op1) && checkpos(res)) ||
            (checkneg(op2) && checkpos(res)))  armregs[15]|=CFLAG;
        if ((checkneg(op1) && checkneg(op2) && checkpos(res)) ||
            (checkpos(op1) && checkpos(op2) && checkneg(res)))
            armregs[15]|=VFLAG;
        if (!res)                          armregs[15]|=ZFLAG;
        else if (checkneg(res))            armregs[15]|=NFLAG;
}

inline void setsub(unsigned long op1, unsigned long op2, unsigned long res)
{
        char s[80];
        armregs[15]&=0xFFFFFFF;
        if ((checkneg(op1) && checkpos(op2)) ||
            (checkneg(op1) && checkpos(res)) ||
            (checkpos(op2) && checkpos(res)))  armregs[15]|=CFLAG;
        if (!res)               armregs[15]|=ZFLAG;
        else if (checkneg(res)) armregs[15]|=NFLAG;
        if ((checkneg(op1) && checkpos(op2) && checkpos(res)) ||
            (checkpos(op1) && checkneg(op2) && checkneg(res)))
            armregs[15]|=VFLAG;
}

inline void setzn(unsigned long op)
{
        armregs[15]&=0x3FFFFFFF;
        if (!op)               armregs[15]|=ZFLAG;
        else if (checkneg(op)) armregs[15]|=NFLAG;
}
char err2[512];

inline unsigned long shift(unsigned long opcode)
{
        unsigned long shiftmode=(opcode>>5)&3;
        unsigned long shiftamount=(opcode>>7)&31;
        unsigned long temp;
        int cflag=CFSET;
        if (!(opcode&0xFF0)) return armregs[RM];
        if (opcode&0x10)
        {
                shiftamount=armregs[(opcode>>8)&15]&0xFF;
                if (shiftmode==3)
                   shiftamount&=0x1F;
                cycles--;
        }
        temp=armregs[RM];
//        if (RM==15)        temp+=4;
        if (opcode&0x100000 && shiftamount) armregs[15]&=~CFLAG;
        switch (shiftmode)
        {
                case 0: /*LSL*/
                if (!shiftamount) return temp;
                if (shiftamount==32)
                {
                        if (temp&1 && opcode&0x100000) armregs[15]|=CFLAG;
                        return 0;
                }
                if (shiftamount>32) return 0;
                if (opcode&0x100000)
                {
                        if ((temp<<(shiftamount-1))&0x80000000) armregs[15]|=CFLAG;
                }
                return temp<<shiftamount;

                case 1: /*LSR*/
                if (!shiftamount && !(opcode&0x10))
                {
                        shiftamount=32;
                }
                if (!shiftamount) return temp;
                if (shiftamount==32)
                {
                        if (temp&0x80000000 && opcode&0x100000) armregs[15]|=CFLAG;
                        else if (opcode&0x100000)               armregs[15]&=~CFLAG;
                        return 0;
                }
                if (shiftamount>32) return 0;
                if (opcode&0x100000)
                {
                        if ((temp>>(shiftamount-1))&1) armregs[15]|=CFLAG;
                }
                return temp>>shiftamount;

                case 2: /*ASR*/
                if (!shiftamount)
                {
                        if (opcode&0x10) return temp;
                }
                if (shiftamount>=32 || !shiftamount)
                {
                        if (temp&0x80000000 && opcode&0x100000) armregs[15]|=CFLAG;
                        else if (opcode&0x100000)               armregs[15]&=~CFLAG;
                        if (temp&0x80000000) return 0xFFFFFFFF;
                        return 0;
                }
                if (opcode&0x100000)
                {
                        if (((int)temp>>(shiftamount-1))&1) armregs[15]|=CFLAG;
                }
                return (int)temp>>shiftamount;

                case 3: /*ROR*/
                if (opcode&0x100000) armregs[15]&=~CFLAG;
                if (!shiftamount && !(opcode&0x10))
                {
                        if (opcode&0x100000 && temp&1) armregs[15]|=CFLAG;
                        return (((cflag)?1:0)<<31)|(temp>>1);
                }
                if (!shiftamount)
                {
                        if (opcode&0x100000) armregs[15]|=cflag;
                        return temp;
                }
                if (!(shiftamount&0x1F))
                {
                        if (opcode&0x100000 && temp&0x80000000) armregs[15]|=CFLAG;
                        return temp;
                }
                if (opcode&0x100000)
                {
                        if (((temp>>shiftamount)|(temp<<(32-shiftamount)))&0x80000000) armregs[15]|=CFLAG;
                }
                return (temp>>shiftamount)|(temp<<(32-shiftamount));
                break;
                default:
                sprintf(err2,"Shift mode %i amount %i\n",shiftmode,shiftamount);
                MessageBox(NULL,err2,"Arc",MB_OK);
                dumpregs();
                exit(-1);
        }
}

inline unsigned shift2(unsigned opcode)
{
        unsigned shiftmode=(opcode>>5)&3;
        unsigned shiftamount=(opcode>>7)&31;
        unsigned long temp;
        int cflag=CFSET;
        if (!(opcode&0xFF0)) return armregs[RM];
        if (opcode&0x10)
        {
                shiftamount=armregs[(opcode>>8)&15]&0xFF;
                if (shiftmode==3)
                   shiftamount&=0x1F;
                cycles--;
        }
        temp=armregs[RM];
//        if (RM==15) temp+=4;
        switch (shiftmode)
        {
                case 0: /*LSL*/
                if (!shiftamount)    return temp;
                if (shiftamount>=32) return 0;
                return temp<<shiftamount;

                case 1: /*LSR*/
                if (!shiftamount && !(opcode&0x10))    return 0;
                if (shiftamount>=32) return 0;
                return temp>>shiftamount;

                case 2: /*ASR*/
                if (!shiftamount && !(opcode&0x10)) shiftamount=32;
                if (shiftamount>=32)
                {
                        if (temp&0x80000000)
                           return 0xFFFFFFFF;
                        return 0;
                }
                return (int)temp>>shiftamount;

                case 3: /*ROR*/
                if (!shiftamount && !(opcode&0x10)) return (((cflag)?1:0)<<31)|(temp>>1);
                if (!shiftamount)                   return temp;
                return (temp>>shiftamount)|(temp<<(32-shiftamount));
                break;

                default:
                sprintf(err2,"Shift2 mode %i amount %i\n",shiftmode,shiftamount);
                MessageBox(NULL,err2,"Arc",MB_OK);
                dumpregs();
                exit(-1);
        }
}

inline unsigned rotate(unsigned data)
{
        unsigned long rotval;
        rotval=rotatelookup[data&4095];
        if (data&0x100000 && data&0xF00)
        {
                if (rotval&0x80000000) armregs[15]|=CFLAG;
                else                   armregs[15]&=~CFLAG;
        }
        return rotval;
}

#define rotate2(v) rotatelookup[v&4095]

int ldrlookup[4]={0,8,16,24};

#define ldrresult(v,a) ((v>>ldrlookup[addr&3])|(v<<(32-ldrlookup[addr&3])))

/*unsigned long ldrresult(unsigned long val, unsigned long addr)
{
//        if (addr&3) printf("Unaligned access\n");
//        return val;
        switch (addr&3)
        {
                case 0:
                return val;
                case 1:
                return (val>>8)|(val<<24);
                case 2:
                return (val>>16)|(val<<16);
                case 3:
                return (val>>24)|(val<<8);
        }
}*/

#define undefined()\
                                        templ=armregs[15]-4; \
                                        armregs[15]|=3;\
                                        updatemode(SUPERVISOR);\
                                        armregs[14]=templ;\
                                        armregs[15]&=0xFC000003;\
                                        armregs[15]|=0x08000008;\
                                        refillpipeline();\
                                        cycles--

int accc=0;
FILE *slogfile;
int ins;

void refillpipeline()
{
//        if (!olog) olog=fopen("armlog.txt","wt");
//        opcode=readmeml(PC-8);
        opcode2=readmemff(PC-4);
        opcode3=readmemff(PC);
//        cycles-=3;
//        sprintf(bigs,"Fetched - %08X %07X, %08X %07X\n",opcode2,PC-4,opcode3,PC);
//        fputs(bigs,olog);
}

void refillpipeline2()
{
//        if (!olog) olog=fopen("armlog.txt","wt");
//        opcode=readmeml(PC-8);
        opcode2=readmemff(PC-8);
        opcode3=readmemff(PC-4);
//        cycles-=3;
//        sprintf(bigs,"Fetched - %08X %07X, %08X %07X\n",opcode2,PC-4,opcode3,PC);
//        fputs(bigs,olog);
}

void execarm(int cycs)
{
        unsigned long templ,templ2,mask,addr,addr2;
        int exec,c,cc,cyc,oldcyc,oldcyc2,d;
        unsigned char temp;
        unsigned long oldr15[2];
        FILE *f;
        char s[80];
        char bigs[1024];
        int linecyc;
        cycles+=cycs;
        while (cycles>0)
        {
                oldcyc=cycles;
                linecyc=vidcgetcycs();
                while (linecyc>0)
                {
                        opcode=opcode2;
                        opcode2=opcode3;
                        oldcyc2=cycles;
                        if ((PC>>15)==pccache)
                           opcode3=pccache2[(PC&0x7FFF)>>2];
                        else
                        {
                                templ2=PC>>15;
                                templ=memstat[PC>>15];
                                if (modepritabler[memmode][memstat[PC>>15]])
                                {
                                        pccache=PC>>15;
                                        pccache2=mempoint[PC>>15];
                                        opcode3=mempoint[PC>>15][(PC&0x7FFF)>>2];
                                }
                                else
                                {
                                        opcode3=readmemf(PC);
                                        pccache=0xFFFFFFFF;
                                }
                        }
/*                        if (opcode==0xE35F0000)
                        {
                                sprintf(bigs,"Weird opcode executed at %07X\n",PC);
                                fputs(bigs,olog);
                        }*/
                        if (flaglookup[opcode>>28][armregs[15]>>28] && !prefabort)
                        {
                                switch ((opcode>>20)&0xFF)
                                {
                                        case 0x00: /*AND reg*/
                                        if (((opcode&0xE000090)==0x90)) /*MUL*/
                                        {
                                                armregs[MULRD]=(armregs[MULRM])*(armregs[MULRS]);
                                                cycles-=17;
                                        }
                                        else
                                        {
                                                if (RD==15)
                                                {
                                                        templ=shift(opcode);
                                                        armregs[15]=(((GETADDR(RN)&templ)+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                                        refillpipeline();
                                                }
                                                else
                                                {
                                                        templ=shift(opcode);
                                                        armregs[RD]=GETADDR(RN)&templ;
                                                }
                                                cycles--;
                                        }
                                        break;
                                        case 0x01: /*ANDS reg*/
                                        if (((opcode&0xE000090)==0x90)) /*MULS*/
                                        {
                                                armregs[MULRD]=(armregs[MULRM])*(armregs[MULRS]);
                                                setzn(armregs[MULRD]);
                                                cycles-=17;
                                        }
                                        else
                                        {
                                                if (RD==15)
                                                {
                                                        templ=shift(opcode);
                                                        armregs[15]=(GETADDR(RN)&templ)+4;
                                                        refillpipeline();
                                                }
                                                else
                                                {
                                                        templ=shift(opcode);
                                                        armregs[RD]=GETADDR(RN)&templ;
                                                        setzn(armregs[RD]);
                                                }
                                                cycles--;
                                        }
                                        break;

                                        case 0x02: /*EOR reg*/
                                        if (((opcode&0xE000090)==0x90)) /*MLA*/
                                        {
                                                armregs[MULRD]=((armregs[MULRM])*(armregs[MULRS]))+armregs[MULRN];
                                                cycles-=17;
                                        }
                                        else
                                        {
                                                if (RD==15)
                                                {
                                                        templ=shift(opcode);
                                                        armregs[15]=(((GETADDR(RN)^templ)+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                                        refillpipeline();
                                                }
                                                else
                                                {
                                                        templ=shift(opcode);
                                                        armregs[RD]=GETADDR(RN)^templ;
                                                }
                                                cycles--;
                                        }
                                        break;
                                        case 0x03: /*EORS reg*/
                                        if (((opcode&0xE000090)==0x90)) /*MLA*/
                                        {
                                                armregs[MULRD]=((armregs[MULRM])*(armregs[MULRS]))+armregs[MULRN];
                                                setzn(armregs[MULRD]);
                                                cycles-=17;
                                        }
                                        else
                                        {
                                                if (RD==15)
                                                {
                                                        templ=shift2(opcode);
                                                        armregs[15]=(GETADDR(RN)^templ)+4;
                                                        refillpipeline();
                                                }
                                                else
                                                {
                                                        templ=shift(opcode);
                                                        armregs[RD]=GETADDR(RN)^templ;
                                                        setzn(armregs[RD]);
                                                }
                                                cycles--;
                                        }
                                        break;

                                        case 0x04: /*SUB reg*/
                                        if (RD==15)
                                        {
                                                templ=shift2(opcode);
                                                armregs[15]=(((GETADDR(RN)-templ)+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=shift(opcode);
                                                armregs[RD]=GETADDR(RN)-templ;
                                        }
                                        cycles--;
                                        break;
                                        case 0x05: /*SUBS reg*/
                                        if (RD==15)
                                        {
                                                templ=shift2(opcode);
                                                armregs[15]=(GETADDR(RN)-templ)+4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=shift(opcode);
                                                setsub(GETADDR(RN),templ,GETADDR(RN)-templ);
                                                armregs[RD]=GETADDR(RN)-templ;
                                        }
                                        cycles--;
                                        break;

                                        case 0x06: /*RSB reg*/
                                        if (RD==15)
                                        {
                                                templ=shift(opcode);
                                                armregs[15]=(((templ-GETADDR(RN))+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=shift(opcode);
                                                armregs[RD]=templ-GETADDR(RN);
                                        }
                                        cycles--;
                                        break;
                                        case 0x07: /*RSBS reg*/
                                        if (RD==15)
                                        {
                                                templ=shift2(opcode);
                                                armregs[15]=(templ-GETADDR(RN))+4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=shift(opcode);
                                                setsub(templ,GETADDR(RN),templ-GETADDR(RN));
                                                armregs[RD]=templ-GETADDR(RN);
                                        }
                                        cycles--;
                                        break;

                                        case 0x08: /*ADD reg*/
                                        if (RD==15)
                                        {
                                                templ=shift2(opcode);
        //                                        printf("R15=%08X+%08X+4=",GETADDR(RN),templ);
                                                armregs[15]=((GETADDR(RN)+templ+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                                refillpipeline();
        //                                        printf("%08X\n",armregs[15]);
                                        }
                                        else
                                        {
                                                templ=shift(opcode);
                                                armregs[RD]=GETADDR(RN)+templ;
                                        }
                                        cycles--;
                                        break;
                                        case 0x09: /*ADDS reg*/
                                        if (RD==15)
                                        {
                                                templ=shift2(opcode);
        //                                        printf("R15=%08X+%08X+4=",GETADDR(RN),templ);
                                                armregs[15]=GETADDR(RN)+templ+4;
                                                refillpipeline();
        //                                        printf("%08X\n",armregs[15]);
                                        }
                                        else
                                        {
                                                templ=shift(opcode);
                                                setadd(GETADDR(RN),templ,GETADDR(RN)+templ);
        //                                        printf("ADDS %08X+%08X = ",GETADDR(RN),templ);
                                                armregs[RD]=GETADDR(RN)+templ;
        //                                        printf("%08X\n",armregs[RD]);
        //                                        setzn(templ);
                                        }
                                        cycles--;
                                        break;
                                
                                        case 0x0A: /*ADC reg*/
                                        if (RD==15)
                                        {
                                                templ2=CFSET;
                                                templ=shift2(opcode);
                                                armregs[15]=((GETADDR(RN)+templ+templ2+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ2=CFSET;
                                                templ=shift(opcode);
                                                armregs[RD]=GETADDR(RN)+templ+templ2;
                                        }
                                        cycles--;
                                        break;
                                        case 0x0B: /*ADCS reg*/
                                        if (RD==15)
                                        {
                                                templ2=CFSET;
                                                templ=shift2(opcode);
                                                armregs[15]=GETADDR(RN)+templ+templ2+4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ2=CFSET;
                                                templ=shift(opcode);
                                                setadd(GETADDR(RN),templ,GETADDR(RN)+templ+templ2);
                                                armregs[RD]=GETADDR(RN)+templ+templ2;
                                        }
                                        cycles--;
                                        break;

                                        case 0x0C: /*SBC reg*/
                                        templ2=(CFSET)?0:1;
                                        if (RD==15)
                                        {
                                                templ=shift2(opcode);
                                                armregs[15]=(((GETADDR(RN)-(templ+templ2))+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=shift(opcode);
                                                armregs[RD]=GETADDR(RN)-(templ+templ2);
                                        }
                                        cycles--;
                                        break;
                                        case 0x0D: /*SBCS reg*/
                                        templ2=(CFSET)?0:1;
                                        if (RD==15)
                                        {
                                                templ=shift2(opcode);
                                                armregs[15]=(GETADDR(RN)-(templ+templ2))+4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=shift(opcode);
                                                setsub(GETADDR(RN),templ,GETADDR(RN)-(templ+templ2));
                                                armregs[RD]=GETADDR(RN)-(templ+templ2);
                                        }
                                        cycles--;
                                        break;
                                        case 0x0E: /*RSC reg*/
                                        templ2=(CFSET)?0:1;
                                        if (RD==15)
                                        {
                                                templ=shift2(opcode);
                                                armregs[15]=(((templ-(GETADDR(RN)+templ2))+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=shift(opcode);
                                                armregs[RD]=templ-(GETADDR(RN)+templ2);
                                        }
                                        cycles--;
                                        break;

                                        case 0x10: /*SWP word*/
                                        if (arm3)
                                        {
                                                addr=armregs[RN];
                                                templ=GETREG(RM);
                                                LOADREG(RD,readmeml(addr));
                                                writememl(addr,templ);
                                                cycles-=3;
                                        }
                                        else
                                        {
                                                templ=armregs[15]-4;
                                                armregs[15]|=3;
                                                updatemode(SUPERVISOR);
                                                armregs[14]=templ;
                                                armregs[15]&=0xFC000003;
                                                armregs[15]|=0x08000008;
                                                cycles-=3;
                                                refillpipeline();
                                        }
                                        break;
                                        
                                        case 0x11: /*TST reg*/
                                        if (RD==15)
                                        {
                                                opcode&=~0x100000;
                                                templ=armregs[15]&0x3FFFFFC;
                                                armregs[15]=((GETADDR(RN)&shift2(opcode))&0xFC000003)|templ;
//                                                refillpipeline();
                                        }
                                        else
                                        {
                                                setzn(GETADDR(RN)&shift(opcode));
                                        }
                                        cycles--;
                                        break;

                                        case 0x12: /*SWP byte*/
                                        if (arm3)
                                        {
                                                addr=armregs[RN];
                                                templ=GETREG(RM);
                                                LOADREG(RD,readmemb(addr));
                                                writememb(addr,templ);
                                                cycles-=3;
                                        }
                                        else
                                        {
                                                templ=armregs[15]-4;
                                                armregs[15]|=3;
                                                updatemode(SUPERVISOR);
                                                armregs[14]=templ;
                                                armregs[15]&=0xFC000003;
                                                armregs[15]|=0x08000008;
                                                cycles-=3;
                                                refillpipeline();
                                        }
                                        break;
                                        
                                        case 0x13: /*TEQ reg*/
                                        if (RD==15)
                                        {
                                                opcode&=~0x100000;
                                                templ=armregs[15]&0x3FFFFFC;
                                                armregs[15]=((GETADDR(RN)^shift(opcode))&0xFC000003)|templ;
//                                                refillpipeline();
                                        }
                                        else
                                        {
                                                setzn(GETADDR(RN)^shift(opcode));
                                        }
                                        cycles--;
                                        break;

                                        case 0x15: /*CMP reg*/
                                        if (RD==15)
                                        {
                                                opcode&=~0x100000;
                                                armregs[15]&=0x3FFFFFC;
                                                armregs[15]|=((GETADDR(RN)-shift(opcode))&0xFC000003);
//                                                refillpipeline();
                                        }
                                        else
                                           setsub(GETADDR(RN),shift(opcode),GETADDR(RN)-shift(opcode));
                                        cycles--;
                                        break;

                                        case 0x17: /*CMN reg*/
                                        if (RD==15)
                                        {
                                                opcode&=~0x100000;
                                                armregs[15]&=0x3FFFFFC;
                                                armregs[15]|=((GETADDR(RN)+shift2(opcode))&0xFC000003);
//                                                refillpipeline();
                                        }
                                        else
                                           setadd(GETADDR(RN),shift2(opcode),GETADDR(RN)+shift2(opcode));
                                        cycles--;
                                        break;

                                        case 0x18: /*ORR reg*/
                                        if (RD==15)
                                        {
                                                templ=shift(opcode);
                                                armregs[15]=(((GETADDR(RN)|templ)+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=shift(opcode);
                                                armregs[RD]=GETADDR(RN)|templ;
                                        }
                                        cycles--;
                                        break;
                                        case 0x19: /*ORRS reg*/
                                        if (RD==15)
                                        {
                                                templ=shift(opcode);
                                                armregs[15]=(GETADDR(RN)|templ)+4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=shift(opcode);
                                                armregs[RD]=GETADDR(RN)|templ;
                                                setzn(armregs[RD]);
                                        }
                                        cycles--;
                                        break;

                                        case 0x1A: /*MOV reg*/
                                        if (RD==15)
                                        {
                                                armregs[15]=(armregs[15]&0xFC000003)|((shift(opcode)+4)&0x3FFFFFC);
                                                refillpipeline();
                                        }
                                        else
                                           armregs[RD]=shift(opcode);
                                        cycles--;
                                        break;
                                        case 0x1B: /*MOVS reg*/
                                        if (RD==15)
                                        {
                                                armregs[15]=shift(opcode)+4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                armregs[RD]=shift(opcode);
                                                setzn(armregs[RD]);
                                        }
                                        cycles--;
                                        break;

                                        case 0x1C: /*BIC reg*/
                                        if (RD==15)
                                        {
                                                templ=shift(opcode);
                                                armregs[15]=(((GETADDR(RN)&~templ)+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=shift(opcode);
                                                armregs[RD]=GETADDR(RN)&~templ;
                                        }
                                        cycles--;
                                        break;
                                        case 0x1D: /*BICS reg*/
                                        if (RD==15)
                                        {
                                                templ=shift(opcode);
                                                armregs[15]=(GETADDR(RN)&~templ)+4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=shift(opcode);
                                                armregs[RD]=GETADDR(RN)&~templ;
                                                setzn(armregs[RD]);
                                        }
                                        cycles--;
                                        break;

                                        case 0x1E: /*MVN reg*/
                                        if (RD==15)
                                        {
                                                armregs[15]=(armregs[15]&0xFC000003)|(((~shift(opcode))+4)&0x3FFFFFC);
                                                refillpipeline();
                                        }
                                        else
                                           armregs[RD]=~shift(opcode);
                                        cycles--;
                                        break;
                                        case 0x1F: /*MVNS reg*/
                                        if (RD==15)
                                        {
                                                armregs[15]=(~shift(opcode))+4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                armregs[RD]=~shift(opcode);
                                                setzn(armregs[RD]);
                                        }
                                        cycles--;
                                        break;

                                        case 0x20: /*AND imm*/
                                        if (RD==15)
                                        {
                                                templ=rotate2(opcode);
                                                armregs[15]=(((GETADDR(RN)&templ)+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=rotate2(opcode);
                                                armregs[RD]=GETADDR(RN)&templ;
                                        }
                                        cycles--;
                                        break;
                                        case 0x21: /*ANDS imm*/
                                        if (RD==15)
                                        {
                                                templ=rotate(opcode);
                                                armregs[15]=(GETADDR(RN)&templ)+4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=rotate(opcode);
                                                armregs[RD]=GETADDR(RN)&templ;
                                                setzn(armregs[RD]);
                                        }
                                        cycles--;
                                        break;

                                        case 0x22: /*EOR imm*/
                                        if (RD==15)
                                        {
                                                templ=rotate2(opcode);
                                                armregs[15]=(((GETADDR(RN)^templ)+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=rotate2(opcode);
                                                armregs[RD]=GETADDR(RN)^templ;
                                        }
                                        cycles--;
                                        break;
                                        case 0x23: /*EORS imm*/
                                        if (RD==15)
                                        {
                                                templ=rotate(opcode);
                                                armregs[15]=(GETADDR(RN)^templ)+4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=rotate(opcode);
                                                armregs[RD]=GETADDR(RN)^templ;
                                                setzn(armregs[RD]);
                                        }
                                        cycles--;
                                        break;

                                        case 0x24: /*SUB imm*/
                                        if (RD==15)
                                        {
                                                templ=rotate2(opcode);
                                                armregs[15]=(((GETADDR(RN)-templ)+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=rotate2(opcode);
                                                armregs[RD]=GETADDR(RN)-templ;
                                        }
                                        cycles--;
                                        break;
                                        case 0x25: /*SUBS imm*/
                                        if (RD==15)
                                        {
                                                templ=rotate(opcode);
                                                armregs[15]=(GETADDR(RN)-templ)+4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=rotate(opcode);
                                                setsub(GETADDR(RN),templ,GETADDR(RN)-templ);
                                                armregs[RD]=GETADDR(RN)-templ;
                                        }
                                        cycles--;
                                        break;

                                        case 0x26: /*RSB imm*/
                                        if (RD==15)
                                        {
                                                templ=rotate2(opcode);
                                                armregs[15]=(((templ-GETADDR(RN))+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=rotate2(opcode);
                                                armregs[RD]=templ-GETADDR(RN);
                                        }
                                        cycles--;
                                        break;
                                        case 0x27: /*RSBS imm*/
                                        if (RD==15)
                                        {
                                                templ=rotate(opcode);
                                                armregs[15]=(templ-GETADDR(RN))+4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=rotate(opcode);
                                                setsub(templ,GETADDR(RN),templ-GETADDR(RN));
                                                armregs[RD]=templ-GETADDR(RN);
                                        }
                                        cycles--;
                                        break;

                                        case 0x28: /*ADD imm*/
                                        if (RD==15)
                                        {
                                                templ=rotate2(opcode);
                                                armregs[15]=(((GETADDR(RN)+templ)+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=rotate2(opcode);
                                                armregs[RD]=GETADDR(RN)+templ;
                                        }
                                        cycles--;
                                        break;
                                        case 0x29: /*ADDS imm*/
                                        if (RD==15)
                                        {
                                                templ=rotate(opcode);
                                                armregs[15]=GETADDR(RN)+templ+4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=rotate(opcode);
                                                setadd(GETADDR(RN),templ,GETADDR(RN)+templ);
                                                armregs[RD]=GETADDR(RN)+templ;
                                        }
                                        cycles--;
                                        break;

                                        case 0x2A: /*ADC imm*/
                                        if (RD==15)
                                        {
                                                templ2=CFSET;
                                                templ=rotate2(opcode);
                                                armregs[15]=((GETADDR(RN)+templ+templ2+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ2=CFSET;
                                                templ=rotate2(opcode);
                                                armregs[RD]=GETADDR(RN)+templ+templ2;
                                        }
                                        cycles--;
                                        break;
                                        case 0x2B: /*ADCS imm*/
                                        if (RD==15)
                                        {
                                                templ2=CFSET;
                                                templ=rotate(opcode);
                                                armregs[15]=GETADDR(RN)+templ+templ2+4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ2=CFSET;
                                                templ=rotate(opcode);
                                                setadd(GETADDR(RN),templ,GETADDR(RN)+templ+templ2);
                                                armregs[RD]=GETADDR(RN)+templ+templ2;
                                        }
                                        cycles--;
                                        break;

                                        case 0x2C: /*SBC imm*/
                                        templ2=(CFSET)?0:1;
                                        if (RD==15)
                                        {
                                                templ=rotate2(opcode);
                                                armregs[15]=(((GETADDR(RN)-(templ+templ2))+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=rotate2(opcode);
                                                armregs[RD]=GETADDR(RN)-(templ+templ2);
                                        }
                                        cycles--;
                                        break;
                                        case 0x2D: /*SBCS imm*/
                                        templ2=(CFSET)?0:1;
                                        if (RD==15)
                                        {
                                                templ=rotate(opcode);
                                                armregs[15]=(GETADDR(RN)-(templ+templ2))+4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=rotate(opcode);
                                                setsub(GETADDR(RN),templ,GETADDR(RN)-(templ+templ2));
                                                armregs[RD]=GETADDR(RN)-(templ+templ2);
                                        }
                                        cycles--;
                                        break;
                                        case 0x2E: /*RSC imm*/
                                        templ2=(CFSET)?0:1;
                                        if (RD==15)
                                        {
                                                templ=rotate(opcode);
                                                armregs[15]=(((templ-(GETADDR(RN)+templ2))+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=rotate(opcode);
                                                armregs[RD]=templ-(GETADDR(RN)+templ2);
                                        }
                                        cycles--;
                                        break;
                                        case 0x2F: /*RSCS imm*/
                                        templ2=(CFSET)?0:1;
                                        if (RD==15)
                                        {
                                                templ=rotate(opcode);
                                                armregs[15]=(templ-(GETADDR(RN)+templ2))+4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=rotate(opcode);
                                                setsub(templ,GETADDR(RN),templ-(GETADDR(RN)+templ2));
                                                armregs[RD]=templ-(GETADDR(RN)+templ2);
                                        }
                                        cycles--;
                                        break;

                                        case 0x31: /*TST imm*/
                                        if (RD==15)
                                        {
                                                opcode&=~0x100000;
                                                templ=armregs[15]&0x3FFFFFC;
                                                armregs[15]=((GETADDR(RN)&rotate2(opcode))&0xFC000003)|templ;
//                                                refillpipeline();
                                        }
                                        else
                                        {
                                                setzn(GETADDR(RN)&rotate(opcode));
                                        }
                                        cycles--;
                                        break;
                                
                                        case 0x33: /*TEQ imm*/
                                        if (RD==15)
                                        {
                                                opcode&=~0x100000;
                                                if (armregs[15]&3)
                                                {
                                                        templ=armregs[15]&0x3FFFFFC;
                                                        armregs[15]=((GETADDR(RN)^rotate2(opcode))&0xFC000003)|templ;
//                                                        if (!olog) olog=fopen("armlog.txt","wt");
//                                                        sprintf(s,"TEQP %08X %i\n",armregs[15],getline());
//                                                        fputs(s,olog);
                                                }
                                                else
                                                {
                                                        templ=armregs[15]&0x0FFFFFFF;
                                                        armregs[15]=((GETADDR(RN)^rotate2(opcode))&0xF0000000)|templ;
                                                }
//                                                refillpipeline();
                                        }
                                        else
                                        {
                                                setzn(GETADDR(RN)^rotate(opcode));
                                        }
                                        cycles--;
                                        break;

                                        case 0x35: /*CMP imm*/
                                        if (RD==15)
                                        {
                                                opcode&=~0x100000;
                                                armregs[15]&=0x3FFFFFC;
                                                armregs[15]|=((GETADDR(RN)-rotate2(opcode))&0xFC000003);
//                                                refillpipeline();
                                        }
                                        else
                                           setsub(GETADDR(RN),rotate(opcode),GETADDR(RN)-rotate(opcode));
                                        cycles--;
                                        break;

                                        case 0x37: /*CMN imm*/
                                        if (RD==15)
                                        {
                                                opcode&=~0x100000;
                                                armregs[15]&=0x3FFFFFC;
                                                armregs[15]|=((GETADDR(RN)+rotate2(opcode))&0xFC000003);
//                                                refillpipeline();
                                        }
                                        else
                                           setadd(GETADDR(RN),rotate(opcode),GETADDR(RN)+rotate(opcode));
                                        cycles--;
                                        break;

                                        case 0x38: /*ORR imm*/
                                        if (RD==15)
                                        {
                                                templ=rotate2(opcode);
                                                armregs[15]=(((GETADDR(RN)|templ)+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=rotate2(opcode);
                                                armregs[RD]=GETADDR(RN)|templ;
                                        }
                                        cycles--;
                                        break;
                                        case 0x39: /*ORRS imm*/
                                        if (RD==15)
                                        {
                                                templ=rotate(opcode);
                                                if (armregs[15]&3)
                                                   armregs[15]=(GETADDR(RN)|templ)+4;
                                                else
                                                   armregs[15]=(((GETADDR(RN)|templ)+4)&0xF3FFFFFC)|(armregs[15]&0xC000003);
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=rotate(opcode);
                                                armregs[RD]=GETADDR(RN)|templ;
                                                setzn(armregs[RD]);
                                        }
                                        cycles--;
                                        break;

                                        case 0x3A: /*MOV imm*/
                                        if (RD==15)
                                        {
                                                armregs[15]=(armregs[15]&0xFC000003)|(rotate2(opcode)&0x3FFFFFC);
                                                refillpipeline();
                                        }
                                        else
                                           armregs[RD]=rotate2(opcode);
                                        cycles--;
                                        break;
                                        case 0x3B: /*MOVS imm*/
                                        if (RD==15)
                                        {
                                                armregs[15]=rotate(opcode)+4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                armregs[RD]=rotate(opcode);
                                                setzn(armregs[RD]);
                                        }
                                        cycles--;
                                        break;

                                        case 0x3C: /*BIC imm*/
                                        if (RD==15)
                                        {
                                                templ=rotate2(opcode);
                                                armregs[15]=(((GETADDR(RN)&~templ)+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=rotate2(opcode);
                                                armregs[RD]=GETADDR(RN)&~templ;
                                        }
                                        cycles--;
                                        break;
                                        case 0x3D: /*BICS imm*/
                                        if (RD==15)
                                        {
                                                templ=rotate(opcode);
                                                armregs[15]=(GETADDR(RN)&~templ)+4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                templ=rotate(opcode);
                                                armregs[RD]=GETADDR(RN)&~templ;
                                                setzn(armregs[RD]);
                                        }
                                        cycles--;
                                        break;

                                        case 0x3E: /*MVN imm*/
                                        if (RD==15)
                                        {
                                                armregs[15]=(armregs[15]&0xFC000003)|(((~rotate2(opcode))+4)&0x3FFFFFC);
                                                refillpipeline();
                                        }
                                        else
                                           armregs[RD]=~rotate2(opcode);
                                        cycles--;
                                        break;
                                        case 0x3F: /*MVNS imm*/
                                        if (RD==15)
                                        {
                                                armregs[15]=(~rotate(opcode))+4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                armregs[RD]=~rotate(opcode);
                                                setzn(armregs[RD]);
                                        }
                                        cycles--;
                                        break;
/*case 0x40:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
if (addr&0xFC000000) { databort=2; break; }
writememl(addr,armregs[RD]);
if (databort) break;
addr-=addr2;
armregs[RN]=addr;
cycles-=2;
break;

case 0x41:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
if (addr&0xFC000000) { databort=2; break; }
templ=readmeml(addr);
templ=ldrresult(templ,addr);
if (databort) break;
addr-=addr2;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x42:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
templ2=memmode;
memmode=0;
if (addr&0xFC000000) { databort=2; break; }
writememl(addr,armregs[RD]);
memmode=templ2;
if (databort) break;
addr-=addr2;
armregs[RN]=addr;
cycles-=2;
break;

case 0x43:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
templ2=memmode;
memmode=0;
if (addr&0xFC000000) { databort=2; break; }
templ=readmeml(addr);
templ=ldrresult(templ,addr);
memmode=templ2;
if (databort) break;
addr-=addr2;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x44:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
if (addr&0xFC000000) { databort=2; break; }
writememb(addr,armregs[RD]);
if (databort) break;
addr-=addr2;
armregs[RN]=addr;
cycles-=2;
break;

case 0x45:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
if (addr&0xFC000000) { databort=2; break; }
templ=readmemb(addr);
if (databort) break;
addr-=addr2;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x46:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
templ2=memmode;
memmode=0;
if (addr&0xFC000000) { databort=2; break; }
writememb(addr,armregs[RD]);
memmode=templ2;
if (databort) break;
addr-=addr2;
armregs[RN]=addr;
cycles-=2;
break;

case 0x47:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
templ2=memmode;
memmode=0;
if (addr&0xFC000000) { databort=2; break; }
templ=readmemb(addr);
memmode=templ2;
if (databort) break;
addr-=addr2;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x48:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
if (addr&0xFC000000) { databort=2; break; }
writememl(addr,armregs[RD]);
if (databort) break;
addr+=addr2;
armregs[RN]=addr;
cycles-=2;
break;

case 0x49:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
if (addr&0xFC000000) { databort=2; break; }
templ=readmeml(addr);
templ=ldrresult(templ,addr);
if (databort) break;
addr+=addr2;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x4A:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
templ2=memmode;
memmode=0;
if (addr&0xFC000000) { databort=2; break; }
writememl(addr,armregs[RD]);
memmode=templ2;
if (databort) break;
addr+=addr2;
armregs[RN]=addr;
cycles-=2;
break;

case 0x4B:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
templ2=memmode;
memmode=0;
if (addr&0xFC000000) { databort=2; break; }
templ=readmeml(addr);
templ=ldrresult(templ,addr);
memmode=templ2;
if (databort) break;
addr+=addr2;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x4C:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
if (addr&0xFC000000) { databort=2; break; }
writememb(addr,armregs[RD]);
if (databort) break;
addr+=addr2;
armregs[RN]=addr;
cycles-=2;
break;

case 0x4D:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
if (addr&0xFC000000) { databort=2; break; }
templ=readmemb(addr);
if (databort) break;
addr+=addr2;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x4E:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
templ2=memmode;
memmode=0;
if (addr&0xFC000000) { databort=2; break; }
writememb(addr,armregs[RD]);
memmode=templ2;
if (databort) break;
addr+=addr2;
armregs[RN]=addr;
cycles-=2;
break;

case 0x4F:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
templ2=memmode;
memmode=0;
if (addr&0xFC000000) { databort=2; break; }
templ=readmemb(addr);
memmode=templ2;
if (databort) break;
addr+=addr2;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x50:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
addr-=addr2;
if (addr&0xFC000000) { databort=2; break; }
writememl(addr,armregs[RD]);
if (databort) break;
cycles-=2;
break;

case 0x51:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
addr-=addr2;
if (addr&0xFC000000) { databort=2; break; }
templ=readmeml(addr);
templ=ldrresult(templ,addr);
if (databort) break;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x52:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
addr-=addr2;
if (addr&0xFC000000) { databort=2; break; }
writememl(addr,armregs[RD]);
if (databort) break;
armregs[RN]=addr;
cycles-=2;
break;

case 0x53:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
addr-=addr2;
if (addr&0xFC000000) { databort=2; break; }
templ=readmeml(addr);
templ=ldrresult(templ,addr);
if (databort) break;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x54:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
addr-=addr2;
if (addr&0xFC000000) { databort=2; break; }
writememb(addr,armregs[RD]);
if (databort) break;
cycles-=2;
break;

case 0x55:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
addr-=addr2;
if (addr&0xFC000000) { databort=2; break; }
templ=readmemb(addr);
if (databort) break;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x56:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
addr-=addr2;
if (addr&0xFC000000) { databort=2; break; }
writememb(addr,armregs[RD]);
if (databort) break;
armregs[RN]=addr;
cycles-=2;
break;

case 0x57:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
addr-=addr2;
if (addr&0xFC000000) { databort=2; break; }
templ=readmemb(addr);
if (databort) break;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x58:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
addr+=addr2;
if (addr&0xFC000000) { databort=2; break; }
writememl(addr,armregs[RD]);
if (databort) break;
cycles-=2;
break;

case 0x59:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
addr+=addr2;
if (addr&0xFC000000) { databort=2; break; }
templ=readmeml(addr);
templ=ldrresult(templ,addr);
if (databort) break;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x5A:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
addr+=addr2;
if (addr&0xFC000000) { databort=2; break; }
writememl(addr,armregs[RD]);
if (databort) break;
armregs[RN]=addr;
cycles-=2;
break;

case 0x5B:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
addr+=addr2;
if (addr&0xFC000000) { databort=2; break; }
templ=readmeml(addr);
templ=ldrresult(templ,addr);
if (databort) break;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x5C:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
addr+=addr2;
if (addr&0xFC000000) { databort=2; break; }
writememb(addr,armregs[RD]);
if (databort) break;
cycles-=2;
break;

case 0x5D:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
addr+=addr2;
if (addr&0xFC000000) { databort=2; break; }
templ=readmemb(addr);
if (databort) break;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x5E:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
addr+=addr2;
if (addr&0xFC000000) { databort=2; break; }
writememb(addr,armregs[RD]);
if (databort) break;
armregs[RN]=addr;
cycles-=2;
break;

case 0x5F:
addr=GETADDR(RN);
addr2=opcode&0xFFF;
addr+=addr2;
if (addr&0xFC000000) { databort=2; break; }
templ=readmemb(addr);
if (databort) break;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x60:
addr=GETADDR(RN);
addr2=shift2(opcode);
if (addr&0xFC000000) { databort=2; break; }
writememl(addr,armregs[RD]);
if (databort) break;
addr-=addr2;
armregs[RN]=addr;
cycles-=2;
break;

case 0x61:
addr=GETADDR(RN);
addr2=shift2(opcode);
if (addr&0xFC000000) { databort=2; break; }
templ=readmeml(addr);
templ=ldrresult(templ,addr);
if (databort) break;
addr-=addr2;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x62:
addr=GETADDR(RN);
addr2=shift2(opcode);
templ2=memmode;
memmode=0;
if (addr&0xFC000000) { databort=2; break; }
writememl(addr,armregs[RD]);
memmode=templ2;
if (databort) break;
addr-=addr2;
armregs[RN]=addr;
cycles-=2;
break;

case 0x63:
addr=GETADDR(RN);
addr2=shift2(opcode);
templ2=memmode;
memmode=0;
if (addr&0xFC000000) { databort=2; break; }
templ=readmeml(addr);
templ=ldrresult(templ,addr);
memmode=templ2;
if (databort) break;
addr-=addr2;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x64:
addr=GETADDR(RN);
addr2=shift2(opcode);
if (addr&0xFC000000) { databort=2; break; }
writememb(addr,armregs[RD]);
if (databort) break;
addr-=addr2;
armregs[RN]=addr;
cycles-=2;
break;

case 0x65:
addr=GETADDR(RN);
addr2=shift2(opcode);
if (addr&0xFC000000) { databort=2; break; }
templ=readmemb(addr);
if (databort) break;
addr-=addr2;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x66:
addr=GETADDR(RN);
addr2=shift2(opcode);
templ2=memmode;
memmode=0;
if (addr&0xFC000000) { databort=2; break; }
writememb(addr,armregs[RD]);
memmode=templ2;
if (databort) break;
addr-=addr2;
armregs[RN]=addr;
cycles-=2;
break;

case 0x67:
addr=GETADDR(RN);
addr2=shift2(opcode);
templ2=memmode;
memmode=0;
if (addr&0xFC000000) { databort=2; break; }
templ=readmemb(addr);
memmode=templ2;
if (databort) break;
addr-=addr2;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x68:
addr=GETADDR(RN);
addr2=shift2(opcode);
if (addr&0xFC000000) { databort=2; break; }
writememl(addr,armregs[RD]);
if (databort) break;
addr+=addr2;
armregs[RN]=addr;
cycles-=2;
break;

case 0x69:
addr=GETADDR(RN);
addr2=shift2(opcode);
if (addr&0xFC000000) { databort=2; break; }
templ=readmeml(addr);
templ=ldrresult(templ,addr);
if (databort) break;
addr+=addr2;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x6A:
addr=GETADDR(RN);
addr2=shift2(opcode);
templ2=memmode;
memmode=0;
if (addr&0xFC000000) { databort=2; break; }
writememl(addr,armregs[RD]);
memmode=templ2;
if (databort) break;
addr+=addr2;
armregs[RN]=addr;
cycles-=2;
break;

case 0x6B:
addr=GETADDR(RN);
addr2=shift2(opcode);
templ2=memmode;
memmode=0;
if (addr&0xFC000000) { databort=2; break; }
templ=readmeml(addr);
templ=ldrresult(templ,addr);
memmode=templ2;
if (databort) break;
addr+=addr2;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x6C:
addr=GETADDR(RN);
addr2=shift2(opcode);
if (addr&0xFC000000) { databort=2; break; }
writememb(addr,armregs[RD]);
if (databort) break;
addr+=addr2;
armregs[RN]=addr;
cycles-=2;
break;

case 0x6D:
addr=GETADDR(RN);
addr2=shift2(opcode);
if (addr&0xFC000000) { databort=2; break; }
templ=readmemb(addr);
if (databort) break;
addr+=addr2;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x6E:
addr=GETADDR(RN);
addr2=shift2(opcode);
templ2=memmode;
memmode=0;
if (addr&0xFC000000) { databort=2; break; }
writememb(addr,armregs[RD]);
memmode=templ2;
if (databort) break;
addr+=addr2;
armregs[RN]=addr;
cycles-=2;
break;

case 0x6F:
addr=GETADDR(RN);
addr2=shift2(opcode);
templ2=memmode;
memmode=0;
if (addr&0xFC000000) { databort=2; break; }
templ=readmemb(addr);
memmode=templ2;
if (databort) break;
addr+=addr2;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x70:
addr=GETADDR(RN);
addr2=shift2(opcode);
addr-=addr2;
if (addr&0xFC000000) { databort=2; break; }
writememl(addr,armregs[RD]);
if (databort) break;
cycles-=2;
break;

case 0x71:
addr=GETADDR(RN);
addr2=shift2(opcode);
addr-=addr2;
if (addr&0xFC000000) { databort=2; break; }
templ=readmeml(addr);
templ=ldrresult(templ,addr);
if (databort) break;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x72:
addr=GETADDR(RN);
addr2=shift2(opcode);
addr-=addr2;
if (addr&0xFC000000) { databort=2; break; }
writememl(addr,armregs[RD]);
if (databort) break;
armregs[RN]=addr;
cycles-=2;
break;

case 0x73:
addr=GETADDR(RN);
addr2=shift2(opcode);
addr-=addr2;
if (addr&0xFC000000) { databort=2; break; }
templ=readmeml(addr);
templ=ldrresult(templ,addr);
if (databort) break;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x74:
addr=GETADDR(RN);
addr2=shift2(opcode);
addr-=addr2;
if (addr&0xFC000000) { databort=2; break; }
writememb(addr,armregs[RD]);
if (databort) break;
cycles-=2;
break;

case 0x75:
addr=GETADDR(RN);
addr2=shift2(opcode);
addr-=addr2;
if (addr&0xFC000000) { databort=2; break; }
templ=readmemb(addr);
if (databort) break;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x76:
addr=GETADDR(RN);
addr2=shift2(opcode);
addr-=addr2;
if (addr&0xFC000000) { databort=2; break; }
writememb(addr,armregs[RD]);
if (databort) break;
armregs[RN]=addr;
cycles-=2;
break;

case 0x77:
addr=GETADDR(RN);
addr2=shift2(opcode);
addr-=addr2;
if (addr&0xFC000000) { databort=2; break; }
templ=readmemb(addr);
if (databort) break;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x78:
addr=GETADDR(RN);
addr2=shift2(opcode);
addr+=addr2;
if (addr&0xFC000000) { databort=2; break; }
writememl(addr,armregs[RD]);
if (databort) break;
cycles-=2;
break;

case 0x79:
addr=GETADDR(RN);
addr2=shift2(opcode);
addr+=addr2;
if (addr&0xFC000000) { databort=2; break; }
templ=readmeml(addr);
templ=ldrresult(templ,addr);
if (databort) break;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x7A:
addr=GETADDR(RN);
addr2=shift2(opcode);
addr+=addr2;
if (addr&0xFC000000) { databort=2; break; }
writememl(addr,armregs[RD]);
if (databort) break;
armregs[RN]=addr;
cycles-=2;
break;

case 0x7B:
addr=GETADDR(RN);
addr2=shift2(opcode);
addr+=addr2;
if (addr&0xFC000000) { databort=2; break; }
templ=readmeml(addr);
templ=ldrresult(templ,addr);
if (databort) break;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x7C:
addr=GETADDR(RN);
addr2=shift2(opcode);
addr+=addr2;
if (addr&0xFC000000) { databort=2; break; }
writememb(addr,armregs[RD]);
if (databort) break;
cycles-=2;
break;

case 0x7D:
addr=GETADDR(RN);
addr2=shift2(opcode);
addr+=addr2;
if (addr&0xFC000000) { databort=2; break; }
templ=readmemb(addr);
if (databort) break;
LOADREG(RD,templ);
cycles-=2;
break;

case 0x7E:
addr=GETADDR(RN);
addr2=shift2(opcode);
addr+=addr2;
if (addr&0xFC000000) { databort=2; break; }
writememb(addr,armregs[RD]);
if (databort) break;
armregs[RN]=addr;
cycles-=2;
break;

case 0x7F:
addr=GETADDR(RN);
addr2=shift2(opcode);
addr+=addr2;
if (addr&0xFC000000) { databort=2; break; }
templ=readmemb(addr);
if (databort) break;
armregs[RN]=addr;
LOADREG(RD,templ);
cycles-=2;
break;
*/

//#if 0
                                        case 0x4A: /*STRT*/
                                        addr=GETADDR(RN);
                                        if (opcode&0x2000000) addr2=shift2(opcode);
                                        else                  addr2=opcode&0xFFF;
                                        if (!(opcode&0x800000))  addr2=-addr2;
                                        if (opcode&0x1000000)
                                        {
                                                addr+=addr2;
                                        }
                                        templ=memmode;
                                        memmode=0;
                                        writememl(addr,armregs[RD]);
                                        memmode=templ;
                                        if (databort) break;
                                        if (!(opcode&0x1000000))
                                        {
                                                addr+=addr2;
                                                armregs[RN]=addr;
                                        }
                                        else
                                        {
                                                if (opcode&0x200000) armregs[RN]=addr;
                                        }
                                        cycles-=3;
                                        break;

                                        case 0x4B: /*LDRT*/
                                        addr=GETADDR(RN);
                                        if (opcode&0x2000000) addr2=shift2(opcode);
                                        else                  addr2=opcode&0xFFF;
                                        if (!(opcode&0x800000))  addr2=-addr2;
                                        if (opcode&0x1000000)
                                        {
                                                addr+=addr2;
                                        }
                                        templ=memmode;
                                        memmode=0;
                                        templ2=readmeml(addr);
                                        memmode=templ;
                                        if (databort) break;
                                        templ2=ldrresult(templ2,addr);
                                        LOADREG(RD,templ2);
//                                        if (RD==15) refillpipeline();
                                        if (!(opcode&0x1000000))
                                        {
                                                addr+=addr2;
                                                armregs[RN]=addr;
                                        }
                                        else
                                        {
                                                if (opcode&0x200000) armregs[RN]=addr;
                                        }
                                        cycles-=4;
                                        break;

                                        case 0x47: /*LDRBT*/
                                        addr=GETADDR(RN);
                                        if (opcode&0x2000000) addr2=shift2(opcode);
                                        else                  addr2=opcode&0xFFF;
                                        if (!(opcode&0x800000))  addr2=-addr2;
                                        if (opcode&0x1000000)
                                        {
                                                addr+=addr2;
                                        }
                                        templ=memmode;
                                        memmode=0;
                                        templ2=readmemb(addr);
                                        memmode=templ;
                                        if (databort) break;
                                        LOADREG(RD,templ2);
                                        if (!(opcode&0x1000000))
                                        {
                                                addr+=addr2;
                                                armregs[RN]=addr;
                                        }
                                        else
                                        {
                                                if (opcode&0x200000) armregs[RN]=addr;
                                        }
                                        cycles-=4;
/*                                        if (RD==7)
                                        {
                                                if (!olog) olog=fopen("armlog.txt","wt");
                                                sprintf(s,"LDRB R7 %02X,%07X\n",armregs[7],PC);
                                                fputs(s,olog);
                                        }*/
                                        break;

                                        case 0x60: case 0x68:
                                        case 0x70: case 0x72: case 0x78: case 0x7A:
                                        case 0x40: case 0x48: /*STR*/
                                        case 0x50: case 0x52: case 0x58: case 0x5A:
                                        if ((opcode&0x2000010)==0x2000010)
                                        {
                                                undefined();
                                                break;
                                        }
                                        addr=GETADDR(RN);
                                        if (opcode&0x2000000) addr2=shift2(opcode);
                                        else                  addr2=opcode&0xFFF;
                                        if (!(opcode&0x800000))  addr2=-addr2;
                                        if (opcode&0x1000000)
                                        {
                                                addr+=addr2;
                                        }
                                        if (RD==15) { writememl(addr,armregs[RD]+4); }
                                        else        { writememl(addr,armregs[RD]); }
                                        if (databort) break;
                                        if (!(opcode&0x1000000))
                                        {
                                                addr+=addr2;
                                                armregs[RN]=addr;
                                        }
                                        else
                                        {
                                                if (opcode&0x200000) armregs[RN]=addr;
                                        }
                                        cycles-=3;
                                        break;

                                        case 0x41: case 0x49: /*LDR*/
                                        case 0x51: case 0x53: case 0x59: case 0x5B:
                                        case 0x61: case 0x69:
                                        case 0x71: case 0x73: case 0x79: case 0x7B:
                                        if ((opcode&0x2000010)==0x2000010)
                                        {
                                                undefined();
                                                break;
                                        }
                                        addr=GETADDR(RN);
                                        if (opcode&0x2000000) addr2=shift2(opcode);
                                        else                  addr2=opcode&0xFFF;
                                        if (!(opcode&0x800000))  addr2=-addr2;
                                        if (opcode&0x1000000)
                                        {
                                                addr+=addr2;
                                        }
                                        templ=readmeml(addr);
                                        templ=ldrresult(templ,addr);
                                        if (databort) break;
                                        if (!(opcode&0x1000000))
                                        {
                                                addr+=addr2;
                                                armregs[RN]=addr;
                                        }
                                        else
                                        {
                                                if (opcode&0x200000) armregs[RN]=addr;
                                        }
                                        LOADREG(RD,templ);
//                                        if (RD==15) refillpipeline();
                                        cycles-=4;
/*                                        if (RD==7)
                                        {
                                                if (!olog) olog=fopen("armlog.txt","wt");
                                                sprintf(s,"LDR R7 %08X,%07X\n",armregs[7],PC);
                                                fputs(s,olog);
                                        }*/
                                        break;

                                        case 0x65: case 0x6D:
                                        case 0x75: case 0x77: case 0x7D: case 0x7F:
                                        if (opcode&0x10)
                                        {
                                                undefined();
                                                break;
                                        }
                                        case 0x45: case 0x4D: /*LDRB*/
                                        case 0x55: case 0x57: case 0x5D: case 0x5F:
                                        addr=GETADDR(RN);
                                        if (opcode&0x2000000) addr2=shift2(opcode);
                                        else                  addr2=opcode&0xFFF;
                                        if (!(opcode&0x800000))  addr2=-addr2;
                                        if (opcode&0x1000000)
                                        {
                                                addr+=addr2;
                                        }
                                        templ=readmemb(addr);
                                        if (databort) break;
                                        if (!(opcode&0x1000000))
                                        {
                                                addr+=addr2;
                                                armregs[RN]=addr;
                                        }
                                        else
                                        {
                                                if (opcode&0x200000) armregs[RN]=addr;
                                        }
                                        armregs[RD]=templ;
                                        cycles-=4;
                                        break;

                                        case 0x64: case 0x6C:
                                        case 0x74: case 0x76: case 0x7C: case 0x7E:
                                        if (opcode&0x10)
                                        {
                                                undefined();
                                                break;
                                        }
                                        case 0x44: case 0x4C: /*STRB*/
                                        case 0x54: case 0x56: case 0x5C: case 0x5E:
                                        addr=GETADDR(RN);
                                        if (opcode&0x2000000) addr2=shift2(opcode);
                                        else                  addr2=opcode&0xFFF;
                                        if (!(opcode&0x800000))  addr2=-addr2;
                                        if (opcode&0x1000000)
                                        {
                                                addr+=addr2;
                                        }
                                        writememb(addr,armregs[RD]);
                                        if (databort) break;
                                        if (!(opcode&0x1000000))
                                        {
                                                addr+=addr2;
                                                armregs[RN]=addr;
                                        }
                                        else
                                        {
                                                if (opcode&0x200000) armregs[RN]=addr;
                                        }
                                        cycles-=3;
                                        break;
//#endif
                                        case 0x80: /*STMDA*/
                                        mask=0x8000;
                                        addr=armregs[RN];
                                        for (c=15;c>-1;c--)
                                        {
                                                if (opcode&mask)
                                                {
                                                        if (c==15) { writememl(addr,armregs[c]+4); }
                                                        else       { writememl(addr,armregs[c]); }
                                                        addr-=4;
                                                        cycles--;
                                                }
                                                mask>>=1;
                                        }
                                        cycles-=2;
                                        break;

                                        case 0x81: /*LDMDA*/
                                        mask=0x8000;
                                        addr=armregs[RN];
                                        for (c=15;c>-1;c--)
                                        {
                                                if (opcode&mask)
                                                {
                                                        if (c==15) armregs[15]=(armregs[15]&0xFC000003)|((readmeml(addr)+4)&0x3FFFFFC);
                                                        else       armregs[c]=readmeml(addr);
                                                        addr-=4;
                                                        cycles--;
                                                }
                                                mask>>=1;
                                        }
                                        if (opcode&0x8000) refillpipeline();
                                        cycles-=3;
                                        break;

                                        case 0x82: /*STMDA !*/
                                        mask=0x8000;
                                        addr=armregs[RN];
                                        for (c=15;c>-1;c--)
                                        {
                                                if (opcode&mask)
                                                {
                                                        if (c==15) { writememl(addr,armregs[c]+4); }
                                                        else       { writememl(addr,armregs[c]); }
                                                        addr-=4;
                                                        armregs[RN]-=4;
                                                        cycles--;
                                                }
                                                mask>>=1;
                                        }
                                        cycles-=2;
                                        break;
                                
                                        case 0x83: /*LDMDA !*/
                                        mask=0x8000;
                                        addr=armregs[RN];
                                        for (c=15;c>-1;c--)
                                        {
                                                if (opcode&mask)
                                                {
                                                        if (c==15) armregs[15]=(armregs[15]&0xFC000003)|((readmeml(addr)+4)&0x3FFFFFC);
                                                        else       armregs[c]=readmeml(addr);
                                                        addr-=4;
                                                        armregs[RN]-=4;
                                                        cycles--;
                                                }
                                                mask>>=1;
                                        }
                                        if (opcode&0x8000) refillpipeline();
                                        cycles-=3;
                                        break;

                                        case 0x85: /*LDMDA ^*/
                                        mask=0x8000;
                                        addr=armregs[RN];
                                        if (opcode&0x8000)
                                        {
                                                for (c=15;c>-1;c--)
                                                {
                                                        if (opcode&mask)
                                                        {
                                                                if (c==15 && !(armregs[15]&3))
                                                                   armregs[15]=(readmeml(addr)&0xF3FFFFFC)|(armregs[15]&0xC000003);
                                                                else
                                                                   armregs[c]=readmeml(addr);
                                                                addr-=4;
                                                                cycles--;
                                                        }
                                                        mask>>=1;
                                                }
                                                armregs[15]+=4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                for (c=15;c>-1;c--)
                                                {
                                                        if (opcode&mask)
                                                        {
                                                                *usrregs[c]=readmeml(addr);
                                                                addr-=4;
                                                                cycles--;
                                                        }
                                                        mask>>=1;
                                                }
                                        }
                                        cycles-=3;
                                        break;

                                        case 0x88: /*STMIA*/
                                        mask=1;
                                        addr=armregs[RN];
                                        for (c=0;c<16;c++)
                                        {
                                                if (opcode&mask)
                                                {
                                                        if (c==15) { writememl(addr,armregs[c]+4); }
                                                        else       { writememl(addr,armregs[c]); }
                                                        addr+=4;
                                                        cycles--;
                                                }
                                                mask<<=1;
                                        }
                                        cycles-=2;
                                        break;

                                        case 0x89: /*LDMIA*/
                                        mask=1;
                                        addr=armregs[RN];
                                        for (c=0;c<16;c++)
                                        {
                                                if (opcode&mask)
                                                {
                                                        if (c==15) armregs[15]=(armregs[15]&0xFC000003)|((readmeml(addr)+4)&0x3FFFFFC);
                                                        else       armregs[c]=readmeml(addr);
                                                        addr+=4;
                                                        cycles--;
                                                }
                                                mask<<=1;
                                        }
                                        if (opcode&0x8000) refillpipeline();
                                        cycles-=3;
                                        break;

                                        case 0x8A: /*STMIA !*/
                                        mask=1;
                                        addr=armregs[RN];
                                        for (c=0;c<16;c++)
                                        {
                                                if (opcode&mask)
                                                {
                                                        if (c==15) { writememl(addr,armregs[c]+4); }
                                                        else       { writememl(addr,armregs[c]); }
                                                        addr+=4;
                                                        armregs[RN]+=4;
                                                        cycles--;
                                                }
                                                mask<<=1;
                                        }
                                        cycles-=2;
                                        break;

                                        case 0x8B: /*LDMIA !*/
                                        mask=1;
                                        addr=armregs[RN];
                                        for (c=0;c<16;c++)
                                        {
                                                if (opcode&mask)
                                                {
                                                        if (c==15) armregs[15]=(armregs[15]&0xFC000003)|((readmeml(addr)+4)&0x3FFFFFC);
                                                        else       armregs[c]=readmeml(addr);
                                                        addr+=4;
                                                        armregs[RN]+=4;
                                                        cycles--;
                                                }
                                                        mask<<=1;
                                        }
                                        if (opcode&0x8000) refillpipeline();
                                        cycles-=3;
                                        break;
                                
                                        case 0x8C: /*STMIA ^*/
                                        mask=1;
                                        addr=armregs[RN];
                                        for (c=0;c<16;c++)
                                        {
                                                if (opcode&mask)
                                                {
                                                        if (c==15) { writememl(addr,*usrregs[c]+4); }
                                                        else       { writememl(addr,*usrregs[c]); }
                                                        addr+=4;
                                                        cycles--;
                                                }
                                                mask<<=1;
                                        }
                                        cycles-=2;
                                        break;

                                        case 0x8D: /*LDMIA ^*/
                                        mask=1;
                                        addr=armregs[RN];
                                        if (opcode&0x8000)
                                        {
                                                for (c=0;c<16;c++)
                                                {
                                                        if (opcode&mask)
                                                        {
                                                                if (c==15 && !(armregs[15]&3))
                                                                   armregs[15]=(readmeml(addr)&0xF3FFFFFC)|(armregs[15]&0xC000003);
                                                                else
                                                                   armregs[c]=readmeml(addr);
                                                                addr+=4;
                                                                cycles--;
                                                        }
                                                        mask<<=1;
                                                }
                                                armregs[15]+=4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                for (c=0;c<16;c++)
                                                {
                                                        if (opcode&mask)
                                                        {
                                                                *usrregs[c]=readmeml(addr);
                                                                addr+=4;
                                                                cycles--;
                                                        }
                                                        mask<<=1;
                                                }
                                        }
                                        cycles-=3;
                                        break;

                                        case 0x8F: /*LDMIA !^*/
                                        mask=1;
                                        addr=armregs[RN];
                                        if (opcode&0x8000)
                                        {
                                                for (c=0;c<16;c++)
                                                {
                                                        if (opcode&mask)
                                                        {
                                                                if (c==15 && !(armregs[15]&3))
                                                                   armregs[15]=(readmeml(addr)&0xF3FFFFFC)|(armregs[15]&0xC000003);
                                                                else
                                                                   armregs[c]=readmeml(addr);
                                                                addr+=4;
                                                                armregs[RN]+=4;
                                                                cycles--;
                                                        }
                                                        mask<<=1;
                                                }
                                                armregs[15]+=4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                for (c=0;c<16;c++)
                                                {
                                                        if (opcode&mask)
                                                        {
                                                                *usrregs[c]=readmeml(addr);
                                                                addr+=4;
                                                                armregs[RN]+=4;
                                                                cycles--;
                                                        }
                                                        mask<<=1;
                                                }
                                        }
                                        cycles-=3;
                                        break;

                                        case 0x90: /*STMDB*/
                                        mask=0x8000;
                                        addr=armregs[RN];
                                        for (c=15;c>-1;c--)
                                        {
                                                if (opcode&mask)
                                                {
                                                        addr-=4;
                                                        if (c==15) { writememl(addr,armregs[c]+4); }
                                                        else       { writememl(addr,armregs[c]); }
                                                        cycles--;
                                                }
                                                mask>>=1;
                                        }
                                        cycles-=2;
                                        break;

                                        case 0x91: /*LDMDB*/
                                        mask=0x8000;
                                        addr=armregs[RN];
                                        for (c=15;c>-1;c--)
                                        {
                                                if (opcode&mask)
                                                {
                                                        addr-=4;
                                                        if (c==15) armregs[15]=(armregs[15]&0xFC000003)|((readmeml(addr)+4)&0x3FFFFFC);
                                                        else       armregs[c]=readmeml(addr);
                                                        cycles--;
                                                }
                                                mask>>=1;
                                        }
                                        if (opcode&0x8000) refillpipeline();
                                        cycles-=3;
                                        break;

                                        case 0x92: /*STMDB !*/
                                        mask=0x8000;
                                        addr=armregs[RN];
                                        templ=0;
                                        for (c=15;c>-1;c--)
                                        {
                                                if (opcode&mask)
                                                {
                                                        addr-=4;
                                                        armregs[RN]-=4;
                                                        if (c==15)                { writememl(addr,armregs[c]+4); }
                                                        else if (c==RN && !templ) { writememl(addr,armregs[c]+4); }
                                                        else                      { writememl(addr,armregs[c]); templ=1;}
                                                        cycles--;
                                                }
                                                mask>>=1;
                                        }
                                        cycles-=2;
                                        break;

                                        case 0x93: /*LDMDB !*/
                                        mask=0x8000;
                                        addr=armregs[RN];
                                        for (c=15;c>-1;c--)
                                        {
                                                if (opcode&mask)
                                                {
                                                        addr-=4;
                                                        armregs[RN]-=4;
                                                        if (c==15) armregs[15]=(armregs[15]&0xFC000003)|((readmeml(addr)+4)&0x3FFFFFC);
                                                        else       armregs[c]=readmeml(addr);
                                                        cycles--;
                                                }
                                                mask>>=1;
                                        }
                                        if (opcode&0x8000) refillpipeline();
                                        cycles-=3;
                                        break;

                                        case 0x94: /*STMDB ^*/
                                        mask=0x8000;
                                        addr=armregs[RN];
                                        for (c=15;c>-1;c--)
                                        {
                                                if (opcode&mask)
                                                {
                                                        addr-=4;
                                                        if (c==15) { writememl(addr,*usrregs[c]+4); }
                                                        else       { writememl(addr,*usrregs[c]); }
                                                        cycles--;
                                                }
                                                mask>>=1;
                                        }
                                        cycles-=2;
                                        break;

                                        case 0x95: /*LDMDB ^*/
                                        mask=0x8000;
                                        addr=armregs[RN];
                                        if (opcode&0x8000)
                                        {
                                                for (c=15;c>-1;c--)
                                                {
                                                        if (opcode&mask)
                                                        {
                                                                addr-=4;
                                                                if (c==15 && !(armregs[15]&3))
                                                                   armregs[15]=(readmeml(addr)&0xF3FFFFFC)|(armregs[15]&0xC000003);
                                                                else
                                                                   armregs[c]=readmeml(addr);
                                                                cycles--;
                                                        }
                                                        mask>>=1;
                                                }
                                                armregs[15]+=4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                for (c=15;c>-1;c--)
                                                {
                                                        if (opcode&mask)
                                                        {
                                                                addr-=4;
                                                                *usrregs[c]=readmeml(addr);
                                                                cycles--;
                                                        }
                                                        mask>>=1;
                                                }
                                        }
                                        cycles-=3;
                                        break;

                                        case 0x96: /*STMDB !^*/
                                        mask=0x8000;
                                        addr=armregs[RN];
                                        templ=0;
                                        for (c=15;c>-1;c--)
                                        {
                                                if (opcode&mask)
                                                {
                                                        addr-=4;
                                                        armregs[RN]-=4;
                                                        if (c==15)                { writememl(addr,*usrregs[c]+4); }
                                                        else if (c==RN && !templ) { writememl(addr,*usrregs[c]+4); }
                                                        else                      { writememl(addr,*usrregs[c]); }
                                                        cycles--;
                                                }
                                                mask>>=1;
                                        }
                                        cycles-=2;
                                        break;
                                        case 0x98: /*STMIB*/
                                        mask=1;
                                        addr=armregs[RN];
                                        for (c=0;c<16;c++)
                                        {
                                                if (opcode&mask)
                                                {
                                                        addr+=4;
                                                        if (c==15) { writememl(addr,armregs[c]+4); }
                                                        else       { writememl(addr,armregs[c]); }
                                                        cycles--;
                                                }
                                                mask<<=1;
                                        }
                                        cycles-=2;
                                        break;

                                        case 0x99: /*LDMIB*/
                                        mask=1;
                                        addr=armregs[RN];
                                        for (c=0;c<16;c++)
                                        {
                                                if (opcode&mask)
                                                {
                                                        addr+=4;
                                                        if (c==15) armregs[15]=(armregs[15]&0xFC000003)|((readmeml(addr)+4)&0x3FFFFFC);
                                                        else       armregs[c]=readmeml(addr);
                                                        cycles--;
                                                }
                                                mask<<=1;
                                        }
                                        if (opcode&0x8000) refillpipeline();
                                        cycles-=3;
                                        break;
                                        
                                        case 0x9A: /*STMIB !*/
                                        mask=1;
                                        addr=armregs[RN];
                                        templ=0;
                                        for (c=0;c<16;c++)
                                        {
                                                if (opcode&mask)
                                                {
                                                        addr+=4;
                                                        armregs[RN]+=4;
                                                        if (c==15)                { writememl(addr,armregs[c]+4); }
                                                        else if (c==RN && !templ) { writememl(addr,armregs[c]-4); }
                                                        else                      { writememl(addr,armregs[c]); }
                                                        cycles--;
                                                }
                                                mask<<=1;
                                        }
                                        cycles-=2;
                                        break;

                                        case 0x9C: /*STMIB ^*/
                                        mask=1;
                                        addr=armregs[RN];
                                        for (c=0;c<16;c++)
                                        {
                                                if (opcode&mask)
                                                {
                                                        addr+=4;
                                                        if (c==15) { writememl(addr,*usrregs[c]+4); }
                                                        else       { writememl(addr,*usrregs[c]); }
                                                        cycles--;
                                                }
                                                mask<<=1;
                                        }
                                        cycles-=2;
                                        break;

                                        case 0x9D: /*LDMIB ^*/
                                        mask=1;
                                        addr=armregs[RN];
                                        if (opcode&0x8000)
                                        {
                                                for (c=0;c<16;c++)
                                                {
                                                        if (opcode&mask)
                                                        {
                                                                addr+=4;
                                                                if (c==15 && !(armregs[15]&3))
                                                                   armregs[15]=(readmeml(addr)&0xF3FFFFFC)|(armregs[15]&0xC000003);
                                                                else
                                                                   armregs[c]=readmeml(addr);
                                                                cycles--;
                                                        }
                                                        mask<<=1;
                                                }
                                                armregs[15]+=4;
                                                refillpipeline();
                                        }
                                        else
                                        {
                                                for (c=0;c<16;c++)
                                                {
                                                        if (opcode&mask)
                                                        {
                                                                addr+=4;
                                                                *usrregs[c]=readmeml(addr);
                                                                cycles--;
                                                        }
                                                        mask<<=1;
                                                }
                                        }
                                        cycles-=3;
                                        break;

                                        case 0xB0: case 0xB1: case 0xB2: case 0xB3: /*BL*/
                                        case 0xB4: case 0xB5: case 0xB6: case 0xB7:
                                        case 0xB8: case 0xB9: case 0xBA: case 0xBB:
                                        case 0xBC: case 0xBD: case 0xBE: case 0xBF:
                                        templ=(opcode&0xFFFFFF)<<2;
                                        armregs[14]=armregs[15]-4;
                                        armregs[15]=((armregs[15]+templ+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                        refillpipeline();
                                        cycles-=4;
                                        break;

                                        case 0xA0: case 0xA1: case 0xA2: case 0xA3: /*B*/
                                        case 0xA4: case 0xA5: case 0xA6: case 0xA7:
                                        case 0xA8: case 0xA9: case 0xAA: case 0xAB:
                                        case 0xAC: case 0xAD: case 0xAE: case 0xAF:
                                        templ=(opcode&0xFFFFFF)<<2;
                                        armregs[15]=((armregs[15]+templ+4)&0x3FFFFFC)|(armregs[15]&0xFC000003);
                                        refillpipeline();
                                        cycles-=4;
                                        break;

                                        case 0xE0: case 0xE2: case 0xE4: case 0xE6: /*MCR*/
                                        case 0xE8: case 0xEA: case 0xEC: case 0xEE:
                                        if (MULRS==15 && (opcode&0x10) && arm3)
                                        {
                                                writecp15(RN,armregs[RD]);
                                        }
                                        else
                                        {
                                                templ=armregs[15]-4;
                                                armregs[15]|=3;
                                                updatemode(SUPERVISOR);
                                                armregs[14]=templ;
                                                armregs[15]&=0xFC000003;
                                                armregs[15]|=0x08000008;
                                                cycles-=4;
                                                refillpipeline();
                                        }
                                        break;

                                        case 0xE1: case 0xE3: case 0xE5: case 0xE7: /*MRC*/
                                        case 0xE9: case 0xEB: case 0xED: case 0xEF:
                                        if (MULRS==15 && (opcode&0x10) && arm3)
                                        {
                                                if (RD==15) armregs[RD]=(armregs[RD]&0x3FFFFFC)|(readcp15(RN)&0xFC000003);
                                                else        armregs[RD]=readcp15(RN);
                                        }
                                        else
                                        {
                                                templ=armregs[15]-4;
                                                armregs[15]|=3;
                                                updatemode(SUPERVISOR);
                                                armregs[14]=templ;
                                                armregs[15]&=0xFC000003;
                                                armregs[15]|=0x08000008;
                                                cycles-=4;
                                                refillpipeline();
                                        }
                                        break;
                                        
                                        case 0xC0: case 0xC1: case 0xC2: case 0xC3: /*Co-pro*/
                                        case 0xC4: case 0xC5: case 0xC6: case 0xC7:
                                        case 0xC8: case 0xC9: case 0xCA: case 0xCB:
                                        case 0xCC: case 0xCD: case 0xCE: case 0xCF:
                                        case 0xD0: case 0xD1: case 0xD2: case 0xD3:
                                        case 0xD4: case 0xD5: case 0xD6: case 0xD7:
                                        case 0xD8: case 0xD9: case 0xDA: case 0xDB:
                                        case 0xDC: case 0xDD: case 0xDE: case 0xDF:
                                        templ=armregs[15]-4;
                                        armregs[15]|=3;
                                        updatemode(SUPERVISOR);
                                        armregs[14]=templ;
                                        armregs[15]&=0xFC000003;
                                        armregs[15]|=0x08000008;
                                        cycles-=4;
                                        refillpipeline();
                                        break;

                                        case 0xF0: case 0xF1: case 0xF2: case 0xF3: /*SWI*/
                                        case 0xF4: case 0xF5: case 0xF6: case 0xF7:
                                        case 0xF8: case 0xF9: case 0xFA: case 0xFB:
                                        case 0xFC: case 0xFD: case 0xFE: case 0xFF:
//                                        if (!olog) olog=fopen("olog.txt","wt");
/*                                        sprintf(err2,"SWI %05X %07X  R0 %08X R1 %08X R9 %08X\n",opcode&0xFFFFF,PC,armregs[0],armregs[1],armregs[9]);
                                        fputs(err2,olog);*/
                                        if ((opcode&0xFFFF)==0xD)
                                        {
//                                                sprintf(err2,"SWI D %08X %08X %08X %07X  ",armregs[0],armregs[1],armregs[2],PC);
//                                                fputs(err2,olog);
                                                if (armregs[0])
                                                {
                                                        addr=armregs[1];
                                                        while (readmemb(addr))
                                                        {
                                                                putc(readmemb(addr),olog);
                                                                addr++;
                                                        }
                                                }
                                                putc('\n',olog);
                                        }
                                        if (mousehack && !fullscreen)
                                        {
                                        if ((opcode&0x1FFFF)==7 && armregs[0]==0x15 && (readmemb(armregs[1])==1))
                                        {
                                                setmouseparams(armregs[1]);
                                        }
                                        else if ((opcode&0x1FFFF)==7 && armregs[0]==0x15 && (readmemb(armregs[1])==4))
                                        {
                                                getunbufmouse(armregs[1]);
                                        }
                                        else if ((opcode&0x1FFFF)==7 && armregs[0]==0x15 && (readmemb(armregs[1])==3))
                                        {
                                                setmousepos(armregs[1]);
                                        }
                                        else if ((opcode&0x1FFFF)==7 && armregs[0]==0x15 && (readmemb(armregs[1])==5))
                                        {
                                                setmousepos(armregs[1]);
                                        }
                                        }
                                        if ((opcode&0xFFFF)==0x1C && mousehack && !fullscreen)
                                        {
                                                getosmouse();
                                                armregs[15]&=~VFLAG;
                                        }
                                        else
                                        {
                                                templ=armregs[15]-4;
                                                armregs[15]|=3;
                                                updatemode(SUPERVISOR);
                                                armregs[14]=templ;
                                                armregs[15]&=0xFC000003;
                                                armregs[15]|=0x0800000C;
                                                cycles-=4;
                                                refillpipeline();
                                        }
                                        break;

                                        default:
                                        sprintf(s,"Bad opcode %02X %08X at %07X\n",(opcode>>20)&0xFF,opcode,PC);
                                        MessageBox(NULL,s,"Arc",MB_OK);
                                        dumpregs();
                                        exit(-1);
                                }
                        }
                        if (databort|armirq|prefabort)
                        {
                                if (prefabort)       /*Prefetch abort*/
                                {
                                        templ=armregs[15];
                                        armregs[15]|=3;
                                        updatemode(SUPERVISOR);
                                        armregs[14]=templ;
                                        armregs[15]&=0xFC000003;
                                        armregs[15]|=0x08000010;
                                        refillpipeline();
                                        prefabort=0;
                                }
                                else if (databort==1)     /*Data abort*/
                                {
//                                        output=0;
/*                                        if (!olog) olog=fopen("armlog.txt","wt");
                                        sprintf(err2,"Dat abort at %07X %i\n",PC,ins);
                                        fputs(err2,olog);
                                        dumpregs();
                                        exit(-1);*/
                                        templ=armregs[15];
                                        armregs[15]|=3;
                                        updatemode(SUPERVISOR);
                                        armregs[14]=templ;
                                        armregs[15]&=0xFC000003;
                                        armregs[15]|=0x08000014;
                                        refillpipeline();
                                        databort=0;
                                }
                                else if (databort==2) /*Address Exception*/
                                {
                                        templ=armregs[15];
                                        armregs[15]|=3;
                                        updatemode(SUPERVISOR);
                                        armregs[14]=templ;
                                        armregs[15]&=0xFC000003;
                                        armregs[15]|=0x08000018;
                                        refillpipeline();
                                        databort=0;
                                }
                                else if ((armirq&2) && !(armregs[15]&0x4000000)) /*FIQ*/
                                {
                                        templ=armregs[15];
                                        armregs[15]|=3;
                                        updatemode(FIQ);
                                        armregs[14]=templ;
                                        armregs[15]&=0xFC000001;
                                        armregs[15]|=0x0C000020;
                                        refillpipeline();
                                }
                                else if ((armirq&1) && !(armregs[15]&0x8000000)) /*IRQ*/
                                {
                                        templ=armregs[15];
                                        armregs[15]|=3;
                                        updatemode(IRQ);
                                        armregs[14]=templ;
                                        armregs[15]&=0xFC000002;
                                        armregs[15]|=0x0800001C;
                                        refillpipeline();
                                }
                        }
//                        if ((PC-8)==0x8000) ins=0;
                        armregs[15]+=4;
                        if ((armregs[15]&3)!=mode) updatemode(armregs[15]&3);
/*                        oopc=opc;
                        opc=PC-8;*/
                        if (oshack && (PC-8)==0x38D824C) armregs[15]|=ZFLAG;
//                        if (PC==0x8000) output=1;
/*                        if (PC==0x38d1b88 || PC==0x38d9dc8 || PC==0x38dd060 || PC==0x38dd384 || PC==0x38dd53c || PC==0x38de204 || PC==0x38de260)
                        {
                                if (!olog) olog=fopen("olog.txt","wt");
                                sprintf(s,"%07X R5 %07X R7 %08X R14 %07X\n",PC,armregs[5],armregs[7],armregs[14]);
                                fputs(s,olog);
                        }
                        if (PC==0x38dcfb4)
                        {
                                output=1;
                                timetolive=50;
                        }
                        if (PC==0x38dd060)
                        {
                                output=1;
                                timetolive=10;
                        }
                        if (PC==0x38e6740)
                        {
                                sprintf(err2,"R3=%08X\n",armregs[3]);
                                fputs(err2,olog);
                        }
                        if (PC==0x38d9dc8)
                        {
                                sprintf(err2,"38d9dc8\n");
                                fputs(err2,olog);
                        }*/
//                        if ((PC-8)==0x396898C) { sprintf(err2,"Hit 396898C R1 %08X R2 %08X R12 %08X\n",armregs[1],armregs[2],armregs[12]); fputs(err2,olog); }
//                        if ((PC-8)==0x6FC48) { output=1; /*timetolive=50;*/ }
//                        if (output &&
/*                        if ((PC-8)==0x38D0D90) { output=1; timetolive=50; }
                        if ((PC-8)==0x38DE21C) { output=1; timetolive=50; }
                        if ((PC-8)==0x38D0BB8) { output=1; timetolive=500; }
                        if ((PC-8)==0x38D1278) { output=1; timetolive=2000; }
                        if ((PC-8)==0x38E3530) { output=1; timetolive=2000; }
                        if (armregs[2]==0x80002000 && oldr2!=armregs[2])
                        {
                                sprintf(err2,"R2 80002000 at %07X\n",PC-8);
                                fputs(err2,olog);
                        }
                        oldr2=armregs[2];
                        if (armregs[1]==4 && oldr1!=armregs[1])
                        {
                                sprintf(err2,"R1 4 at %07X %07X %07X\n",PC-8,opc,oopc);
                                fputs(err2,olog);
                        }
                        oldr1=armregs[1];*/
//                        if (ins==3590000) output=1;
//                        if (ins==33200000) output=1;
/*                        if (output)
                        {
                                if (!olog) olog=fopen("olog.txt","wt");
                                sprintf(err2,"%i : %07X %08X %08X %08X %08X %08X %08X %08X %08X %08X  %08X %08X %08X - %08X %08X\n",ins,PC,armregs[0],armregs[1],armregs[2],armregs[3],armregs[4],armregs[5],armregs[6],armregs[7],armregs[8],armregs[12],armregs[13],armregs[14],armregs[15],opcode);
                                fputs(err2,olog);
                        }*/
//                        if (ins==3595000) exit(0);*/
                        if (timetolive)
                        {
                                timetolive--;
                                if (!timetolive)
                                   output=0;
                        }
                        cyc=(oldcyc2-cycles);
                        ioc.timerc[0]-=(cyc<<1);
                        ioc.timerc[1]-=(cyc<<1);
                        if ((ioc.timerc[0]<0) || (ioc.timerc[1]<0)) updateioctimers();
                        soundtime-=cyc;
                        if (soundtime<0)
                        {
                                pollsound();
                                if (!speed)        soundtime+=32;
                                else if (speed==1) soundtime+=48;
                                else               soundtime+=96;
                        }
                        linecyc-=(cyc<<1);
                        inscount++;
                        ins++;
                }
                pollline();
                cyc=(oldcyc-cycles);
                if (keydelay)
                {
                        keydelay-=128;
                        if (keydelay<1) { keydelay=0; keycallback(); }
                }
                if (keydelay2)
                {
                        keydelay2-=128;
                        if (keydelay2<1) { keydelay2=0; keycallback2(); }
                }
                if (discint)
                {
                        discint-=128;
                        if (discint<1) { discint=0; callback();/*callback82c711();*/ }
                }
/*                if (discrint)
                {
                        discrint-=128;
                        if (discrint<1) { discrint=0; callbackr82c711(); }
                }*/
/*                if (disccint)
                {
                        disccint-=128;
                        if (disccint<1) { disccint=0; discchangecint(); }
                }*/
/*                disciint-=128;
                if (disciint<0)
                {
                        disciint+=400000;
                        callback82c711index();
                }*/
        }
}

/*6FC48 - MOV R0,PC*/
