/*Arculator 0.3 by Tom Walker
  Main header file*/
  
/*ARM*/
unsigned long *usrregs[16],userregs[16],superregs[16],fiqregs[16],irqregs[16];
unsigned long armregs[16];
int armirq,armfiq;
#define PC ((armregs[15])&0x3FFFFFC)
int ins,output;

void resetarm();
void execarm(int cycles);
void dumpregs();
int databort;
unsigned long opcode,opcode2,opcode3;

/*IOC*/
struct
{
        unsigned char irqa,irqb,fiq;
        unsigned char mska,mskb,mskf;
        unsigned char ctrl;
        int timerc[4],timerl[4],timerr[4];
} ioc;

/*Memory*/
int modepritabler[3][6],modepritablew[3][6];
unsigned long *mempoint[0x800];
unsigned char *mempointb[0x800];
int memstat[0x800];
unsigned long *ram,*rom;
int memmode;

#define readmemb(a)    ((modepritabler[memmode][memstat[((a)>>15)&0x7FF]])?mempointb[((a)>>15)&0x7FF][(a)&0x7FFF]:readmemfb(a))
#define readmeml(a)    ((modepritabler[memmode][memstat[((a)>>15)&0x7FF]])?mempoint[((a)>>15)&0x7FF][((a)&0x7FFF)>>2]:readmemfl(a))
#define writememb(a,v) if (modepritablew[memmode][memstat[((a)>>15)&0x7FF]]) mempointb[((a)>>15)&0x7FF][(a)&0x7FFF]=(v&0xFF); else writememfb(a,v);
#define writememl(a,v) if (modepritablew[memmode][memstat[((a)>>15)&0x7FF]]) mempoint[((a)>>15)&0x7FF][((a)&0x7FFF)>>2]=v; else writememfl(a,v);

/*MEMC*/
unsigned long vinit,vstart,vend;
unsigned long cinit;
unsigned long sstart,ssend,ssend2,sptr;

/*VIDC*/
unsigned long vidcr[64];
int soundhz,soundper;
int offsetx,offsety;
int fullborders;
//int mousex,mousey;

/*Disc*/
char discname[4][512];
int curdrive;
int discchange[4];

int soundena,mousehack,oshack;
int fullscreen;
int speed;
int arm3;

/*Mouse*/
int ml,mr,mt,mb;


char exname[512];
