/*Arculator 0.25 by Tom Walker
  VIDC10 emulation*/
#include <stdio.h>
FILE *olog;
#include <allegro.h>
#include "arc.h"

int readflash[4];
int ledcaps,lednum,ledscr;
int track,sector;
float inssec;
int curx,cursy,curey;
int hstart,hbstart,hend,hbend;
int vstart2,vend2;
int acc=0;
unsigned short lookup4bpp[256];

void makelookup()
{
        int c;
        for (c=0;c<256;c++)
        {
                lookup4bpp[c]=c&15;
                lookup4bpp[c]|=(c&0xF0)<<4;
        }
}

float sampdiff;
unsigned long sdif;

struct
{
        unsigned long vtot,htot;
        int line;
        int displayon,borderon;
        unsigned long addr,caddr;
        int cycs;
        int vbstart,vbend;
        int vdstart,vdend;
        int hbstart,hbend;
        int hdstart,hdend;
        int sync,inter;
        unsigned short pal[32],pal8[256];
        int cx,cys,cye;
} vidc;

int palchange;
unsigned long vidlookup[256];

void redolookup()
{
        int c;
        switch (vidcr[0x38]&0xF)
        {
                case 8: /*Mode 9*/
                for (c=0;c<16;c++)
                {
                        vidlookup[c]=vidc.pal[c&0xF]|(vidc.pal[c&0xF]<<16);
                }
                break;
                case 10: /*Mode 12*/
                for (c=0;c<256;c++)
                {
                        vidlookup[c]=vidc.pal[c&0xF]|(vidc.pal[(c>>4)&0xF]<<16);
                }
                break;
        }
}

void writevidc(unsigned long v)
{
        char s[80];
        RGB r;
        int c,d;
        vidcr[v>>26]=v;
        if ((v>>26)<0x14)
        {
                r.b=(v&0xF00)>>6;
                r.g=(v&0xF0)>>2;
                r.r=(v&0xF)<<2;
                vidc.pal[(v>>26)&0x1F]=makecol(r.r<<2,r.g<<2,r.b<<2);
                d=v>>26;
                palchange=1;
                for (c=d;c<0x100+d;c+=16)
                {
                        r.r=vidcr[d&15]&0xF;
                        r.g=(vidcr[d&15]&0xF0)>>4;
                        r.b=(vidcr[d&15]&0xF00)>>8;
                        if (c&0x10) r.r|=8; else r.r&=~8;
                        if (c&0x20) r.g|=4; else r.g&=~4;
                        if (c&0x40) r.g|=8; else r.g&=~8;
                        if (c&0x80) r.b|=8; else r.b&=~8;
                        if (c<0x100) vidc.pal8[c]=makecol(r.r<<4,r.g<<4,r.b<<4);
                }
        }
        if ((v>>24)==0x98) curx=((v&0xFFF000)>>13)-255;//printf("VIDC 98 write %i\n",(v&0xFFF000)>>13);
        if ((v>>24)==0xB8) cursy=((v&0xFFF000)>>14)-37;//printf("VIDC B8 write %i\n",(v&0xFFF000)>>13);
        if ((v>>24)==0xBC) curey=((v&0xFFF000)>>14)-37;//printf("VIDC BC write %i\n",(v&0xFFF000)>>13);
        if ((v>>24)==0x88) { hbstart=(v&0x3FF000)>>12; /*printf("Diff %i\n",(hbstart>>1)-(hstart>>1));*/ }
        if ((v>>24)==0x8C) { hstart=(v&0x3FF000)>>12; /*printf("Diff %i\n",(hbstart>>1)-(hstart>>1));*/ }
        if ((v>>24)==0x90) hend=(v&0x3FF000)>>12;
        if ((v>>24)==0x94) hbend=(v&0x3FF000)>>12;
        if ((v>>24)==0xAC) vstart2=(v&0xFFF000)>>14;
        if ((v>>24)==0xB0) vend2=(v&0xFFF000)>>14;
        if ((v>>24)==0x80) vidc.htot=(v&0xFFFFFF)>>14;
        if ((v>>24)==0xA0) vidc.vtot=((v&0xFFFFFF)>>14)+1;
        if ((v>>24)==0x84) vidc.sync=(v&0xFFFFFF);
        if ((v>>24)==0x88) vidc.hbstart=((v&0xFFFFFF)>>14);
        if ((v>>24)==0x8C)
        {
                vidc.hdstart=((v&0xFFFFFF)>>14);
        }
        if ((v>>24)==0x90) vidc.hdend=((v&0xFFFFFF)>>14);
        if ((v>>24)==0x94) vidc.hbend=((v&0xFFFFFF)>>14);
        if ((v>>24)==0x9C) vidc.inter=(v&0xFFFFFF);
        if ((v>>24)==0xA8) vidc.vbstart=((v&0xFFFFFF)>>14)+1;
        if ((v>>24)==0xAC)
        {
                vidc.vdstart=((v&0xFFFFFF)>>14)+1;
        }
        if ((v>>24)==0xB0) vidc.vdend=((v&0xFFFFFF)>>14)+1;
        if ((v>>24)==0xB4) vidc.vbend=((v&0xFFFFFF)>>14)+1;
        if ((v>>24)==0x98) vidc.cx=(v&0xFFE000);
        if ((v>>24)==0xB8) vidc.cys=(v&0xFFC000);
        if ((v>>24)==0xBC) vidc.cye=(v&0xFFC000);
        if ((v>>24)==0xC0)
        {
                soundhz=250000/((v&0xFF)+2);
                soundper=((v&0xFF)+2);//8000000/soundhz;
                sampdiff=200.0f/(float)soundper;
                sdif=(int)((float)sampdiff*4096.0f);
        }
//        printf("VIDC write %08X\n",v);
}

BITMAP *b,*b2;
int deskdepth;

void initvid()
{
        int depth;
        allegro_init();
        depth=deskdepth=desktop_color_depth();
        if (depth==16)
        {
                set_color_depth(16);
                if (set_gfx_mode(GFX_AUTODETECT_WINDOWED,800,600,0,0))
                {
                        set_color_depth(15);
                        depth=15;
                        set_gfx_mode(GFX_AUTODETECT_WINDOWED,800,600,0,0);
                }
        }
        else if (depth)
        {
                set_color_depth(depth);
                set_gfx_mode(GFX_AUTODETECT_WINDOWED,800,600,0,0);
        }
        else
           set_gfx_mode(GFX_AUTODETECT_WINDOWED,800,600,0,0);
        if (depth!=15) set_color_depth(16);
        else           set_color_depth(15);
//        set_color_depth(8);
        b=create_bitmap(1024,1024);
        b2=create_bitmap(80,600);
        clear(b);
        makelookup();
        vidc.line=0;
}

void reinitvideo()
{
        if (fullscreen)
        {
                set_color_depth(16);
                set_gfx_mode(GFX_AUTODETECT_FULLSCREEN,800,600,0,0);
        }
        else
        {
                if (deskdepth==16)
                {
                        set_color_depth(16);
                        if (set_gfx_mode(GFX_AUTODETECT_WINDOWED,800,600,0,0))
                        {
                                set_color_depth(15);
                                set_gfx_mode(GFX_AUTODETECT_WINDOWED,800,600,0,0);
                        }
                }
                else if (deskdepth)
                {
                        set_color_depth(deskdepth);
                        set_gfx_mode(GFX_AUTODETECT_WINDOWED,800,600,0,0);
                }
                else
                   set_gfx_mode(GFX_AUTODETECT_WINDOWED,800,600,0,0);
                if (deskdepth!=15) set_color_depth(16);
                else               set_color_depth(15);
        }
}

//#if 0
int lastblack=0;
PALETTE pal;

void updatepal()
{
        int c;
        switch (vidcr[0x38]&0xC)
        {
                case 0x0: /*1 bpp*/
                case 0x4: /*2 bpp*/
                case 0x8: /*4 bpp*/
                for (c=0;c<20;c++)
                {
                        pal[c].r=(vidcr[c]&0xF)<<2;
                        pal[c].g=((vidcr[c]&0xF0)>>4)<<2;
                        pal[c].b=((vidcr[c]&0xF00)>>8)<<2;
                }
                break;
                case 0xC: /*8 bpp*/
                for (c=0;c<256;c++)
                {
                        pal[c].r=vidcr[c&15]&0xF;
                        pal[c].g=(vidcr[c&15]&0xF0)>>4;
                        pal[c].b=(vidcr[c&15]&0xF00)>>8;
                        if (c&0x10) pal[c].r|=8; else pal[c].r&=~8;
                        if (c&0x20) pal[c].g|=4; else pal[c].g&=~4;
                        if (c&0x40) pal[c].g|=8; else pal[c].g&=~8;
                        if (c&0x80) pal[c].b|=8; else pal[c].b&=~8;
                        pal[c].r<<=2; pal[c].g<<=2; pal[c].b<<=2;
                }
                break;
        }
}
//#endif

void drawvid()
{
}

FILE *vlog;
void pollline()
{
        int col=0;
        int x,xx,xl,y;
        unsigned long temp;
        unsigned long *p;
        char s[256];
        int l=(vidc.line-16)<<1;
        if (palchange)
        {
                redolookup();
                palchange=0;
        }
        if (vidc.line==vidc.vbstart) vidc.borderon=0;
        if (vidc.line==vidc.vdstart) vidc.displayon=1;
        if (vidc.line==vidc.vdend)
        {
                vidc.displayon=0;
                ioc.irqa|=8;
                updateirqs();
        }
        if (vidc.line==vidc.vbend)   vidc.borderon=1;
//#if 0
        if (vidc.line>=16 && vidc.line<=316)
        {
                if (vidc.displayon)
                {
                        switch (vidcr[0x38]&0xF)
                        {
                                case 2: /*Mode 0*/
                                xl=((vidc.hdend+1)<<1)-168;
                                x=((vidc.hdstart+1)<<1)-168;
                                for (;x<xl,x<800;x+=32)
                                {
                                        temp=ram[vidc.addr++];
                                        ((unsigned short *)b->line[l])[x]=vidc.pal[temp&1];
                                        ((unsigned short *)b->line[l])[x+1]=vidc.pal[(temp>>1)&1];
                                        ((unsigned short *)b->line[l])[x+2]=vidc.pal[(temp>>2)&1];
                                        ((unsigned short *)b->line[l])[x+3]=vidc.pal[(temp>>3)&1];
                                        ((unsigned short *)b->line[l])[x+4]=vidc.pal[(temp>>4)&1];
                                        ((unsigned short *)b->line[l])[x+5]=vidc.pal[(temp>>5)&1];
                                        ((unsigned short *)b->line[l])[x+6]=vidc.pal[(temp>>6)&1];
                                        ((unsigned short *)b->line[l])[x+7]=vidc.pal[(temp>>7)&1];
                                        ((unsigned short *)b->line[l])[x+8]=vidc.pal[(temp>>8)&1];
                                        ((unsigned short *)b->line[l])[x+9]=vidc.pal[(temp>>9)&1];
                                        ((unsigned short *)b->line[l])[x+10]=vidc.pal[(temp>>10)&1];
                                        ((unsigned short *)b->line[l])[x+11]=vidc.pal[(temp>>11)&1];
                                        ((unsigned short *)b->line[l])[x+12]=vidc.pal[(temp>>12)&1];
                                        ((unsigned short *)b->line[l])[x+13]=vidc.pal[(temp>>13)&1];
                                        ((unsigned short *)b->line[l])[x+14]=vidc.pal[(temp>>14)&1];
                                        ((unsigned short *)b->line[l])[x+15]=vidc.pal[(temp>>15)&1];
                                        ((unsigned short *)b->line[l])[x+16]=vidc.pal[(temp>>16)&1];
                                        ((unsigned short *)b->line[l])[x+17]=vidc.pal[(temp>>17)&1];
                                        ((unsigned short *)b->line[l])[x+18]=vidc.pal[(temp>>18)&1];
                                        ((unsigned short *)b->line[l])[x+19]=vidc.pal[(temp>>19)&1];
                                        ((unsigned short *)b->line[l])[x+20]=vidc.pal[(temp>>20)&1];
                                        ((unsigned short *)b->line[l])[x+21]=vidc.pal[(temp>>21)&1];
                                        ((unsigned short *)b->line[l])[x+22]=vidc.pal[(temp>>22)&1];
                                        ((unsigned short *)b->line[l])[x+23]=vidc.pal[(temp>>23)&1];
                                        ((unsigned short *)b->line[l])[x+24]=vidc.pal[(temp>>24)&1];
                                        ((unsigned short *)b->line[l])[x+25]=vidc.pal[(temp>>25)&1];
                                        ((unsigned short *)b->line[l])[x+26]=vidc.pal[(temp>>26)&1];
                                        ((unsigned short *)b->line[l])[x+27]=vidc.pal[(temp>>27)&1];
                                        ((unsigned short *)b->line[l])[x+28]=vidc.pal[(temp>>28)&1];
                                        ((unsigned short *)b->line[l])[x+29]=vidc.pal[(temp>>29)&1];
                                        ((unsigned short *)b->line[l])[x+30]=vidc.pal[(temp>>30)&1];
                                        ((unsigned short *)b->line[l])[x+31]=vidc.pal[(temp>>31)&1];
                                        if (vidc.addr==vend+4) vidc.addr=vstart;
                                }
                                break;
                                case 8: /*Mode 9*/
                                xl=((vidc.hdend+1)<<2)-176;
                                x=((vidc.hdstart+1)<<2)-176;
                                p=(unsigned long *)(b->line[l]+(x<<1));
                                xl-=x;
                                xl>>=1;
                                xx=x;
                                for (x=0;(x<xl)&&(x<(800-xx));x+=8)
                                {
                                        temp=ram[vidc.addr++];
                                        p[0]=vidlookup[temp&0xF];
                                        p[1]=vidlookup[(temp>>4)&0xF];
                                        p[2]=vidlookup[(temp>>8)&0xF];
                                        p[3]=vidlookup[(temp>>12)&0xF];
                                        p[4]=vidlookup[(temp>>16)&0xF];
                                        p[5]=vidlookup[(temp>>20)&0xF];
                                        p[6]=vidlookup[(temp>>24)&0xF];
                                        p[7]=vidlookup[(temp>>28)&0xF];
                                        p+=8;
                                        if (vidc.addr==vend+4) vidc.addr=vstart;
                                }
                                xl=((vidc.hdend+1)<<2)-176;
                                break;
                                case 10: /*Mode 12*/
                                xl=((vidc.hdend+1)<<1)-176;
                                x=((vidc.hdstart+1)<<1)-176;
                                p=(unsigned long *)(b->line[l]+(x<<1));
                                xl-=x;
                                xl>>=1;
                                xx=x;
                                for (x=0;(x<xl)&&(x<(800-xx));x+=4)
                                {
                                        temp=ram[vidc.addr++];
                                        p[0]=vidlookup[temp&0xFF];
                                        p[1]=vidlookup[(temp>>8)&0xFF];
                                        p[2]=vidlookup[(temp>>16)&0xFF];
                                        p[3]=vidlookup[(temp>>24)&0xFF];
                                        p+=4;
                                        if (vidc.addr==vend+4) vidc.addr=vstart;
                                }
                                xl=((vidc.hdend+1)<<1)-176;
                                break;
                                case 12: /*Mode 13*/
                                xl=((vidc.hdend+1)<<2)-176;
                                x=((vidc.hdstart+1)<<2)-176;
                                for (;(x<xl)&&(x<800);x+=8)
                                {
                                        temp=ram[vidc.addr++];
                                        if (x<800)
                                        {
                                                ((unsigned short *)b->line[l])[x]=((unsigned short *)b->line[l])[x+1]=vidc.pal8[temp&0xFF];
                                                ((unsigned short *)b->line[l])[x+2]=((unsigned short *)b->line[l])[x+3]=vidc.pal8[(temp>>8)&0xFF];
                                                ((unsigned short *)b->line[l])[x+4]=((unsigned short *)b->line[l])[x+5]=vidc.pal8[(temp>>16)&0xFF];
                                                ((unsigned short *)b->line[l])[x+6]=((unsigned short *)b->line[l])[x+7]=vidc.pal8[(temp>>24)&0xFF];
                                        }
                                        if (vidc.addr==vend+4) vidc.addr=vstart;
                                }
                                break;
                                case 14: /*Mode 15*/
                                xl=((vidc.hdend+1)<<1)-176;
                                x=((vidc.hdstart+1)<<1)-176;
                                for (;(x<xl)&&(x<800);x+=4)
                                {
                                        temp=ram[vidc.addr++];
                                        ((unsigned short *)b->line[l])[x]=vidc.pal8[temp&0xFF];
                                        ((unsigned short *)b->line[l])[x+1]=vidc.pal8[(temp>>8)&0xFF];
                                        ((unsigned short *)b->line[l])[x+2]=vidc.pal8[(temp>>16)&0xFF];
                                        ((unsigned short *)b->line[l])[x+3]=vidc.pal8[(temp>>24)&0xFF];
                                        if (vidc.addr==vend+4) vidc.addr=vstart;
                                }
                                break;

                                default:
                                textprintf(b,font,0,0,0x7FFF,"%i",vidcr[0x38]&0xF);
                        }
                        if (((vidc.cys>>14)+1)<=vidc.line && ((vidc.cye>>14)+1)>vidc.line)
                        {
                                switch (vidcr[0x38]&0xF)
                                {
                                        case 8: /*Mode 9*/
                                        case 12: /*Mode 13*/
                                        x=(((vidc.cx>>14)+1)<<2)-178;
                                        if (x>800) break;
                                        temp=ram[vidc.caddr++];
                                        for (xx=0;xx<32;xx+=2)
                                        {
                                                if (temp&3) ((unsigned short *)b->line[l])[x+xx]=((unsigned short *)b->line[l])[x+xx+1]=vidc.pal[(temp&3)|0x10];
                                                temp>>=2;
                                        }
                                        temp=ram[vidc.caddr++];
                                        for (xx=32;xx<64;xx+=2)
                                        {
                                                if (temp&3) ((unsigned short *)b->line[l])[x+xx]=((unsigned short *)b->line[l])[x+xx+1]=vidc.pal[(temp&3)|0x10];
                                                temp>>=2;
                                        }
//                                        hline(b,x,l,x+31,0xFFFF);
                                        break;

                                        case 2:  /*Mode 0*/
                                        case 10: /*Mode 12*/
                                        case 14: /*Mode 15*/
                                        x=(((vidc.cx>>14)+1)<<1)-176;
                                        if (x>800) break;
                                        temp=ram[vidc.caddr++];
                                        for (xx=0;xx<16;xx++)
                                        {
                                                if (temp&3) ((unsigned short *)b->line[l])[x+xx]=vidc.pal[(temp&3)|0x10];
                                                temp>>=2;
                                        }
                                        temp=ram[vidc.caddr++];
                                        for (xx=16;xx<32;xx++)
                                        {
                                                if (temp&3) ((unsigned short *)b->line[l])[x+xx]=vidc.pal[(temp&3)|0x10];
                                                temp>>=2;
                                        }
//                                        hline(b,x,l,x+31,0xFFFF);
                                        break;
                                }
                        }
                        switch (vidcr[0x38]&0xF)
                        {
                                case 8: /*Mode 9*/
                                if (((vidc.hbstart<<2)-184)<(((vidc.hdstart+1)<<2)-176))
                                   hline(b,0,l,((vidc.hdstart+1)<<2)-177,vidc.pal[0x10]);
                                else
                                   hline(b,0,l,(vidc.hbstart<<2)-185,vidc.pal[0x10]);
                                if (((vidc.hbend<<2)-184) < xl)
                                   hline(b,(vidc.hbend<<2)-184,l,799,vidc.pal[0x10]);
                                else
                                   hline(b,xl,l,799,vidc.pal[0x10]);
                                break;
                                case 12: /*Mode 13*/
                                if (((vidc.hbstart<<2)-184)<(((vidc.hdstart+1)<<2)-176))
                                   hline(b,0,l,((vidc.hdstart+1)<<2)-177,vidc.pal[0x10]);
                                else
                                   hline(b,0,l,(vidc.hbstart<<2)-181,vidc.pal[0x10]);
                                if (((vidc.hbend<<2)-182) < xl)
                                   hline(b,(vidc.hbend<<2)-184,l,799,vidc.pal[0x10]);
                                else
                                   hline(b,xl,l,799,vidc.pal[0x10]);
                                break;
                                case 2:  /*Mode 0*/
                                case 10: /*Mode 12*/
                                case 14: /*Mode 15*/
                                if (((vidc.hbstart<<1)-184)<(((vidc.hdstart+1)<<1)-176))
                                   hline(b,0,l,((vidc.hdstart+1)<<1)-177,vidc.pal[0x10]);
                                else
                                   hline(b,0,l,(vidc.hbstart<<1)-185,vidc.pal[0x10]);
                                if (((vidc.hbend<<1)-184)<xl)
                                   hline(b,(vidc.hbend<<1)-184,l,799,vidc.pal[0x10]);
                                else
                                   hline(b,xl,l,799,vidc.pal[0x10]);
                                break;
                        }
                }
                if (vidc.borderon || !vidc.displayon)
                {
                        hline(b,0,l,799,vidc.pal[16]);
                }
        }
//#endif
        vidc.line++;
        if (vidc.line>=vidc.vtot)
        {
                if (vidc.line==vidc.vtot)
                {
//                textprintf(b,font,0,0,0x7FFF,"%08X %08X   ",vidc.hdstart,vidc.hbstart);
                        if (fullborders|fullscreen)
                           blit(b,screen,0,0,0,0,800,600);
                        else
                           blit(b,screen,60,24,0,0,672,544);
/*                        else
                        {
                                for (y=0;y<544;y+=2)
                                    blit(b,screen,60,y+24,0,y,672,1);
                        }*/

                        if (fullborders|fullscreen)
                        {
                                if (readflash[0]) rectfill(screen,780,4,796,8,makecol(255,160,32));
                                if (readflash[1]) rectfill(screen,760,4,776,8,makecol(255,160,32));
                                if (readflash[2]) rectfill(screen,740,4,756,8,makecol(255,160,32));
                                if (readflash[3]) rectfill(screen,720,4,736,8,makecol(255,160,32));
                        }
                        else
                        {
                                if (readflash[0]) rectfill(screen,652,4,668,8,makecol(255,160,32));
                                if (readflash[1]) rectfill(screen,632,4,648,8,makecol(255,160,32));
                                if (readflash[2]) rectfill(screen,612,4,628,8,makecol(255,160,32));
                                if (readflash[3]) rectfill(screen,592,4,608,8,makecol(255,160,32));
                        }
                        readflash[0]=readflash[1]=readflash[2]=readflash[3]=0;
                }
                vidc.line=0;
                vidc.addr=vinit;
                vidc.caddr=cinit;
                if (!(vidcr[0x38]&3)) offsetx=((vidc.hdstart+1)<<2)-176;
                else                  offsetx=((vidc.hdstart+1)<<1)-176;
                offsety=(vidc.vdstart-16)<<1;
                if (!fullborders)
                {
                        offsetx-=60;
                        offsety-=24;
                }
        }
}

int vidcgetcycs()
{
        int temp=(vidc.htot+1)<<1;
        if (vidcr[0x38]&2) temp>>=1;
        vidc.cycs=temp<<1;
        if (!speed) return temp<<1;
        else if (speed==1) return temp*3;
        return temp*6;
}

//117-436
void dumpvid()
{
        int c,x,y;
        unsigned char temp;
        BITMAP *b;
        allegro_init();
        set_gfx_mode(GFX_AUTODETECT,640,480,0,0);
        b=create_bitmap(640,256);
        c=0;
        for (y=0;y<256;y++)
        {
                for (x=0;x<640;x+=8)
                {
                        temp=((unsigned char *)ram)[c]; c++;
                        b->line[y][x+7]=(temp>>7)&1;
                        b->line[y][x+6]=(temp>>6)&1;
                        b->line[y][x+5]=(temp>>5)&1;
                        b->line[y][x+4]=(temp>>4)&1;
                        b->line[y][x+3]=(temp>>3)&1;
                        b->line[y][x+2]=(temp>>2)&1;
                        b->line[y][x+1]=(temp>>1)&1;
                        b->line[y][x+0]=temp&1;
                }
        }
        save_pcx("arc.pcx",b,desktop_palette);
}
