/*Arculator 0.25 by Tom Walker
  MEMC1a emulation*/

#include <stdio.h>
#include "arc.h"
#include <allegro.h>
#include <winalleg.h>

unsigned long memctrl;
signed short soundbuf[2][50000];
int sinprog=0;
int sdmaena=0;
int bigcyc=0;
char err2[256];
FILE *olog;
int logsound;
int osmode;
int memcpages[0x400];
int samppos=0,sampbuf=0;
AUDIOSTREAM *as;
int spdcount;
FILE *soundf;
FILE *slogfile;

void initsound()
{
        unsigned short *p;
        if (!soundena) return;
        if (install_sound(DIGI_AUTODETECT,MIDI_NONE,0))
        {
                soundena=0;
                return;
        }
        as=play_audio_stream(25000>>3,16,0,125000>>2,255,128);
        p=0;
        while (!p)
        {
                p=(unsigned short *)get_audio_stream_buffer(as);
                sleep(0);
        }
        while (!spdcount)
        {
                sleep(0);
        }
        free_audio_stream_buffer(as);
//        soundf=fopen("sound.pcm","wb");
//        slogfile=fopen("sound.txt","wt");
}

void deinitsound()
{
        stop_audio_stream(as);
        remove_sound();
}

signed short lastbuffer[2]={0,0};
void mixsound()
{
        int c;
        unsigned short *p;
        short temp;
        float tempf,tempf2;
        if (!soundena) return;
        p=0;
        while (!p)
        {
                p=(unsigned short *)get_audio_stream_buffer(as);
                sleep(0);
        }
        for (c=0;c<((25000>>1)>>2);c++)
        {
                temp=(soundbuf[sampbuf^1][c<<3]/16);
                temp+=(soundbuf[sampbuf^1][(c<<3)+1]/16);
                temp+=(soundbuf[sampbuf^1][(c<<3)+2]/16);
                temp+=(soundbuf[sampbuf^1][(c<<3)+3]/16);
                temp+=(soundbuf[sampbuf^1][(c<<3)+4]/16);
                temp+=(soundbuf[sampbuf^1][(c<<3)+5]/16);
                temp+=(soundbuf[sampbuf^1][(c<<3)+6]/16);
                temp+=(soundbuf[sampbuf^1][(c<<3)+7]/16);
                tempf=((float)lastbuffer[0]*((float)13/(float)16));
                temp+=tempf;
                lastbuffer[1]=lastbuffer[0];
                lastbuffer[0]=temp;
                p[c]=temp;
        }
//        memcpy(p,&soundbuf[sampbuf^1][0],50000>>1);
        for (c=0;c<((25000>>1)>>2);c++) p[c]^=0x8000;
        free_audio_stream_buffer(as);
}

signed short convbyte(unsigned char v)
{//                         7C       chord = 3     p = E/14
        signed short temp=1<<((v>>5)+4);
        temp+=(((v>>1)&0xF)<<(v>>5));
        if (v&1) temp=-temp;
        return temp;
/*        unsigned char temp=(1<<(v>>5))-1;             //  temp=7
        if (v&0x80) temp+=(((v>>1)&0xF)<<((v>>5)-4));  // +14<<
        else        temp+=(((v>>1)&0xF)>>(4-(v>>5)));
        temp>>=1;
        if (v&1) temp=(temp^0xFF)+1;
        return temp;*/
}

signed short samples[8];
int samplecount=0,sampledelay=0;
//float lastsamp;

unsigned short mixsample()
{
        signed short temp2=0;
        unsigned short *temp3;
        signed short temp=samples[0];//((signed short)((signed char)convbyte(samples[0])))*8;
        float tempf;
        temp3=&temp2;
        temp2+=temp;
/*        temp=((signed short)((signed char)convbyte(samples[1])))*16;
        temp2+=temp;
        temp=((signed short)((signed char)convbyte(samples[2])))*16;
        temp2+=temp;
        temp=((signed short)((signed char)convbyte(samples[3])))*16;
        temp2+=temp;
        temp=((signed short)((signed char)convbyte(samples[4])))*16;
        temp2+=temp;
        temp=((signed short)((signed char)convbyte(samples[5])))*16;
        temp2+=temp;
        temp=((signed short)((signed char)convbyte(samples[6])))*16;
        temp2+=temp;
        temp=((signed short)((signed char)convbyte(samples[7])))*16;
        temp2+=temp;*/
//        putc((*temp3)&0xFF,soundf);
//        putc((*temp3)>>8,soundf);
/*        tempf=((float)lastbuffer[0]*((float)13/(float)16));
        temp2+=tempf;
        lastbuffer[1]=lastbuffer[0];
        lastbuffer[0]=temp2;*/
//        if (samppos&3)
//           soundbuf[sampbuf][(samppos>>2)]+=(*temp3);
//        else
//        if ((samppos&3)==3)
//        {
/*                tempf=((float)lastbuffer[1]*((float)13/(float)16));
                temp2+=tempf;
                lastbuffer[1]=lastbuffer[0];
                lastbuffer[0]=temp2;*/
//        }
           soundbuf[sampbuf][samppos]=temp;
        samppos++;
        if (samppos==(50000>>1))
        {
                samppos=0;
                sampbuf^=1;
        }
        return *temp3;
}

int soundtime;
float sampdiff;
unsigned long spos,sdif,soend;
#define getdmaaddr(addr) (((addr>>2)&0x7FFF)<<2)
void writememc(unsigned long a)
{
        int c;
        char s[256];
/*        if (!slogfile) slogfile=fopen("slog.txt","wt");
        if (a&0x7080)
        {
                sprintf(s,"Write %08X %04X\n",a,a&0x7080);
                fputs(s,slogfile);
        }*/
        switch ((a>>17)&7)
        {
                case 0: /*printf("MEMC write %08X - VINIT  = %05X\n",a,getdmaaddr(a));*/ vinit=getdmaaddr(a); return;
                case 1: /*printf("MEMC write %08X - VSTART = %05X\n",a,getdmaaddr(a));*/ vstart=getdmaaddr(a); return;
                case 2: /*printf("MEMC write %08X - VEND   = %05X\n",a,getdmaaddr(a));*/ vend=getdmaaddr(a); return;
                case 3: /*printf("MEMC write %08X - CINIT  = %05X\n",a,getdmaaddr(a));*/ cinit=getdmaaddr(a); /*printf("CINIT=%05X\n",cinit<<2);*/ return;
                case 4: /*sprintf(s,"%08i MEMC write %08X - SSTART = %05X %05X\n",bigcyc,a,getdmaaddr(a),spos);*/
//                fputs(s,slogfile);
//                if (!logsound) return;
                sstart=getdmaaddr(a); /*printf("SSTART=%05X\n",sstart<<2);*/
//                soundtime=soundper*(ssend-sstart);
                ioc.irqb&=~2;
                updateirqs();
                spos=sstart;
                sinprog=1;
//                for (c=sstart;c<ssend;c++) mixsamp(ram[c]);
                return;
                case 5: /*sprintf(s,"%08i MEMC write %08X - SEND   = %05X %05X\n",bigcyc,a,getdmaaddr(a),spos);*/ ssend=getdmaaddr(a); /*printf("SEND=%05X\n",send<<2);*/
//                fputs(s,slogfile);
//                soend=ssend;
                ioc.irqb&=~2;
                updateirqs();
                return;
                case 6: /*sprintf(s,"%08i MEMC write %08X - SPTR   = %05X %05X\n",bigcyc,a,getdmaaddr(a),spos);*/ sptr=getdmaaddr(a); /*printf("SPTR=%05X\n",sptr); */
//                fputs(s,slogfile);
//                if (!logsound) return;
//                soundtime=27500;
                spos=sstart;
                ioc.irqb&=~2;
                updateirqs();
                sinprog=1;
                return;
                case 7: osmode=(a&0x1000)?1:0; /*MEMC ctrl*/
                sdmaena=(a&0x800)?1:0;
                memctrl=a;
                return;
                
                default:
                sprintf(err2,"Bad MEMC adr %i %08X\n",(a>>17)&7,a);
                MessageBox(NULL,err2,"Arc",MB_OK);
                dumpregs();
                exit(-1);
        }
}

void pollsound()
{
        char s[256];
        float tempf;
        mixsample();
        if (!sinprog || !sdmaena) return;
        sampledelay++;
        if (sampledelay>=soundper)
        {
//                if (!slogfile) slogfile=fopen("slogfile.txt","wt");
//                sprintf(s,"New sample %05X %i %i %i\n",spos,samplecount,soundper,sampledelay);
//                fputs(s,slogfile);
                sampledelay=0;
                samples[0/*samplecount*/]=(ram[spos&0x1FFFF]>>((spos&3)<<3))&0xFF;
                samples[0]=convbyte(samples[0])*2;
//                tempf=(float)lastsamp*((float)13/(float)16);
//                samples[0]+=tempf;
//                lastsamp=samples[0];
                spos++;
                samplecount++;
                samplecount&=7;
                if (spos==ssend)
                {
//                        sprintf(s,"Sound over %05X %05X\n",spos,sstart);
//                        fputs(s,slogfile);
                        spos=sstart;
                        ioc.irqb|=2;
                        updateirqs();
                        sinprog=0;
                }
        }
/*        if (!sdmaena)
        {
                soundbuf[sampbuf][samppos++]=0;
                if (samppos==8000)
                {
                        samppos=0;
                        sampbuf^=1;
                }
                return;
        }
//        if (!soundf) soundf=fopen("sound.pcm","wb");
        soundbuf[sampbuf][samppos++]=mixsamp(ram[(spos>>12)&~1],ram[(spos>>12)|1]);
        if (samppos==8000)
        {
                samppos=0;
                sampbuf^=1;
        }
        if (!sinprog) return;
        spos+=sdif;
//        if (spos>=soend)
        if ((spos&0xFFFF0000)==(soend&0xFFFF0000))
        {
//                if (!slogfile) slogfile=fopen("slog.txt","wt");
//                sprintf(s,"%08i Interrupt %08X %08X %08X %08X %08X %08X\n",bigcyc,spos,soend,sdif,sstart,ssend,sptr);
//                fputs(s,slogfile);
                spos=sstart<<12;
                ioc.irqb|=2;
                updateirqs();
                sinprog=0;
                spos-=sdif;
        }*/
}

int output;

void writecam(unsigned long a)
{
        int page,access,logical,c;
        char s[256];
/*        if (!slogfile) slogfile=fopen("slog.txt","wt");
        if (a&0x7080)
        {
                sprintf(s,"Write %08X %04X\n",a,a&0x7080);
                fputs(s,slogfile);
        }*/
        page=((a>>3)&0xf) | ((a&1)<<4) | ((a&2)<<5) | ((a&4)<<3);
        if (a&0x80) page|=0x80;
        if (a&0x1000) page|=0x100;
        access=(a>>8)&3;
        logical=(a>>15)&0xFF;
        logical|=(a>>2)&0x300;
//        printf("MEMC write %08X - logical %03X physical %03X access %i addr %07X\n",a,logical,page,access,logical<<15);
        for (c=0;c<0x400;c++)
        {
                if (memcpages[c]==(page<<15))
                {
                        memcpages[c]=~0;
                        memstat[c]=0;
                }
        }
        memcpages[logical]=page<<15;
        memstat[logical]=access+1;
        mempoint[logical]=&ram[page<<13];
        mempointb[logical]=(unsigned char *)&ram[page<<13];
//        sprintf(err2,"Logical page %03X %07X = %07X %i\n",logical,logical<<15,page<<15,access);
//        fputs(err2,olog);
//        output=1;
//        memcpermissions[logical]=access;
}
