/*Arculator 0.1 by Tom Walker
  WD1772 FDC emulation*/
#include <stdio.h>
#include "arc.h"
#include <allegro.h>
#include <winalleg.h>

int discchanged=0;
int readflash;
char err2[256];
FILE *olog;
int readaddr=0;
unsigned char disc[2][80][5][1024]; /*Disc - E format (2 sides, 80 tracks, 5 sectors, 1024 bytes)*/
int output,output2;
int fdcside;
int commandpos=0;
int fiq;
int track=0,sector=1;
unsigned char fdctrack=0,fdcsector=0,fdcdata,fdcstatus=0;
int discint=0;
unsigned char fdccommand;

void loaddisc(char *fn)
{
        FILE *ff=fopen(fn,"rb");
        int c,d,e,f;
        for (d=0;d<80;d++)
        {
                for (c=0;c<2;c++)
                {
                        for (e=0;e<5;e++)
                        {
                                for (f=0;f<1024;f++)
                                {
                                        disc[c][d][e][f]=getc(ff);
                                }
                        }
                }
        }
        fclose(ff);
//        fdcstatus=0;
}

/*This function doesn't seem to work correctly - saved discs are corrupted*/
/*Hence it is commented out*/
void updatedisc(char *fn)
{
/*        FILE *ff;
        int c,d,e,f;
        if (!discchanged) return;
        ff=fopen(fn,"wb");
        for (d=0;d<80;d++)
        {
                for (c=0;c<2;c++)
                {
                        for (e=0;e<5;e++)
                        {
                                for (f=0;f<1024;f++)
                                {
                                        putc(disc[c][d][e][f],ff);
                                }
                        }
                }
        }
        fclose(ff);
        discchanged=0;*/
}

void callback()
{
        int c;
        FILE *f;
        unsigned long templ;
        switch (fdccommand>>4)
        {
                case 0x0: /*Restore*/
                track=fdctrack=0;
                iocfiq(2);
                discint=0;
                fdcstatus=0xA4;
//                fdcstatus|=0x04;
//                fdcstatus&=~1;
//                printf("Restore callback\n");
                break;

                case 0x1: /*Seek*/
                fdctrack=track=fdcdata;
                iocfiq(2);
                discint=0;
                fdcstatus=0xA0;
//                fdcstatus|=0xA0;
//                fdcstatus&=~5;
                if (!track) fdcstatus|=4;
                commandpos=0;
//                printf("Seek callback %02X - seeked to %02X\n",fdccommand,track);
                break;

                case 0x5: /*Step in*/
                track++;
                if (track==80) track=79;
                fdctrack=track;
                iocfiq(2);
                discint=0;
//                fdcstatus&=~5;
//                fdcstatus|=0xA0;
                fdcstatus=0xA0;
                commandpos=0;
                break;

                case 0x8: /*Read sector*/
//                sprintf(err2,"Read side %i track %02i sector %i byte %03X %02X\n",fdcside,track,sector,commandpos,disc[fdcside&1][track%80][sector%5][commandpos&1023]);
//                if (!commandpos) fputs(err2,olog);
                if (sector>4 || track>79 || commandpos>1024)
                {
                        sprintf(err2,"Bad read sector %i %i %i\n",track,sector,commandpos);
                        MessageBox(NULL,err2,"Arc",MB_OK);
                        dumpregs();
                        exit(-1);
                }
/*                if (!commandpos)
                {
                        track=fdctrack;
                        sector=fdcsector;
                        printf("Sector command end\n");
                }*/
                if (commandpos==1024)
                {
                        iocfiq(2);
                        fdcstatus&=~1;
                        fdcstatus=0x80;
                }
                else
                {
                        fdcdata=disc[fdcside&1][track%80][sector%5][commandpos&1023];
                        commandpos++;
                        iocfiq(1);
                        fdcstatus=0x83;
//                        fdcstatus|=2;
                        discint=100>>1;
                }
                break;

                case 0xA: /*Write sector*/
                if (commandpos==-1)
                {
                        commandpos=0;
                        iocfiq(1);
                        fdcstatus=0x83;
                        discint=100>>1;
                        return;
                }
                if (commandpos==1024)
                {
                        iocfiq(2);
                        fdcstatus&=~1;
                        fdcstatus=0x80;
                }
                else
                {
                        disc[fdcside&1][track%80][sector%5][commandpos&1023]=fdcdata;
                        commandpos++;
                        iocfiq(1);
                        fdcstatus=0x83;
//                        fdcstatus|=2;
                        discint=30;
                }
                break;

                case 0xC: /*Read address*/
                discint=5000;
                iocfiq(1);
                fdcstatus=0x81;
                switch (commandpos--)
                {
                        case 6: fdcdata=track; break;
                        case 5: fdcdata=(fdcside)?1:0; break;
                        case 4: fdcdata=sector; sector++; if (sector==5) sector=0; break;
                        case 3: fdcdata=3; break;
                        case 2: fdcdata=0xA5; break;
                        case 1: fdcdata=0x5A; break;
                        case 0:
                        discint=0;
                        iocfiqc(1);
                        iocfiq(2);
                        fdcstatus=0;//0x80;
                        fdcsector=track;
                        readaddr++;
//                        if (readaddr==8)
//                           output2=1;
                }
//                printf("Read address %i %02X\n",commandpos,fdcdata);
                break;
        }
}

void write1770(unsigned addr, unsigned data)
{
        char bigs[256];
//        printf("1770 write %08X %04X\n",addr,data);
        switch (addr&0xC)
        {
                case 0: /*Command reg*/
//                if (!olog) olog=fopen("armlog.txt","wt");
//                sprintf(bigs,"1772 command %02X\n",data);
//                fputs(bigs,olog);
                if (fdcstatus&1)
                {
                        sprintf(err2,"Rejected 1772 command %02X\n",data);
                        MessageBox(NULL,err2,"Arc",MB_OK);
                        dumpregs();
                        exit(-1);
                }
//                log("1770 command %02X\n",data>>16);
                fdccommand=data;
                fdcstatus=0x81;
                switch ((data>>4)&0xF)
                {
                        case 0x0: /*Restore*/
                        discint=5000>>2;
//                        fdcstatus=1;//(fdcstatus|1)&~0x1A;
                        break;

                        case 0x1: /*Seek*/
                        discint=2000>>2;
//                        fdcstatus=1;//(fdcstatus|1)&~0x1A;
                        break;

                        case 0x5: /*Step in*/
                        discint=1000>>2;
//                        fdcstatus=1;//(fdcstatus|1)&~0x1A;
                        break;

                        case 0x8: /*Read sector*/
                        readflash=1;
                        discint=500>>2;
                        commandpos=0;
//                        fdcstatus&=~4;
//                        fdcstatus|=1;
                        track=fdctrack;
                        sector=fdcsector;
                        break;

                        case 0xA: /*Write sector*/
                        discchanged=1;
                        discint=1000>>2;
                        commandpos=-1;
//                        fdcstatus&=~4;
//                        fdcstatus|=1;
                        track=fdctrack;
                        sector=fdcsector;
                        break;

                        case 0xC: /*Read address*/
                        commandpos=6;
                        discint=5000>>1;
//                        fdcstatus=(fdcstatus|1)&~0x7E;
//                        fdcstatus&=~4;
//                        fdcstatus|=1;
//                        log("read %i %i %i\n",track,fdcside,sector);
                        break;

                        case 0xD: /*Force interrupt*/
                        if (fdccommand&8) iocfiq(2);
                        else              iocfiqc(2);
                        discint=0;
                        fdcstatus=0x80;
                        break;

                        default:
                        allegro_exit();
                        sprintf(err2,"Bad command %01X\n",(data>>4)&0xF);
                        MessageBox(NULL,err2,"Arc",MB_OK);
                        exit(-1);
                }
                break;
                case 4: /*Track reg*/
                fdctrack=data;
//                printf("Track reg = %02X %i\n",data,data);
                break;
                case 8: /*Sector reg*/
                fdcsector=data;
//                printf("Sector reg = %02X %i\n",data,data);
                break;
                case 0xC: /*Data reg*/
                fdcstatus&=~2;
//                printf("FDC data write %02X\n",data);
                fdcdata=data;
                iocfiqc(1);
                break;
        }
//        log("1770 write addr %08X data %02X\n",addr,data);
}

unsigned char read1770(unsigned addr)
{
//        printf("1770 read %08X\n",addr);
        switch (addr&0xC)
        {
                case 0: /*Status reg*/
                iocfiqc(2);
//                printf("Returning status %02X %07X %08X\n",fdcstatus,PC,*armregs[3]);
                return fdcstatus;
                case 4: /*Track reg*/
//                printf("Reading fdctrack\n");
                return fdctrack;
                case 8: /*Sector reg*/
//                printf("Reading fdcsector\n");
                return fdcsector;
                case 0xC: /*Data reg*/
                fdcstatus&=~2;
//                printf("Reading fdcdata\n");
                iocfiqc(1);
                return fdcdata;
        }
}
