#include <allegro.h>
#include "arc.h"

#define getdmaaddr(addr) (((addr>>2)&0x7FFF)<<2)

int running;
int osmode;
int memcpages[0x400];
int memcpermissions[0x400];
int instructions;

unsigned long *armregs[16];
int pagesizes[4]={4,8,16,32};
int pagesize=3;
void writememc(unsigned addr, unsigned data)
{
        int page,access,logical;
//        log("MEMC write addr %08X data %02X PC %07X ins %i\n",addr&0x3FFFFFF,data,(*armregs[15]&0x3FFFFFC)-8,instructions);
        if (addr>0x37FFFFF)
        {
               addr-=0x3800000;
               if (pagesize!=3)
               {
                        closevideo();
                        printf("Mapping - not in 32k, but in %ik\n",pagesizes[pagesize]);
                        exit(-1);
               }
               switch (pagesize)
               {
                     case 0: /*4K*/
                     page=addr&127;
                     access=(addr>>8)&3;
                     logical=(addr>>10)&0x1FFF;
                     break;
                     case 1: /*8K*/
                     page=(addr>>1)&63;
                     page|=(addr&1)<<6;
                     access=(addr>>8)&3;
                     logical=(addr>>11)&0xFFF;
                     break;
                     case 2: /*16K*/
                     page=(addr>>2)&31;
                     page|=(addr&3)<<5;
                     access=(addr>>8)&3;
                     logical=(addr>>12)&0x7FF;
                     break;
                     case 3: /*32K*/
                     page=((addr>>3)&0xf) | ((addr&1)<<4) | ((addr&2)<<5) | ((addr&4)<<3);
//                     printf("page is %02X\n",page);
//                     page=(addr>>3)&15;
//                     page|=((addr&1)<<4)|((addr&2)<<5)|((addr&4)<<3);
                     access=(addr>>8)&3;
                     logical=(addr>>15)&0xFF;
                     logical|=(addr>>2)&0x300;
//                     matchaddr=((address & 0xff) << 15) |
//                ((address & 0x300) << 2);
//      mask=0x807f8c00;
                     memcpages[logical]=page<<15;
                     memcpermissions[logical]=access;
                     break;
               }
//               log("Physical page %02X (%07X) mapped to page %04X (%07X) with permissions %i\n",page,(page<<15)+0x2000000,logical,logical<<15,access);
        }
        else
        {
               switch ((addr>>17)&7)
               {
                     case 0: /*VINIT*/
                     vinit=getdmaaddr(addr);
//                     log("VINIT set to %05X\n",vinit);
                     break;
                     case 1: /*VSTART*/
                     vstart=getdmaaddr(addr);
//                     log("VSTART set to %05X\n",vstart);
                     break;
                     case 2: /*VEND*/
                     vend=getdmaaddr(addr);
//                     log("VEND set to %05X\n",vend);
//                     drawscreen();
                     break;
                     case 3: /*CINIT*/
                     cinit=getdmaaddr(addr);
//                     log("CINIT set to %05X\n",cinit);
                     break;
                     case 4: /*SSTART*/
                     sstart=getdmaaddr(addr);
//                     log("SSTART set to %05X\n",sstart);
                     break;
                     case 5: /*SEND*/
                     send=getdmaaddr(addr);
//                     log("SEND set to %05X\n",send);
                     break;
                     case 6: /*SPTR*/
                     sptr=getdmaaddr(addr);
//                     log("SPTR set to %05X\n",sptr);
                     break;
                     case 7: /*MEMCCTRL*/
                     memcctrl=addr&0x1FFF;
                     pagesize=(memcctrl>>2)&3;
                     osmode=memcctrl&0x1000;
                     if (!(memcctrl&0x400) && running)
                        clear_to_color(screen,1);
//                     log("MEMC CTRL - page size %ik %c%c %s\n",pagesizes[(memcctrl>>2)&3],(memcctrl&0x400)?'V':' ',(memcctrl&0x800)?'S':' ',(memcctrl&0x1000)?"OS":"");
                     break;
               }
        }
}

void dumpmemcregs()
{
        printf("SSTART=%05X SEND=%05X SPRT=%05X\n",sstart,send,sptr);
}

void dumpmemcpages()
{
        int c;
        for (c=0;c<0x400;c++)
            log("Page %i - %07X - mapped to %07X\n",c,c<<15,memcpages[c]);
}

unsigned readmemc(unsigned addr)
{
//        log("MEMC read addr %08X\n",addr);
        return 0;
}
