#include <allegro.h>
#include "arc.h"
#include "keytable.h"

#define KEYB_HRST 0xFF

/*Mouse buttons - keys 7,0 7,1 and 7,2 (LMR)*/

int i2cclock,i2cdata;
void sendkeyboard(unsigned char code);
int timers[4],timersrunning[4],timerlatch[4];
unsigned long *armregs[16];
int keyboardstate=0;
unsigned char keytx,keyrx;
int keytime=0,keypolltime=0;
int keycommand=0;
int keyrow,keycol;
int oldkeys[128];
int oldmouseb=0;
int oldx=0,oldy=0;

void pollkeys()
{
        int c;
        int x,y;
#ifndef SYSTEM_AUTODETECT
        for (c=1;c<70;c++)
#else
        for (c=1;c<104;c++)
#endif
        {
                if (key[c]!=oldkeys[c])
                {
//                        log("Key %i down\n",c,oldtonew[c-1]);
                        oldkeys[c]=key[c];
#ifndef SYSTEM_AUTODETECT
                        keyrow=keytable[oldtonew[c-1]][0];
                        keycol=keytable[oldtonew[c-1]][1];
#else
                        keyrow=keytable[c-1][0];
                        keycol=keytable[c-1][1];
#endif
                        if (keyrow>-1 && keycol>-1)
                        {
                                if (key[c])
                                {
//                                        log("Keypress scan %i row %i col %i\n",c,keyrow,keycol);
                                        keyboardstate=4;
                                        sendkeyboard(0xC0|(keyrow&0xF));
                                        keypolltime=2048;
                                }
                                else
                                {
//                                        log("Keyrelease scan %i row %i col %i\n",c,keyrow,keycol);
                                        keyboardstate=5;
                                        sendkeyboard(0xD0|(keyrow&0xF));
                                        keypolltime=2048;
                                }
                                return;
                        }
                }
        }
        if ((mouse_b&1)!=(oldmouseb&1))
        {
                keycol=0;
                if (mouse_b&1)
                {
                        keyboardstate=4;
                        sendkeyboard(0xC0|7);
                        keypolltime=2048;
                }
                else
                {
                        keyboardstate=5;
                        sendkeyboard(0xD0|7);
                        keypolltime=2048;
                }
        }
        else if ((mouse_b&2)!=(oldmouseb&2))
        {
                keycol=2;
                if (mouse_b&2)
                {
                        keyboardstate=4;
                        sendkeyboard(0xC0|7);
                        keypolltime=2048;
                }
                else
                {
                        keyboardstate=5;
                        sendkeyboard(0xD0|7);
                        keypolltime=2048;
                }
        }
        if (mouse_b!=oldmouseb)
        {
                oldmouseb=mouse_b;
                return;
        }
        get_mouse_mickeys(&x,&y);
        if (x!=oldx || y!=oldy)
        {
                oldx=x;
                oldy=y;
                if (x<0)
                   sendkeyboard(((x^0x3F)&0x3F)|0x40);
                else
                   sendkeyboard(x&0x3F);
                keyboardstate=6;
                keypolltime=2048;
        }
}

void sendkeyq()
{
        if (keyboardstate==3)
        {
                keyboardstate=4;
                keyrow=2;
                keycol=7;
                sendkeyboard(0xC2);
                keypolltime=3000;
        }
}

void pollkeyboard()
{
        switch (keyboardstate)
        {
                case 4:
                sendkeyboard(0xC0|(keycol&0xF));
                keyboardstate=3;
                break;
                case 5:
                sendkeyboard(0xD0|(keycol&0xF));
                keyboardstate=3;
                break;
                case 6:
                if (oldy<0)
                   sendkeyboard(((oldy^0x3F)&0x3F)|0x40);
                else
                   sendkeyboard(oldy&0x3F);
                keyboardstate=3;
                break;
        }
}

void printkeystate()
{
        printf("KEYTX=%02X KEYRX=%02X KEYTIME=%i\n",keytx,keyrx,keytime);
}

void sendkeyboard(unsigned char code)
{
//        log("Keyboard sent %02X  state %i\n",code,keyboardstate);
        iocreg[IOC_KEYB]=code;
        iocreg[IOC_IRQSTAT_B]|=0x80;
        updateiocints();
        keyrx=code;
}

void keyboardreceive(unsigned char code)
{
//        log("Keyboard received %02X  state %i\n",code,keyboardstate);
        switch (keyboardstate)
        {
                case 0:
                if (code==0xFF)
                {
                        sendkeyboard(0xFF);
                        keyboardstate=1;
                }
                break;

                case 1:
                if (code==0xFE)
                {
                        sendkeyboard(0xFE);
                        keyboardstate=2;
                }
                else
                   sendkeyboard(0xFF);
                break;

                case 2:
                if (code==0xFD)
                {
                        sendkeyboard(0xFD);
                        keyboardstate=3;
                }
                break;

                default:
                if (code==0xFF)
                {
                        sendkeyboard(0xFF);
                        keyboardstate=1;
                }
                switch (code&0xF0)
                {
                        case 0: /*Change LEDs*/
                        sendkeyboard((code&7)|0xA0);
                        break;

                        case 0x20: /*Request ID*/
                        if (code!=0x20)
                           log("KEYB code %02X\n",code);
                        keycommand=0x20;
                        sendkeyboard(0x81);
                        break;

                        default:
                        log("KEYB code %02X\n",code);
                        break;
                }
        }
}

void initioc()
{
        int c;
        for (c=0;c<32;c++)
            iocreg[c]=0;
        for (c=0;c<128;c++)
            oldkeys[c]=0;
        iocreg[0]=3;
        iocreg[IOC_CONTROL]=0xFF;
        iocreg[IOC_IRQSTAT_A]=0x80;//0x90;
        iocreg[IOC_T0LOW]=iocreg[IOC_T0HIGH]=0xFF;
        iocreg[IOC_T1LOW]=iocreg[IOC_T1HIGH]=0xFF;
        iocreg[IOC_T2LOW]=iocreg[IOC_T2HIGH]=0xFF;
        iocreg[IOC_T3LOW]=iocreg[IOC_T3HIGH]=0xFF;
//        sendkeyboard(KEYB_HRST);
        for (c=0;c<4;c++)
            timers[c]=timersrunning[c]=0;
}

void dumpiocregs()
{
        printf("T1C=%04X T2C=%04X T3C=%04X T4C=%04X\n",timers[0],timers[1],timers[2],timers[3]);
        printf("T1L=%04X T2L=%04X T3L=%04X T4L=%04X\n",timerlatch[0],timerlatch[1],timerlatch[2],timerlatch[3]);
        printf("T1 %s T2 %s T3 %s T4 %s\n",(timersrunning[0])?"on":"off",(timersrunning[1])?"on":"off",(timersrunning[2])?"on":"off",(timersrunning[3])?"on":"off");
        printf("IRQA STAT %02X ENA %02X   ",iocreg[IOC_IRQSTAT_A],iocreg[IOC_IRQMASK_A]);
        printf("IRQB STAT %02X ENA %02X\n",iocreg[IOC_IRQSTAT_B],iocreg[IOC_IRQMASK_B]);
}

void dumpiocregslog()
{
        logfile("T1C=%04X T2C=%04X T3C=%04X T4C=%04X\n",timers[0],timers[1],timers[2],timers[3]);
        logfile("T1L=%04X T2L=%04X T3L=%04X T4L=%04X\n",timerlatch[0],timerlatch[1],timerlatch[2],timerlatch[3]);
        logfile("T1 %s T2 %s T3 %s T4 %s\n",(timersrunning[0])?"on":"off",(timersrunning[1])?"on":"off",(timersrunning[2])?"on":"off",(timersrunning[3])?"on":"off");
        logfile("IRQA STAT %02X ENA %02X   ",iocreg[IOC_IRQSTAT_A],iocreg[IOC_IRQMASK_A]);
        logfile("IRQB STAT %02X ENA %02X\n",iocreg[IOC_IRQSTAT_B],iocreg[IOC_IRQMASK_B]);
}

void writeioc(unsigned addr, unsigned data)
{
        data>>=16;
        addr&=0x7F;
        addr>>=2;
        /*check here*/
/*        if (iocreg[IOC_IRQSTAT_A]==0xF0)
        {
                closevideo();
                printf("Bloody hell - IRQSTAT_A &F0\n");
                dumpregs();
                dumpiocregs();
                dumpram();
                exit(-1);
        }*/
//        if (!addr)
//           return;
        if (addr!=IOC_IRQCLEAR)
           iocreg[addr]=data&0xFF;
//        else
//           logfile("IRQ clear %02X\n",data&0xFF);
        switch (addr)
        {
                case IOC_CONTROL:
                cmosi2cchange(data&2,data&1);
                break;

                case IOC_KEYB:
//                log("KEYB write data %02X\n",data);
                iocreg[IOC_IRQSTAT_B]&=0xBF;
                updateiocints();
                keytx=data;
                keytime=10000;
                break;

                case IOC_IRQCLEAR:
                data&=0x7F;
                iocreg[IOC_IRQSTAT_A]&=~data;
                updateiocints();
                break;

                case IOC_IRQMASK_A:
                case IOC_IRQMASK_B:
                updateiocints();
                break;

                case IOC_T0LOW:
                timerlatch[0]&=0xFF00;
                timerlatch[0]|=(data&0xFF);
                break;
                case IOC_T0HIGH:
                timerlatch[0]&=0xFF;
                timerlatch[0]|=((data&0xFF)<<8);
                break;
                case IOC_T0GO:
                timersrunning[0]=1;
                timers[0]=timerlatch[0];
                //printf("T1 going\n");
                break;
                case IOC_T0LATCH:
                iocreg[0x10]=timers[0]&0xFF;
                iocreg[0x11]=timers[0]>>8;
                break;

                case IOC_T1LOW:
                timerlatch[1]&=0xFF00;
                timerlatch[1]|=(data&0xFF);
                break;
                case IOC_T1HIGH:
                timerlatch[1]&=0xFF;
                timerlatch[1]|=((data&0xFF)<<8);
                break;
                case IOC_T1GO:
                timersrunning[1]=1;
                timers[1]=timerlatch[1];
                //printf("T2 going\n");
                break;
                case IOC_T1LATCH:
                iocreg[0x14]=timers[1]&0xFF;
                iocreg[0x15]=timers[1]>>8;
                break;

                case IOC_T2LOW:
                timerlatch[2]&=0xFF00;
                timerlatch[2]|=(data&0xFF);
                break;
                case IOC_T2HIGH:
                timerlatch[2]&=0xFF;
                timerlatch[2]|=((data&0xFF)<<8);
                break;
                case IOC_T2GO:
                timersrunning[2]=1;
                timers[2]=timerlatch[2];
                //printf("T3 going\n");
                break;
                case IOC_T2LATCH:
                iocreg[0x18]=timers[2]&0xFF;
                iocreg[0x19]=timers[2]>>8;
                break;

                case IOC_T3LOW:
                timerlatch[3]&=0xFF00;
                timerlatch[3]|=(data&0xFF);
                break;
                case IOC_T3HIGH:
                timerlatch[3]&=0xFF;
                timerlatch[3]|=((data&0xFF)<<8);
                break;
                case IOC_T3GO:
                timersrunning[3]=1;
                timers[3]=timerlatch[3];
                //printf("T4 going\n");
                break;
                case IOC_T3LATCH:
                iocreg[0x1C]=timers[3]&0xFF;
                iocreg[0x1D]=timers[3]>>8;
                break;
        }
}

unsigned readioc(unsigned addr)
{
//        if (((addr>>2)&0x7F)!=IOC_T0LOW)
//           log("IOC read addr %08X %02X\n",addr);
        addr&=0x7F;
        addr>>=2;
        if (addr==IOC_CONTROL)
           return ((i2cclock)?2:0)|((i2cdata)?1:0);
        if (addr==IOC_KEYB)
        {
                iocreg[IOC_IRQSTAT_B]&=0x7F;
                updateiocints();
        }
        if (addr==4)
           return iocreg[addr]|8;
        if (addr==8)
           return iocreg[addr];
        return iocreg[addr];
}

void updateiocints()
{
        int temp=(iocreg[IOC_IRQSTAT_A]&0x6F)&iocreg[IOC_IRQMASK_A];
        temp|=((iocreg[IOC_IRQSTAT_B]&iocreg[IOC_IRQMASK_B])<<8);
        iocreg[IOC_IRQREQ_A]=(iocreg[IOC_IRQSTAT_A]&0x6F)&iocreg[IOC_IRQMASK_A];
        iocreg[IOC_IRQREQ_B]=iocreg[IOC_IRQSTAT_B]&iocreg[IOC_IRQMASK_B];
        armirq=0;
        if (temp)
        {
                armirq=1;
//                printf("temp is %02X IRQ  PC %07X\n",temp,(*armregs[15]-8)&0x3FFFFFC);
//                dumpiocregs();
        }
}

void vblank()
{
        iocreg[IOC_IRQSTAT_A]|=8;
        updateiocints();
}

void updateioctimers(int cycles)
{
        int c;
        int timerints[4]={0x20,0x40,0,0};
        for (c=0;c<2;c++)
        {
//               if (timersrunning[c])
//               {
                     timers[c]-=cycles;
                     if (timers[c]<0)
                     {
                           timers[c]=timerlatch[c];
                           iocreg[IOC_IRQSTAT_A]|=timerints[c];
                     }
//               }
        }
        if (keytime)
        {
                keytime-=cycles;
                if (keytime<1)
                {
                        keytime=0;
                        keyboardreceive(keytx);
                        iocreg[IOC_IRQSTAT_B]|=0x40;
                }
        }
        else if (keypolltime)
        {
                keypolltime-=cycles;
                if (keypolltime<1)
                {
                        keypolltime=0;
                        pollkeyboard();
                }
        }
        updateiocints();
}
