#include <stdio.h>
#include <allegro.h>

unsigned long loadaddr,runaddr;
char filename[80];
int exitsync=0;
int bit4,bit1;
int warlocksmode=0;
int exitarm=0;
int width;
PALETTE pal;
int output;
int alternatescreen=5;
unsigned char oldtext[4000];
int oldy;
int running=0;

#define GETRD ((opcode>>12)&0xF)
#define GETRN ((opcode>>16)&0xF)
#define GETRM (data&0xF)

#define NFLAG 0x80000000
#define ZFLAG 0x40000000
#define CFLAG 0x20000000
#define VFLAG 0x10000000
#define IFLAG 0x08000000
#define FFLAG 0x04000000

#define NFLAGSET (*armregs[15]&NFLAG)
#define ZFLAGSET (*armregs[15]&ZFLAG)
#define CFLAGSET (*armregs[15]&CFLAG)
#define VFLAGSET (*armregs[15]&VFLAG)
#define IFLAGSET (*armregs[15]&IFLAG)
#define FFLAGSET (*armregs[15]&FFLAG)

unsigned long *armregs[16];

int cury;

void savetext()
{
        gettext(1,1,80,25,oldtext);
        oldy=wherey();
}

void loadfile()
{
        FILE *f=fopen(filename,"rb");
        int c=loadaddr;
        while (!feof(f))
        {
                writeByte(c,getc(f));
                c++;
        }
        fclose(f);
}

void restoretext()
{
        puttext(1,1,80,25,oldtext);
        gotoxy(1,oldy);
}

void updatereg()
{
        int c;
        cury=wherey();
        gotoxy(1,1);
        for (c=0;c<11;c++)
            cprintf("                                                                                ");
        gotoxy(1,1);
        printf("R0 =%08X  R4 =%08X  R8 =%08X  R12=%08X\n",*armregs[0],*armregs[4],*armregs[8],*armregs[12]);
        printf("R1 =%08X  R5 =%08X  R9 =%08X  R13=%08X\n",*armregs[1],*armregs[5],*armregs[9],*armregs[13]);
        printf("R2 =%08X  R6 =%08X  R10=%08X  R14=%08X\n",*armregs[2],*armregs[6],*armregs[10],*armregs[14]);
        printf("R3 =%08X  R7 =%08X  R11=%08X  R15=%08X\n",*armregs[3],*armregs[7],*armregs[11],*armregs[15]);
        printf("PC=%08X   %c%c%c%c%c%c\n",(*armregs[15]-8)&0x3FFFFFC,NFLAGSET?'N':' ',ZFLAGSET?'Z':' ',CFLAGSET?'C':' ',VFLAGSET?'V':' ',IFLAGSET?'I':' ',FFLAGSET?'F':' ');
        printf("--------------------------------------------------------------------------------");
        c=(*armregs[15]-8)&0x3FFFFFC;
        disassemble(c-8);
        disassemble(c-4);
        textcolor(15);
        disassemble(c);
        textcolor(7);
        disassemble(c+4);
        disassemble(c+8);
        printf("--------------------------------------------------------------------------------");
        gotoxy(1,cury);
}

void debug()
{
        int quit=0,temp,keydown=0;
        char command[80],params[3][80];
        int c,d,addr,tempw;
        clrscr();
        gotoxy(1,13);
        while (!quit)
        {
                updatereg();
                scanf("%s",command);
                switch (command[0])
                {
                        case 'a': case 'A':
                        scanf("%s",params[0]);
                        execopcode(atoi(params[0]));
                        printf("%i cycles executed\n",atoi(params[0]));
                        break;

                        case 'd': case 'D':
                        scanf("%X",&addr);
                        for (c=0;c<8;c++)
                        {
                                printf("%08X : ",addr);
                                for (d=0;d<16;d++)
                                    printf("%02X ",readByte(addr++));
                                printf("\n");
                        }
                        break;

                        case 'g': case 'G':
                        savetext();
                        set_gfx_mode(GFX_VESA1,640,480,0,0);
                        install_keyboard();
                        set_palette(pal);
                        running=1;
                        while (!key[KEY_END])
                        {
                                execopcode(120000);
                                if (exitsync)
                                   exitsync=0;
                                if (exitarm)
                                   goto donego;
                                drawscreen();
                                vblank();
                                pollkeys();
                                if (key[KEY_HOME])
                                {
                                        while (key[KEY_HOME]);
                                        loadfile();
                                }
/*                                if (key[KEY_Q] && !keydown)
                                {
                                        sendkeyq();
                                        keydown=1;
                                }*/
                        }
                        set_gfx_mode(GFX_TEXT,0,0,0,0);
                        restoretext();
                        donego:
                        remove_keyboard();
                        exitarm=0;
                        break;

                        case 'h': case 'H': case '?':
                        printf("D hexaddr - dump 128 bytes of memory to screen\n");
                        printf("E c       - executes c cycles\n");
                        printf("G         - run until keypress\n");
                        printf("H or ?    - this helptext\n");
                        printf("J         - jump to address\n");
                        printf("L         - toggle logfile status\n");
                        printf("S         - alternate screen address (for TCD Demo 1)\n");
                        printf("T         - trace\n");
                        printf("V         - draw Archimedes screen\n");
                        printf("X         - quit\n");
                        printf("\n");
                        break;

                        case 'j': case 'J':
                        scanf("%X",&addr);
                        *armregs[15]&=0xFC000003;
                        *armregs[15]|=(addr+8)&0x3FFFFFC;
                        break;

                        case 'l': case 'L':
                        output^=1;
                        break;

                        case 's': case 'S':
                        printf("Please select screen emulation mode :\n");
                        printf("0. Screen base at &1F08000\n");
                        printf("1. Screen base at &1FEC000\n");
                        printf("2. Screen base at &1FE8000\n");
                        printf("3. Screen base at &1F90000\n");
                        printf("4. Screen base set by MEMC\n");
                        printf("5. Warlocks mode\n");
                        printf("6. Mode 12\n");
                        printf("7. Mode 0\n");
                        printf("8. Mode 13\n");
                        printf(":");
                        scanf("%i",&temp);
                        warlocksmode=0;
                        bit4=bit1=0;
                        width=320;
                        if (temp<5)
                           alternatescreen=temp;
                        else if (temp==5)
                        {
                                alternatescreen=4;
                                warlocksmode=1;
                                width=336;
                        }
                        else if (temp==6)
                        {
                                alternatescreen=5;
                                width=320;
                                bit4=1;
                                bit1=0;
                        }
                        else if (temp==7)
                        {
                                alternatescreen=5;
                                width=80;
                                bit4=bit1=1;
                        }
                        else if (temp==8)
                        {
                                alternatescreen=5;
                                width=320;
                                bit4=bit1=0;
                        }
                        else
                           printf("Bad choice\n");
                        break;

                        case 't': case 'T':
                        execopcode(1);
                        break;

                        case 'v': case 'V':
                        savetext();
                        drawscreenfordebug();
                        restoretext();
                        break;

                        case 'w': case 'W':
                        scanf("%i",&tempw);
                        if (tempw>640)
                           printf("Width out of range\n");
                        else
                        {
                                width=tempw;
                                printf("Width set to %i pixels\n",width);
                        }
                        break;

                        case 'x': case 'X':
                        quit=1;
                        break;

                        default:
                        printf("Bad command\n");
                        break;
                }
        }
}

int memoverlay;

char s[80];

inline void shiftdis(unsigned data)
{
        unsigned shiftmode=(data>>5)&3;
        unsigned shiftamount=(data>>7)&31;
        int temp;
        int rm;
        if (data&0x10)
           shiftamount=*armregs[(data>>8)&15];
        rm=GETRM;
        if (!(data&0x10))
        {
                switch (shiftmode)
                {
                        case 0: /*LSL*/
                        if (!shiftamount)
                           sprintf(s,"R%i",rm);
                        else
                           sprintf(s,"R%i LSL %i",rm,shiftamount);
                        break;

                        case 1: /*LSR*/
                        sprintf(s,"R%i LSR %i",rm,shiftamount);
                        break;

                        case 2: /*ASR - this is wrong!*/
                        sprintf(s,"R%i ASR %i",rm,shiftamount);
                        break;

                        case 3: /*ROR*/
                        rm=GETRM;
                        if (!shiftamount)
                           sprintf(s,"R%i RRX",rm);
                        else
                           sprintf(s,"R%i ROR %i",rm,shiftamount);
                        break;
                }
        }
        else
        {
                switch (shiftmode)
                {
                        case 0: /*LSL*/
                        sprintf(s,"R%i LSL R%i",rm,(data>>8)&15);
                        break;

                        case 1: /*LSR*/
                        sprintf(s,"R%i LSR R%i",rm,(data>>8)&15);
                        break;

                        case 2: /*ASR - this is wrong!*/
                        sprintf(s,"R%i ASR R%i",rm,(data>>8)&15);
                        break;

                        case 3: /*ROR*/
                        rm=GETRM;
                        if (!shiftamount)
                           sprintf(s,"R%i RRX",rm);
                        else
                           sprintf(s,"R%i ROR R%i",rm,(data>>8)&15);
                        break;
                }
        }
}

inline unsigned rotatedis(unsigned data)
{
        unsigned rotval=data&0xFF;
        unsigned rotamount=((data>>8)&0xF)<<1;
        return (rotval>>rotamount)|(rotval<<(32-rotamount));
}

char cond[16][4]={"EQ","NE","CS","CC","MI","PL","VS","VC","HI","LS","GE","LT","GT","LE","","NV"};
void disassemble(int addr)
{
        int old=memoverlay;
        unsigned long opcode=readDWord(addr&0x3FFFFFC);
        shiftdis(opcode);
        cprintf("%07X : ",addr&0x3FFFFFC);
        switch ((opcode>>20)&0xFF)
        {
                case 0x00:
                cprintf("AND%s R%i,R%i,%s\n",cond[opcode>>28],GETRD,GETRN,s);
                break;
                case 0x01:
                cprintf("AND%sS R%i,R%i,%s\n",cond[opcode>>28],GETRD,GETRN,s);
                break;

                case 0x02:
                cprintf("EOR%s R%i,R%i,%s\n",cond[opcode>>28],GETRD,GETRN,s);
                break;
                case 0x03:
                cprintf("EOR%sS R%i,R%i,%s\n",cond[opcode>>28],GETRD,GETRN,s);
                break;

                case 0x04:
                cprintf("SUB%s R%i,R%i,%s\n",cond[opcode>>28],GETRD,GETRN,s);
                break;
                case 0x05:
                cprintf("SUB%sS R%i,R%i,%s\n",cond[opcode>>28],GETRD,GETRN,s);
                break;

                case 0x06:
                cprintf("RSB%s R%i,R%i,%s\n",cond[opcode>>28],GETRD,GETRN,s);
                break;
                case 0x07:
                cprintf("RSB%sS R%i,R%i,%s\n",cond[opcode>>28],GETRD,GETRN,s);
                break;

                case 0x08:
                cprintf("ADD%s R%i,R%i,%s\n",cond[opcode>>28],GETRD,GETRN,s);
                break;
                case 0x09:
                cprintf("ADD%sS R%i,R%i,%s\n",cond[opcode>>28],GETRD,GETRN,s);
                break;

                case 0x0A:
                cprintf("ADC%s R%i,R%i,%s\n",cond[opcode>>28],GETRD,GETRN,s);
                break;
                case 0x0B:
                cprintf("ADC%sS R%i,R%i,%s\n",cond[opcode>>28],GETRD,GETRN,s);
                break;

                case 0x0C:
                cprintf("SBC%s R%i,R%i,%s\n",cond[opcode>>28],GETRD,GETRN,s);
                break;
                case 0x0D:
                cprintf("SBC%sS R%i,R%i,%s\n",cond[opcode>>28],GETRD,GETRN,s);
                break;

                case 0x0E:
                cprintf("RSC%s R%i,R%i,%s\n",cond[opcode>>28],GETRD,GETRN,s);
                break;
                case 0x0F:
                cprintf("RSC%sS R%i,R%i,%s\n",cond[opcode>>28],GETRD,GETRN,s);
                break;

                case 0x10:
                cprintf("TST%s R%i,%s\n",cond[opcode>>28],GETRN,s);
                break;
                case 0x11:
                cprintf("TST%sS R%i,%s\n",cond[opcode>>28],GETRN,s);
                break;

                case 0x12:
                if (GETRD==15)
                   cprintf("TEQP%s R%i,%s\n",cond[opcode>>28],GETRN,s);
                else
                   cprintf("TEQ%s R%i,%s\n",cond[opcode>>28],GETRN,s);
                break;
                case 0x13:
                if (GETRD==15)
                   cprintf("TEQP%s R%i,%s\n",cond[opcode>>28],GETRN,s);
                else
                   cprintf("TEQ%sS R%i,%s\n",cond[opcode>>28],GETRN,s);
                break;

                case 0x14:
                cprintf("CMP%s R%i,%s\n",cond[opcode>>28],GETRN,s);
                break;
                case 0x15:
                cprintf("CMP%sS R%i,%s\n",cond[opcode>>28],GETRN,s);
                break;

                case 0x16:
                cprintf("CMN%s R%i,%s\n",cond[opcode>>28],GETRN,s);
                break;
                case 0x17:
                cprintf("CMN%sS R%i,%s\n",cond[opcode>>28],GETRN,s);
                break;

                case 0x18:
                cprintf("ORR%s R%i,R%i,%s\n",cond[opcode>>28],GETRD,GETRN,s);
                break;
                case 0x19:
                cprintf("ORR%sS R%i,R%i,%s\n",cond[opcode>>28],GETRD,GETRN,s);
                break;

                case 0x1A:
                cprintf("MOV%s R%i,%s\n",cond[opcode>>28],GETRD,s);
                break;
                case 0x1B:
                cprintf("MOV%sS R%i,%s\n",cond[opcode>>28],GETRD,s);
                break;

                case 0x1C:
                cprintf("BIC%s R%i,R%i,%s\n",cond[opcode>>28],GETRD,GETRN,s);
                break;
                case 0x1D:
                cprintf("BIC%sS R%i,R%i,%s\n",cond[opcode>>28],GETRD,GETRN,s);
                break;

                case 0x1E:
                cprintf("MVN%s R%i,%s\n",cond[opcode>>28],GETRD,s);
                break;
                case 0x1F:
                cprintf("MVN%sS R%i,%s\n",cond[opcode>>28],GETRD,s);
                break;

                case 0x20:
                cprintf("AND%s R%i,R%i,%X\n",cond[opcode>>28],GETRD,GETRN,rotatedis(opcode));
                break;
                case 0x21:
                cprintf("AND%sS R%i,R%i,%X\n",cond[opcode>>28],GETRD,GETRN,rotatedis(opcode));
                break;

                case 0x22:
                cprintf("EOR%s R%i,R%i,%X\n",cond[opcode>>28],GETRD,GETRN,rotatedis(opcode));
                break;
                case 0x23:
                cprintf("EOR%sS R%i,R%i,%X\n",cond[opcode>>28],GETRD,GETRN,rotatedis(opcode));
                break;

                case 0x24:
                cprintf("SUB%s R%i,R%i,%X\n",cond[opcode>>28],GETRD,GETRN,rotatedis(opcode));
                break;
                case 0x25:
                cprintf("SUB%sS R%i,R%i,%X\n",cond[opcode>>28],GETRD,GETRN,rotatedis(opcode));
                break;

                case 0x26:
                cprintf("RSB%s R%i,R%i,%X\n",cond[opcode>>28],GETRD,GETRN,rotatedis(opcode));
                break;
                case 0x27:
                cprintf("RSB%sS R%i,R%i,%X\n",cond[opcode>>28],GETRD,GETRN,rotatedis(opcode));
                break;

                case 0x28:
                cprintf("ADD%s R%i,R%i,%X\n",cond[opcode>>28],GETRD,GETRN,rotatedis(opcode));
                break;
                case 0x29:
                cprintf("ADD%sS R%i,R%i,%X\n",cond[opcode>>28],GETRD,GETRN,rotatedis(opcode));
                break;

                case 0x2A:
                cprintf("ADC%s R%i,R%i,%X\n",cond[opcode>>28],GETRD,GETRN,rotatedis(opcode));
                break;
                case 0x2B:
                cprintf("ADC%sS R%i,R%i,%X\n",cond[opcode>>28],GETRD,GETRN,rotatedis(opcode));
                break;

                case 0x2C:
                cprintf("SBC%s R%i,R%i,%X\n",cond[opcode>>28],GETRD,GETRN,rotatedis(opcode));
                break;
                case 0x2D:
                cprintf("SBC%sS R%i,R%i,%X\n",cond[opcode>>28],GETRD,GETRN,rotatedis(opcode));
                break;

                case 0x2E:
                cprintf("RSC%s R%i,R%i,%X\n",cond[opcode>>28],GETRD,GETRN,rotatedis(opcode));
                break;
                case 0x2F:
                cprintf("RSC%sS R%i,R%i,%X\n",cond[opcode>>28],GETRD,GETRN,rotatedis(opcode));
                break;

                case 0x30:
                cprintf("TST%s R%i,%X\n",cond[opcode>>28],GETRN,rotatedis(opcode));
                break;
                case 0x31:
                cprintf("TST%sS R%i,%X\n",cond[opcode>>28],GETRN,rotatedis(opcode));
                break;

                case 0x32:
                if (GETRD==15)
                   cprintf("TEQP%s R%i,%X\n",cond[opcode>>28],GETRN,rotatedis(opcode));
                else
                   cprintf("TEQ%s R%i,%X\n",cond[opcode>>28],GETRN,rotatedis(opcode));
                break;
                case 0x33:
                if (GETRD==15)
                   cprintf("TEQP%s R%i,%X\n",cond[opcode>>28],GETRN,rotatedis(opcode));
                else
                   cprintf("TEQ%sS R%i,%X\n",cond[opcode>>28],GETRN,rotatedis(opcode));
                break;

                case 0x34:
                cprintf("CMP%s R%i,%X\n",cond[opcode>>28],GETRN,rotatedis(opcode));
                break;
                case 0x35:
                cprintf("CMP%sS R%i,%X\n",cond[opcode>>28],GETRN,rotatedis(opcode));
                break;

                case 0x36:
                cprintf("CMN%s R%i,%X\n",cond[opcode>>28],GETRN,rotatedis(opcode));
                break;
                case 0x37:
                cprintf("CMN%sS R%i,%X\n",cond[opcode>>28],GETRN,rotatedis(opcode));
                break;

                case 0x38:
                cprintf("ORR%s R%i,R%i,%X\n",cond[opcode>>28],GETRD,GETRN,rotatedis(opcode));
                break;
                case 0x39:
                cprintf("ORR%sS R%i,R%i,%X\n",cond[opcode>>28],GETRD,GETRN,rotatedis(opcode));
                break;

                case 0x3A:
                cprintf("MOV%s R%i,%X\n",cond[opcode>>28],GETRD,rotatedis(opcode));
                break;
                case 0x3B:
                cprintf("MOV%sS R%i,%X\n",cond[opcode>>28],GETRD,rotatedis(opcode));
                break;

                case 0x3C:
                cprintf("BIC%s R%i,R%i,%X\n",cond[opcode>>28],GETRD,GETRN,rotatedis(opcode));
                break;
                case 0x3D:
                cprintf("BIC%sS R%i,R%i,%X\n",cond[opcode>>28],GETRD,GETRN,rotatedis(opcode));
                break;

                case 0x3E:
                cprintf("MVN%s R%i,%X\n",cond[opcode>>28],GETRD,rotatedis(opcode));
                break;
                case 0x3F:
                cprintf("MVN%sS R%i,%X\n",cond[opcode>>28],GETRD,rotatedis(opcode));
                break;

                case 0x48: /*STR imm post*/
                if (opcode&0xFFF)
                   cprintf("STR%s R%i,[R%i]%c%03X\n",cond[opcode>>28],GETRD,GETRN,(opcode&0x800000)?'+':'-',opcode&0xFFF);
                else
                   cprintf("STR%s R%i,[R%i]\n",cond[opcode>>28],GETRD,GETRN);
                break;

                case 0x49: /*LDR imm post*/
                if (opcode&0xFFF)
                   cprintf("LDR%s R%i,[R%i]%c%03X\n",cond[opcode>>28],GETRD,GETRN,(opcode&0x800000)?'+':'-',opcode&0xFFF);
                else
                   cprintf("LDR%s R%i,[R%i]\n",cond[opcode>>28],GETRD,GETRN);
                break;

                case 0x51: /*LDR imm*/
                case 0x59:
                if (opcode&0xFFF)
                   cprintf("LDR%s R%i,[R%i%c%03X]\n",cond[opcode>>28],GETRD,GETRN,(opcode&0x800000)?'+':'-',opcode&0xFFF);
                else
                   cprintf("LDR%s R%i,[R%i]\n",cond[opcode>>28],GETRD,GETRN);
                break;

                case 0x53: /*LDR! imm*/
                case 0x5B:
                if (opcode&0xFFF)
                   cprintf("LDR%s R%i!,[R%i%c%03X]\n",cond[opcode>>28],GETRD,GETRN,(opcode&0x800000)?'+':'-',opcode&0xFFF);
                else
                   cprintf("LDR%s R%i!,[R%i]\n",cond[opcode>>28],GETRD,GETRN);
                break;

                case 0x5C: /*STRB imm*/
                if (opcode&0xFFF)
                   cprintf("STRB%s R%i,[R%i%c%03X]\n",cond[opcode>>28],GETRD,GETRN,(opcode&0x800000)?'+':'-',opcode&0xFFF);
                else
                   cprintf("STRB%s R%i,[R%i]\n",cond[opcode>>28],GETRD,GETRN);
                break;

                case 0x5D: /*LDRB imm*/
                if (opcode&0xFFF)
                   cprintf("LDRB%s R%i,[R%i%c%03X]\n",cond[opcode>>28],GETRD,GETRN,(opcode&0x800000)?'+':'-',opcode&0xFFF);
                else
                   cprintf("LDRB%s R%i,[R%i]\n",cond[opcode>>28],GETRD,GETRN);
                break;

                case 0x7C: /*STRB*/
                cprintf("STRB%s R%i!,[R%i%c%s]\n",cond[opcode>>28],GETRD,GETRN,(opcode&0x800000)?'+':'-',s);
                break;

                case 0x7D: /*LDRB*/
                cprintf("LDRB%s R%i!,[R%i%c%s]\n",cond[opcode>>28],GETRD,GETRN,(opcode&0x800000)?'+':'-',s);
                break;

                case 0xA0: case 0xA1: case 0xA2: case 0xA3: /*B*/
                case 0xA4: case 0xA5: case 0xA6: case 0xA7:
                case 0xA8: case 0xA9: case 0xAA: case 0xAB:
                case 0xAC: case 0xAD: case 0xAE: case 0xAF:
                cprintf("B%s &%07X\n",cond[opcode>>28],(addr+((opcode&0xFFFFFF)<<2)+8)&0x3FFFFFC);
                break;

                case 0xB0: case 0xB1: case 0xB2: case 0xB3: /*BL*/
                case 0xB4: case 0xB5: case 0xB6: case 0xB7:
                case 0xB8: case 0xB9: case 0xBA: case 0xBB:
                case 0xBC: case 0xBD: case 0xBE: case 0xBF:
                cprintf("BL%s &%07X\n",cond[opcode>>28],(addr+((opcode&0xFFFFFF)<<2)+8)&0x3FFFFFC);
                break;

                case 0xF0: /*SWI*/
                cprintf("SWI%s %X\n",cond[opcode>>28],opcode&0xFFFFF);
                break;

                default:
                cprintf("Unknown opcode %02X\n",(opcode>>20)&0xFF);
                break;
        }
        cprintf("%c",0xD);
        memoverlay=old;
}
