int output2=0;
unsigned long oldr15,oldoldr15;
int exitsync;
int ins_exec=0;
int soutput=0;
int interrupts=0;
int cycles=0;
int onstack=0;
/*400 - CAM failure
  800 - protection failure*/
unsigned long ram[0x100000];    /*RAM - 4 megs*/
#include <allegro.h>
#include "arc.h"
#include <stdio.h>

int undefinedinst=0;
int cflag;
int exitarm;
int trapr13=1;
unsigned long videobase;
int firstswithing=1;
//03801C14 : EBFFFB3C : BL      &380090c
//03801C18 : EA00001C : B       &3801c90
//R4 is 3801bd8

//MEMC stuff is around 1BE8-1x90 and 29A4-25AC
//Data proc opcode is >> 21 & F
//    01001000
//    01111001
//    01011100
//    01100000
/*LDR/STR
  CCCC01IPUBWLnnnnddddIIIIIIIIIIII
  I - immediate (0=immediate)
  B - byte
  W - writeback
  L - load/store (1=load)
*/

int instructions=0;
int timetolive=0;
char armmodes[4][20]=
{
        "USER","FIQ","IRQ","SUPERVISOR"
};

int vidbank;
int aborted=0;
int output=0;
FILE *swilog;
void (*armopcodes[256])();
void (*armopcodes2[256])();
void dumpregs();

unsigned long ldrresult(unsigned long val, unsigned long addr)
{
        switch (addr&3)
        {
                case 0:
                return val;
                case 1:
                return (val>>8)|(val<<24);
                case 2:
                return (val>>16)|(val<<16);
                case 3:
                return (val>>24)|(val<<8);
        }
}

void writec(unsigned char c)
{
        if (!swilog)
           swilog=fopen("swi.log","wt");
        fputc(c,swilog);
}

unsigned long opcode;
unsigned long *armregs[16];
unsigned long userregs[16],superregs[16],irqregs[16],fiqregs[16];
unsigned long temp,addr,temp2,tempaddr;
int loopreg;
int rd,rm,rn,rs;

#define GETRD ((opcode>>12)&0xF)
#define GETRN ((opcode>>16)&0xF)
#define GETRM (opcode&0xF)

#define GETMULRD ((opcode>>16)&0xF)
#define GETMULRN ((opcode>>12)&0xF)
#define GETMULRS ((opcode>>8)&0xF)
#define GETMULRM (opcode&0xF)

#define NFLAG 0x80000000
#define ZFLAG 0x40000000
#define CFLAG 0x20000000
#define VFLAG 0x10000000
#define IFLAG 0x08000000

#define NFLAGSET (*armregs[15]&NFLAG)
#define ZFLAGSET (*armregs[15]&ZFLAG)
#define CFLAGSET (*armregs[15]&CFLAG)
#define VFLAGSET (*armregs[15]&VFLAG)

inline void changemode()
{
      int c;
//      printf("Mode change to %i\n",*armregs[15]&3);
      switch (*armregs[15]&3)
      {
            case 0: /*User mode*/
            for (c=8;c<15;c++)
                armregs[c]=&userregs[c];
//            armregs[13]=&userregs[13];
//            armregs[14]=&userregs[14];
            break;
            case 1: /*FIQ mode*/
            for (c=8;c<15;c++)
                armregs[c]=&fiqregs[c];
            break;
            case 2: /*IRQ mode*/
            for (c=8;c<15;c++)
                armregs[c]=&userregs[c];
            armregs[13]=&irqregs[13];
            armregs[14]=&irqregs[14];
            break;
            case 3: /*Supervisor mode*/
            for (c=8;c<13;c++)
                armregs[c]=&userregs[c];
            armregs[13]=&superregs[13];
            armregs[14]=&superregs[14];
            break;
      }
}

inline void setzn(unsigned data)
{
        if (opcode&0x100000)
        {
                *armregs[15]&=0x3FFFFFFF;
                if (!data)
                   *armregs[15]|=ZFLAG;
                if (data&0x80000000)
                   *armregs[15]|=NFLAG;
        }
}

/*Check CMPS and LE*/

#define checkpos(v) !(v&0x80000000)
#define checkneg(v) (v&0x80000000)

inline void setsubflags(unsigned long op1, unsigned long op2)
{
        unsigned long res=op1-op2;
        if (opcode&0x100000)
        {
                if (output) logfile(" updating flags - %08X-%08X ",op1,op2);
                *armregs[15]&=0xFFFFFFF;
                if ((checkneg(op1) && checkpos(op2)) ||
                    (checkneg(op1) && checkpos(res)) ||
                    (checkpos(op2) && checkpos(res)))
                    *armregs[15]|=CFLAG;
                if ((checkneg(op1) && checkpos(op2) && checkpos(res)) ||
                    (checkpos(op1) && checkneg(op2) && checkneg(res)))
                    *armregs[15]|=VFLAG;
                if (!res)
                   *armregs[15]|=ZFLAG;
                else if (checkneg(res))
                   *armregs[15]|=NFLAG;
/*                if (op1>=op2)
                   *armregs[15]|=CFLAG;
                if ((op1&0x80000000)&&!(op2&0x80000000)&&!((op1-op2)&0x80000000))
                   *armregs[15]|=VFLAG;
                if (!(op1&0x80000000)&&(op2&0x80000000)&&((op1-op2)&0x80000000))
                   *armregs[15]|=VFLAG;
                if (!(op1-op2))
                   *armregs[15]|=ZFLAG;
                if ((op1-op2)&0x80000000)
                   *armregs[15]|=NFLAG;*/
        }
}

inline void setaddflags(unsigned long op1, unsigned long op2)
{
        unsigned long res=op1+op2;
        if (opcode&0x100000)
        {
                *armregs[15]&=0xFFFFFFF;
                if ((op1|op2)>>30)
                {
                        if ((checkneg(op1) && checkneg(op2)) ||
                            (checkneg(op1) && checkpos(res)) ||
                            (checkneg(op2) && checkpos(res)))
                            *armregs[15]|=CFLAG;
                        if ((checkneg(op1) && checkneg(op2) && checkpos(res)) ||
                            (checkpos(op1) && checkpos(op2) && checkneg(res)))
                            *armregs[15]|=VFLAG;
                }
//                if (!(op1&0x80000000)&&((op1+op2)&0x80000000))
//                   *armregs[15]|=VFLAG;
                if (!res)
                   *armregs[15]|=ZFLAG;
                else if (checkneg(res))
                   *armregs[15]|=NFLAG;
        }
}

inline unsigned rotate(unsigned data)
{
        unsigned rotval=data&0xFF;
        unsigned rotamount=((data>>8)&0xF)<<1;
        rotval=(rotval>>rotamount)|(rotval<<(32-rotamount));
        if (data&0x100000 && rotamount)
        {
                if (rotval&0x80000000)
                   *armregs[15]|=CFLAG;
                else
                   *armregs[15]&=~CFLAG;
        }
        return rotval;
}

inline unsigned shift(unsigned data)
{
        unsigned shiftmode=(data>>5)&3;
        unsigned shiftamount=(data>>7)&31;
        unsigned long temp;
        int cflag=CFLAGSET;
        if (!(data&0xFF0))
        {
                rm=GETRM;
                return *armregs[rm];
        }
        if (data&0x10)
           shiftamount=*armregs[(data>>8)&15];
        rm=GETRM;
        temp=*armregs[rm];
        if (rm==15)
           temp+=4;
        if (data&0x100000 && shiftamount)
           *armregs[15]&=~CFLAG;
        switch (shiftmode)
        {
                case 0: /*LSL*/
                if (!shiftamount)
                   return temp;
                if (shiftamount==32)
                {
                        if (temp&1 && data&0x100000)
                           *armregs[15]|=CFLAG;
                        return 0;
                }
                if (shiftamount>32)
                   return 0;
                if (data&0x100000)
                {
                        if ((temp<<(shiftamount-1))&0x80000000)
                           *armregs[15]|=CFLAG;
                }
                return temp<<shiftamount;

                case 1: /*LSR*/
                if (!shiftamount)
                   return temp;
                if (shiftamount==32)
                {
                        if (temp&0x80000000 && data&0x100000)
                           *armregs[15]|=CFLAG;
                        return 0;
                }
                if (shiftamount>32)
                   return 0;
                if (data&0x100000)
                {
                        if ((temp>>(shiftamount-1))&1)
                           *armregs[15]|=CFLAG;
                }
                return temp>>shiftamount;

                case 2: /*ASR*/
                if (!shiftamount)
                {
                        if (data&0x10)
                           return temp;
                }
                if (shiftamount>=32 || !shiftamount)
                {
                        *armregs[15]&=~CFLAG;
                        if (temp&0x80000000 && data&0x100000)
                           *armregs[15]|=CFLAG;
                        if (temp&0x80000000)
                           return 0xFFFFFFFF;
                        return 0;
                }
                if (data&0x100000)
                {
                        if ((temp>>(shiftamount-1))&1)
                           *armregs[15]|=CFLAG;
                }
                return (int)temp>>shiftamount;

                case 3: /*ROR*/
                if (data&0x100000)
                   *armregs[15]&=~CFLAG;
                if (!shiftamount && !(data&0x10))
                {
                        if (data&0x100000 && temp&1)
                           *armregs[15]|=CFLAG;
                        return (((cflag)?1:0)<<31)|(temp>>1);
                }
                if (!shiftamount)
                {
                        if (data&0x100000)
                           *armregs[15]|=cflag;
                        return temp;
                }
                if (!(shiftamount&0x1F))
                {
                        if (data&0x100000 && temp&0x80000000)
                           *armregs[15]|=CFLAG;
                        return temp;
                }
                if (data&0x100000)
                {
                        if (((temp>>shiftamount)|(temp<<(32-shiftamount)))&0x80000000)
                           *armregs[15]|=CFLAG;
                }
                return (temp>>shiftamount)|(temp<<(32-shiftamount));
                break;
                default:
                closevideo();
                printf("Shift mode %i amount %i\n",shiftmode,shiftamount);
                if (data&0x100000)
                   printf("C flag should be changed\n");
                exit(-1);
        }
}

inline unsigned shift2(unsigned data)
{
        unsigned shiftmode=(data>>5)&3;
        unsigned shiftamount=(data>>7)&31;
        unsigned long temp;
        if (!(data&0xFF0))
        {
                rm=GETRM;
                return *armregs[rm];
        }
        if (data&0x10)
           shiftamount=*armregs[(data>>8)&15];
        rm=GETRM;
        temp=*armregs[rm];
        if (rm==15)
           temp+=4;
        switch (shiftmode)
        {
                case 0: /*LSL*/
                if (!shiftamount)
                   return temp;
                if (shiftamount==32)
                   return 0;
                if (shiftamount>32)
                   return 0;
                return temp<<shiftamount;

                case 1: /*LSR*/
                if (!shiftamount)
                   return temp;
                if (shiftamount==32)
                   return 0;
                if (shiftamount>32)
                   return 0;
                return temp>>shiftamount;

                case 2: /*ASR*/
                if (!shiftamount)
                   return temp;
                if (shiftamount>=32)
                {
                        if (temp&0x80000000)
                           return 0xFFFFFFFF;
                        return 0;
                }
                return (int)temp>>shiftamount;

                case 3: /*ROR*/
                rm=GETRM;
                if (!shiftamount && !(data&0x10))
                   return (((cflag)?1:0)<<31)|(temp>>1);
                if (!shiftamount)
                   return temp;
                return (temp>>shiftamount)|(temp<<(32-shiftamount));
                break;

                default:
                closevideo();
                printf("Shift mode %i amount %i\n",shiftmode,shiftamount);
                exit(-1);
        }
}

void badopcode()
{
        closevideo();
        printf("Bad opcode %08X at %07X\n",opcode,*armregs[15]&0x3FFFFFC);
        dumpregs();
        dumpram();
        dumpiocregs();
        exit(-1);
}

void badopcode2()
{
        closevideo();
        printf("Bad extended opcode %08X at %07X\n",opcode,*armregs[15]&0x3FFFFFC);
        dumpregs();
        dumpram();
        dumpiocregs();
        exit(-1);
}

void branch()
{
        cycles-=2;
        temp=*armregs[15]&0x3FFFFFC;
        temp+=((opcode&0xFFFFFF)<<2)+4;
        if (output) logfile("B %07X",temp-4);
        *armregs[15]&=0xFC000003;
        *armregs[15]|=(temp&0x3FFFFFC);
//        if (((opcode>>20)&0xFF)==0xA7)
//           dumpregs();
}

void branchlink()
{
        cycles-=2;
        temp=*armregs[15]&0x3FFFFFC;
        temp+=((opcode&0xFFFFFF)<<2)+4;
        if (output) logfile("BL %07X",temp-4);
        *armregs[14]=*armregs[15]-4;
        *armregs[15]&=0xFC000003;
        *armregs[15]|=(temp&0x3FFFFFC);
}

/*0x2000000 - Immediate flag (1=immediate)
  0x100000  - Set flags
  >> 21 & F - Opcode*/

unsigned char dataops[16][5]={"AND","EOR","SUB","RSB","ADD","ADC","SBC","RBC","TST","TEQ","CMP","CMN","ORR","MOV","BIC","MVN"};

void dataproc()
{
        rd=GETRD;
        rn=GETRN;
        temp2=(opcode>>21)&0xF;
//        if (rd==15 && temp2!=2 && temp2!=4 && temp2!=9 && temp2!=12 && temp2!=13 && temp2!=14)
//           printf("RD IS 15 opcode %02X\n",temp2);
//        if (((opcode>>20)&0xFF)==0x10)
//           output=1;
//        if (temp2==2 && rd==15)
//           output=1;
        if (opcode&0x2000000)
        {
                temp=rotate(opcode);
                if (output) logfile("%s%c R%i,R%i,%08X",dataops[temp2],(opcode&0x100000)?'S':' ',rd,rn,temp);
        }
        else
        {
//                printf("%08X\n",*armregs[14]);
                temp=shift(opcode);
                if (output) logfile("%s%c R%i,R%i,R%i",dataops[temp2],(opcode&0x100000)?'S':' ',rd,rn,opcode&0xF);
        }
        switch (temp2)
        {
                case 0: /*AND*/
                if (rd==15) logfile("AND RD 15\n");
                if (rn==15) logfile("AND RN 15\n");
                *armregs[rd]=*armregs[rn]&temp;
                setzn(*armregs[rd]);
                break;

                case 1: /*EOR*/
                if (rd==15) logfile("EOR RD 15\n");
                if (rn==15) logfile("EOR RN 15\n");
                *armregs[rd]=*armregs[rn]^temp;
                setzn(*armregs[rd]);
                break;

                case 2: /*SUB*/
//                if (rd==15)
//                   output=1;
                if (rn==15)
                {
                        temp2=*armregs[rn];
                        if (rd==15)
                        {
                                if (opcode&0x100000)
                                   *armregs[rd]=(temp2&0x3FFFFFC)-temp;
                                else
                                {
                                        *armregs[rd]&=0xFC000003;
                                        *armregs[rd]|=((temp2&0x3FFFFFC)-temp)&0x3FFFFFC;
                                }
                                *armregs[rd]+=4;
                        }
                        else
                        {
                                setsubflags(*armregs[rn]&0x3FFFFFC,temp);
                                *armregs[rd]=(*armregs[rn]&0x3FFFFFC)-temp;
                        }
                }
                else
                {
                        setsubflags(*armregs[rn],temp);
                        if (rd==15)
                        {
                                if (opcode&0x100000)
                                   *armregs[rd]=*armregs[rn]-temp;
                                else
                                {
                                        *armregs[rd]&=0xFC000003;
                                        *armregs[rd]|=(*armregs[rn]-temp)&0x3FFFFFC;
                                }
                                *armregs[rd]+=4;
                        }
                        else
                           *armregs[rd]=*armregs[rn]-temp;
                }
                if (output) logfile( "- now %08X",*armregs[rd]);
                break;

                case 3: /*RSB*/
                if (rd==15) logfile("RSB RD 15\n");
                if (rn==15) logfile("RSB RN 15\n");
                setsubflags(temp,*armregs[rn]);
                *armregs[rd]=temp-*armregs[rn];
                break;

                case 4: /*ADD*/
                if (rd==15)
                {
                        temp2=*armregs[rn];
                        if (rn==15)
                           temp2&=0x3FFFFFC;
                        if (opcode&0x100000)
                           *armregs[15]=(temp2+temp+4);
                        else
                        {
                                *armregs[15]&=0xFC000003;
                                *armregs[15]|=((temp2+temp+4)&0x3FFFFFC);
                        }
                }
                else
                {
                        temp2=*armregs[rn];
                        if (rn==15)
                           temp2&=0x3FFFFFC;
                        setaddflags(temp2,temp);
                        *armregs[rd]=temp2+temp;
                }
                if (output) logfile(" - now %08X",*armregs[rd]);
                break;

                case 5: /*ADC*/
                if (rd==15) logfile("ADC RD 15\n");
                if (rn==15) logfile("ADC RN 15\n");
                setaddflags(*armregs[rn],temp);
                *armregs[rd]=*armregs[rn]+temp+((cflag)?1:0);
                break;

                case 6: /*SBC*/
                if (rd==15) logfile("SBC RD 15\n");
                if (rn==15) logfile("SBC RN 15\n");
                setsubflags(*armregs[rn],temp);
                *armregs[rd]=(*armregs[rn]-temp)-((cflag)?0:1);
                break;

                case 7: /*RSC*/
                if (rd==15) logfile("RSC RD 15\n");
                if (rn==15) logfile("RSC RN 15\n");
                setsubflags(temp,*armregs[rn]);
                *armregs[rd]=(temp-*armregs[rn])-((cflag)?0:1);
                break;

                case 8: /*TST*/
                if (rd==15)
                {
                        if (!(*armregs[15]&3))
                        {
                                closevideo();
                                printf("TSTP in user mode\n");
                                dumpregs();
                                exit(-1);
                        }
                        if (rn==15)
                        {
                                closevideo();
                                printf("TSTP\n");
                                dumpregs();
                                exit(-1);
                        }
                        temp=*armregs[rn]&temp;
                        *armregs[15]&=0x3FFFFFC;
                        *armregs[15]|=(temp&0xFC000003);
                        updateiocints();
                }
                else
                {
                        if (!(opcode&0x100000))
                        {
                                closevideo();
                                printf("TST without S\n");
                                dumpregs();
                                exit(-1);
                        }
                        setzn(*armregs[rn]&temp);
                        if (output) logfile(" - was %08X",*armregs[rn]);
                }
                break;

                case 9: /*TEQ*/
                if (rd==15)
                {
                        if (rn==15)
                           temp^=(*armregs[rn]&0x3FFFFFC);
                        else
                           temp^=*armregs[rn];
                        if (!(*armregs[15]&3))
                        {
                                *armregs[15]&=0xFFFFFFF;
                                *armregs[15]|=(temp&0xF0000000);
                        }
                        else
                        {
                                *armregs[15]&=0x3FFFFFC;
                                *armregs[15]|=(temp&0xFC000003);
                        }
                        if (output) logfile("mode now %s R15 %07X",armmodes[*armregs[15]&3],*armregs[15]);
                        updateiocints();
                }
                else
                {
/*                        if (!(opcode&0x100000))
                        {
                                exitarm=1;
                                set_gfx_mode(GFX_TEXT,0,0,0,0);
                                restoretext();
                                printf("TEQ without S\n");
                                return;
                        }*/
                        setzn(*armregs[rn]^temp);
                }
                break;

                case 10: /*CMP*/
                if (rd==15)
                {
                        if (!(*armregs[15]&3))
                        {
                                closevideo();
                                printf("CMPP in user mode\n");
                                dumpregs();
                                exit(-1);
                        }
                        closevideo();
                        printf("CMPP\n");
                        dumpregs();
                        exit(-1);
                        temp=*armregs[rn]-temp;
                        *armregs[15]&=0x3FFFFFC;
                        *armregs[15]|=(temp&0xFC000003);
                        updateiocints();
                }
                else
                {
                        if (!(opcode&0x100000))
                        {
                                closevideo();
                                printf("CMP without S\n");
                                dumpregs();
                                exit(-1);
                        }
                        setsubflags(*armregs[rn],temp);
                }
                if (output) logfile(" - %08X-%08X",*armregs[rn],temp);
                break;

                case 11: /*CMN*/
                if (rd==15)
                {
                        if (!(*armregs[15]&3))
                        {
                                closevideo();
                                printf("CMNP in user mode\n");
                                dumpregs();
                                exit(-1);
                        }
                        closevideo();
                        printf("CMNP\n");
                        dumpregs();
                        exit(-1);
                        temp=*armregs[rn]+temp;
                        *armregs[15]&=0x3FFFFFC;
                        *armregs[15]|=(temp&0xFC000003);
                        updateiocints();
                }
                else
                {
                        if (!(opcode&0x100000))
                        {
                                closevideo();
                                printf("CMN without S\n");
                                dumpregs();
                                exit(-1);
                        }
                        setaddflags(*armregs[rn],temp);
                }
                break;

                case 12: /*ORR*/
                if (rd==15)
                {
                        if (opcode&0x100000)
                           *armregs[rd]=*armregs[rn]|temp;
                        else
                           *armregs[rd]=(*armregs[rd]&0xFC000003)|((*armregs[rn]|temp)&0x3FFFFFC);
                        *armregs[rd]+=4;
                }
                else
                {
                        if (rn==15) logfile("ORR RN 15\n");
                        *armregs[rd]=*armregs[rn]|temp;
                        setzn(*armregs[rd]);
                }
                if (output) logfile(" - now %08X",*armregs[rd]);
                break;

                case 13: /*MOV*/
                if (rd==15)
                {
                        if (opcode&0x100000)
                        {
                                *armregs[15]=temp+4;
                        }
                        else
                        {
                                *armregs[15]&=0xFC000003;
                                *armregs[15]|=((temp+4)&0x3FFFFFC);
                        }
                }
                else
                {
                        *armregs[rd]=temp;
                        setzn(*armregs[rd]);
                        if (output) logfile(" - R%i now %08X R15 now %08X",rd,*armregs[rd],*armregs[15]);
                }
                break;

                case 14: /*BIC*/
                if (rd==15)
                {
                        if (opcode&0x100000)
                           *armregs[rd]=*armregs[rn]&~temp;
                        else
                           *armregs[rd]=(*armregs[rd]&0xFC000003)|((*armregs[rn]&~temp)&0x3FFFFFC);
                        *armregs[rd]+=4;
                }
                else
                {
                        *armregs[rd]=*armregs[rn]&~temp;
                        setzn(*armregs[rd]);
                }
                if (output) logfile(" - now %08X",*armregs[rd]);
                break;

                case 15: /*MVN*/
                if (output) logfile(" - %08X",temp);
                *armregs[rd]=~temp;
                setzn(*armregs[rd]);
                if (output) logfile(" - now %08X",*armregs[rd]);
                break;
        }
//        if (output) logfile("\n");
}

void ldr()
{
        rd=GETRD;
        rn=GETRN;
        tempaddr=*armregs[rn];
        if (rn==15) tempaddr&=0x3FFFFFC;
        if (opcode&0x1000000) /*Pre-index*/
        {
                if (opcode&0x2000000) /*Register offset*/
                {
                        if (opcode&0x800000)
                           tempaddr+=shift2(opcode);
                        else
                           tempaddr-=shift2(opcode);
                }
                else /*Immediate offset*/
                {
                        if (opcode&0x800000)
                           tempaddr+=opcode&0xFFF;
                        else
                           tempaddr-=opcode&0xFFF;
                }
        }
        if ((opcode&0x1200000)==0x200000)
        {
                temp2=*armregs[15]&3;
                *armregs[15]&=~3;
        }
        if (opcode&0x400000)
           temp=readByte(tempaddr);
        else
           temp=ldrresult(readDWord(tempaddr),tempaddr);
        if ((opcode&0x1200000)==0x200000)
           *armregs[15]|=temp2;
        if (aborted)
           return;
        if (rd==15)
           *armregs[15]=(*armregs[15]&0xFC000003)|((temp+4)&0x3FFFFFC);
        else
           *armregs[rd]=temp;
        if (!(opcode&0x1000000)) /*Post-index*/
        {
                if (opcode&0x2000000) /*Register offset*/
                {
                        if (opcode&0x800000)
                           *armregs[rn]+=shift2(opcode);
                        else
                           *armregs[rn]-=shift2(opcode);
                }
                else /*Immediate offset*/
                {
                        if (opcode&0x800000)
                           *armregs[rn]+=opcode&0xFFF;
                        else
                           *armregs[rn]-=opcode&0xFFF;
                }
        }
        else if (opcode&0x200000)
           *armregs[rn]=tempaddr;
        if (output) logfile("LDR    R%i=%08X R%i=%08X",rd,*armregs[rd],rn,*armregs[rn]);
        cycles--;
}

void str()
{
        rd=GETRD;
        rn=GETRN;
        tempaddr=*armregs[rn];
        if (rn==15) tempaddr&=0x3FFFFFC;
        if (opcode&0x1000000) /*Pre-index*/
        {
                if (opcode&0x2000000) /*Register offset*/
                {
                        if (opcode&0x800000)
                           tempaddr+=shift2(opcode);
                        else
                           tempaddr-=shift2(opcode);
                }
                else /*Immediate offset*/
                {
                        if (opcode&0x800000)
                           tempaddr+=opcode&0xFFF;
                        else
                           tempaddr-=opcode&0xFFF;
                }
        }
        if ((opcode&0x1200000)==0x200000)
        {
                temp2=*armregs[15]&3;
                *armregs[15]&=~3;
        }
        if (opcode&0x400000)
           writeByte(tempaddr,*armregs[rd]);
        else
           writeDWord(tempaddr,*armregs[rd]);
        if ((opcode&0x1200000)==0x200000)
           *armregs[15]|=temp2;
        if (aborted)
           return;
        if (!(opcode&0x1000000)) /*Post-index*/
        {
                if (opcode&0x2000000) /*Register offset*/
                {
                        if (opcode&0x800000)
                           *armregs[rn]+=shift2(opcode);
                        else
                           *armregs[rn]-=shift2(opcode);
                }
                else /*Immediate offset*/
                {
                        if (opcode&0x800000)
                           *armregs[rn]+=opcode&0xFFF;
                        else
                           *armregs[rn]-=opcode&0xFFF;
                }
        }
        else if (opcode&0x200000)
            *armregs[rn]=tempaddr;
        cycles--;
}

#if 0
void ldm()
{
        int sflag=opcode&0x400000;
        if (sflag && opcode&0x8000) sflag=0;
        rn=GETRN;
        addr=*armregs[rn];
        if (opcode&0x800000) /*up*/
        {
                temp=1;
                if (!(opcode&0x1000000)) addr+=4;
                for (loopreg=0;loopreg<16;loopreg++)
                {
                        if (opcode&temp)
                        {
                                if (loopreg==15)
                                {
                                        cycles-=2;
                                        if (opcode&0x400000)
                                           *armregs[15]=readDWord(addr)+4;
                                        else
                                           *armregs[15]=(*armregs[15]&0xFC000003)|((readDWord(addr)+4)&0x3FFFFFC);
                                }
                                else if (sflag)
                                   userregs[loopreg]=readDWord(addr);
                                else
                                   *armregs[loopreg]=readDWord(addr);
                                addr+=4;
                                if (opcode&0x200000) *armregs[rn]+=4;
                                cycles--;
                        }
                        temp<<=1;
                }
        }
        else /*down*/
        {
                temp=0x8000;
                if (!(opcode&0x1000000)) addr-=4;
                for (loopreg=15;loopreg>=0;loopreg--)
                {
                        if (opcode&temp)
                        {
                                if (loopreg==15)
                                {
                                        cycles-=2;
                                        if (opcode&0x400000)
                                           *armregs[15]=readDWord(addr)+4;
                                        else
                                           *armregs[15]=(*armregs[15]&0xFC000003)|((readDWord(addr)+4)&0x3FFFFFC);
                                }
                                else if (sflag)
                                   userregs[loopreg]=readDWord(addr);
                                else
                                   *armregs[loopreg]=readDWord(addr);
                                addr-=4;
                                if (opcode&0x200000) *armregs[rn]-=4;
                                cycles--;
                        }
                        temp>>=1;
                }
        }
}

void stm()
{
        int sflag=opcode&0x400000;
        if (sflag && opcode&0x8000) sflag=0;
        rn=GETRN;
        addr=*armregs[rn];
        if (opcode&0x800000) /*up*/
        {
                temp=1;
                if (!(opcode&0x1000000)) addr+=4;
                for (loopreg=0;loopreg<16;loopreg++)
                {
                        if (opcode&temp)
                        {
//                                if (output) logfile("write R%i %07X\n",loopreg,addr);
                                if (sflag)
                                   writeDWord(addr,userregs[loopreg]);
                                else if (loopreg==15)
                                   writeDWord(addr,*armregs[loopreg]+4);
                                else
                                   writeDWord(addr,*armregs[loopreg]);
                                addr+=4;
                                if (opcode&0x200000) *armregs[rn]+=4;
                                cycles--;
                        }
                        temp<<=1;
                }
        }
        else /*down*/
        {
                temp=0x8000;
                if (!(opcode&0x1000000)) addr-=4;
                for (loopreg=15;loopreg>=0;loopreg--)
                {
                        if (opcode&temp)
                        {
//                                if (output) logfile("write R%i %07X\n",loopreg,addr);
                                if (sflag)
                                   writeDWord(addr,userregs[loopreg]);
                                else if (loopreg==15)
                                   writeDWord(addr,*armregs[loopreg]+4);
                                else
                                   writeDWord(addr,*armregs[loopreg]);
                                addr-=4;
                                if (opcode&0x200000) *armregs[rn]-=4;
                                cycles--;
                        }
                        temp>>=1;
                }
        }
}
#endif

//#if 0
void ldmda()
{
        rn=GETRN;
        addr=*armregs[rn];
        temp=0x8000;
        for (loopreg=15;loopreg>=0;loopreg--)
        {
                if (opcode&temp)
                {
//                        if (soutput && rn==13) onstack--;
//                        if (soutput && rn==13) logfile("Reading R%i from %i\n",loopreg,onstack);
                        if (loopreg==15)
                        {
                                cycles-=2;
                                if (opcode&0x400000)
                                   *armregs[loopreg]=readDWord(addr)+4;
                                else
                                {
                                        *armregs[loopreg]&=0xFC000003;
                                        *armregs[loopreg]|=(readDWord(addr)+4)&0x3FFFFFC;
                                }
                        }
                        else
                           *armregs[loopreg]=readDWord(addr);
                        addr-=4;
                        if (opcode&0x200000)
                           *armregs[rn]-=4;
                        cycles--;
               }
               temp>>=1;
        }
        if (output) logfile("LDMDA R%i - ",rn);
        if (output) logfile("R%i now %08X",rn,*armregs[rn]);
}

void stmda()
{
        rn=GETRN;
        addr=*armregs[rn];
        temp=0x8000;
        for (loopreg=15;loopreg>=0;loopreg--)
        {
                if (opcode&temp)
                {
                        if (loopreg==15)
                           writeDWord(addr,*armregs[loopreg]+4);
                        else
                           writeDWord(addr,*armregs[loopreg]);
                        addr-=4;
                        if (opcode&0x200000)
                           *armregs[rn]-=4;
                        cycles--;
               }
               temp>>=1;
        }
        if (output) logfile("STMDA R%i - ",rn);
        if (output) logfile("R%i now %08X",rn,*armregs[rn]);
}

void ldmia()
{
        rn=GETRN;
        addr=*armregs[rn];
        temp=1;
        for (loopreg=0;loopreg<16;loopreg++)
        {
                if (opcode&temp)
                {
//                        if (soutput && rn==13) onstack--;
//                        if (soutput && rn==13) logfile("Reading R%i from %i\n",loopreg,onstack);
                        if (loopreg==15)
                        {
                                cycles-=2;
                                if (opcode&0x400000)
                                   *armregs[loopreg]=readDWord(addr)+4;
                                else
                                {
                                        *armregs[loopreg]&=0xFC000003;
                                        *armregs[loopreg]|=(readDWord(addr)+4)&0x3FFFFFC;
                                }
                        }
                        else
                           *armregs[loopreg]=readDWord(addr);
                        addr+=4;
                        if (opcode&0x200000)
                           *armregs[rn]+=4;
                        cycles--;
               }
               temp<<=1;
        }
        if (output) logfile("LDMIA R%i - ",rn);
        if (output) logfile("R%i now %08X",rn,*armregs[rn]);
}

void ldmias()
{
        rn=GETRN;
        addr=*armregs[rn];
        temp=1;
        if (opcode&0x8000)
        {
                ldmia();
                return;
        }
        for (loopreg=0;loopreg<16;loopreg++)
        {
                if (opcode&temp)
                {
                        if (loopreg==15)
                        {
                                cycles-=2;
                                userregs[loopreg]=readDWord(addr)+4;
                        }
                        else
                           userregs[loopreg]=readDWord(addr);
                        addr+=4;
                        if (opcode&0x200000)
                           userregs[rn]+=4;
                        cycles--;
                }
                temp<<=1;
        }
        if (output) logfile("LDMIA^ R%i - ",rn);
        if (output) logfile("R%i now %08X",rn,*armregs[rn]);
}

void stmia()
{
        rn=GETRN;
        addr=*armregs[rn];
        temp=1;
        for (loopreg=0;loopreg<16;loopreg++)
        {
               if (opcode&temp)
               {
                     if (loopreg==15)
                        writeDWord(addr,*armregs[loopreg]+4);
                     else
                        writeDWord(addr,*armregs[loopreg]);
                     addr+=4;
                     if (opcode&0x200000)
                        *armregs[rn]+=4;
                     cycles--;
               }
               temp<<=1;
        }
        if (output) logfile("STMIA R%i - ",rn);
        if (output) logfile("R%i now %08X",rn,*armregs[rn]);
}

void stmias()
{
        rn=GETRN;
        addr=*armregs[rn];
        temp=1;
        for (loopreg=0;loopreg<16;loopreg++)
        {
               if (opcode&temp)
               {
                     if (loopreg==15)
                        writeDWord(addr,userregs[loopreg]+4);
                     else
                        writeDWord(addr,userregs[loopreg]);
                     addr+=4;
                     if (opcode&0x200000)
                        *armregs[rn]+=4;
                     cycles--;
               }
               temp<<=1;
        }
        if (output) logfile("STMIA^ R%i - ",rn);
        if (output) logfile("R%i now %08X",rn,*armregs[rn]);
}

void ldmdbs()
{
        rn=GETRN;
        addr=*armregs[rn];
        temp=0x8000;
        if (opcode&0x8000)
        {
                ldmdb();
                return;
        }
        for (loopreg=15;loopreg>-1;loopreg--)
        {
                if (opcode&temp)
                {
                        addr-=4;
                        if (opcode&0x200000)
                           userregs[rn]-=4;
                        if (loopreg==15)
                        {
                                cycles-=2;
                                userregs[loopreg]=readDWord(addr)+4;
                        }
                        else
                           userregs[loopreg]=readDWord(addr);
                        cycles--;
                }
                temp>>=1;
        }
        if (output) logfile("LDMDB^ R%i - ",rn);
        if (output) logfile("R%i now %08X",rn,*armregs[rn]);
}

void ldmdb()
{
        rn=GETRN;
        addr=*armregs[rn];
        temp=0x8000;
        for (loopreg=15;loopreg>-1;loopreg--)
        {
               if (opcode&temp)
               {
                        addr-=4;
                        if (opcode&0x200000)
                           *armregs[rn]-=4;
                        if (loopreg==15)
                        {
                                cycles-=2;
                                if (opcode&0x400000)
                                   *armregs[loopreg]=readDWord(addr)+4;
                                else
                                {
                                        *armregs[loopreg]&=0xFC000003;
                                        *armregs[loopreg]|=(readDWord(addr)+4)&0x3FFFFFC;
                                }
                        }
                        else
                           *armregs[loopreg]=readDWord(addr);
                        cycles--;
               }
               temp>>=1;
        }
        if (output) logfile("LDMDB R%i - ",rn);
        if (output) logfile("R%i now %08X",rn,*armregs[rn]);
}

void stmdb()
{
        rn=GETRN;
        addr=*armregs[rn];
        temp=0x8000;
        for (loopreg=15;loopreg>-1;loopreg--)
        {
               if (opcode&temp)
               {
                     addr-=4;
                     if (opcode&0x200000)
                        *armregs[rn]-=4;
//                     if (soutput && rn==13) logfile("Saving R%i to stackpos %i\n",loopreg,onstack);
                     if (loopreg==15)
                        writeDWord(addr,*armregs[loopreg]+4);
                     else
                        writeDWord(addr,*armregs[loopreg]);
//                     if (soutput && rn==13) onstack++;
                     cycles--;
               }
               temp>>=1;
        }
        if (output) logfile("STMDB R%i - ",rn);
        if (output) logfile("R%i now %08X",rn,*armregs[rn]);
}

void stmdbs()
{
        rn=GETRN;
        addr=*armregs[rn];
        temp=0x8000;
        for (loopreg=15;loopreg>-1;loopreg--)
        {
               if (opcode&temp)
               {
                     addr-=4;
                     if (opcode&0x200000)
                        *armregs[rn]-=4;
                     if (loopreg==15)
                        writeDWord(addr,userregs[loopreg]+4);
                     else
                        writeDWord(addr,userregs[loopreg]);
                     cycles--;
               }
               temp>>=1;
        }
        if (output) logfile("STMDB^ R%i - ",rn);
        if (output) logfile("R%i now %08X",rn,*armregs[rn]);
}

void ldmib()
{
        rn=GETRN;
        addr=*armregs[rn];
        temp=1;
        for (loopreg=0;loopreg<16;loopreg++)
        {
                if (opcode&temp)
                {
                        addr+=4;
                        if (opcode&0x200000)
                           *armregs[rn]+=4;
                        if (loopreg==15)
                        {
                                cycles-=2;
                                if (opcode&0x400000)
                                   *armregs[loopreg]=readDWord(addr)+4;
                                else
                                {
                                        *armregs[loopreg]&=0xFC000003;
                                        *armregs[loopreg]|=(readDWord(addr)+4)&0x3FFFFFC;
                                }
                        }
                        else
                           *armregs[loopreg]=readDWord(addr);
                        cycles--;
                }
                temp<<=1;
        }
        if (output) logfile("LDMIB R%i",rn);
}

void stmib()
{
        rn=GETRN;
        addr=*armregs[rn];
        temp=1;
        for (loopreg=0;loopreg<16;loopreg++)
        {
               if (opcode&temp)
               {
                     addr+=4;
                     if (opcode&0x200000)
                        *armregs[rn]+=4;
                     if (loopreg==15)
                        writeDWord(addr,*armregs[loopreg]+4);
                     else
                        writeDWord(addr,*armregs[loopreg]);
                     cycles--;
               }
               temp<<=1;
        }
        if (output) logfile("STMIB R%i - ",rn);
        if (output) logfile("R%i now %08X",rn,*armregs[rn]);
}
//#endif

void mul()
{
        rd=GETMULRD;
        rm=GETMULRM;
        rs=GETMULRS;
        temp=(*armregs[rm])*(*armregs[rs]); /*Probably not needed*/
        *armregs[rd]=temp;
        if (opcode&0x100000)
           setzn(*armregs[rd]);
        if (output) logfile("%s R%i,R%i,R%i - %08X %08X - now %08X",(opcode&0x100000)?"MULS":"MUL",rd,rm,rs,*armregs[rm],*armregs[rs],*armregs[rd]);
        cycles-=16; /*Probably too few*/
}

void mla()
{
        rd=GETMULRD;
        rm=GETMULRM;
        rs=GETMULRS;
        rn=GETMULRN;
        temp=(*armregs[rm])*(*armregs[rs]); /*Probably not needed*/
        *armregs[rd]=temp+*armregs[rn];
        if (opcode&0x100000)
           setzn(*armregs[rd]);
        if (output) logfile("%s R%i,R%i,R%i - %08X %08X - now %08X",(opcode&0x100000)?"MULS":"MUL",rd,rm,rs,*armregs[rm],*armregs[rs],*armregs[rd]);
}

void copro()
{
        undefinedinst=1;
}

unsigned long eventV,r12param;
int enabledevents=0;
unsigned long calleveryrate,calleveryaddr,calleveryr12;
int plotx,ploty;

void fakeswi()
{
        int c;
        int done=0;
        int type,addr;
        int tempaddr,tempaddr2;
        if (output) logfile("SWI %05X",opcode&0xFFFFF);
//        log("SWI %05X at %07X  R0=%08X R1=%08X R2=%08X\n",opcode&0xFFFFF,(*armregs[15]-8)&0x3FFFFFC,*armregs[0],*armregs[1],*armregs[2]);
//        dumpregs();
//        getch();
//        opcode&=0xFFFFF;
        if ((opcode&0xFFFFF)>0xFF && (opcode&0xFFFFF)<0x200)
           writec(opcode&0xFF);
        else if ((opcode&0xFFFFF)>0x7FFFF)
           return;
        else
        {
                switch (opcode&0xFFFFF)
                {
                        case 0x63F40: /*Joystick*/
                        if (key[KEY_RIGHT])
                           *armregs[0]|=0x3F00;
                        else if (key[KEY_LEFT])
                           *armregs[0]|=0xBF00;
                        if (key[KEY_UP])
                           *armregs[0]|=0x3F;
                        else if (key[KEY_DOWN])
                           *armregs[0]|=0xBF;
                        if (key[KEY_RCONTROL])
                           *armregs[0]|=0x10000;
                        break;

                        case 0x2E: /*OS_SpriteOp*/
                        logfile("OS_SpriteOp\n");
                        dumpregslog();
                        break;

                        case 0x45: /*OS_Plot*/
                        plotx=*armregs[1];
                        ploty=*armregs[2];
                        break;

                        case 0x3C: /*OS_CallEvery*/
                        calleveryrate=*armregs[0];
                        calleveryaddr=*armregs[1];
                        calleveryr12=*armregs[2];
                        break;

                        case 0x1F: /*OS_Claim*/
                        if (*armregs[0]==0x10)
                        {
                                eventV=*armregs[1];
                                r12param=*armregs[2];
                        }
                        else
                        {
                                exitarm=1;
                                set_gfx_mode(GFX_TEXT,0,0,0,0);
                                restoretext();
                                printf("Trying to claim vector %02X\n",*armregs[0]);
                                return;
                        }
                        break;

                        case 0x20004: /*OS_ReadC*/
                        *armregs[15]&=~CFLAG;
                        *armregs[0]=0;
//                        output=1;
//                        dumpregslog();
                        break;

                        case 0x10: /*OS_GetEnv*/
                        *armregs[0]=4;
                        *armregs[1]=0x100000;
                        break;

                        case 0x1C: /*OS_Mouse*/
                        *armregs[0]=0;
                        *armregs[1]=0;
                        *armregs[2]=0;
                        *armregs[3]=0;
                        break;

                        case 0x51:
                        *armregs[0]=32768;
                        *armregs[1]=128;
                        break;

                        case 1: /*OS_WriteS*/
                        addr=(*armregs[15]&0x3FFFFFC)-4;
                        while (!done)
                        {
                                temp=readDWord(addr);
                                addr+=4;
                                for (c=0;c<4;c++)
                                {
//                                        printf("c=%i temp=%02X\n",c,temp&0xFF);
                                        if (temp&0xFF)
                                           writec(temp&0xFF);
                                        else
                                        {
                                                done=1;
                                                addr+=c;
                                                break;
                                        }
                                        temp>>=8;
                                }
                        }
//                        printf("addr %07X\n",addr);
                        if (addr&3)
                        {
                                addr-=3;
                                *armregs[15]&=0xFC000003;
                                *armregs[15]|=(addr+8);
//                                printf("PC now %07X\n",(*armregs[15]-8)&0x3FFFFFC);
                        }
                        else
                        {
                                *armregs[15]&=0xFC000003;
                                *armregs[15]|=(addr+4);
//                                printf("PC now %07X\n",(*armregs[15]-8)&0x3FFFFFC);
                        }
                        break;

#if 0  /*This one is totally broke, only enable if you want to see coppersine
         not run*/
                        case 1:
                        *armregs[15]+=4;
                        break;
#endif

                        case 0x5C:
                        switch (*armregs[0])
                        {
                                case 2: /*screen area*/
                                *armregs[0]=0x1F08000;
                                *armregs[1]=480*1024;
                                *armregs[2]=480*1024;
                                break;

                                case 4: /*font cache - ArcAngels demo wants
                                          this for some undetermined reason*/
                                *armregs[0]=0x1E00000;
                                *armregs[1]=32*1024;
                                *armregs[2]=32*1024;
                                break;

                                case 3: /*sprite area - figured it out!
                                          ArcAngels demo wants every last bit
                                          of memory. Brilliant*/
                                *armregs[0]=0x1E00000; /*Fake it*/
                                *armregs[1]=32*1024;
                                *armregs[2]=32*1024;
                                break;

                                default:
                                closevideo();
                                printf("SWI 5C area %i\n",*armregs[0]);
                                dumpregs();
                                exit(-1);
                        }
                        break;

                        case 0x2A:    /*OS_Change_DynamicArea*/
                        switch (*armregs[0])
                        {
                                case 4: /*font cache - no you can't change it
                                          you twat!!*/
                                *armregs[1]=0x8000;
                                break; /*piss off*/

                                case 3: /*guessed right first time - I must be
                                          a genius - sprite area by the way*/
                                *armregs[1]=0x8000;
                                break; /*now piss off*/

                                case 2: /*soon I will know the load and run
                                          addresses for this demo off by heart.*/
                                *armregs[1]=0x8000*480;
                                break; /*once again, piss off*/

                                default:
                                closevideo();
                                printf("SWI 2A area %i\n",*armregs[0]);
                                dumpregs();
                                exit(-1);
                        }
                        break;

                        case 0x1A:    /*OS_UpdateMEMC*/
                        break;

                        case 0x0: case 0x20000:    /*OS_WriteC*/
                        writec(*armregs[0]);
                        break;

                        case 0x5: case 0x20005: /*CLI*/
                        /*In future - keep list of modules (makes OS_Module do something useful*/
                        break;

                        case 0x6: case 0x20006:    /*OSBYTE*/
                        switch (*armregs[0])
                        {
                                case 0x4: /*cursor key crap*/
                                break;

                                case 0xE: /*enable event*/
                                if (*armregs[1]==4)
                                   enabledevents|=1<<4;
                                else
                                {
                                        exitarm=1;
                                        set_gfx_mode(GFX_TEXT,0,0,0,0);
                                        restoretext();
                                        printf("Enabling event %i\n",*armregs[1]);
                                        return;
                                }
                                break;

                                case 0xF: /*flush buffers*/
                                break;

                                case 0x13: /*vsync*/
//                                vsync();
                                drawscreen();
                                break;

                                case 0x70: /*VDU bank*/
//                                printf("buffer now bank %i\n",*armregs[1]);
                                break;

                                case 0x71: /*display bank*/
//                                printf("display now bank %i\n",*armregs[1]);
                                vidbank=*armregs[1];
                                break;

                                case 0x76: /*update LEDs*/
                                break;

                                case 0x79: /*Scan key*/
                                if (*armregs[1]&0x80)
                                   *armregs[1]=0;
                                else
                                   *armregs[1]=0xFF;
                                break;

                                case 0x7A: /*Scan keyboard*/
                                firstswithing^=1;
                                if (firstswithing)
                                   *armregs[1]=0;
                                else
                                   *armregs[1]=0xFF;
                                break;

                                case 0x7C: /*Clear esc cond*/
                                break;

                                case 0x7E: /*Clear esc state*/
                                *armregs[1]=0;
                                break;

                                case 0x80: /*252-253*/
                                if (*armregs[1]==252 || *armregs[1]==253)
                                {
                                        *armregs[1]=8;
                                        *armregs[2]=8;
                                }
                                else
                                {
                                        *armregs[1]=0;
                                        *armregs[2]=0;
                                }
                                break;

                                case 0x81: /*Scan keyboard*/
                                if (*armregs[2]==0xFF && !(*armregs[1]&0x7F))
                                {
                                        *armregs[1]=0xFF;
                                }
                                else if (*armregs[2]==0xFF && (*armregs[1]&0x80))
                                {
                                        *armregs[1]=*armregs[2]=0;
                                }
                                else
                                {
                                        firstswithing^=1;
                                        if (firstswithing)
                                           *armregs[1]=0;
                                        else
                                           *armregs[1]=0xFF;
                                }
                                break;

                                case 0xC8: /*r/w escape/break action*/
                                break;

                                case 0xCA: /*r/w keyboard status*/
                                break;

                                default:
                                closevideo();
                                printf("Bad OSBYTE %08X\n",*armregs[0]);
                                dumpregs();
                                exit(-1);
                        }
                        break;

                        case 0x20007: case 0x7:     /*OSWORD*/
                        switch (*armregs[0])
                        {
                                case 0xC: /*change palette entry*/
//                                log("Changing palette\n");
                                break;

                                case 0x15: /*mouse params*/
                                break;

                                case 0x16:
                                tempaddr=*armregs[1];
                                type=readByte(tempaddr++);
                                addr=readByte(tempaddr++);
                                addr|=readByte(tempaddr++)<<8;
                                addr|=readByte(tempaddr++)<<16;
                                addr|=readByte(tempaddr++)<<24;
                                videobase=addr-0x8000;
//                                printf("Type %i addr %08X\n",type,addr);
                                break;

                                default:
                                closevideo();
                                printf("Bad OSWORD %08X\n",*armregs[0]);
                                dumpregs();
                                exit(-1);
                        }
                        break;

                        case 0x2C:    /*test escape*/
                        *armregs[15]&=~CFLAG;
                        break;

                        case 0x1E:    /*OS_Module*/
                        case 0x2001E:
                        switch (*armregs[0])
                        {
                                case 0xA: /*Insert module - oh shit*/
                                break;
                                case 0xB: /*Insert module into RMA*/
                                break;

                                default:
                                closevideo();
                                restoretext();
                                exitarm=1;
                                printf("Bad OS_Module %08X\n",*armregs[0]);
                                return;
                        }
                        break;

                        case 0x31: case 0x20031:   /*OS_ReadVDUVariables*/
                        tempaddr=*armregs[0];
                        tempaddr2=*armregs[1];
                        while (1)
                        {
                                temp=readDWord(tempaddr);
                                if (temp==0xFFFFFFFF)
                                   return;
                                tempaddr+=4;
                                switch (temp)
                                {
                                        case 148: /*vid mem offset*/
                                        writeDWord(tempaddr2,0x1F08000);
                                        tempaddr2+=4;
                                        break;

                                        case 149: /*vidc offset*/
                                        writeDWord(tempaddr2,0x1F08000);
                                        tempaddr2+=4;
                                        break;

                                        default:
                                        closevideo();
                                        dumpram();
                                        printf("Bad variable %i\n",temp);
                                        dumpregs();
                                        exit(-1);
                                }
                        }
                        break;

                        case 0x36: case 0x20036:   /*OS_RemoveCursors*/
                        break;

                        case 0x3A:    /*OS_ValidateAddress*/
                        *armregs[15]&=~CFLAG;
                        break;

                        case 0x16: case 0x20016: /*OS_EnterOS*/
                        if (output) logfile("Was mode %i\n",*armregs[15]&3);
                        *armregs[15]|=3;
                        break;

                        case 0x20046: /*WriteN - R0=pointer, R1=number of chars*/
//                        printf("%07X\n",*armregs[0]);
                        for (c=0;c<*armregs[1];c++)
                        {
                                writec(readByte(*armregs[0]));
                                *armregs[0]=*armregs[0]+1;
                        }
                        break;

                        case 0x40142: /*Sound stuff*/
                        case 0x40140:
                        case 0x40180:
                        case 0x40183:
                        case 0x40184:
                        case 0x40189:
                        case 0x4018A:
                        break;

                        case 0x40185: /*Sound stuff*/
                        *armregs[1]=0;
                        break;

                        default:
                        exitarm=1;
                        set_gfx_mode(GFX_TEXT,0,0,0,0);
                        restoretext();
                        printf("Bad SWI %05X\n",opcode&0xFFFFF);
                        return;
                }
        }
}

void swi()
{
        int c;
        cycles-=2;
//        logfile("SWI %05X  R0 %08X  PC %07X",opcode&0xFFFFF,*armregs[0],(*armregs[15]-8)&0x3FFFFFC);
//        if (!output) logfile("\n");
        if ((opcode&0x1FFFF)==6 && *armregs[0]==0x13)
        {
                exitsync=1;
                return;
        }
        if ((opcode&0x1FF00)==0x100)
           writec(opcode&0xFF);
        if (!(opcode&0x1FFFF))
           writec(*armregs[0]&0xFF);
        if ((opcode&0x1FFFF)==1)
        {
                c=(*armregs[15]-4)&0x3FFFFFC;
                while (1)
                {
                        temp=readByte(c++);
                        if (!temp)
                           break;
                        else
                           writec(temp);
                }
        }
        if ((opcode&0x1FFFF)==2)
        {
                c=*armregs[0];
                while (1)
                {
                        temp=readByte(c++);
                        if (!temp)
                           break;
                        else
                           writec(temp);
                }
        }
/*        if ((opcode&0x7FFFF)==0x60186)
        {
                dumpregslog();
                output=1;
        }*/
//        if ((opcode&0x5FFFF)==0x00000)
//           dumpregslog();
        temp2=*armregs[15]-4;
        *armregs[15]|=3;
        changemode();
        *armregs[14]=temp2;
        *armregs[15]&=0xFC000003;
        *armregs[15]|=0xC;
}

inline void execit()
{
        if ((opcode&0xF0)==0x90)
           armopcodes2[(opcode>>20)&0xFF]();
        else
           armopcodes[(opcode>>20)&0xFF]();
}

void dumpregs()
{
        int c,d;
        for (d=0;d<4;d++)
        {
                for (c=0;c<4;c++)
                {
                        printf("R%i=%08X  ",c|(d<<2),*armregs[c|(d<<2)]);
                }
                printf("\n");
        }
        printf("FIQ regs : \n");
        for (c=0;c<4;c++)
            printf("R%i=%08X  ",c+8,fiqregs[c+8]);
        printf("\n");
        for (c=0;c<4;c++)
            printf("R%i=%08X  ",c+12,fiqregs[c+12]);
        printf("\n");
        printf("%i instructions executed\n",instructions);
        printf("oldr15 %08X oldoldr15 %08X\n",oldr15,oldoldr15);
}

void dumpregslog()
{
        int c,d;
        for (d=0;d<4;d++)
        {
                for (c=0;c<4;c++)
                {
                        logfile("R%i=%08X  ",c|(d<<2),*armregs[c|(d<<2)]);
                }
                logfile("\n");
        }
        logfile("FIQ regs : \n");
        for (c=0;c<4;c++)
            logfile("R%i=%08X  ",c+8,fiqregs[c+8]);
        logfile("\n");
        for (c=0;c<4;c++)
            logfile("R%i=%08X  ",c+12,fiqregs[c+12]);
        logfile("\n");
        logfile("%i instructions executed\n\n",instructions);
}

void initarm(int swifake)
{
        int c;
        for (c=0;c<16;c++)
            armregs[c]=&userregs[c];
        if (!swifake)
        {
                armregs[13]=&superregs[13];
                armregs[14]=&superregs[14];
                *armregs[15]=0xC00000B;
        }
        else
           *armregs[15]=0xC000008;
        *armregs[13]=0x1C07FFC;
        superregs[13]=0x1C03FFC;
//        *armregs[14]=~0;
        for (c=0;c<256;c++)
            armopcodes[c]=badopcode;
        for (c=0;c<0x40;c++)
            armopcodes[c]=dataproc;
//        armopcodes[0x00]=dataproc;
        armopcodes[0x01]=dataproc;
        armopcodes[0x02]=dataproc;
        armopcodes[0x04]=dataproc;
        armopcodes[0x05]=dataproc;
        armopcodes[0x08]=dataproc;
        armopcodes[0x09]=dataproc;
        armopcodes[0x0A]=dataproc;
        armopcodes[0x10]=dataproc;
        armopcodes[0x13]=dataproc;
        armopcodes[0x15]=dataproc;
        armopcodes[0x18]=dataproc;
        armopcodes[0x19]=dataproc;
        armopcodes[0x1A]=dataproc;
        armopcodes[0x1B]=dataproc;
        armopcodes[0x1D]=dataproc;
        armopcodes[0x1E]=dataproc;
        armopcodes[0x20]=dataproc;
        armopcodes[0x21]=dataproc;
        armopcodes[0x22]=dataproc;
        armopcodes[0x24]=dataproc;
        armopcodes[0x25]=dataproc;
        armopcodes[0x26]=dataproc;
        armopcodes[0x28]=dataproc;
        armopcodes[0x31]=dataproc;
        armopcodes[0x33]=dataproc;
        armopcodes[0x35]=dataproc;
        armopcodes[0x37]=dataproc;
        armopcodes[0x38]=dataproc;
        armopcodes[0x39]=dataproc;
        armopcodes[0x3A]=dataproc;
        armopcodes[0x3B]=dataproc;
        armopcodes[0x3C]=dataproc;
        armopcodes[0x3E]=dataproc;
        for (c=0x40;c<0x80;c++)
        {
                if (c&1)
                   armopcodes[c]=ldr;
                else
                   armopcodes[c]=str;
        }
/*        for (c=0x80;c<0xA0;c++)
        {
                if (c&1)
                   armopcodes[c]=ldm;
                else
                   armopcodes[c]=stm;
        }*/
        armopcodes[0x80]=stmda;
        armopcodes[0x81]=ldmda;
        armopcodes[0x88]=stmia;
        armopcodes[0x89]=ldmia;
        armopcodes[0x8A]=stmia;
        armopcodes[0x8B]=ldmia;
        armopcodes[0x8C]=stmias;
        armopcodes[0x8D]=ldmias;
        armopcodes[0x8F]=ldmias;
        armopcodes[0x90]=stmdb;
        armopcodes[0x91]=ldmdb;
        armopcodes[0x92]=stmdb;
        armopcodes[0x93]=ldmdb;
        armopcodes[0x95]=ldmdbs;
        armopcodes[0x96]=stmdbs;
        armopcodes[0x98]=stmib;
        armopcodes[0x99]=ldmib;
        armopcodes[0x9B]=ldmib;

        armopcodes[0xA0]=branch;
        armopcodes[0xA6]=branch;
        armopcodes[0xA7]=branch;
        armopcodes[0xA9]=branch;
        armopcodes[0xAE]=branch;
        armopcodes[0xAF]=branch;
        armopcodes[0xB0]=branchlink;
        armopcodes[0xBF]=branchlink;
        armopcodes[0xE1]=copro;
        armopcodes[0xE3]=copro;
        armopcodes[0xE5]=copro;
        if (!swifake)
           armopcodes[0xF0]=swi;
        else
           armopcodes[0xF0]=fakeswi;
        for (c=0;c<256;c++)
            armopcodes2[c]=armopcodes[c];
        for (c=0;c<32;c++)
            armopcodes2[c]=badopcode2;
        armopcodes2[0]=mul;
        armopcodes2[1]=mul;
        armopcodes2[2]=mla;
        armopcodes2[3]=mla;
}

void armabort()
{
        aborted=1;
}

void execopcode(int cycs)
{
        int c=0;
        int lastmode;
        cycles=cycs;
        while (cycles>0)
        {
                oldoldr15=oldr15;
                oldr15=*armregs[15];
                lastmode=*armregs[15]&3;
                opcode=readDWord((*armregs[15]-8)&0x3FFFFFC);
                if (output) logfile("%i : %07X : %08X : %c :",instructions,(*armregs[15]&0x3FFFFFC)-8,opcode,(VFLAGSET)?'V':' ');
                cflag=*armregs[15]&CFLAG;
                switch (opcode>>28)
                {
                        case 0:  /*EQ*/
                        if (ZFLAGSET)
                           execit();
                        break;
                        case 1:  /*NE*/
                        if (!ZFLAGSET)
                           execit();
                        break;
                        case 2: /*CS*/
                        if (CFLAGSET)
                           execit();
                        break;
                        case 3: /*CC*/
                        if (!CFLAGSET)
                           execit();
                        break;
                        case 4: /*MI*/
                        if (NFLAGSET)
                           execit();
                        break;
                        case 5: /*PL*/
                        if (!NFLAGSET)
                           execit();
                        break;
                        case 6: /*VS*/
                        if (VFLAGSET)
                           execit();
                        break;
                        case 7: /*VC*/
                        if (!VFLAGSET)
                           execit();
                        break;
                        case 8: /*HI*/
                        if (CFLAGSET && !ZFLAGSET)
                           execit();
                        break;
                        case 9: /*LS*/
                        if (!CFLAGSET || ZFLAGSET)
                           execit();
                        break;
                        case 10: /*GE*/
                        if (NFLAGSET == VFLAGSET)
                           execit();
                        break;
                        case 11: /*LT*/
                        if (NFLAGSET != VFLAGSET)
                           execit();
                        break;
                        case 12: /*GT*/
                        if (!ZFLAGSET && (NFLAGSET == VFLAGSET))
                           execit();
                        break;
                        case 13: /*LE*/
                        if (ZFLAGSET || (NFLAGSET != VFLAGSET))
                           execit();
                        break;
                        case 14: /*AL*/
                        execit();
                        break;
                        case 15: /*NV*/
                        break;
                        default:
                        closevideo();
                        printf("Unknown condition code %i\n",opcode>>28);
                        dumpregs();
                        exit(-1);
                }
                if (output) logfile("\n");
                if (exitarm)
                   return;
                if ((*armregs[15]&3)!=lastmode)
                {
                        changemode(); /*Update mode*/
                }
                c++;
                if (c==16)
                   updateioctimers(3);
                c&=15;
                cycles--;
                *armregs[15]+=4;
/*                if (*armregs[13]>0xC0000000 && trapr13)
                {
                        output=1;
                        dumpregslog();
                        logfile("R13 outside of address space\n");
                        trapr13=0;
                }
                if ((*armregs[15]&0x3FFFFFC)==8)
                {
                        output=1;
                        dumpregslog();
                        logfile("Branch through zero\n");
                }*/
                if (output2)
                {
                        logfile("%i : %08X %08X %08X %08X ",instructions+1,*armregs[0],*armregs[1],*armregs[2],*armregs[3]);
                        logfile("%08X %08X %08X %08X ",*armregs[4],*armregs[5],*armregs[6],*armregs[7]);
                        logfile("%08X %08X %08X %08X ",*armregs[8],*armregs[9],*armregs[10],*armregs[11]);
                        logfile("%08X %08X %08X %08X\n",*armregs[12],*armregs[13],*armregs[14],(*armregs[15])&~3);
                }
/*                if ((*armregs[15]&0x3FFFFFC)==(0x3806BBC+8) && !output)
                {
                        output=1;
                        dumpregslog();
                        logfile("old R15 %08X\n",oldr15);
//                        timetolive=1000;
                }*/
/*                if ((*armregs[15]&0x3FFFFFC)==(0x38130A0+8) && output)
                {
//                        output=1;
                        closevideo();
                        dumpregslog();
                        dumpregs();
                        dumpram();
//                        logfile("old R15 %08X\n",oldr15);
//                        timetolive=1000;
                        exit(-1);
                }*/
                if (undefinedinst)
                {
//                        logfile("Undefined instruction at %07X\n",(*armregs[15]-8)&0x3FFFFFC);
//                        output=1;
//                        dumpregslog();
                        temp2=*armregs[15];
                        *armregs[15]|=3;
                        changemode();
                        *armregs[14]=temp2;
                        *armregs[15]&=0xFC000003;
                        *armregs[15]|=0x0C;
                        undefinedinst=0;
                }
                else if (aborted)
                {
                        temp2=*armregs[15];
                        *armregs[15]|=3;
                        changemode();
                        *armregs[14]=temp2;
                        *armregs[15]&=0xFC000003;
                        *armregs[15]|=0x18;
                        aborted=0;
                }
                else if (armirq && !(*armregs[15]&0x8000000))
                {
//                        logfile("Interrupt at %07X\n",(*armregs[15]-8)&0x3FFFFFC);
//                        dumpiocregslog();
                        temp2=*armregs[15]-4;
                        *armregs[15]&=~3;
                        *armregs[15]|=2;
                        changemode();
                        *armregs[14]=temp2;
                        *armregs[15]&=0xFC000003;
                        *armregs[15]|=0x20;
                        *armregs[15]|=0x8000000;
                }
/*                if (fiqregs[12]&0x2FF80)
                {
//                        closevideo();
//                        dumpregs();
//                        exit(-1);
                }*/
                instructions++;
                ins_exec++;
//                if (instructions==30)
//                   exit(0);
/*                if (instructions==144000)
                {
//                        soutput=1;
                        output=1;
                        dumpregslog();
                        timetolive=10000;
                }*/
/*                if (opcode==0)
                {
                        closevideo();
                        printf("ARM dead\n");
                        printf("old pc %07X\n",(oldoldr15-8)&0x3FFFFFC);
                        dumpregs();
                        dumpram();
                        exit(-1);
                }*/
                if (timetolive)
                {
                        timetolive--;
                        if (!timetolive)
                        {
                                closevideo();
                                printf("Life expired\n");
                                dumpregs();
                                dumpiocregs();
                                exit(-1);
                        }
                }
//                ram[0]++;
//                if (readByte(0x1F16664)==219)
//                   output=1;
                if (exitsync)
                {
                        cycles=0;
                        return;
                }
        }
}
