#include <stdlib.h>
#include <stdio.h>
#include <stddef.h>
#include <stdarg.h>
#include <string.h>
#include "arc.h"

FILE *arclog,*armlog;
char filename[80];
unsigned long loadaddr,runaddr;
int faking=0;

int main(int argc, char *argv[])
{
        int c=0;
        int frames=0;
        printf("Archimedes emulator v0.1 starting\n");
        arclog=fopen("arc.log","wt");
        armlog=fopen("arm.log","wt");
        if (argc<2)
           initmem();
        else
        {
                strcpy(filename,argv[1]);
                if (argc>3)
                {
                        sscanf(argv[2],"%x",&loadaddr);
                        sscanf(argv[3],"%x",&runaddr);
                }
                else
                   loadaddr=runaddr=0x8000;
                printf("Boot RiscOS with this file?");
                if (toupper(getch())=='Y')
                   initmem();
                else
                {
                        initmem2(argv[1],loadaddr,runaddr);
                        faking=1;
                }
        }
        loadcmos();
        initarm(faking);
        initioc();
//        printf("Press a key to go\n");
//        getch();
        initvideo();
        debug();
/*        while (!kbhit())
        {
                execopcode(160000);
        }*/
        closevideo();
        dumpregs();
        dumpiocregs();
        dumpvidcregs();
        dumpram();
        dumpmemcregs();
        return 0;
}

void log(char *format, ...)
{
   char buf[256];

   va_list ap;
   va_start(ap, format);
   vsprintf(buf, format, ap);
   va_end(ap);
   fputs(buf,arclog);
}

void logfile(char *format, ...)
{
   char buf[256];

   va_list ap;
   va_start(ap, format);
   vsprintf(buf, format, ap);
   va_end(ap);
   fputs(buf,armlog);
}
