#include "arc.h"

int i2cclock,i2cdata;
int keyway=0;
unsigned char tempkey,iockey,iockey2;
int keydelay=0;

void updateirqs()
{
        if ((ioc.mska&ioc.irqa)||(ioc.mskb&ioc.irqb)) armirq=1;
        else                                          armirq=0;
}

void writeioc(unsigned long addr, unsigned long v)
{
        switch (addr&0x7C)
        {
                case 0x00: cmosi2cchange(v&2,v&1); ioc.ctrl=v&0xFC; return;
                case 0x04: ioc.irqb&=~0x40; updateirqs(); iockey2=v; keydelay=1000; keyway=1; return;
                case 0x14: ioc.irqa&=~v; updateirqs(); return;
                case 0x18: ioc.mska=v; updateirqs(); return;
                case 0x24: return; /*????*/
                case 0x28: ioc.mskb=v; updateirqs(); return;
                case 0x34: return; /*????*/
                case 0x38: ioc.mskf=v; return;
                case 0x40: ioc.timerl[0]=(ioc.timerl[0]&0xFF00)|v; return;
                case 0x44: ioc.timerl[0]=(ioc.timerl[0]&0xFF)|(v<<8); return;
                case 0x48: ioc.timerc[0]=ioc.timerl[0]; return;
                case 0x4C: ioc.timerr[0]=ioc.timerc[0]; return;
                case 0x50: ioc.timerl[1]=(ioc.timerl[1]&0xFF00)|v; return;
                case 0x54: ioc.timerl[1]=(ioc.timerl[1]&0xFF)|(v<<8); return;
                case 0x58: ioc.timerc[1]=ioc.timerl[1]; return;
                case 0x5C: ioc.timerr[1]=ioc.timerc[1]; return;
                case 0x60: ioc.timerl[2]=(ioc.timerl[2]&0xFF00)|v; return;
                case 0x64: ioc.timerl[2]=(ioc.timerl[2]&0xFF)|(v<<8); return;
                case 0x68: ioc.timerc[2]=ioc.timerl[2]; return;
                case 0x6C: ioc.timerr[2]=ioc.timerc[2]; return;
                case 0x70: ioc.timerl[3]=(ioc.timerl[3]&0xFF00)|v; return;
                case 0x74: ioc.timerl[3]=(ioc.timerl[3]&0xFF)|(v<<8); return;
                case 0x78: ioc.timerc[3]=ioc.timerl[3]; return;
                case 0x7C: ioc.timerr[3]=ioc.timerc[3]; return;
        }
        printf("Bad IOC write %07X %04X\n",addr,v);
        dumpregs();
        exit(-1);
}

unsigned char readioc(unsigned long addr)
{
        unsigned char temp;
        switch (addr&0x7C)
        {
                case 0x00: return ((i2cclock)?2:0)|((i2cdata)?1:0)|4;
                case 0x04: ioc.irqb&=~0x80; updateirqs(); return iockey;
                case 0x10: temp=ioc.irqa; ioc.irqa&=~0x10; return temp;
                case 0x14: return ioc.irqa&ioc.mska;
                case 0x18: return ioc.mska;
                case 0x20: return ioc.irqb;
                case 0x24: return ioc.irqb&ioc.mskb;
                case 0x28: return ioc.mskb;
                case 0x30: return ioc.fiq;
                case 0x40: return ioc.timerr[0];
                case 0x44: return ioc.timerr[0]>>8;
                case 0x50: return ioc.timerr[1];
                case 0x54: return ioc.timerr[1]>>8;
                case 0x60: return ioc.timerr[2];
                case 0x64: return ioc.timerr[2]>>8;
                case 0x70: return ioc.timerr[3];
                case 0x74: return ioc.timerr[3]>>8;
        }
        printf("Bad IOC read %07X\n",addr);
        dumpregs();
        exit(-1);
}

void iocfiq(unsigned char v)
{
        ioc.fiq|=v;
        if (ioc.fiq&ioc.mskf) armfiq=1;
        else                  armfiq=0;
//        printf("FIQup %i %i\n",ioc.fiq,armfiq);
}

void iocfiqc(unsigned char v)
{
        ioc.fiq&=~v;
        if (ioc.fiq&ioc.mskf) armfiq=1;
        else                  armfiq=0;
//        printf("FIQup %i %i\n",ioc.fiq,armfiq);
}

void updateioctimers()
{
        if (!ioc.timerc[0])
        {
                ioc.irqa|=0x20;
                ioc.timerc[0]=ioc.timerl[0];
                updateirqs();
        }
        if (!ioc.timerc[1])
        {
                ioc.irqa|=0x20;
                ioc.timerc[0]=ioc.timerl[0];
                updateirqs();
        }
}

void resetioc()
{
        ioc.irqa=0;//x10;
        ioc.irqb=0;
}

void keycallback()
{
        if (!keyway)
        {
                iockey=tempkey;
                ioc.irqb|=0x80;
                updateirqs();
//                printf("Keyrx now %02X\n",iockey);
        }
        else
        {
                writekeyboard(iockey2);
                ioc.irqb|=0x40;
                updateirqs();
        }
}

void sendkey(unsigned char v)
{
        tempkey=v;
        keydelay=1000;
        keyway=0;
}
