#include <stdio.h>
#include "arc.h"

int soundtime;
int discint;
unsigned char cmosram[256];
int cccount=0;
int keydelay;
int armirq=0;
int output=0;
int firstins;

#define USER       0
#define FIQ        1
#define IRQ        2
#define SUPERVISOR 3

#define NFSET ((*armregs[15]&0x80000000)?1:0)
#define ZFSET ((*armregs[15]&0x40000000)?1:0)
#define CFSET ((*armregs[15]&0x20000000)?1:0)
#define VFSET ((*armregs[15]&0x10000000)?1:0)

#define NFLAG 0x80000000
#define ZFLAG 0x40000000
#define CFLAG 0x20000000
#define VFLAG 0x10000000
#define IFLAG 0x08000000

#define RD ((opcode>>12)&0xF)
#define RN ((opcode>>16)&0xF)
#define RM (opcode&0xF)

#define MULRD ((opcode>>16)&0xF)
#define MULRN ((opcode>>12)&0xF)
#define MULRS ((opcode>>8)&0xF)
#define MULRM (opcode&0xF)

#define GETADDR(r) ((r==15)?(*armregs[15]&0x3FFFFFC):*armregs[r])
#define LOADREG(r,v) if (r==15) *armregs[15]=(*armregs[15]&0xFC000003)|((v+4)&0x3FFFFFC); else *armregs[r]=v;
#define GETREG(r) ((r==15) ? *armregs[15]+4 : *armregs[r])
#define LDRRESULT(a,v) ((a&3)?(v>>((a&3)<<3))|(v<<(((a&3)^3)<<3)):v)

int ins=0;

/*0=i/o, 1=all, 2=r/o, 3=os r/o, 4=super only, 5=read mem, write io*/
/*0=user, 1=os, 2=super*/
int modepritabler[3][6]=
{
        {0,1,1,0,0,1},
        {0,1,1,1,0,1},
        {0,1,1,1,1,1}
};
int modepritablew[3][6]=
{
        {0,1,0,0,0,0},
        {0,1,1,0,0,0},
        {0,1,1,1,1,0}
};

int mode;
int osmode=0;

void updatemode(int m)
{
        int c;
        mode=m;
        switch (m)
        {
                case USER:
                for (c=0;c<16;c++) armregs[c]=&userregs[c];
                memmode=osmode;
                break;
                case IRQ:
                for (c=0;c<16;c++) armregs[c]=&userregs[c];
                armregs[13]=&irqregs[13];
                armregs[14]=&irqregs[14];
                memmode=2;
                break;
                case FIQ:
                for (c=0;c<16;c++) armregs[c]=&userregs[c];
                for (c=8;c<15;c++) armregs[c]=&fiqregs[c];
                memmode=2;
                break;
                case SUPERVISOR:
                for (c=0;c<16;c++) armregs[c]=&userregs[c];
                armregs[13]=&superregs[13];
                armregs[14]=&superregs[14];
                memmode=2;
                break;
        }
}

void resetarm()
{
        updatemode(SUPERVISOR);
        *armregs[15]=0x0C00000B;
        mode=3;
        memmode=2;
        firstins=1;
}

void dumpregs()
{
        int c;
        FILE *f=fopen("vram.dmp","wb");
        printf("R 0=%08X R 4=%08X R 8=%08X R12=%08X\n",*armregs[0],*armregs[4],*armregs[8],*armregs[12]);
        printf("R 1=%08X R 5=%08X R 9=%08X R13=%08X\n",*armregs[1],*armregs[5],*armregs[9],*armregs[13]);
        printf("R 2=%08X R 6=%08X R10=%08X R14=%08X\n",*armregs[2],*armregs[6],*armregs[10],*armregs[14]);
        printf("R 3=%08X R 7=%08X R11=%08X R15=%08X\n",*armregs[3],*armregs[7],*armregs[11],*armregs[15]);
        printf("f12=%08X ",fiqregs[12]);
        printf("PC =%07X ins=%i\n",PC,ins);
        for (c=0;c<0x80000;c++)
            putc(((unsigned char *)ram)[c],f);
        fclose(f);
        f=fopen("zeropage.dmp","wb");
        fwrite(ram,0x8000,1,f);
        fclose(f);
        f=fopen("cmos.bin","wb");
        fwrite(cmosram,256,1,f);
        fclose(f);
/*        f=fopen("highpage.dmp","wb");
        for (c=0x1F00000;c<0x1F08000;c++)
            putc(readmemb(c),f);
        fclose(f);
        f=fopen("midpage.dmp","wb");
        for (c=0x1810000;c<0x1818000;c++)
            putc(readmemb(c),f);
        fclose(f);*/
        dumpvid();
        printf("VIDC=%08X\n",vidcr[0xE0>>2]);
}

void loadrom()
{
        FILE *f;
        int c;
/*        f=fopen("cmos.ram","rb");
        fread(cmosram,256,1,f);
        fclose(f);*/
//        memset(cmosram,0,256);
        f=fopen("ic24.rom","rb");
        fread(rom,0x80000,1,f);
        fclose(f);
        f=fopen("ic25.rom","rb");
        fread(&rom[0x20000], 0x80000,1,f);
        fclose(f);
        f=fopen("ic26.rom","rb");
        fread(&rom[0x40000],0x80000,1,f);
        fclose(f);
        f=fopen("ic27.rom","rb");
        fread(&rom[0x60000],0x80000,1,f);
        fclose(f);
/*        f=fopen("2/ic24.rom","rb");
        fread(rom,0x20000,1,f);
        fclose(f);
        f=fopen("2/ic25.rom","rb");
        fread(&rom[0x8000], 0x20000,1,f);
        fclose(f);
        f=fopen("2/ic26.rom","rb");
        fread(&rom[0x10000],0x20000,1,f);
        fclose(f);
        f=fopen("2/ic27.rom","rb");
        fread(&rom[0x18000],0x20000,1,f);
        fclose(f);*/
/*        f=fopen("arthur.rom","rb");
        fread(rom,0x80000,1,f);
        fclose(f);*/
/*        rom[0x1945C>>2]=0xFFFFFFFF;
        rom[0x19464>>2]=0xFFFFFFFF;*/
}

#define checkneg(v) (v&0x80000000)
#define checkpos(v) !(v&0x80000000)

inline void setadd(unsigned long op1, unsigned long op2)
{
        unsigned long res=op1+op2;
        *armregs[15]&=0xFFFFFFF;
        if (res<op1)                       *armregs[15]|=CFLAG;
        if (!checkneg(op1)&&checkneg(res)) *armregs[15]|=VFLAG;
        if (!res)                          *armregs[15]|=ZFLAG;
        else if (checkneg(res))            *armregs[15]|=NFLAG;
}

inline void setsub(unsigned long op1, unsigned long op2)
{
        unsigned long res=op1-op2;
        char s[80];
        *armregs[15]&=0xFFFFFFF;
        if (op1>=op2)           *armregs[15]|=CFLAG;
        if (!res)               *armregs[15]|=ZFLAG;
        else if (checkneg(res)) *armregs[15]|=NFLAG;
        if ((checkneg(op1) && checkpos(op2) && checkpos(res)) ||
            (checkpos(op1) && checkneg(op2) && checkneg(res)))
            *armregs[15]|=VFLAG;
}

inline void setzn(unsigned long op)
{
        *armregs[15]&=0x3FFFFFFF;
        if (!op)               *armregs[15]|=ZFLAG;
        else if (checkneg(op)) *armregs[15]|=NFLAG;
}

inline unsigned long shift(unsigned long opcode)
{
        unsigned long shiftmode=(opcode>>5)&3;
        unsigned long shiftamount=(opcode>>7)&31;
        unsigned long temp;
        int cflag=CFSET;
        if (!(opcode&0xFF0)) return *armregs[RM];
        if (opcode&0x10)     shiftamount=*armregs[(opcode>>8)&15]&0xFF;
        temp=*armregs[RM];
        if (RM==15)        temp+=4;
        if (opcode&0x100000 && shiftamount) *armregs[15]&=~CFLAG;
        switch (shiftmode)
        {
                case 0: /*LSL*/
                if (!shiftamount) return temp;
                if (shiftamount==32)
                {
                        if (temp&1 && opcode&0x100000) *armregs[15]|=CFLAG;
                        return 0;
                }
                if (shiftamount>32) return 0;
                if (opcode&0x100000)
                {
                        if ((temp<<(shiftamount-1))&0x80000000) *armregs[15]|=CFLAG;
                }
                return temp<<shiftamount;

                case 1: /*LSR*/
                if (!shiftamount) return temp;
                if (shiftamount==32)
                {
                        if (temp&0x80000000 && opcode&0x100000) *armregs[15]|=CFLAG;
                        return 0;
                }
                if (shiftamount>32) return 0;
                if (opcode&0x100000)
                {
                        if ((temp>>(shiftamount-1))&1) *armregs[15]|=CFLAG;
                }
                return temp>>shiftamount;

                case 2: /*ASR*/
                if (!shiftamount)
                {
                        if (opcode&0x10) return temp;
                }
                if (shiftamount>=32 || !shiftamount)
                {
                        *armregs[15]&=~CFLAG;
                        if (temp&0x80000000 && opcode&0x100000) *armregs[15]|=CFLAG;
                        if (temp&0x80000000) return 0xFFFFFFFF;
                        return 0;
                }
                if (opcode&0x100000)
                {
                        if ((temp>>(shiftamount-1))&1) *armregs[15]|=CFLAG;
                }
                return (int)temp>>shiftamount;

                case 3: /*ROR*/
                if (opcode&0x100000) *armregs[15]&=~CFLAG;
                if (!shiftamount && !(opcode&0x10))
                {
                        if (opcode&0x100000 && temp&1) *armregs[15]|=CFLAG;
                        return (((cflag)?1:0)<<31)|(temp>>1);
                }
                if (!shiftamount)
                {
                        if (opcode&0x100000) *armregs[15]|=cflag;
                        return temp;
                }
                if (!(shiftamount&0x1F))
                {
                        if (opcode&0x100000 && temp&0x80000000) *armregs[15]|=CFLAG;
                        return temp;
                }
                if (opcode&0x100000)
                {
                        if (((temp>>shiftamount)|(temp<<(32-shiftamount)))&0x80000000) *armregs[15]|=CFLAG;
                }
                return (temp>>shiftamount)|(temp<<(32-shiftamount));
                break;
                default:
                printf("Shift mode %i amount %i\n",shiftmode,shiftamount);
                dumpregs();
                exit(-1);
        }
}

inline unsigned shift2(unsigned opcode)
{
        unsigned shiftmode=(opcode>>5)&3;
        unsigned shiftamount=(opcode>>7)&31;
        unsigned long temp;
        int cflag=CFSET;
        if (!(opcode&0xFF0)) return *armregs[RM];
        if (opcode&0x10) shiftamount=*armregs[(opcode>>8)&15]&0xFF;
        temp=*armregs[RM];
        if (RM==15) temp+=4;
        switch (shiftmode)
        {
                case 0: /*LSL*/
                if (!shiftamount)    return temp;
                if (shiftamount==32) return 0;
                if (shiftamount>32)  return 0;
                return temp<<shiftamount;

                case 1: /*LSR*/
                if (!shiftamount)    return temp;
                if (shiftamount==32) return 0;
                if (shiftamount>32)  return 0;
                return temp>>shiftamount;

                case 2: /*ASR*/
                if (!shiftamount) return temp;
                if (shiftamount>=32)
                {
                        if (temp&0x80000000)
                           return 0xFFFFFFFF;
                        return 0;
                }
                return (int)temp>>shiftamount;

                case 3: /*ROR*/
                if (!shiftamount && !(opcode&0x10)) return (((cflag)?1:0)<<31)|(temp>>1);
                if (!shiftamount)                   return temp;
                return (temp>>shiftamount)|(temp<<(32-shiftamount));
                break;

                default:
                printf("Shift2 mode %i amount %i\n",shiftmode,shiftamount);
                dumpregs();
                exit(-1);
        }
}

inline unsigned rotate(unsigned data)
{
        unsigned rotval=data&0xFF;
        unsigned rotamount=((data>>8)&0xF)<<1;
        rotval=(rotval>>rotamount)|(rotval<<(32-rotamount));
        if (data&0x100000 && rotamount)
        {
                if (rotval&0x80000000) *armregs[15]|=CFLAG;
                else                   *armregs[15]&=~CFLAG;
        }
        return rotval;
}

unsigned long ldrresult(unsigned long val, unsigned long addr)
{
        if (addr&3) printf("Unaligned access\n");
//        return val;
        switch (addr&3)
        {
                case 0:
                return val;
                case 1:
                return (val>>8)|(val<<24);
                case 2:
                return (val>>16)|(val<<16);
                case 3:
                return (val>>24)|(val<<8);
        }
}


int accc=0;
void execarm(int cycles)
{
        unsigned long opcode,templ,templ2,mask,oldpc,addr,addr2;
        int exec,c;
        unsigned char temp;
        FILE *f;
        while (cycles>0)
        {
                oldpc=PC;
                opcode=readmeml(PC);
                switch (opcode>>28)
                {
                        case 0:  /*EQ*/ exec=ZFSET; break;
                        case 1:  /*NE*/ exec=!ZFSET; break;
                        case 2:  /*CS*/ exec=CFSET; break;
                        case 3:  /*CC*/ exec=!CFSET; break;
                        case 4:  /*MI*/ exec=NFSET; break;
                        case 5:  /*PL*/ exec=!NFSET; break;
                        case 6:  /*VS*/ exec=VFSET; break;
                        case 7:  /*VC*/ exec=!VFSET; break;
                        case 8:  /*HI*/ exec=(CFSET && !ZFSET); break;
                        case 9:  /*LS*/ exec=(!CFSET || ZFSET); break;
                        case 10: /*GE*/ exec=(NFSET == VFSET); break;
                        case 11: /*LT*/ exec=(NFSET != VFSET); break;
                        case 12: /*GT*/ exec=(!ZFSET && (NFSET==VFSET)); break;
                        case 13: /*LE*/ exec=(ZFSET || (NFSET!=VFSET)); break;
                        case 14: /*AL*/ exec=1; break;
                        case 15: /*NV*/ exec=0; break;
                }
                if (exec && ((opcode&0xE000090)==0x90))
                {
                        switch ((opcode>>20)&0xFF)
                        {
                                case 0x00: /*MUL*/
                                *armregs[MULRD]=(*armregs[MULRM])*(*armregs[MULRS]);
                                cycles-=32;
                                break;
                                case 0x01: /*MULS*/
                                *armregs[MULRD]=(*armregs[MULRM])*(*armregs[MULRS]);
                                setzn(*armregs[MULRD]);
                                cycles-=32;
                                break;
                                case 0x02: /*MLA*/
                                *armregs[MULRD]=((*armregs[MULRM])*(*armregs[MULRS]))+*armregs[MULRN];
                                cycles-=32;
                                break;
                                                                
                                default:
                                printf("Bad ext opcode %02X %08X at %07X\n",(opcode>>20)&0xFF,opcode,PC);
                                dumpregs();
                                exit(-1);
                        }                        
                }
                else if (exec)
                {
                        switch ((opcode>>20)&0xFF)
                        {
                                case 0x00: /*AND reg*/
                                if (RD==15)
                                {
                                        templ=shift(opcode);
                                        *armregs[15]=(((GETADDR(RN)&templ)+4)&0x3FFFFFC)|(*armregs[15]&0xFC000003);
                                }
                                else
                                {
                                        templ=shift(opcode);
                                        *armregs[RD]=GETADDR(RN)&templ;
                                }
                                cycles--;
                                break;
                                case 0x01: /*ANDS reg*/
                                if (RD==15)
                                {
                                        templ=shift(opcode);
                                        *armregs[15]=(GETADDR(RN)&templ)+4;
                                }
                                else
                                {
                                        templ=shift(opcode);
                                        *armregs[RD]=GETADDR(RN)&templ;
                                        setzn(*armregs[RD]);
                                }
                                cycles--;
                                break;

                                case 0x02: /*EOR reg*/
                                if (RD==15)
                                {
                                        templ=shift(opcode);
                                        *armregs[15]=(((GETADDR(RN)^templ)+4)&0x3FFFFFC)|(*armregs[15]&0xFC000003);
                                }
                                else
                                {
                                        templ=shift(opcode);
                                        *armregs[RD]=GETADDR(RN)^templ;
                                }
                                cycles--;
                                break;
                                case 0x03: /*EORS reg*/
                                if (RD==15)
                                {
                                        templ=shift2(opcode);
                                        *armregs[15]=(GETADDR(RN)^templ)+4;
                                }
                                else
                                {
                                        templ=shift(opcode);
                                        *armregs[RD]=GETADDR(RN)^templ;
                                        setzn(*armregs[RD]);
                                }
                                cycles--;
                                break;

                                case 0x04: /*SUB reg*/
                                if (RD==15)
                                {
                                        templ=shift2(opcode);
                                        printf("R15=%08X-%08X+4=",GETADDR(RN),templ);
                                        *armregs[15]=(((GETADDR(RN)-templ)+4)&0x3FFFFFC)|(*armregs[15]&0xFC000003);
                                        printf("%08X\n",*armregs[15]);
                                }
                                else
                                {
                                        templ=shift(opcode);
                                        *armregs[RD]=GETADDR(RN)-templ;
                                }
                                cycles--;
                                break;
                                case 0x05: /*SUBS reg*/
                                if (RD==15)
                                {
                                        templ=shift2(opcode);
                                        *armregs[15]=(GETADDR(RN)-templ)+4;
                                }
                                else
                                {
                                        templ=shift(opcode);
                                        setsub(GETADDR(RN),templ);
                                        *armregs[RD]=GETADDR(RN)-templ;
                                }
                                cycles--;
                                break;

                                case 0x06: /*RSB reg*/
                                if (RD==15)
                                {
                                        templ=shift(opcode);
                                        *armregs[15]=(((templ-GETADDR(RN))+4)&0x3FFFFFC)|(*armregs[15]&0xFC000003);
                                }
                                else
                                {
                                        templ=shift(opcode);
                                        *armregs[RD]=templ-GETADDR(RN);
                                }
                                cycles--;
                                break;
                                case 0x07: /*RSBS reg*/
                                if (RD==15)
                                {
                                        templ=shift2(opcode);
                                        *armregs[15]=(templ-GETADDR(RN))+4;
                                }
                                else
                                {
                                        templ=shift(opcode);
                                        setsub(templ,GETADDR(RN));
                                        *armregs[RD]=templ-GETADDR(RN);
                                }
                                cycles--;
                                break;

                                case 0x08: /*ADD reg*/
                                if (RD==15)
                                {
                                        templ=shift2(opcode);
//                                        printf("R15=%08X+%08X+4=",GETADDR(RN),templ);
                                        *armregs[15]=((GETADDR(RN)+templ+4)&0x3FFFFFC)|(*armregs[15]&0xFC000003);
//                                        printf("%08X\n",*armregs[15]);
                                }
                                else
                                {
                                        templ=shift(opcode);
                                        *armregs[RD]=GETADDR(RN)+templ;
                                }
                                cycles--;
                                break;
                                case 0x09: /*ADDS reg*/
                                if (RD==15)
                                {
                                        templ=shift2(opcode);
//                                        printf("R15=%08X+%08X+4=",GETADDR(RN),templ);
                                        *armregs[15]=GETADDR(RN)+templ+4;
//                                        printf("%08X\n",*armregs[15]);
                                }
                                else
                                {
                                        templ=shift(opcode);
                                        setadd(GETADDR(RN),templ);
//                                        printf("ADDS %08X+%08X = ",GETADDR(RN),templ);
                                        *armregs[RD]=GETADDR(RN)+templ;
//                                        printf("%08X\n",*armregs[RD]);
//                                        setzn(templ);
                                }
                                cycles--;
                                break;
                                
                                case 0x0A: /*ADC reg*/
                                if (RD==15)
                                {
                                        templ2=CFSET;
                                        templ=shift2(opcode);
                                        *armregs[15]=((GETADDR(RN)+templ+templ2+4)&0x3FFFFFC)|(*armregs[15]&0xFC000003);
                                }
                                else
                                {
                                        templ2=CFSET;
                                        templ=shift(opcode);
                                        *armregs[RD]=GETADDR(RN)+templ+templ2;
                                }
                                cycles--;
                                break;
                                case 0x0B: /*ADCS reg*/
                                if (RD==15)
                                {
                                        templ2=CFSET;
                                        templ=shift2(opcode);
                                        *armregs[15]=GETADDR(RN)+templ+templ2+4;
                                }
                                else
                                {
                                        templ2=CFSET;
                                        templ=shift(opcode);
                                        setadd(GETADDR(RN),templ);
                                        *armregs[RD]=GETADDR(RN)+templ+templ2;
                                }
                                cycles--;
                                break;

                                case 0x0C: /*SBC reg*/
                                templ2=CFSET;
                                if (RD==15)
                                {
                                        templ=shift2(opcode);
                                        *armregs[15]=(((GETADDR(RN)-(templ+templ2))+4)&0x3FFFFFC)|(*armregs[15]&0xFC000003);
                                }
                                else
                                {
                                        templ=shift(opcode);
                                        *armregs[RD]=GETADDR(RN)-(templ+templ2);
                                }
                                cycles--;
                                break;
                                case 0x0D: /*SBCS reg*/
                                templ2=CFSET;
                                if (RD==15)
                                {
                                        templ=shift2(opcode);
                                        *armregs[15]=(GETADDR(RN)-(templ+templ2))+4;
                                }
                                else
                                {
                                        templ=shift(opcode);
                                        setsub(GETADDR(RN),templ);
                                        *armregs[RD]=GETADDR(RN)-(templ+templ2);
                                }
                                cycles--;
                                break;

                                case 0x0E: /*RSC reg*/
                                templ2=CFSET;
                                if (RD==15)
                                {
                                        templ=shift2(opcode);
                                        *armregs[15]=((((templ+templ2)-GETADDR(RN))+4)&0x3FFFFFC)|(*armregs[15]&0xFC000003);
                                }
                                else
                                {
                                        templ=shift(opcode);
                                        *armregs[RD]=(templ+templ2)-GETADDR(RN);
                                }
                                cycles--;
                                break;

                                case 0x11: /*TST reg*/
                                if (RD==15)
                                {
                                        opcode&=~0x100000;
                                        templ=*armregs[15]&0x3FFFFFC;
                                        *armregs[15]=((GETADDR(RN)&shift2(opcode))&0xFC000003)|templ;
                                }
                                else
                                {
                                        setzn(GETADDR(RN)&shift(opcode));
                                }
                                cycles--;
                                break;

                                case 0x13: /*TEQ reg*/
                                if (RD==15)
                                {
                                        opcode&=~0x100000;
                                        templ=*armregs[15]&0x3FFFFFC;
                                        *armregs[15]=((GETADDR(RN)^shift(opcode))&0xFC000003)|templ;
//                                        printf("R15 now %08X %08X\n",*armregs[15],*armregs[15]&0xFC000003);
                                }
                                else
                                {
                                        setzn(GETADDR(RN)^shift(opcode));
                                }
                                cycles--;
                                break;

                                case 0x15: /*CMP reg*/
                                if (RD==15)
                                {
                                        opcode&=~0x100000;
                                        *armregs[15]&=0x3FFFFFC;
                                        *armregs[15]|=((GETADDR(RN)-shift(opcode))&0xFC000003);
//                                        printf("R15 now %08X %08X\n",*armregs[15],*armregs[15]&0xFC000003);
                                }
                                else
                                   setsub(GETADDR(RN),shift(opcode));
                                cycles--;
                                break;

                                case 0x17: /*CMN reg*/
                                if (RD==15)
                                {
                                        opcode&=~0x100000;
                                        *armregs[15]&=0x3FFFFFC;
                                        *armregs[15]|=((GETADDR(RN)+shift2(opcode))&0xFC000003);
                                        printf("R15 now %08X %08X\n",*armregs[15],*armregs[15]&0xFC000003);
                                }
                                else
                                   setadd(GETADDR(RN),shift2(opcode));
                                cycles--;
                                break;

                                case 0x18: /*ORR reg*/
                                if (RD==15)
                                {
                                        templ=shift(opcode);
                                        *armregs[15]=(((GETADDR(RN)|templ)+4)&0x3FFFFFC)|(*armregs[15]&0xFC000003);
                                }
                                else
                                {
                                        templ=shift(opcode);
                                        *armregs[RD]=GETADDR(RN)|templ;
                                }
                                cycles--;
                                break;
                                case 0x19: /*ORRS reg*/
                                if (RD==15)
                                {
                                        templ=shift(opcode);
                                        *armregs[15]=(GETADDR(RN)|templ)+4;
                                }
                                else
                                {
                                        templ=shift(opcode);
                                        *armregs[RD]=GETADDR(RN)|templ;
                                        setzn(*armregs[RD]);
                                }
                                cycles--;
                                break;

                                case 0x1A: /*MOV reg*/
                                if (RD==15)
                                   *armregs[15]=(*armregs[15]&0xFC000003)|((shift(opcode)+4)&0x3FFFFFC);
                                else
                                   *armregs[RD]=shift(opcode);
                                cycles--;
                                break;
                                case 0x1B: /*MOVS reg*/
                                if (RD==15)
                                   *armregs[15]=shift(opcode)+4;
                                else
                                {
                                        *armregs[RD]=shift(opcode);
                                        setzn(*armregs[RD]);
                                }
                                cycles--;
                                break;

                                case 0x1C: /*BIC reg*/
                                if (RD==15)
                                {
                                        templ=shift(opcode);
                                        *armregs[15]=(((GETADDR(RN)&~templ)+4)&0x3FFFFFC)|(*armregs[15]&0xFC000003);
                                }
                                else
                                {
                                        templ=shift(opcode);
                                        *armregs[RD]=GETADDR(RN)&~templ;
                                }
                                cycles--;
                                break;
                                case 0x1D: /*BICS reg*/
                                if (RD==15)
                                {
                                        templ=shift(opcode);
                                        *armregs[15]=(GETADDR(RN)&~templ)+4;
                                }
                                else
                                {
                                        templ=shift(opcode);
                                        *armregs[RD]=GETADDR(RN)&~templ;
                                        setzn(*armregs[RD]);
                                }
                                cycles--;
                                break;

                                case 0x1E: /*MVN reg*/
                                if (RD==15)
                                   *armregs[15]=(*armregs[15]&0xFC000003)|(((~shift(opcode))+4)&0x3FFFFFC);
                                else
                                   *armregs[RD]=~shift(opcode);
                                cycles--;
                                break;
                                case 0x1F: /*MVNS reg*/
                                if (RD==15)
                                   *armregs[15]=(~shift(opcode))+4;
                                else
                                {
                                        *armregs[RD]=~shift(opcode);
                                        setzn(*armregs[RD]);
                                }
                                cycles--;
                                break;

                                case 0x20: /*AND imm*/
                                if (RD==15)
                                {
                                        templ=rotate(opcode);
                                        *armregs[15]=(((GETADDR(RN)&templ)+4)&0x3FFFFFC)|(*armregs[15]&0xFC000003);
                                }
                                else
                                {
                                        templ=rotate(opcode);
                                        *armregs[RD]=GETADDR(RN)&templ;
                                }
                                cycles--;
                                break;
                                case 0x21: /*ANDS imm*/
                                if (RD==15)
                                {
                                        templ=rotate(opcode);
                                        *armregs[15]=(GETADDR(RN)&templ)+4;
                                }
                                else
                                {
                                        templ=rotate(opcode);
                                        *armregs[RD]=GETADDR(RN)&templ;
                                        setzn(*armregs[RD]);
                                }
                                cycles--;
                                break;

                                case 0x22: /*EOR imm*/
                                if (RD==15)
                                {
                                        templ=rotate(opcode);
                                        *armregs[15]=(((GETADDR(RN)^templ)+4)&0x3FFFFFC)|(*armregs[15]&0xFC000003);
                                }
                                else
                                {
                                        templ=rotate(opcode);
                                        *armregs[RD]=GETADDR(RN)^templ;
                                }
                                cycles--;
                                break;
                                case 0x23: /*EORS imm*/
                                if (RD==15)
                                {
                                        templ=rotate(opcode);
                                        *armregs[15]=(GETADDR(RN)^templ)+4;
                                }
                                else
                                {
                                        templ=rotate(opcode);
                                        *armregs[RD]=GETADDR(RN)^templ;
                                        setzn(*armregs[RD]);
                                }
                                cycles--;
                                break;

                                case 0x24: /*SUB imm*/
                                if (RD==15)
                                {
                                        templ=rotate(opcode);
                                        *armregs[15]=(((GETADDR(RN)-templ)+4)&0x3FFFFFC)|(*armregs[15]&0xFC000003);
                                }
                                else
                                {
                                        templ=rotate(opcode);
                                        *armregs[RD]=GETADDR(RN)-templ;
                                }
                                cycles--;
                                break;
                                case 0x25: /*SUBS imm*/
                                if (RD==15)
                                {
                                        templ=rotate(opcode);
                                        *armregs[15]=(GETADDR(RN)-templ)+4;
                                }
                                else
                                {
                                        templ=rotate(opcode);
                                        setsub(GETADDR(RN),templ);
                                        *armregs[RD]=GETADDR(RN)-templ;
                                }
                                cycles--;
                                break;
                                
                                case 0x26: /*RSB imm*/
                                if (RD==15)
                                {
                                        templ=rotate(opcode);
                                        *armregs[15]=(((templ-GETADDR(RN))+4)&0x3FFFFFC)|(*armregs[15]&0xFC000003);
                                }
                                else
                                {
                                        templ=rotate(opcode);
                                        *armregs[RD]=templ-GETADDR(RN);
                                }
                                cycles--;
                                break;
                                case 0x27: /*RSBS imm*/
                                if (RD==15)
                                {
                                        templ=rotate(opcode);
                                        *armregs[15]=(templ-GETADDR(RN))+4;
                                }
                                else
                                {
                                        templ=rotate(opcode);
                                        setsub(templ,GETADDR(RN));
                                        *armregs[RD]=templ-GETADDR(RN);
                                }
                                cycles--;
                                break;

                                case 0x28: /*ADD imm*/
                                if (RD==15)
                                {
                                        templ=rotate(opcode);
                                        *armregs[15]=(((GETADDR(RN)+templ)+4)&0x3FFFFFC)|(*armregs[15]&0xFC000003);
                                }
                                else
                                {
                                        templ=rotate(opcode);
                                        *armregs[RD]=GETADDR(RN)+templ;
//                                        printf("RD=%08X\n",*armregs[RD]);
                                }
                                cycles--;
                                break;
                                case 0x29: /*ADDS imm*/
                                if (RD==15)
                                {
                                        templ=rotate(opcode);
                                        *armregs[15]=GETADDR(RN)+templ+4;
                                }
                                else
                                {
                                        templ=rotate(opcode);
                                        setadd(GETADDR(RN),templ);
                                        *armregs[RD]=GETADDR(RN)+templ;
                                }
                                cycles--;
                                break;

                                case 0x2A: /*ADC imm*/
                                if (RD==15)
                                {
                                        templ2=CFSET;
                                        templ=rotate(opcode);
                                        *armregs[15]=((GETADDR(RN)+templ+templ2+4)&0x3FFFFFC)|(*armregs[15]&0xFC000003);
                                }
                                else
                                {
                                        templ2=CFSET;
                                        templ=rotate(opcode);
                                        *armregs[RD]=GETADDR(RN)+templ+templ2;
                                }
                                cycles--;
                                break;
                                case 0x2B: /*ADCS imm*/
                                if (RD==15)
                                {
                                        templ2=CFSET;
                                        templ=rotate(opcode);
                                        *armregs[15]=GETADDR(RN)+templ+templ2+4;
                                }
                                else
                                {
                                        templ2=CFSET;
                                        templ=rotate(opcode);
                                        setadd(GETADDR(RN),templ);
                                        *armregs[RD]=GETADDR(RN)+templ+templ2;
                                }
                                cycles--;
                                break;

                                case 0x2C: /*SBC imm*/
                                templ2=CFSET;
                                if (RD==15)
                                {
                                        templ=rotate(opcode);
                                        *armregs[15]=(((GETADDR(RN)-(templ+templ2))+4)&0x3FFFFFC)|(*armregs[15]&0xFC000003);
                                }
                                else
                                {
                                        templ=rotate(opcode);
                                        *armregs[RD]=GETADDR(RN)-(templ+templ2);
                                }
                                cycles--;
                                break;
                                case 0x2D: /*SBCS imm*/
                                templ2=CFSET;
                                if (RD==15)
                                {
                                        templ=rotate(opcode);
                                        *armregs[15]=(GETADDR(RN)-(templ+templ2))+4;
                                }
                                else
                                {
                                        templ=rotate(opcode);
                                        setsub(GETADDR(RN),templ);
                                        *armregs[RD]=GETADDR(RN)-(templ+templ2);
                                }
                                cycles--;
                                break;

                                case 0x31: /*TST imm*/
                                if (RD==15)
                                {
                                        opcode&=~0x100000;
                                        templ=*armregs[15]&0x3FFFFFC;
                                        *armregs[15]=((GETADDR(RN)&rotate(opcode))&0xFC000003)|templ;
                                        printf("R15 now %08X %08X\n",*armregs[15],*armregs[15]&0xFC000003);
                                }
                                else
                                {
                                        setzn(GETADDR(RN)&rotate(opcode));
                                }
                                cycles--;
                                break;
                                
                                case 0x33: /*TEQ imm*/
                                if (RD==15)
                                {
                                        opcode&=~0x100000;
                                        templ=*armregs[15]&0x3FFFFFC;
                                        *armregs[15]=((GETADDR(RN)^rotate(opcode))&0xFC000003)|templ;
//                                        printf("R15 now %08X %08X\n",*armregs[15],*armregs[15]&0xFC000003);
                                }
                                else
                                {
                                        setzn(GETADDR(RN)^rotate(opcode));
                                }
                                cycles--;
                                break;

                                case 0x35: /*CMP imm*/
                                if (RD==15)
                                {
                                        opcode&=~0x100000;
                                        *armregs[15]&=0x3FFFFFC;
                                        *armregs[15]|=((GETADDR(RN)-rotate(opcode))&0xFC000003);
                                }
                                else
                                   setsub(GETADDR(RN),rotate(opcode));
                                cycles--;
                                break;

                                case 0x37: /*CMN imm*/
                                if (RD==15)
                                {
                                        opcode&=~0x100000;
                                        *armregs[15]&=0x3FFFFFC;
                                        *armregs[15]|=((GETADDR(RN)+rotate(opcode))&0xFC000003);
                                        printf("R15 now %08X %08X\n",*armregs[15],*armregs[15]&0xFC000003);
                                }
                                else
                                   setadd(GETADDR(RN),rotate(opcode));
                                cycles--;
                                break;
                                
                                case 0x38: /*ORR imm*/
                                if (RD==15)
                                {
                                        templ=rotate(opcode);
                                        *armregs[15]=(((GETADDR(RN)|templ)+4)&0x3FFFFFC)|(*armregs[15]&0xFC000003);
                                }
                                else
                                {
                                        templ=rotate(opcode);
                                        *armregs[RD]=GETADDR(RN)|templ;
                                }
                                cycles--;
                                break;
                                case 0x39: /*ORRS imm*/
                                if (RD==15)
                                {
                                        templ=rotate(opcode);
                                        *armregs[15]=(GETADDR(RN)|templ)+4;
                                }
                                else
                                {
                                        templ=rotate(opcode);
                                        *armregs[RD]=GETADDR(RN)|templ;
                                        setzn(*armregs[RD]);
                                }
                                cycles--;
                                break;

                                case 0x3A: /*MOV imm*/
                                if (RD==15)
                                   *armregs[15]=(*armregs[15]&0xFC000003)|(rotate(opcode)&0x3FFFFFC);
                                else
                                   *armregs[RD]=rotate(opcode);
                                cycles--;
                                break;
                                case 0x3B: /*MOVS imm*/
                                if (RD==15)
                                   *armregs[15]=rotate(opcode)+4;
                                else
                                {
                                        *armregs[RD]=rotate(opcode);
                                        setzn(*armregs[RD]);
                                }
                                cycles--;
                                break;

                                case 0x3C: /*BIC imm*/
                                if (RD==15)
                                {
                                        templ=rotate(opcode);
                                        *armregs[15]=(((GETADDR(RN)&~templ)+4)&0x3FFFFFC)|(*armregs[15]&0xFC000003);
                                }
                                else
                                {
                                        templ=rotate(opcode);
                                        *armregs[RD]=GETADDR(RN)&~templ;
                                }
                                cycles--;
                                break;
                                case 0x3D: /*BICS imm*/
                                if (RD==15)
                                {
                                        templ=rotate(opcode);
                                        *armregs[15]=(GETADDR(RN)&~templ)+4;
                                }
                                else
                                {
                                        templ=rotate(opcode);
                                        *armregs[RD]=GETADDR(RN)&~templ;
                                        setzn(*armregs[RD]);
                                }
                                cycles--;
                                break;

                                case 0x3E: /*MVN imm*/
                                if (RD==15)
                                   *armregs[15]=(*armregs[15]&0xFC000003)|(((~rotate(opcode))+4)&0x3FFFFFC);
                                else
                                   *armregs[RD]=~rotate(opcode);
                                cycles--;
                                break;
                                case 0x3F: /*MVNS imm*/
                                if (RD==15)
                                   *armregs[15]=(~rotate(opcode))+4;
                                else
                                {
                                        *armregs[RD]=~rotate(opcode);
                                        setzn(*armregs[RD]);
                                }
                                cycles--;
                                break;

                                case 0x4A: /*STRT*/
                                addr=GETADDR(RN);
                                if (opcode&0x2000000) addr2=shift2(opcode);
                                else                  addr2=opcode&0xFFF;
                                if (opcode&0x1000000)
                                {
                                        if (opcode&0x800000) addr+=addr2;
                                        else                 addr-=addr2;
                                }
                                templ=memmode;
                                memmode=0;
                                writememl(addr,*armregs[RD]);
                                memmode=templ;
                                if (databort) break;
                                if (!(opcode&0x1000000))
                                {
                                        if (opcode&0x800000) addr+=addr2;
                                        else                 addr-=addr2;
                                        *armregs[RN]=addr;
                                }
                                else
                                {
                                        if (opcode&0x200000) *armregs[RN]=addr;
                                }
                                cycles-=2;
                                break;

                                case 0x4B: /*LDRT*/
                                addr=GETADDR(RN);
                                if (opcode&0x2000000) addr2=shift2(opcode);
                                else                  addr2=opcode&0xFFF;
                                if (opcode&0x1000000)
                                {
                                        if (opcode&0x800000) addr+=addr2;
                                        else                 addr-=addr2;
                                }
                                templ=memmode;
                                memmode=0;
                                templ2=readmeml(addr);
                                memmode=templ;
                                if (databort) break;
                                LOADREG(RD,templ2);
                                if (!(opcode&0x1000000))
                                {
                                        if (opcode&0x800000) addr+=addr2;
                                        else                 addr-=addr2;
                                        *armregs[RN]=addr;
                                }
                                else
                                {
                                        if (opcode&0x200000) *armregs[RN]=addr;
                                }
                                cycles-=2;
                                break;

                                case 0x40: case 0x48: case 0x50: case 0x52: /*STR*/
                                case 0x58: case 0x5A: case 0x60: case 0x68:
                                case 0x70: case 0x72: case 0x78: case 0x7A:
                                addr=GETADDR(RN);
                                if (opcode&0x2000000) addr2=shift2(opcode);
                                else                  addr2=opcode&0xFFF;
                                if (opcode&0x1000000)
                                {
                                        if (opcode&0x800000) addr+=addr2;
                                        else                 addr-=addr2;
                                }
                                writememl(addr,*armregs[RD]);
                                if (databort) break;
//                                printf("R%i to %07X = %08X\n",RD,addr,*armregs[RD]);
                                if (!(opcode&0x1000000))
                                {
                                        if (opcode&0x800000) addr+=addr2;
                                        else                 addr-=addr2;
                                        *armregs[RN]=addr;
                                }
                                else
                                {
                                        if (opcode&0x200000) *armregs[RN]=addr;
                                }
//                                printf("R%i = %08X\n",RN,*armregs[RN]);
                                cycles-=2;
                                break;

                                case 0x41: case 0x49: case 0x51: case 0x53: /*LDR*/
                                case 0x59: case 0x5B: case 0x69: case 0x71:
                                case 0x79: case 0x7B:
                                addr=GETADDR(RN);
                                if (opcode&0x2000000) addr2=shift2(opcode);
                                else                  addr2=opcode&0xFFF;
                                if (opcode&0x1000000)
                                {
                                        if (opcode&0x800000) addr+=addr2;
                                        else                 addr-=addr2;
                                }
                                templ=readmeml(addr);
                                templ=ldrresult(templ,addr);
                                if (databort) break;
//                                printf("R%i from %07X = %08X\n",RD,addr,*armregs[RD]);
                                if (!(opcode&0x1000000))
                                {
                                        if (opcode&0x800000) addr+=addr2;
                                        else                 addr-=addr2;
                                        *armregs[RN]=addr;
                                }
                                else
                                {
                                        if (opcode&0x200000) *armregs[RN]=addr;
                                }
                                LOADREG(RD,templ);
//                                printf("R%i = %08X\n",RN,*armregs[RN]);
                                cycles-=2;
                                break;

                                case 0x45: case 0x4D: case 0x55: case 0x57: /*LDRB*/
                                case 0x5D: case 0x5F: case 0x6D: case 0x75:
                                case 0x7D: case 0x7F:
                                addr=GETADDR(RN);
                                if (opcode&0x2000000) addr2=shift2(opcode);
                                else                  addr2=opcode&0xFFF;
                                if (opcode&0x1000000)
                                {
                                        if (opcode&0x800000) addr+=addr2;
                                        else                 addr-=addr2;
                                }
                                templ=readmemb(addr);
                                if (databort) break;
//                                printf("R%i from %07X = %02X\n",RD,addr,*armregs[RD]);
                                if (!(opcode&0x1000000))
                                {
                                        if (opcode&0x800000) addr+=addr2;
                                        else                 addr-=addr2;
                                        *armregs[RN]=addr;
                                }
                                else
                                {
                                        if (opcode&0x200000) *armregs[RN]=addr;
                                }
                                *armregs[RD]=templ;
//                                printf("R%i = %08X\n",RN,*armregs[RN]);
                                cycles-=2;
                                break;

                                case 0x44: case 0x4C: case 0x54: case 0x56: /*STRB*/
                                case 0x5C: case 0x5E: case 0x6C: case 0x7C:
                                case 0x7E:
                                addr=GETADDR(RN);
                                if (opcode&0x2000000) addr2=shift2(opcode);
                                else                  addr2=opcode&0xFFF;
                                if (opcode&0x1000000)
                                {
                                        if (opcode&0x800000) addr+=addr2;
                                        else                 addr-=addr2;
                                }
                                writememb(addr,*armregs[RD]);
                                if (databort) break;
//                                printf("R%i to %07X = %02X\n",RD,addr,*armregs[RD]);
                                if (!(opcode&0x1000000))
                                {
                                        if (opcode&0x800000) addr+=addr2;
                                        else                 addr-=addr2;
                                        *armregs[RN]=addr;
                                }
                                else
                                {
                                        if (opcode&0x200000) *armregs[RN]=addr;
                                }
//                                printf("R%i = %08X  PC %07X\n",RN,*armregs[RN],PC);
//                                exit(0);
                                cycles-=2;
                                break;

                                case 0x80: /*STMDA*/
                                mask=0x8000;
                                addr=*armregs[RN];
                                for (c=15;c>-1;c--)
                                {
                                        if (opcode&mask)
                                        {
                                                if (c==15) { writememl(addr,*armregs[c]+4); }
                                                else       { writememl(addr,*armregs[c]); }
                                                addr-=4;
                                                cycles--;
                                        }
                                        mask>>=1;
                                }
                                cycles--;
                                break;

                                case 0x81: /*LDMDA*/
                                mask=0x8000;
                                addr=*armregs[RN];
                                for (c=15;c>-1;c--)
                                {
                                        if (opcode&mask)
                                        {
                                                if (c==15) *armregs[15]=(*armregs[15]&0xFC000003)|((readmeml(addr)+4)&0x3FFFFFC);
                                                else       *armregs[c]=readmeml(addr);
                                                addr-=4;
                                                cycles--;
                                        }
                                        mask>>=1;
                                }
                                cycles--;
                                break;

                                case 0x82: /*STMDA !*/
                                mask=0x8000;
                                addr=*armregs[RN];
                                for (c=15;c>-1;c--)
                                {
                                        if (opcode&mask)
                                        {
                                                if (c==15) { writememl(addr,*armregs[c]+4); }
                                                else       { writememl(addr,*armregs[c]); }
                                                addr-=4;
                                                *armregs[RN]-=4;
                                                cycles--;
                                        }
                                        mask>>=1;
                                }
                                cycles--;
                                break;
                                
                                case 0x83: /*LDMDA !*/
                                mask=0x8000;
                                addr=*armregs[RN];
                                for (c=15;c>-1;c--)
                                {
                                        if (opcode&mask)
                                        {
                                                if (c==15) *armregs[15]=(*armregs[15]&0xFC000003)|((readmeml(addr)+4)&0x3FFFFFC);
                                                else       *armregs[c]=readmeml(addr);
                                                addr-=4;
                                                *armregs[RN]-=4;
                                                cycles--;
                                        }
                                        mask>>=1;
                                }
                                cycles--;
                                break;

                                case 0x88: /*STMIA*/
                                mask=1;
                                addr=*armregs[RN];
                                for (c=0;c<16;c++)
                                {
                                        if (opcode&mask)
                                        {
                                                if (c==15) { writememl(addr,*armregs[c]+4); }
                                                else       { writememl(addr,*armregs[c]); }
                                                addr+=4;
                                                cycles--;
                                        }
                                        mask<<=1;
                                }
                                cycles--;
                                break;

                                case 0x89: /*LDMIA*/
                                mask=1;
                                addr=*armregs[RN];
                                for (c=0;c<16;c++)
                                {
                                        if (opcode&mask)
                                        {
                                                if (c==15) *armregs[15]=(*armregs[15]&0xFC000003)|((readmeml(addr)+4)&0x3FFFFFC);
                                                else       *armregs[c]=readmeml(addr);
                                                addr+=4;
                                                cycles--;
                                        }
                                        mask<<=1;
                                }
                                cycles--;
                                break;

                                case 0x8A: /*STMIA !*/
                                mask=1;
                                addr=*armregs[RN];
                                for (c=0;c<16;c++)
                                {
                                        if (opcode&mask)
                                        {
                                                if (c==15) { writememl(addr,*armregs[c]+4); }
                                                else       { writememl(addr,*armregs[c]); }
                                                addr+=4;
                                                *armregs[RN]+=4;
                                                cycles--;
                                        }
                                        mask<<=1;
                                }
                                cycles--;
                                break;

                                case 0x8B: /*LDMIA !*/
                                mask=1;
                                addr=*armregs[RN];
                                for (c=0;c<16;c++)
                                {
                                        if (opcode&mask)
                                        {
                                                if (c==15) *armregs[15]=(*armregs[15]&0xFC000003)|((readmeml(addr)+4)&0x3FFFFFC);
                                                else       *armregs[c]=readmeml(addr);
//                                                if (output) printf("R%i = %08X from %07X\n",c,*armregs[c],addr);
                                                addr+=4;
                                                *armregs[RN]+=4;
                                                cycles--;
                                        }
                                        mask<<=1;
                                }
                                cycles--;
                                break;
                                
                                case 0x8C: /*STMIA ^*/
                                mask=1;
                                addr=*armregs[RN];
                                for (c=0;c<16;c++)
                                {
                                        if (opcode&mask)
                                        {
                                                if (c==15) { writememl(addr,userregs[c]+4); }
                                                else       { writememl(addr,userregs[c]); }
                                                addr+=4;
                                                cycles--;
                                        }
                                        mask<<=1;
                                }
                                cycles--;
                                break;

                                case 0x8D: /*LDMIA ^*/
                                mask=1;
                                addr=*armregs[RN];
                                if (opcode&0x8000)
                                {
                                        for (c=0;c<16;c++)
                                        {
                                                if (opcode&mask)
                                                {
                                                        *armregs[c]=readmeml(addr);
                                                        addr+=4;
                                                        cycles--;
                                                }
                                                mask<<=1;
                                        }
                                        *armregs[15]+=4;
                                }
                                else
                                {
                                        for (c=0;c<16;c++)
                                        {
                                                if (opcode&mask)
                                                {
                                                        userregs[c]=readmeml(addr);
                                                        addr+=4;
                                                        cycles--;
                                                }
                                                mask<<=1;
                                        }
                                }
                                cycles--;
                                break;

                                case 0x8F: /*LDMIA !^*/
                                mask=1;
                                addr=*armregs[RN];
//                                userregs[RN]=addr;
                                if (opcode&0x8000)
                                {
                                        for (c=0;c<16;c++)
                                        {
                                                if (opcode&mask)
                                                {
                                                        *armregs[c]=readmeml(addr);
//                                                        printf("R%i=%08X from %07X\n",c,*armregs[c],addr);
                                                        addr+=4;
                                                        *armregs[RN]+=4;
                                                        cycles--;
                                                }
                                                mask<<=1;
                                        }
                                        *armregs[15]+=4;
                                }
                                else
                                {
                                        for (c=0;c<16;c++)
                                        {
                                                if (opcode&mask)
                                                {
                                                        userregs[c]=readmeml(addr);
                                                        addr+=4;
                                                        *armregs[RN]+=4;
                                                        cycles--;
                                                }
                                                mask<<=1;
                                        }
                                }
                                cycles--;
                                break;

                                case 0x90: /*STMDB*/
                                mask=0x8000;
                                addr=*armregs[RN];
                                for (c=15;c>-1;c--)
                                {
                                        if (opcode&mask)
                                        {
                                                addr-=4;
                                                if (c==15) { writememl(addr,*armregs[c]+4); }
                                                else       { writememl(addr,*armregs[c]); }
                                                cycles--;
                                        }
                                        mask>>=1;
                                }
                                cycles--;
                                break;

                                case 0x91: /*LDMDB*/
                                mask=0x8000;
                                addr=*armregs[RN];
                                for (c=15;c>-1;c--)
                                {
                                        if (opcode&mask)
                                        {
                                                addr-=4;
                                                if (c==15) *armregs[15]=(*armregs[15]&0xFC000003)|((readmeml(addr)+4)&0x3FFFFFC);
                                                else       *armregs[c]=readmeml(addr);
                                                cycles--;
                                        }
                                        mask>>=1;
                                }
                                cycles--;
                                break;
                                
                                case 0x92: /*STMDB !*/
                                mask=0x8000;
                                addr=*armregs[RN];
                                for (c=15;c>-1;c--)
                                {
                                        if (opcode&mask)
                                        {
                                                addr-=4;
                                                *armregs[RN]-=4;
//                                                if (addr==0x1C01BFC) printf("1C01BFC R%i\n",c);
                                                if (c==15) { writememl(addr,*armregs[c]+4); }
                                                else       { writememl(addr,*armregs[c]); }
//                                                if (output) printf("R%i = %08X  to  %07X\n",c,*armregs[c],addr);
                                                cycles--;
                                        }
                                        mask>>=1;
                                }
                                cycles--;
                                break;

                                case 0x93: /*LDMDB !*/
                                mask=0x8000;
                                addr=*armregs[RN];
                                for (c=15;c>-1;c--)
                                {
                                        if (opcode&mask)
                                        {
                                                addr-=4;
                                                *armregs[RN]-=4;
                                                if (c==15) *armregs[15]=(*armregs[15]&0xFC000003)|((readmeml(addr)+4)&0x3FFFFFC);
                                                else       *armregs[c]=readmeml(addr);
                                                cycles--;
                                        }
                                        mask>>=1;
                                }
                                cycles--;
                                break;

                                case 0x94: /*STMDB ^*/
                                mask=0x8000;
                                addr=*armregs[RN];
                                for (c=15;c>-1;c--)
                                {
                                        if (opcode&mask)
                                        {
                                                addr-=4;
                                                if (c==15) { writememl(addr,userregs[c]+4); }
                                                else       { writememl(addr,userregs[c]); }
                                                cycles--;
                                        }
                                        mask>>=1;
                                }
                                cycles--;
                                break;

                                case 0x95: /*LDMDB ^*/
                                mask=0x8000;
                                addr=*armregs[RN];
                                if (opcode&0x8000)
                                {
                                        for (c=15;c>-1;c--)
                                        {
                                                if (opcode&mask)
                                                {
                                                        addr-=4;
                                                        *armregs[c]=readmeml(addr);
                                                        cycles--;
                                                }
                                                mask>>=1;
                                        }
                                        *armregs[15]+=4;
                                }
                                else
                                {
                                        for (c=15;c>-1;c--)
                                        {
                                                if (opcode&mask)
                                                {
                                                        addr-=4;
                                                        userregs[c]=readmeml(addr);
                                                        cycles--;
                                                }
                                                mask>>=1;
                                        }
                                }
                                cycles--;
                                break;

                                case 0x98: /*STMIB*/
                                mask=1;
                                addr=*armregs[RN];
                                for (c=0;c<16;c++)
                                {
                                        if (opcode&mask)
                                        {
                                                addr+=4;
                                                if (c==15) { writememl(addr,*armregs[c]+4); }
                                                else       { writememl(addr,*armregs[c]); }
                                                cycles--;
                                        }
                                        mask<<=1;
                                }
                                cycles--;
                                break;

                                case 0x99: /*LDMIB*/
                                mask=1;
                                addr=*armregs[RN];
                                for (c=0;c<16;c++)
                                {
                                        if (opcode&mask)
                                        {
                                                addr+=4;
                                                if (c==15) *armregs[15]=(*armregs[15]&0xFC000003)|((readmeml(addr)+4)&0x3FFFFFC);
                                                else       *armregs[c]=readmeml(addr);
                                                cycles--;
                                        }
                                        mask<<=1;
                                }
                                cycles--;
                                break;

                                case 0x9C: /*STMIB ^*/
                                mask=1;
                                addr=*armregs[RN];
                                for (c=0;c<16;c++)
                                {
                                        if (opcode&mask)
                                        {
                                                addr+=4;
                                                if (c==15) { writememl(addr,userregs[c]+4); }
                                                else       { writememl(addr,userregs[c]); }
                                                cycles--;
                                        }
                                        mask<<=1;
                                }
                                cycles--;
                                break;

                                case 0x9D: /*LDMIB ^*/
                                mask=1;
                                addr=*armregs[RN];
                                if (opcode&0x8000)
                                {
                                        for (c=0;c<16;c++)
                                        {
                                                if (opcode&mask)
                                                {
                                                        addr+=4;
                                                        *armregs[c]=readmeml(addr);
                                                        cycles--;
                                                }
                                                mask<<=1;
                                        }
                                        *armregs[15]+=4;
                                }
                                else
                                {
                                        for (c=0;c<16;c++)
                                        {
                                                if (opcode&mask)
                                                {
                                                        addr+=4;
                                                        userregs[c]=readmeml(addr);
                                                        cycles--;
                                                }
                                                mask<<=1;
                                        }
                                }
                                cycles--;
                                break;

                                case 0xB0: case 0xB1: case 0xB2: case 0xB3: /*BL*/
                                case 0xB4: case 0xB5: case 0xB6: case 0xB7:
                                case 0xB8: case 0xB9: case 0xBA: case 0xBB:
                                case 0xBC: case 0xBD: case 0xBE: case 0xBF:
                                templ=(opcode&0xFFFFFF)<<2;
                                *armregs[14]=*armregs[15]-4;
                                *armregs[15]=((*armregs[15]+templ+4)&0x3FFFFFC)|(*armregs[15]&0xFC000003);
                                cycles-=3;
                                break;
                                
                                case 0xA0: case 0xA1: case 0xA2: case 0xA3: /*B*/
                                case 0xA4: case 0xA5: case 0xA6: case 0xA7:
                                case 0xA8: case 0xA9: case 0xAA: case 0xAB:
                                case 0xAC: case 0xAD: case 0xAE: case 0xAF:
                                templ=(opcode&0xFFFFFF)<<2;
                                *armregs[15]=((*armregs[15]+templ+4)&0x3FFFFFC)|(*armregs[15]&0xFC000003);
                                cycles-=3;
                                break;
                                
                                case 0xCB: case 0xD1: case 0xD2: case 0xD5: /*Co-pro*/
                                case 0xD6: case 0xD8: case 0xD9: case 0xDC: 
                                case 0xDD: case 0xE0: case 0xE1: case 0xE2:
                                case 0xE3: case 0xE4: case 0xE5: case 0xED:
//                                printf("Illegal Co-pro instruction ins %i\n",ins);
                                templ=*armregs[15]-4;
                                *armregs[15]|=3;
                                updatemode(SUPERVISOR);
                                *armregs[14]=templ;
                                *armregs[15]&=0xFC000003;
                                *armregs[15]|=0x08000008;
                                cycles--;
                                break;
                                
                                case 0xF0: /*SWI*/
                                //OSWORD 21
/*                                if ((opcode&0xFFFF)==7 && *armregs[0]==21)
                                {
                                        printf("OSWORD 21 %07X R1=%07X %02X%02X%02X%02X %i\n",PC,*armregs[1],readmemb(*armregs[1]+9),readmemb(*armregs[1]+8),readmemb(*armregs[1]+7),readmemb(*armregs[1]+6),ins);
                                        if (output) exit(0);
                                }*/
/*                                if ((opcode&0xFFFF)==6 && *armregs[0]==161)
                                {
//                                        *armregs[2]=0;
                                        *armregs[2]=cmosram[(*armregs[1]+64)&255];
//                                        printf("CMOS read %02X %02X\n",*armregs[1],*armregs[2]);
                                }
                                else if ((opcode&0xFFFF)==6 && *armregs[0]==162)
                                {
                                        cmosram[(*armregs[1]+64)&255]=*armregs[2];
                                }
                                else
                                {*/
                                        templ=*armregs[15]-4;
                                        *armregs[15]|=3;
                                        updatemode(SUPERVISOR);
                                        *armregs[14]=templ;
                                        *armregs[15]&=0xFC000003;
                                        *armregs[15]|=0x0800000C;
//                                }
                                cycles--;
                                break;

                                default:
                                printf("Bad opcode %02X %08X\n",(opcode>>20)&0xFF,opcode);
                                dumpregs();
                                exit(-1);
                        }
                }
                if (databort)
                {
                        templ=*armregs[15];
                        *armregs[15]|=3;
                        updatemode(SUPERVISOR);
                        *armregs[14]=templ;
                        *armregs[15]&=0xFC000003;
                        *armregs[15]|=0x08000014;
                        databort=0;
//                        printf("Data abort ins %i\n",ins);
//                        output=1;
                }
                else if (armfiq && !(*armregs[15]&0x4000000))
                {
                        templ=*armregs[15];
                        *armregs[15]|=3;
                        updatemode(FIQ);
                        *armregs[14]=templ;
                        *armregs[15]&=0xFC000001;
                        *armregs[15]|=0x0C000020;
//                        printf("FIQ %02X\n",ioc.fiq);
                }
                else if (armirq && !(*armregs[15]&0x8000000))
                {
                        templ=*armregs[15];
                        *armregs[15]|=3;
                        updatemode(IRQ);
                        *armregs[14]=templ;
                        *armregs[15]&=0xFC000002;
                        *armregs[15]|=0x0800001C;
                }
                ioc.timerc[0]--;
                ioc.timerc[1]--;
                if (!ioc.timerc[0] || !ioc.timerc[1]) updateioctimers();
                if (soundtime)
                {
                        soundtime--;
                        if (!soundtime)
                        {
                                ioc.irqb|=2;
                                updateirqs();
                        }
                }
                if (keydelay)
                {
                        keydelay--;
                        if (!keydelay) keycallback();
                }
                if (discint)
                {
                        discint--;
                        if (!discint) callback();
                }
                if ((*armregs[15]&3)!=mode) updatemode(*armregs[15]&3);
//                if (output && PC!=oldpc)
//                   printf("PC change %06X %06X %08X\n",PC,oldpc,opcode);
//                if (ins==1260000) output=1;
                *armregs[15]+=4;
//                if (PC==0x38DD2BC) output=1;//printf("hit 38DD2BC R1=%06X R6=%08X\n",*armregs[1],*armregs[6]);
//                if (PC==0x380A1E8) printf("380A1E8 %07X\n",*armregs[10]);
/*                if (PC==0x381F44C)
                {
                        printf("hit 381F44C R1=%06X R3=%08X R5=%08X R6=%08X\n",*armregs[1],*armregs[3],*armregs[5],*armregs[6]);
/*                        f=fopen("point.dmp","wb");
                        for (c=0x1C01C5C;c<0x1C01CB4;c++) putc(readmemb(c),f);
                        fclose(f);
                        dumpregs();
                        exit(-1);*/
/*                }
                if (PC==0x381F474)
                {
                        printf("381F474 ins %i\n",ins);
                        exit(0);
                }
                if (PC==0x381AB18) printf("hit %07X %08X\n",PC,*armregs[0]);*/
//                if (PC==0x38CC374) {if (cccount) output=1; printf("%i\n",cccount); cccount++; }//output=1;
                if (!PC)
                {
                        printf("Branch through zero\n");
                        dumpregs();
                        exit(-1);
                }
                if (output) printf("%07X : %08X %08X %08X %08X  %08X %08X  %08X %08X %08X\n",PC,*armregs[0],*armregs[1],*armregs[2],*armregs[3],*armregs[7],*armregs[8],*armregs[10],*armregs[11],*armregs[12]);
                if (output) output++;
                if (output==2500)
                {
                        dumpregs();
                        exit(-1);
                }
//                printf("%06X\n",PC);
                if (firstins) 
                {
                        memstat[0]=0;
                        firstins=0;
                }
                ins++;
//                if (ins==1261500) output=1;
        }
}
