/*ARM*/
unsigned long userregs[16],superregs[16],fiqregs[16],irqregs[16];
unsigned long *armregs[16];
int armirq,armfiq;
#define PC ((*armregs[15]&0x3FFFFFC)-8)
int ins,output;

void resetarm();
void execarm(int cycles);
void dumpregs();
int databort;

/*IOC*/
struct
{
        unsigned char irqa,irqb,fiq;
        unsigned char mska,mskb,mskf;
        unsigned char ctrl;
        unsigned short timerc[4],timerl[4],timerr[4];
} ioc;

/*Memory*/
int modepritabler[3][6],modepritablew[3][6];
unsigned long *mempoint[0x800];
unsigned char *mempointb[0x800];
int memstat[0x800];
unsigned long *ram,*rom;
int memmode;

#define readmemb(a)    ((modepritabler[memmode][memstat[((a)>>15)&0x7FF]])?mempointb[((a)>>15)&0x7FF][(a)&0x7FFF]:readmemfb(a))
#define readmeml(a)    ((modepritabler[memmode][memstat[((a)>>15)&0x7FF]])?mempoint[((a)>>15)&0x7FF][((a)&0x7FFF)>>2]:readmemfl(a))
#define writememb(a,v) /*if (a==0x9AA) printf("%08X write %02X at %07X  %i\n",a,v,PC,ins); */if (modepritablew[memmode][memstat[((a)>>15)&0x7FF]]) mempointb[((a)>>15)&0x7FF][(a)&0x7FFF]=v; else writememfb(a,v);
#define writememl(a,v) /*if (a==0x1080) printf("%08X write %08X at %07X\n",a,v,PC); if (a==0x1C01C5C && !v && PC==0x381BACC) output=1; */if (modepritablew[memmode][memstat[((a)>>15)&0x7FF]]) mempoint[((a)>>15)&0x7FF][((a)&0x7FFF)>>2]=v; else writememfl(a,v);

/*MEMC*/
unsigned long vinit,vstart,vend;
unsigned long cinit;
unsigned long sstart,send,sptr;

/*VIDC*/
unsigned long vidcr[64];
