#include <stdio.h>
#include "arc.h"

int readaddr=0;
unsigned char disc[2][80][5][1024]; /*Disc - E format (2 sides, 80 tracks, 5 sectors, 1024 bytes)*/
int output,output2;
int fdcside;
int commandpos=0;
int fiq;
int track=0,sector=0;
unsigned char fdctrack=0,fdcsector=0,fdcdata,fdcstatus=0;
int discint=0;
unsigned char fdccommand;

void loaddisc(char *fn)
{
        FILE *ff=fopen(fn,"rb");
        int c,d,e,f;
        for (d=0;d<80;d++)
        {
                for (c=0;c<2;c++)
                {
                        for (e=0;e<5;e++)
                        {
                                for (f=0;f<1024;f++)
                                {
                                        disc[c][d][e][f]=getc(ff);
                                }
                        }
                }
        }
        fclose(ff);
}

void callback()
{
        int c;
        FILE *f;
        unsigned long templ;
        switch (fdccommand>>4)
        {
                case 0x0: /*Restore*/
                track=fdctrack=0;
                iocfiq(2);
                discint=0;
                fdcstatus|=0xA4;
                fdcstatus&=~1;
                printf("Restore callback\n");
                break;

                case 0x1: /*Seek*/
                fdctrack=track=fdcdata;
                iocfiq(2);
                discint=0;
                fdcstatus|=0xA0;
                fdcstatus&=~1;
                if (!track) fdcstatus|=4;
                commandpos=0;
                printf("Seek callback %02X\n",fdccommand);
                break;

                case 0x5: /*Step in*/
                track++;
                if (track==80) track=79;
                fdctrack=track;
                iocfiq(2);
                discint=0;
                fdcstatus|=0xA0;
                fdcstatus&=~1;
                if (!track) fdcstatus|=4;
                commandpos=0;
                printf("Step callback %02X\n",fdccommand);
                break;

                case 0x8: /*Read sector*/
                if (!commandpos)
                {
                        track=fdctrack;
                        sector=fdcsector;
                        printf("Sector command end\n");
                }
                if (commandpos==1024)
                {
                        iocfiq(2);
                        fdcstatus|=0xA0;
                        fdcstatus&=~7;
                        fdcsector++;
                        if (fdcsector==5) fdcsector=0;
                }
                else
                {
                        fdcdata=disc[fdcside][track][sector][commandpos];
//                        printf("FDC data %03X %02X %i %i %i\n",commandpos,fdcdata,fdcside,fdctrack,fdcdata);
                        commandpos++;
                        iocfiq(1);
                        fdcstatus|=2;
                        discint=100;
                }
                break;

                case 0xC: /*Read address*/
                discint=5000;
                iocfiq(1);
                fdcstatus=0x81;
                switch (commandpos--)
                {
                        case 6: fdcdata=track; break;
                        case 5: fdcdata=(fdcside)?1:0; break;
                        case 4: fdcdata=sector; sector++; if (sector==5) sector=0; break;
                        case 3: fdcdata=3; break;
                        case 2: fdcdata=0xA5; break;
                        case 1: fdcdata=0x5A; break;
                        case 0:
                        discint=0;
                        iocfiqc(1);
                        iocfiq(2);
                        fdcstatus=0x80;
                        fdcsector=track;
                        readaddr++;
//                        if (readaddr==8)
//                           output2=1;
                }
                log("Read address %i %02X\n",commandpos,fdcdata);
                break;
        }
}

void write1770(unsigned addr, unsigned data)
{
//        printf("1770 write %08X %04X\n",addr,data);
        switch (addr&0xC)
        {
                case 0: /*Command reg*/
                printf("1772 command %02X\n",data);
//                log("1770 command %02X\n",data>>16);
                fdccommand=data;
                switch ((data>>4)&0xF)
                {
                        case 0x0: /*Restore*/
                        discint=10000;
                        fdcstatus=(fdcstatus|1)&~0x1A;
                        break;

                        case 0x1: /*Seek*/
                        discint=10000;
                        fdcstatus=(fdcstatus|1)&~0x1A;
                        break;

                        case 0x5: /*Step in*/
                        discint=5000;
                        fdcstatus=(fdcstatus|1)&~0x1A;
                        break;
//#if 0
                        case 0x8: /*Read sector*/
                        discint=2000;
                        commandpos=0;
                        fdcstatus=(fdcstatus|1)&~0x1A;
                        break;
//#endif
                        case 0xC: /*Read address*/
//                        output=1;
                        commandpos=6;
                        discint=10000;
                        fdcstatus=(fdcstatus|1)&~0x7E;
//                        log("read %i %i %i\n",track,fdcside,sector);
                        break;

                        case 0xD: /*Force interrupt*/
                        if (fdccommand&8) iocfiq(2);
                        else              iocfiqc(2);
                        discint=0;
                        break;

                        default:
                        allegro_exit();
                        printf("Bad command %01X\n",(data>>4)&0xF);
                        exit(-1);
                }
                break;
                case 4: /*Track reg*/
                fdctrack=data;
                break;
                case 8: /*Sector reg*/
                fdcsector=data;
                break;
                case 0xC: /*Data reg*/
                printf("FDC data write %02X\n",data>>16);
                fdcdata=data;
                break;
        }
//        log("1770 write addr %08X data %02X\n",addr,data);
}

unsigned char read1770(unsigned addr)
{
//        printf("1770 read %08X\n",addr);
        switch (addr&0xC)
        {
                case 0: /*Status reg*/
                iocfiqc(2);
                printf("Returning status %02X\n",fdcstatus);
                return fdcstatus;
                case 4: /*Track reg*/
                printf("Reading fdctrack\n");
                return fdctrack;
                case 8: /*Sector reg*/
                printf("Reading fdcsector\n");
                return fdcsector;
                case 0xC: /*Data reg*/
//                printf("Reading fdcdata\n");
                iocfiqc(1);
                return fdcdata;
        }
}
