int changedpal=1;
int ins_exec;
float mips;

void updatemips()
{
        mips=(float)ins_exec/1000000;
        ins_exec=0;
}

int bit4=1,bit1=1;
int warlocksmode;
int width=80;
unsigned long videobase;
int alternatescreen;
int running;
#define VIDEMU

#include <stdio.h>

#ifdef VIDEMU
#include <allegro.h>
#endif

#include "arc.h"

#ifdef VIDEMU
BITMAP *b;
PALETTE borderpal={{0,0,0}};

PALETTE pal=
{
        {0,0,0},
        {4,4,4},
        {8,8,8},
        {12,12,12},
        {16,0,0},
        {20,4,4},
        {24,8,8},
        {28,12,12},
        {0,0,16},
        {4,4,20},
        {8,8,24},
        {12,12,28},
        {16,0,16},
        {20,4,20},
        {24,8,24},
        {28,12,28}
};

PALETTE beebpal =
{
      {0,0,0},
      {63,0,0},
      {0,63,0},
      {63,63,0},
      {0,0,63},
      {63,0,63},
      {0,63,63},
      {63,63,63},
      {63,63,63},
      {0,63,63},
      {63,0,63},
      {0,0,63},
      {63,63,0},
      {63,0,63},
      {0,63,63},
      {63,63,63}
};

#endif

int cursorx,cursors,cursore;
unsigned long *armregs[16];
unsigned long fiqregs[16];
unsigned long ram[0x100000];    /*RAM - 4 megs*/
int memcpages[0x400];
unsigned char vidcctrl;

#ifdef VIDEMU
RGB rgb;
#endif

int vid8c,vid8creal;
int output;

void dumpvidcregs()
{
        int mhz[4]={8,12,16,34};
        int bpp2col[4]={2,4,16,256};
        printf("Pixel rate is %imhz\n",mhz[vidcctrl&3]);
        printf("%i colours\n",bpp2col[(vidcctrl>>2)&3]);
}

void writevidc(unsigned addr, unsigned data)
{
        int temp,c,col;
//        log("VIDC write %08X\n",data);
        if ((data>>24)==0x98)
        {
                cursorx=(data>>14)&0x3FF;
//                log("cursorx %i %08X\n",cursorx,data);
        }
        if ((data>>24)==0xB8)
        {
                cursors=(data>>14)&0x3FF;
//                log("cursors %i %08X\n",cursors,data);
        }
        if ((data>>24)==0xBC)
        {
                cursore=(data>>14)&0x3FF;
//                log("cursore %i %08X\n",cursore,data);
        }
        if ((data>>24)==0x8C)
        {
                vid8c=((((data>>13)&0xFF)-114)&15)^15;
                vid8creal=(data>>8)&0xFFFF;
        }
        if ((data>>24)==0xE0)
        {
                vidcctrl=data&0xFF;
                if ((vidcctrl&0xC)==0xC)
                {
                        width=320;
                        bit4=bit1=0;
                }
                else if ((vidcctrl&0xC)==8)
                {
                        width=320;
                        bit4=1;
                        bit1=0;
                }
                else
                {
                        width=80;
                        bit4=bit1=1;
                }
        }
        if ((data>>24)==0x44)
        {
                borderpal[1].r=(data&0xF)<<2;
                data>>=4;
                borderpal[1].g=(data&0xF)<<2;
                data>>=4;
                borderpal[1].b=(data&0xF)<<2;
        }
        if ((data>>24)<0x40)
        {
                changedpal=1;
                temp=data>>26;
//                log("Palette write entry %i %03X\n",temp,data&0xFFF);
                pal[temp].r=(data&0xF)<<2;
                data>>=4;
                pal[temp].g=(data&0xF)<<2;
                data>>=4;
                pal[temp].b=(data&0xF)<<2;
                for (c=16;c<256;c++)
                {
                        col=pal[c&15].r;
                        if (c&16) col|=32;
                        pal[c].r=col;
                        col=pal[c&15].g;
                        if (c&32) col|=16;
                        if (c&64) col|=32;
                        pal[c].g=col;
                        col=pal[c&15].b;
                        if (c&128) col|=32;
                        pal[c].b=col;
                }
        }
#ifdef VIDEMU
        if (running && (data>>24)==0x40) /*Special case - set border colour*/
        {
                rgb.r=(data&0xF)<<2;
                rgb.g=((data&0xF0)>>4)<<2;
                rgb.b=((data&0xF00)>>8)<<2;
                set_color(0,&rgb);
//                printf("PC=%07X\n",(*armregs[15]-4)&0x3FFFFFC);
        }
#endif
}

void initvideo()
{
#ifdef VIDEMU
        int c;
        int col;
        allegro_init();
//        set_gfx_mode(GFX_AUTODETECT,320,400,0,0);
        b=create_bitmap(1640,1024);
        clear(b);
        for (c=16;c<256;c++)
        {
                col=pal[c&15].r;
                if (c&16) col|=32;
                pal[c].r=col;
                col=pal[c&15].g;
                if (c&32) col|=16;
                if (c&64) col|=32;
                pal[c].g=col;
                col=pal[c&15].b;
                if (c&128) col|=32;
                pal[c].b=col;
        }
        install_timer();
        install_int_ex(updatemips,MSEC_TO_TIMER(1000));
        install_mouse();
#endif
}

void closevideo()
{
#ifdef VIDEMU
        get_palette(pal);
        save_pcx("scrshot.pcx",b,pal);
        allegro_exit();
        printf("Video base %08X\n",videobase);
#endif
}

void dumppal()
{
        int x,y;
        clear(screen);
        for (y=0;y<16;y++)
            for (x=0;x<16;x++)
                rectfill(screen,x*16,y*16,(x+1)*16,(y+1)*16,x|(y<<4));
        getch();
}

void drawscreen()
{
#ifdef VIDEMU
        int addr;
        int x,y,xx,reload=0;
        if (alternatescreen==0)
           addr=memcpages[0x3E1]>>2;
        else if (alternatescreen==1)
           addr=(memcpages[0x1FEC000>>15]>>2)|((0x1FEC000&0x7FFF)>>2);
        else if (alternatescreen==2)
           addr=(memcpages[0x1FE8000>>15]>>2)|((0x1FE8000&0x7FFF)>>2);
        else if (alternatescreen==3)
           addr=(memcpages[0x1F88000>>15]>>2)|((0x1F88000&0x7FFF)>>2);
        else if (alternatescreen==4)
           addr=(/*vinit*/videobase)>>2;
        else
           addr=vinit;
        if (running && changedpal)
        {
//        if (!bit4 && !bit1)
//        if (memcctrl&0x400)
           set_palette(pal);
//        else
//           set_palette(borderpal);
//        else
//           set_palette(beebpal);
        }
        if (running)
        {
                if (alternatescreen<5 || memcctrl&0x400)
                {
                for (y=0;y<256;y++)
                {
                        for (x=0;x<width;x+=4)
                        {
                                if (alternatescreen>4 && addr>vend)
                                {
                                        addr=0;
                                        reload=1;
                                }
                                if (!bit4)
                                {
                                        b->line[y][x]=ram[addr];
                                        b->line[y][x+1]=ram[addr]>>8;
                                        b->line[y][x+2]=ram[addr]>>16;
                                        b->line[y][x+3]=ram[addr]>>24;
                                }
                                else if (!bit1)
                                {
                                        x<<=1;
                                        b->line[y][x]=ram[addr]&0xF;
                                        b->line[y][x+1]=(ram[addr]>>4)&0xF;
                                        b->line[y][x+2]=(ram[addr]>>8)&0xF;
                                        b->line[y][x+3]=(ram[addr]>>12)&0xF;
                                        b->line[y][x+4]=(ram[addr]>>16)&0xF;
                                        b->line[y][x+5]=(ram[addr]>>20)&0xF;
                                        b->line[y][x+6]=(ram[addr]>>24)&0xF;
                                        b->line[y][x+7]=(ram[addr]>>28)&0xF;
                                        x>>=1;
                                }
                                else
                                {
                                        x<<=3;
                                        for (xx=0;xx<32;xx++)
                                            b->line[y][x+xx]=(ram[addr]>>xx)&1;
                                        x>>=3;
                                }
                                addr++;
//                                addr&=0xFFFFF;
                        }
//                        addr+=52;
                }
//                y=cursors;
//                for (;y<cursore;y++)
//                    hline(b,cursorx,y,cursorx+32,makecol(255,255,255));
                if (reload)
                   textprintf(b,font,0,256,makecol(255,255,255),"Overflowed start %05X end %05X vstart %05X vend %05X  %f mips",vinit,addr,vstart,vend,mips);
                else
                   textprintf(b,font,0,256,makecol(255,255,255),"           start %05X end %05X vstart %05X vend %05X  %f mips",vinit,addr,vstart,vend,mips);
                if (!warlocksmode)
                   blit(b,screen,0,0,0,0,640,264);
                else
                   blit(b,screen,vid8c,16,0,0,304,208);
                }
        }
#endif
}

void drawscreenfordebug()
{
#ifdef VIDEMU
        int addr;
        int x,y,xx;
        if (alternatescreen==0)
           addr=memcpages[0x3E1]>>2;
        else if (alternatescreen==1)
           addr=(memcpages[0x1FEC000>>15]>>2)|((0x1FEC000&0x7FFF)>>2);
        else if (alternatescreen==2)
           addr=(memcpages[0x1FE8000>>15]>>2)|((0x1FE8000&0x7FFF)>>2);
        else if (alternatescreen==3)
           addr=(memcpages[0x1F88000>>15]>>2)|((0x1F88000&0x7FFF)>>2);
        else if (alternatescreen==4)
           addr=/*(*/vinit/*base)>>2*/;
        else
           addr=vinit;
        set_gfx_mode(GFX_VESA1,640,480,0,0);
        if (!bit4 && !bit1)
           set_palette(pal);
        else
           set_palette(beebpal);
//        set_palette(pal);
                for (y=0;y<256;y++)
                {
                        for (x=0;x<width;x+=4)
                        {
                                if (!bit4)
                                {
                                        b->line[y][x]=ram[addr];
                                        b->line[y][x+1]=ram[addr]>>8;
                                        b->line[y][x+2]=ram[addr]>>16;
                                        b->line[y][x+3]=ram[addr]>>24;
                                }
                                else if (!bit1)
                                {
                                        x<<=1;
                                        b->line[y][x]=ram[addr]&0xF;
                                        b->line[y][x+1]=(ram[addr]>>4)&0xF;
                                        b->line[y][x+2]=(ram[addr]>>8)&0xF;
                                        b->line[y][x+3]=(ram[addr]>>12)&0xF;
                                        b->line[y][x+4]=(ram[addr]>>16)&0xF;
                                        b->line[y][x+5]=(ram[addr]>>20)&0xF;
                                        b->line[y][x+6]=(ram[addr]>>24)&0xF;
                                        b->line[y][x+7]=(ram[addr]>>28)&0xF;
                                        x>>=1;
                                }
                                else
                                {
                                        x<<=3;
                                        for (xx=0;xx<32;xx++)
                                            b->line[y][x+xx]=(ram[addr]>>xx)&1;
                                        x>>=3;
                                }
                                addr++;
//                                addr&=0xFFFFF;
                        }
//                        addr+=52;
                }
/*        for (y=0;y<256;y++)
        {
                for (x=0;x<width;x+=4)
                {
                        b->line[y][x]=ram[addr];
                        b->line[y][x+1]=ram[addr]>>8;
                        b->line[y][x+2]=ram[addr]>>16;
                        b->line[y][x+3]=ram[addr]>>24;
                        addr++;
                }
        }**/
        if (!warlocksmode)
           blit(b,screen,0,0,0,0,640,256);
        else
           blit(b,screen,vid8c,16,0,0,304,208);
        getch();
        set_gfx_mode(GFX_TEXT,0,0,0,0);
#endif
}
