#include <stdio.h>
#include "arc.h"

int fdcside;
int running;
#define RISCOS3
//#define RISCOS2
//#define ARTHUR

int bit1,bit4,warlocksmode;
int width,alternatescreen;
int memcpages[0x400];
int memcpermissions[0x400];
int memoverlay=1;
int osmode;
unsigned long *armregs[16];
unsigned long romhigh[0x80000]; /*High ROM - 512k*/
unsigned long ram[0x100000];    /*RAM - 4 megs*/
int output;

void dumpram()
{
        int c;
        unsigned long temp;
        FILE *f=fopen("ram.dmp","wb");
        fwrite(ram,0x400000,1,f);
        fclose(f);
        f=fopen("vram.dmp","wb");
        for (c=0x1F08000;c<0x2000000;c+=4)
        {
                temp=readDWord(c);
                putc(temp&0xFF,f);
                putc(temp>>8,f);
                putc(temp>>16,f);
                putc(temp>>24,f);
        }
        fclose(f);
        f=fopen("program.dmp","wb");
        for (c=0x8000;c<0xB0000;c+=4)
        {
                temp=readDWord(c);
                putc(temp&0xFF,f);
                putc(temp>>8,f);
                putc(temp>>16,f);
                putc(temp>>24,f);
        }
        fclose(f);
        f=fopen("highram.dmp","wb");
        for (c=0x1F00000;c<0x1F08000;c+=4)
        {
                temp=readDWord(c);
                putc(temp&0xFF,f);
                putc(temp>>8,f);
                putc(temp>>16,f);
                putc(temp>>24,f);
        }
        fclose(f);
/*        f=fopen("results.dmp","wb");
        for (c=0x8040;c<0x8140;c+=4)
        {
                temp=readDWord(c);
                putc(temp&0xFF,f);
                putc(temp>>8,f);
                putc(temp>>16,f);
                putc(temp>>24,f);
        }*/
        fclose(f);
}

/*&3350040?*/

#define ROMHIGH (0x3800000-1)
#define ROMLOW  (0x3400000-1)
#define MEMC    (0x3600000-1)
#define VIDC    (0x3400000-1)
#define IOC     (0x3000000-1)
#define PHYSRAM (0x2000000-1)

int bank;
int page,addr2;

unsigned readDWord(unsigned addr)
{
        unsigned long data;
        if (addr&0xFC000000 && running)
        {
                closevideo();
                printf("Address exception - readDWord %08X\n",addr);
                dumpregs();
                exit(-1);
        }
        addr&=0x3FFFFFC;
        if (addr>ROMHIGH)
        {
                memoverlay=0;
                return romhigh[(addr>>2)&0x7FFFF];
        }
        if (addr>ROMLOW)
        {
                return 0;
        }
        if (addr>IOC)
        {
                bank=(addr>>16)&7;
                switch (bank)
                {
                        case 0: /*Internal regs*/
                        return readioc(addr);

                        case 1: /*1772 FDC*/
                        return read1770(addr);

                        case 2: /*Econet*/
                        return 0xFF; /*not emulated yet*/

                        case 3: /*serial*/
                        return 0xFF; /*not emulated yet*/

                        case 4: /*internal expansion*/
                        return 0xFFFFFFFF;

                        case 5: /*Hard disc/latches*/
                        switch (addr)
                        {
                                case 0x3350050: /*IOEB*/
                                /*This chip doesn't exist in the older
                                  Archimedes machines, but is used to detect
                                  what kind of I/O system exists*/
                                return 0xFF; /*Returning 0 will convince RiscOS
                                               that the chip does not exits*/

                                case 0x3350078: /*What is this?*/
                                return 0xFF;

                                default:
                                closevideo();
                                printf("Reading bank 5 addr %08X\n",addr);
                                dumpregs();
                                exit(-1);
                        }
                        return 0xFF;

                        default:
                        closevideo();
                        printf("Reading from bad bank %i %08X\n",bank,addr);
                        dumpregs();
                        exit(-1);
                }
        }
        if (addr>PHYSRAM)
        {
//                if (addr>0x23FFFFF)
//                   return 0xDEAD0BAD;
                return ram[(addr&0x3FFFFF)>>2];
        }
        if (memoverlay)
           return romhigh[(addr>>2)&0x7FFFF];
        else
        {
                page=(addr>>15)&0x3FF;
                switch (memcpermissions[page])
                {
                        case 0:
                        addr2=memcpages[page]|(addr&0x7FFF);
//                        if (addr==0x1c01D30) log("Reading 1C01D30 %08X at %07X %07X\n",ram[(addr2>>2)&0xFFFFF],(*armregs[15]-8)&0x3FFFFFC,addr2);
                        return ram[(addr2>>2)&0xFFFFF];

                        case 1:
                        addr2=memcpages[page]|(addr&0x7FFF);
//                        if (addr==0x1C01D30) log("Reading 1C01D30 %08X at %07X %07X\n",ram[(addr2>>2)&0xFFFFF],(*armregs[15]-8)&0x3FFFFFC,addr2);
                        return ram[(addr2>>2)&0xFFFFF];

                        case 2: /*NA in user mode, RO in OS and RW in supervisor*/
                        if (!(*armregs[15]&3) && !osmode)
                        {
                                armabort();
                                return 0xFFFFFFFF;
                        }
                        addr2=memcpages[page]|(addr&0x7FFF);
//                        if (addr2==0x1C01D30) log("Reading 1C01D30 %08X at %07X %07X\n",ram[(addr2>>2)&0xFFFFF],(*armregs[15]-8)&0x3FFFFFC,addr2);
                        return ram[(addr2>>2)&0xFFFFF];

                        case 3: /*NA in user mode and OS and RW in supervisor*/
                        if (!(*armregs[15]&3))
                        {
                                armabort();
                                return 0xFFFFFFFF;
                        }
                        addr2=memcpages[page]|(addr&0x7FFF);
//                        if (addr2==0x1C01D30) log("Reading 1C01D30 %08X at %07X %07X\n",ram[(addr2>>2)&0xFFFFF],(*armregs[15]-8)&0x3FFFFFC,addr2);
                        return ram[(addr2>>2)&0xFFFFF];
                }
        }
}

unsigned readByte(unsigned addr)
{
        if (addr&0xFC000000)
        {
                closevideo();
                printf("Address exception - readByte %08X\n",addr);
                dumpregs();
                dumpram();
                exit(-1);
        }
        switch (addr&3)
        {
                case 0:
                return readDWord(addr)&0xFF;
                case 1:
                return (readDWord(addr)>>8)&0xFF;
                case 2:
                return (readDWord(addr)>>16)&0xFF;
                case 3:
                return (readDWord(addr)>>24)&0xFF;
        }
}

void writeDWord(unsigned addr, unsigned data)
{
//        if (addr==0x1C01D30)
//           log("Writing %08X to %07X at %07X\n",data,addr,(*armregs[15]-8)&0x3FFFFFC);
//        if ((addr&0x3FFFF00)==0x3200000)
//           log("Writing %08X to %07X\n",data,addr);
//        if (addr==0x36C)
//           logfile("Writing %08X to &36C - PC %07X\n",data,(*armregs[15]-8)&0x3FFFFFC);
        if (addr&0xFC000000)
        {
                closevideo();
                printf("Address exception - writeDWord %08X %08X\n",addr,data);
                dumpregs();
                dumpram();
                exit(-1);
        }
        addr&=0x3FFFFFF;
        if (addr>MEMC)
        {
                writememc(addr,data);
                return;
        }
        if (addr>VIDC)
        {
                writevidc(addr,data);
                return;
        }
        addr&=0x3FFFFFC;
        if (addr>IOC)
        {
                bank=(addr>>16)&7;
                switch (bank)
                {
                        case 0: /*Internal regs*/
//                        log("IOC write %07X %08X %07X\n",addr,data,(*armregs[15]-8)&0x3FFFFFC);
                        writeioc(addr,data);
                        return;

                        case 1: /*1772 FDC*/
                        write1770(addr,data);
                        return;

                        case 2: /*Econet*/
                        log("Econet write %07X %08X\n",addr,data);
                        return; /*Not emulated yet*/

                        case 3: /*Serial*/
                        log("Serial write %07X %08X\n",addr,data);
                        return; /*Not emulated yet*/

                        case 5: /*Hard disc/latches*/
                        switch (addr)
                        {
                                case 0x3350010: /*Printer data*/
                                break; /*No printer, do nothing*/

                                case 0x3350018: /*WD1772 latch A*/
                                fdcside=((data>>16)&0x10)?0:1;
                                break; /*No floppy, do nothing*/

                                case 0x3350040: /*WD1772 latch B*/
                                break; /*No floppy, do nothing*/

                                case 0x3350048: /*What the hell is this?*/
                                case 0x3350074: /*This as well*/
                                case 0x3350078: /*And this*/
                                break;

                                case 0x3350050: /*IOEB*/
                                break; /*I really should find out why it
                                         detects this chip now*/

                                default:
                                closevideo();
                                dumpregs();
                                printf("Bad write %08X to %07X bank 5\n",data,addr);
                                exit(-1);
                        }
                        return;

                        default:
                        closevideo();
                        printf("Writing %08X to bad bank %i %07X\n",data,bank,addr);
                        dumpregs();
                        exit(-1);
                }
        }
        if (addr>PHYSRAM)
        {
//                if (addr>0x23FFFFF)
//                   return;
                ram[(addr&0x3FFFFF)>>2]=data;
                return;
        }
        page=(addr>>15)&0x3FF;
        switch (memcpermissions[page])
        {
                case 0:
                addr2=memcpages[page]|(addr&0x7FFF);
                ram[(addr2>>2)&0xFFFFF]=data;
                return;

                case 1: /*RO in user mode, RW in OS and supervisor*/
                if (!(*armregs[15]&3) && !osmode)
                {
                        armabort();
                        return;
                }
                addr2=memcpages[page]|(addr&0x7FFF);
                ram[(addr2>>2)&0xFFFFF]=data;
                return;

                case 2: /*NA in user mode, RO in OS and RW in supervisor*/
                if (!(*armregs[15]&3))
                {
                        armabort();
                        return;
                }
                addr2=memcpages[page]|(addr&0x7FFF);
                ram[(addr2>>2)&0xFFFFF]=data;
                return;

                case 3: /*NA in user and OS, RW in supervisor*/
                if (!(*armregs[15]&3))
                {
                        armabort();
                        return;
                }
                addr2=memcpages[page]|(addr&0x7FFF);
                ram[(addr2>>2)&0xFFFFF]=data;
                return;
        }
/*        if ((ram[0x16664>>2]&0xFF)==219)
        {
                output=1;
        }*/
}

void writeByte(unsigned addr, unsigned byte)
{
        unsigned temp;
        if (addr&0xFC000000)
        {
                closevideo();
                printf("Address exception - writeByte %08X %02X\n",addr,byte);
                dumpregs();
                exit(-1);
        }
/*        if (addr==0x1F16664 && byte==219)
        {
                output=1;
        }*/
        byte&=0xFF;
        if (addr<0x2000000)
        {
                page=(addr>>15)&0x3FF;
                switch (memcpermissions[page])
                {
                        case 0:
                        addr2=memcpages[page]|(addr&0x7FFF);
                        break;

                        case 1: /*RO in user mode, RW in OS and supervisor*/
                        if (!(*armregs[15]&3) && !osmode)
                        {
                                armabort();
                                return;
                        }
                        addr2=memcpages[page]|(addr&0x7FFF);
                        break;

                        case 2: /*NA in user mode, RO in OS and RW in supervisor*/
                        if (!(*armregs[15]&3))
                        {
                                armabort();
                                return;
                        }
                        addr2=memcpages[page]|(addr&0x7FFF);
                        break;

                        case 3: /*NA in user and OS, RW in supervisor*/
                        if (!(*armregs[15]&3))
                        {
                                armabort();
                                return;
                        }
                        addr2=memcpages[page]|(addr&0x7FFF);
                        break;
                }
                temp=ram[(addr2>>2)&0xFFFFF];
                switch (addr2&3)
                {
                        case 0:
                        temp&=0xFFFFFF00;
                        temp|=byte;
                        break;
                        case 1:
                        temp&=0xFFFF00FF;
                        temp|=(byte<<8);
                        break;
                        case 2:
                        temp&=0xFF00FFFF;
                        temp|=(byte<<16);
                        break;
                        case 3:
                        temp&=0xFFFFFF;
                        temp|=(byte<<24);
                        break;
                }
                ram[(addr2>>2)&0xFFFFF]=temp;
                return;
        }
        if (addr<0x3000000)
        {
                temp=ram[(addr&0x3FFFFF)>>2];
                switch (addr&3)
                {
                        case 0:
                        temp&=0xFFFFFF00;
                        temp|=byte;
                        break;
                        case 1:
                        temp&=0xFFFF00FF;
                        temp|=(byte<<8);
                        break;
                        case 2:
                        temp&=0xFF00FFFF;
                        temp|=(byte<<16);
                        break;
                        case 3:
                        temp&=0xFFFFFF;
                        temp|=(byte<<24);
                        break;
                }
                ram[(addr&0x3FFFFF)>>2]=temp;
                return;
        }
        if (addr<0x3400000)
        {
                writeDWord(addr,byte<<16);
                return;
        }
        switch (addr&3)
        {
                case 0:
                writeDWord(addr,byte);
                break;
                case 1:
                writeDWord(addr,byte<<8);
                break;
                case 2:
                writeDWord(addr,byte<<16);
                break;
                case 3:
                writeDWord(addr,byte<<24);
                break;
        }
}

void initmem()
{
#ifdef ARTHUR
        FILE *f=fopen("arthur.rom","rb");
        fread(romhigh,512*1024,1,f);
        fclose(f);
        memset(ram,0,4*1024*1024);
#endif

#ifdef RISCOS2
        FILE *f=fopen("riscos2.rom","rb");
        fread(romhigh,512*1024,1,f);
        fclose(f);
        memset(ram,0,4*1024*1024);
#endif

#ifdef RISCOS3
        FILE *f=fopen("ic24.rom","rb");
        fread(romhigh,512*1024,1,f);
        fclose(f);
        f=fopen("ic25.rom","rb");
        fread(&romhigh[0x20000],512*1024,1,f);
        fclose(f);
        f=fopen("ic26.rom","rb");
        fread(&romhigh[0x40000],512*1024,1,f);
        fclose(f);
        f=fopen("ic27.rom","rb");
        fread(&romhigh[0x60000],512*1024,1,f);
        fclose(f);
        memset(ram,0,4*1024*1024);
        romhigh[(0x1E7C>>2)]=0xE3A07001; /*Patch ROM to speed up failure screen - MOV R7,#1*/
//        romhigh[(0x234B0>>2)]=0xFAFFFFFB;
//        romhigh[(0x234BC>>2)]=0xFAFFFFF8;
#endif
}

void initmem2(char *fn, int loadaddr, int runaddr)
{
        FILE *f;
        int c,d;
        alternatescreen=0;
        width=320;
        bit4=bit1=0;
        warlocksmode=0;
        memset(ram,0,4*1024*1024);
        /*Set up suitable pages*/
        /*1C00000=380*/
        for (c=0;c<32;c++)      /*Pages 0-31 to 3e0-3ff - 1mb VRAM*/
            memcpages[c+0x3E0]=c<<15;
        for (c=0;c<33+32;c++)      /*Pages 32-65 to 0-32 - 32k system and 1 meg prg*/
            memcpages[c]=(c+32)<<15;
        for (c=0;c<16;c++)
            memcpages[c+0x380]=(c+65+32)<<15;
//        memcpages[0x380]=81;
        memcpages[0x3C0]=0xFF<<15;
        for (c=0;c<128;c++)
            memcpermissions[c]=0;
        f=fopen(fn,"rb");
        c=loadaddr;
        while (!feof(f))
        {
                d=getc(f);
                d|=(getc(f)<<8);
                d|=(getc(f)<<16);
                d|=(getc(f)<<24);
                writeDWord(c,d);
                c+=4;
        }
//        fread(&ram[33<<15]+loadaddr,1024*1024,1,f);
        fclose(f);
        writeDWord(0,0xEA000000|((runaddr-8)>>2));
        memoverlay=0;
}
