#include <stdio.h>
#include "arc.h"

unsigned char disc[2][80][5][1024]; /*Disc - E format (2 sides, 80 tracks, 5 sectors, 1024 bytes)*/
int output;
int fdcside;
int commandpos=0;
int fiq;
int track=0,sector=0;
unsigned char fdctrack=0,fdcsector=0,fdcdata,fdcstatus=0;
int discint=0;
unsigned char fdccommand;

void loaddisc(char *fn)
{
        FILE *ff=fopen(fn,"rb");
        int c,d,e,f;
        for (d=0;d<80;d++)
        {
                for (c=0;c<2;c++)
                {
                        for (e=0;e<5;e++)
                        {
                                for (f=0;f<1024;f++)
                                {
                                        disc[c][d][e][f]=getc(ff);
                                }
                        }
                }
        }
        fclose(ff);
}

void callback()
{
        int c;
        FILE *f;
        unsigned long templ;
        switch (fdccommand>>4)
        {
                case 0x0: /*Restore*/
                fdctrack=0;
                iocfiq(2);
                discint=0;
                fdcstatus|=0xA4;
                fdcstatus&=~1;
                break;

                case 0x8: /*Read sector*/
                if (commandpos==1024)
                {
                        iocfiq(2);
                        fdcstatus|=0xA0;
                        fdcstatus&=~7;
                        fdcsector++;
                        if (fdcsector==5) fdcsector=0;
                }
                else
                {
                        fdcdata=disc[fdcside][fdctrack][fdcsector][commandpos];
                        commandpos++;
                        iocfiq(1);
                        fdcstatus|=2;
                        discint=1000;
                }
                break;

                case 0xC: /*Read address*/
                discint=1000;
                iocfiq(1);
                fdcstatus=0x81;
                switch (commandpos--)
                {
                        case 6: fdcdata=track; break;
                        case 5: fdcdata=(fdcside)?0:1; break;
                        case 4: fdcdata=sector; sector++; if (sector==5) sector=0; break;
                        case 3: fdcdata=3; break;
                        case 2: fdcdata=0xA5; break;
                        case 1: fdcdata=0x5A; break;
                        case 0:
                        discint=0;
                        iocfiqc(1);
                        iocfiq(2);
                        fdcstatus=0x80;
                        fdcsector=track;
                }
                log("Read address %i %02X\n",commandpos,fdcdata);
                break;
        }
}

void write1770(unsigned addr, unsigned data)
{
        switch (addr&0xC)
        {
                case 0: /*Command reg*/
                log("1770 command %02X\n",data>>16);
                fdccommand=data>>16;
                switch ((data>>20)&0xF)
                {
                        case 0x0: /*Restore*/
                        discint=1000;
                        fdcstatus=(fdcstatus|1)&~0x1A;
                        break;
#if 0
                        case 0x8: /*Read sector*/
                        discint=1000;
                        commandpos=0;
                        fdcstatus=(fdcstatus|1)&~0x1A;
                        break;
#endif
                        case 0xC: /*Read address*/
                        commandpos=6;
                        discint=1000;
                        fdcstatus=(fdcstatus|1)&~0x7E;
                        log("read %i %i %i\n",track,fdcside,sector);
                        break;

                        case 0xD: /*Force interrupt*/
                        if (fdccommand&8) iocfiq(2);
                        else              iocfiqc(2);
                        discint=0;
                        break;

                        default:
                        allegro_exit();
                        printf("Bad command %01X\n",(data>>20)&0xF);
                        exit(-1);
                }
                break;
                case 4: /*Track reg*/
                fdctrack=data>>16;
                break;
                case 8: /*Sector reg*/
                fdcsector=data>>16;
                break;
                case 0xC: /*Data reg*/
                fdcdata=data>>16;
                break;
        }
//        log("1770 write addr %08X data %02X\n",addr,data);
}

unsigned read1770(unsigned addr)
{
        switch (addr&0xC)
        {
                case 0: /*Status reg*/
                iocfiqc(2);
                return fdcstatus;
                case 4: /*Track reg*/
                return fdctrack;
                case 8: /*Sector reg*/
                return fdcsector;
                case 0xC: /*Data reg*/
                iocfiqc(1);
                return fdcdata;
        }
}
