//1f00000
//007b800
//0003800
//1f03800
#include <allegro.h>
#include "arc.h"

int ledcaps,lednum,ledscr;
int track,sector;
float inssec;
int curx,cursy,curey;
int hstart,hbstart,hend;
int acc=0;
unsigned short lookup4bpp[256];

void makelookup()
{
        int c;
        for (c=0;c<256;c++)
        {
                lookup4bpp[c]=c&15;
                lookup4bpp[c]|=(c&0xF0)<<4;
        }
}

void writevidc(unsigned long v)
{
        vidcr[v>>26]=v;
        if ((v>>24)==0x98) curx=((v&0xFFF000)>>13)-255;//printf("VIDC 98 write %i\n",(v&0xFFF000)>>13);
        if ((v>>24)==0xB8) cursy=((v&0xFFF000)>>14)-37;//printf("VIDC B8 write %i\n",(v&0xFFF000)>>13);
        if ((v>>24)==0xBC) curey=((v&0xFFF000)>>14)-37;//printf("VIDC BC write %i\n",(v&0xFFF000)>>13);
        if ((v>>24)==0x88) { hbstart=(v&0x3FF000)>>12; /*printf("Diff %i\n",(hbstart>>1)-(hstart>>1));*/ }
        if ((v>>24)==0x8C) { hstart=(v&0x3FF000)>>12; /*printf("Diff %i\n",(hbstart>>1)-(hstart>>1));*/ }
        if ((v>>24)==0x90) hend=(v&0x3FF000)>>12;
//        printf("VIDC write %08X\n",v);
}

BITMAP *b;

void initvid()
{
        int depth;
        allegro_init();
        depth=desktop_color_depth();
        if (depth==16)
        {
                set_color_depth(16);
                if (set_gfx_mode(GFX_AUTODETECT_WINDOWED,640,512,0,0))
                {
                        set_color_depth(15);
                        set_gfx_mode(GFX_AUTODETECT_WINDOWED,640,512,0,0);
                }
        }
        else if (depth)
        {
                set_color_depth(depth);
                set_gfx_mode(GFX_AUTODETECT_WINDOWED,640,512,0,0);
        }
        else
           set_gfx_mode(GFX_AUTODETECT_WINDOWED,640,512,0,0);
        set_color_depth(8);
        b=create_bitmap(672,528);
        clear(b);
        makelookup();
}

int lastblack=0;

void drawvid()
{
        PALETTE pal;
        int c,x,y,cx,moderes;
        unsigned char temp;
        unsigned long c1,c2,addr,templ;
        char s[80];

        switch (vidcr[0x38]&0xC)
        {
                case 0x0: /*1 bpp*/
                pal[0].r=(vidcr[0]&0xF)<<2;
                pal[0].g=((vidcr[0]&0xF0)>>4)<<2;
                pal[0].b=((vidcr[0]&0xF00)>>8)<<2;
                pal[1].r=(vidcr[1]&0xF)<<2;
                pal[1].g=((vidcr[1]&0xF0)>>4)<<2;
                pal[1].b=((vidcr[1]&0xF00)>>8)<<2;
                break;
                case 0x8: /*4 bpp*/
                for (c=0;c<20;c++)
                {
                        pal[c].r=(vidcr[c]&0xF)<<2;
                        pal[c].g=((vidcr[c]&0xF0)>>4)<<2;
                        pal[c].b=((vidcr[c]&0xF00)>>8)<<2;
                }
                break;
                case 0xC: /*8 bpp*/
                for (c=0;c<256;c++)
                {
                        pal[c].r=vidcr[c&15]&0xF;
                        pal[c].g=(vidcr[c&15]&0xF0)>>4;
                        pal[c].b=(vidcr[c&15]&0xF00)>>8;
                        if (c&0x10) pal[c].r|=8; else pal[c].r&=~8;
                        if (c&0x20) pal[c].g|=4; else pal[c].g&=~4;
                        if (c&0x40) pal[c].g|=8; else pal[c].g&=~8;
                        if (c&0x80) pal[c].b|=8; else pal[c].b&=~8;
                        pal[c].r<<=2; pal[c].g<<=2; pal[c].b<<=2;
                }
                break;
        }
        set_palette(pal);
        if (!(pal[0].r|pal[0].g|pal[0].b)) c=0;
        else                               c=makecol(0,0,0);
        if (c!=lastblack) clear_to_color(b,c);
        lastblack=c;
        c=vinit<<2;
        cx=curx;
        switch (vidcr[0x38]&0xF)
        {
                case 2: /*Mode 0*/
                for (y=0;y<512;y+=2)
                {
                        for (x=0;x<640;x+=8)
                        {
                                temp=((unsigned char *)ram)[c]; c++;
                                b->line[y][x+7]=(temp>>7)&1;
                                b->line[y][x+6]=(temp>>6)&1;
                                b->line[y][x+5]=(temp>>5)&1;
                                b->line[y][x+4]=(temp>>4)&1;
                                b->line[y][x+3]=(temp>>3)&1;
                                b->line[y][x+2]=(temp>>2)&1;
                                b->line[y][x+1]=(temp>>1)&1;
                                b->line[y][x+0]=temp&1;
                                if (c==vend<<2) c=vstart<<2;
                        }
                }
                moderes=0;
                break;
                case 8: /*Mode 9*/
                for (y=0;y<512;y+=2)
                {
                        for (x=0;x<640;x+=4)
                        {
                                temp=((unsigned char *)ram)[c]; c++;
                                b->line[y][x+3]=(temp>>4)&0xF;
                                b->line[y][x+2]=(temp>>4)&0xF;
                                b->line[y][x+1]=temp&0xF;
                                b->line[y][x+0]=temp&0xF;
                                if (c==vend<<2) c=vstart<<2;
                        }
                }
                cx=(curx+140);
                moderes=1;
                break;
                case 10: /*Mode 12*/
                c>>=2;
                for (y=0;y<512;y+=2)
                {
                        for (x=0;x<320;x+=4)
                        {
                                templ=ram[c]; c++;
                                ((unsigned short *)b->line[y])[x]=lookup4bpp[templ&0xFF];
                                ((unsigned short *)b->line[y])[x+1]=lookup4bpp[(templ>>8)&0xFF];
                                ((unsigned short *)b->line[y])[x+2]=lookup4bpp[(templ>>16)&0xFF];
                                ((unsigned short *)b->line[y])[x+3]=lookup4bpp[(templ>>24)&0xFF];
                                if (c==vend) c=vstart;
                        }
                }
                moderes=0;
                break;
                case 12: /*Mode 13*/
                for (y=0;y<512;y+=2)
                {
                        for (x=0;x<hend-hstart;x+=2)
                        {
                                temp=((unsigned char *)ram)[c]; c++;
                                b->line[y][x+1]=temp;
                                b->line[y][x+0]=temp;
                                if (c==vend<<2) c=vstart<<2;
                        }
                }
                cx=(curx+140);
                moderes=1;
                break;
        }
        addr=cinit;
        switch (vidcr[0xE0>>2]&3)
        {
                case 0:
                moderes=1;
                curx=(vidcr[0x98>>2]-vidcr[0x8C>>2])>>13;
                break;
                case 1:
                default:
                moderes=0;
                curx=(vidcr[0x98>>2]-vidcr[0x8C>>2])>>13;
                break;
        }
        cx=curx;
        for (y=cursy;y<curey;y++)
        {
                c1=ram[addr];
                c2=ram[addr+1];
                addr+=2;
                if (y<256 && y>-1)
                {
                        if (moderes)
                        {
                                for (x=0;x<16;x++)
                                {
                                        if ((c1>>(x<<1))&3 && ((((cx+x)<<1)+1)&1023)<640) b->line[y<<1][((cx+x)<<1)&1023]=b->line[y<<1][(((cx+x)<<1)+1)&1023]=((c1>>(x<<1))&3)|16;
                                }
                                for (x=0;x<16;x++)
                                {
                                        if ((c2>>(x<<1))&3 && ((((cx+x+16)<<1)+1)&1023)<640) b->line[y<<1][((cx+x+16)<<1)&1023]=b->line[y<<1][(((cx+x+16)<<1)+1)&1023]=((c2>>(x<<1))&3)|16;
                                }
                        }
                        else
                        {
                                for (x=0;x<16;x++)
                                {
                                        if ((c1>>(x<<1))&3 && ((cx+x)&1023)<640) b->line[y<<1][(cx+x)&1023]=((c1>>(x<<1))&3)|16;
                                }
                                for (x=0;x<16;x++)
                                {
                                        if ((c2>>(x<<1))&3 && ((cx+x+16)&1023)<640) b->line[y<<1][(cx+x+16)&1023]=((c2>>(x<<1))&3)|16;
                                }
                        }
                }
        }
        blit(b,screen,0,0,0,0,640,520);
}
//117-436
void dumpvid()
{
        int c,x,y;
        unsigned char temp;
        BITMAP *b;
        allegro_init();
        set_gfx_mode(GFX_AUTODETECT,640,480,0,0);
        b=create_bitmap(640,256);
        c=0;
        for (y=0;y<256;y++)
        {
                for (x=0;x<640;x+=8)
                {
                        temp=((unsigned char *)ram)[c]; c++;
                        b->line[y][x+7]=(temp>>7)&1;
                        b->line[y][x+6]=(temp>>6)&1;
                        b->line[y][x+5]=(temp>>5)&1;
                        b->line[y][x+4]=(temp>>4)&1;
                        b->line[y][x+3]=(temp>>3)&1;
                        b->line[y][x+2]=(temp>>2)&1;
                        b->line[y][x+1]=(temp>>1)&1;
                        b->line[y][x+0]=temp&1;
                }
        }
        save_pcx("arc.pcx",b,desktop_palette);
}
