#include <stdio.h>
#include "arc.h"

int osmode;
int memcpages[0x400];

unsigned char convbyte(unsigned char v)
{
        unsigned char temp=(1<<(v>>5))-1;
        if (v&0x40) temp+=(((v>>1)&0xF)<<((v>>5)-4));
        else        temp+=(((v>>1)&0xF)>>(4-(v>>5)));
        temp>>=1;
        if (v&1) temp=(temp^0xFF)+1;
        return temp;
}

FILE *soundf;

signed char mixsamp(unsigned long v)
{
        signed short temp2=0;
        unsigned short *temp3;
        signed short temp=((signed short)((signed char)convbyte(v)))*64;
        temp3=&temp2;
        temp2+=temp;
        temp=((signed short)((signed char)convbyte(v>>8)))*64;
        temp2+=temp;
        temp=((signed short)((signed char)convbyte(v>>16)))*64;
        temp2+=temp;
        temp=((signed short)((signed char)convbyte(v>>24)))*64;
        temp2+=temp;
        putc((*temp3)&0xFF,soundf);
        putc((*temp3)>>8,soundf);
        return temp2;
}

int soundtime;
#define getdmaaddr(addr) (((addr>>2)&0x7FFF)<<2)
void writememc(unsigned long a)
{
        int c;
        switch ((a>>17)&7)
        {
                case 0: /*printf("MEMC write %08X - VINIT  = %05X\n",a,getdmaaddr(a));*/ vinit=getdmaaddr(a); return;
                case 1: /*printf("MEMC write %08X - VSTART = %05X\n",a,getdmaaddr(a));*/ vstart=getdmaaddr(a); return;
                case 2: /*printf("MEMC write %08X - VEND   = %05X\n",a,getdmaaddr(a));*/ vend=getdmaaddr(a); return;
                case 3: /*printf("MEMC write %08X - CINIT  = %05X\n",a,getdmaaddr(a));*/ cinit=getdmaaddr(a); /*printf("CINIT=%05X\n",cinit<<2);*/ return;
                case 4: /*printf("MEMC write %08X - SSTART = %05X\n",a,getdmaaddr(a));*/ if (!soundf) soundf=fopen("sound.pcm","wb"); sstart=getdmaaddr(a); /*printf("SSTART=%05X\n",sstart<<2);*/ soundtime=27500; ioc.irqb&=~2; for (c=sstart;c<ssend;c++) mixsamp(ram[c]); return;
                case 5: /*printf("MEMC write %08X - SEND   = %05X\n",a,getdmaaddr(a));*/ ssend=getdmaaddr(a); /*printf("SEND=%05X\n",send<<2);*/ ioc.irqb&=~2; return;
                case 6: /*printf("MEMC write %08X - SPTR   = %05X\n",a,getdmaaddr(a));*/ sptr=getdmaaddr(a); /*printf("SPTR=%05X\n",sptr); */soundtime=27500; ioc.irqb&=~2; return;
                case 7: osmode=(a&0x1000)?1:0; /*MEMC ctrl*/
                return;
                
                default:
                printf("Bad MEMC adr %i %08X\n",(a>>17)&7,a);
                dumpregs();
                exit(-1);
        }
}

int output;

void writecam(unsigned long a)
{
        int page,access,logical,c;
        page=((a>>3)&0xf) | ((a&1)<<4) | ((a&2)<<5) | ((a&4)<<3);
        access=(a>>8)&3;
        logical=(a>>15)&0xFF;
        logical|=(a>>2)&0x300;
//        printf("MEMC write %08X - logical %03X physical %03X access %i addr %07X\n",a,logical,page,access,logical<<15);
        for (c=0;c<0x400;c++)
        {
                if (memcpages[c]==(page<<15))
                {
                        memcpages[c]=~0;
                        memstat[c]=0;
                }
        }
        memcpages[logical]=page<<15;
        memstat[logical]=access+1;
        mempoint[logical]=&ram[page<<13];
        mempointb[logical]=(unsigned char *)&ram[page<<13];
//        printf("Logical page %03X %07X = %07X %i\n",logical,logical<<15,page<<15,access);
//        output=1;
//        memcpermissions[logical]=access;
}
