#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include <winalleg.h>
#include "arc.h"

int output;
float inssec;
int inscount;

void updateins()
{
        inssec=(float)inscount/1000000;
        inscount=0;
}

END_OF_FUNCTION(updateins);

int spdcount=0;

void updatespd()
{
        spdcount++;
}

END_OF_FUNCTION(updatespd);

void installins()
{
        LOCK_FUNCTION(updateins);
        LOCK_VARIABLE(inssec);
        LOCK_VARIABLE(inscount);
        install_int_ex(updateins,MSEC_TO_TIMER(1000));
        inscount=0;
        LOCK_FUNCTION(updatespd);
        LOCK_VARIABLE(spdcount);
        install_int_ex(updatespd,MSEC_TO_TIMER(20));
}

void loadfile(FILE *f)
{
        int c;
        unsigned char temp;
        c=0x8000;
        while (!feof(f))
        {
                temp=getc(f);
                writememb(c,temp);
                c++;
        }
}

/*  Declare Windows procedure  */
LRESULT CALLBACK WindowProcedure (HWND, UINT, WPARAM, LPARAM);

/*  Make the class name into a global variable  */
char szClassName[ ] = "WindowsApp";
HWND ghwnd;
int infocus;
int quitting=0;
HMENU menu;
int fastvsync=0,dischack=1,limitspeed=0;
int vsyncbreak;

#define IDM_FILE_RESET    40000
#define IDM_FILE_EXIT     40001
#define IDM_DISC_CHANGE   40010
#define IDM_DISC_REMOVE   40011
#define IDM_OPTIONS_HACK  40020
#define IDM_OPTIONS_FAST  40021
#define IDM_OPTIONS_LIMIT 40022

void makemenu()
{
        HMENU hpop;
        menu=CreateMenu();
        hpop=CreateMenu();
        AppendMenu(hpop,MF_STRING,IDM_FILE_RESET,"&Reset");
        AppendMenu(hpop,MF_SEPARATOR,0,NULL);
        AppendMenu(hpop,MF_STRING,IDM_FILE_EXIT,"E&xit");
        AppendMenu(menu,MF_POPUP,hpop,"&File");
        hpop=CreateMenu();
        AppendMenu(hpop,MF_STRING,IDM_DISC_CHANGE,"&Change Disc");
        AppendMenu(hpop,MF_STRING,IDM_DISC_REMOVE,"&Remove Disc");
        AppendMenu(menu,MF_POPUP,hpop,"&Disc");
        hpop=CreateMenu();
        AppendMenu(hpop,MF_STRING,IDM_OPTIONS_HACK,"&Disc Hack");
        AppendMenu(hpop,MF_STRING,IDM_OPTIONS_FAST,"&Fast Vsync");
        AppendMenu(hpop,MF_STRING,IDM_OPTIONS_LIMIT,"&Limit Speed");
        AppendMenu(menu,MF_POPUP,hpop,"&Options");
}

int WINAPI WinMain (HINSTANCE hThisInstance,
                    HINSTANCE hPrevInstance,
                    LPSTR lpszArgument,
                    int nFunsterStil)

{
        int quited=0;
        char *p,s[80];
        /* This is the handle for our window */
        MSG messages;            /* Here messages to the application are saved */
        WNDCLASSEX wincl;        /* Data structure for the windowclass */

        /* The Window structure */
        wincl.hInstance = hThisInstance;
        wincl.lpszClassName = szClassName;
        wincl.lpfnWndProc = WindowProcedure;      /* This function is called by windows */
        wincl.style = CS_DBLCLKS;                 /* Catch double-clicks */
        wincl.cbSize = sizeof (WNDCLASSEX);

        /* Use default icon and mouse-pointer */
        wincl.hIcon = LoadIcon (NULL, IDI_APPLICATION);
        wincl.hIconSm = LoadIcon (NULL, IDI_APPLICATION);
        wincl.hCursor = LoadCursor (NULL, IDC_ARROW);
        wincl.lpszMenuName = NULL;                 /* No menu */
        wincl.cbClsExtra = 0;                      /* No extra bytes after the window class */
        wincl.cbWndExtra = 0;                      /* structure or the window instance */
        /* Use Windows's default color as the background of the window */
        wincl.hbrBackground = (HBRUSH) COLOR_BACKGROUND;

        /* Register the window class, and if it fails quit the program */
        if (!RegisterClassEx (&wincl))
           return 0;

        makemenu();
        /* The class is registered, let's create the program*/
        ghwnd = CreateWindowEx (
           0,                   /* Extended possibilites for variation */
           szClassName,         /* Classname */
           "Arculator v0.09",   /* Title Text */
           WS_OVERLAPPEDWINDOW&~(WS_MAXIMIZEBOX|WS_SIZEBOX), /* default window */
           CW_USEDEFAULT,       /* Windows decides the position */
           CW_USEDEFAULT,       /* where the window ends up on the screen */
           640+(GetSystemMetrics(SM_CXFIXEDFRAME)*2),/* The programs width */
           512+(GetSystemMetrics(SM_CYFIXEDFRAME)*2)+GetSystemMetrics(SM_CYMENUSIZE)+GetSystemMetrics(SM_CYCAPTION)+1,/* and height in pixels */
           HWND_DESKTOP,        /* The window is a child-window to desktop */
           menu,                /* No menu */
           hThisInstance,       /* Program Instance handler */
           NULL                 /* No Window Creation data */
           );

        /* Make the window visible on the screen */
        ShowWindow (ghwnd, nFunsterStil);
        win_set_window(ghwnd);

        initvid();
        set_config_file("arc.cfg");
        p=get_config_string(NULL,"disc_name",NULL);
        if (!p) discchangeint(0);
        else
        {
                strcpy(discname,p);
                loaddisc(discname);
        }
        initmem();
        resetarm();
        loadrom();
        loadcmos();
        resetioc();
        install_keyboard();
        install_mouse();
        initkeyboard();
        install_timer();
        installins();

        p=get_config_string(NULL,"disc_hack",NULL);
        if (!p || strcmp(p,"1")) dischack=0;
        else                     dischack=1;
        p=get_config_string(NULL,"fast_vsync",NULL);
        if (!p || strcmp(p,"1")) fastvsync=0;
        else                     fastvsync=1;
        p=get_config_string(NULL,"limit_speed",NULL);
        if (!p || strcmp(p,"1")) limitspeed=0;
        else                     limitspeed=1;
        
        if (fastvsync)  CheckMenuItem(menu,IDM_OPTIONS_FAST,MF_CHECKED);
        if (dischack)   CheckMenuItem(menu,IDM_OPTIONS_HACK,MF_CHECKED);
        if (limitspeed) CheckMenuItem(menu,IDM_OPTIONS_LIMIT,MF_CHECKED);
        /* Run the message loop. It will run until GetMessage() returns 0 */
        while (!quited)
        {
                if (infocus && (!limitspeed || spdcount))
                {
                        set_mouse_range(0, 0, SCREEN_W-1, SCREEN_H-1);
                        if (!vsyncbreak)
                           execarm(99000);
                        vsyncbreak=0;
                        ioc.irqa|=8;
                        updateirqs();
                        updatekeys();
                        execarm(1000);
                        drawvid();
                        spdcount=0;
                }
                if (PeekMessage(&messages,NULL,0,0,PM_REMOVE))
                {
                        if (messages.message==WM_QUIT)
                           quited=1;
                        /* Translate virtual-key messages into character messages */
                        TranslateMessage(&messages);
                        /* Send message to WindowProcedure */
                        DispatchMessage(&messages);
                }
        }
        set_config_string(NULL,"disc_name",discname);
        sprintf(s,"%i",dischack);
        set_config_string(NULL,"disc_hack",s);
        sprintf(s,"%i",fastvsync);
        set_config_string(NULL,"fast_vsync",s);
        sprintf(s,"%i",limitspeed);
        set_config_string(NULL,"limit_speed",s);
        return 0;
}

void changedisc(HWND hwnd)
{
        char fn[512];
        char start[512];
        OPENFILENAME ofn;
        fn[0]=0;
        start[0]=0;
        ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hwnd;
	ofn.hInstance = NULL;
	ofn.lpstrFilter = "ADFS Disc Image\0*.adf\0All Files\0*.*\0";
	ofn.lpstrCustomFilter = NULL;
	ofn.nMaxCustFilter = 0;
	ofn.nFilterIndex = 1;
	ofn.lpstrFile = fn;
	ofn.nMaxFile = sizeof(fn);
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = start;
	ofn.lpstrTitle = NULL;
	ofn.Flags = OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY;
	ofn.nFileOffset = 0;
	ofn.nFileExtension = 0;
	ofn.lpstrDefExt = NULL;
	ofn.lCustData = 0;
	ofn.lpfnHook = NULL;
	ofn.lpTemplateName = NULL;
        if (GetOpenFileName(&ofn))
        {
                strcpy(discname,fn);
                loaddisc(fn);
                discchangeint(1);
        }
}

/*  This function is called by the Windows function DispatchMessage()  */
LRESULT CALLBACK WindowProcedure (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
        HMENU hmenu;
        switch (message)                  /* handle the messages */
        {
                case WM_COMMAND:
                hmenu=GetMenu(hwnd);
                switch (LOWORD(wParam))
                {
                        case IDM_DISC_CHANGE:
                        changedisc(ghwnd);
                        return 0;
                        case IDM_DISC_REMOVE:
                        discchangeint(0);
                        return 0;
                        case IDM_FILE_RESET:
                        resetarm();
                        return 0;
                        case IDM_FILE_EXIT:
                        PostQuitMessage(0);
                        return 0;
                        case IDM_OPTIONS_FAST:
                        fastvsync^=1;
                        if (fastvsync) CheckMenuItem(hmenu,IDM_OPTIONS_FAST,MF_CHECKED);
                        else           CheckMenuItem(hmenu,IDM_OPTIONS_FAST,MF_UNCHECKED);
                        return 0;
                        case IDM_OPTIONS_HACK:
                        dischack^=1;
                        if (dischack) CheckMenuItem(hmenu,IDM_OPTIONS_HACK,MF_CHECKED);
                        else          CheckMenuItem(hmenu,IDM_OPTIONS_HACK,MF_UNCHECKED);
                        return 0;
                        case IDM_OPTIONS_LIMIT:
                        limitspeed^=1;
                        if (limitspeed) CheckMenuItem(hmenu,IDM_OPTIONS_LIMIT,MF_CHECKED);
                        else            CheckMenuItem(hmenu,IDM_OPTIONS_LIMIT,MF_UNCHECKED);
                        return 0;
                }
                break;
                case WM_SETFOCUS:
                infocus=1;
                break;
                case WM_KILLFOCUS:
                infocus=0;
                break;
                case WM_DESTROY:
                PostQuitMessage (0);       /* send a WM_QUIT to the message queue */
                break;
                default:                      /* for messages that we don't deal with */
                return DefWindowProc (hwnd, message, wParam, lParam);
        }
        return 0;
}
