#include <allegro.h>
#include "arc.h"
#include "keytable.h"

int ledcaps,lednum,ledscr;
int mousedown[3]={0,0,0};
int mouseena=0;
int keystat=0xFF;
int keyrow,keycol;
unsigned char mousex,mousey;

int keyboardkeydown(int kr, int kc)
{
        if (!keystat)
        {
//                printf(" %i %i\n",kr,kc);
                keyrow=kr;
                keycol=kc;
                sendkey(0xC0|keyrow);
                keystat=1;
                return 1;
        }
        return 0;
}

int keyboardkeyup(int kr, int kc)
{
        if (!keystat)
        {
                keyrow=kr;
                keycol=kc;
                sendkey(0xD0|keyrow);
                keystat=2;
                return 1;
        }
        return 0;
}

void writekeyboard(unsigned char v)
{
//        printf("Keyboard write %02X %i\n",v,keystat);
        switch (keystat)
        {
                case 0: /*Normal*/
//                printf("Normal - write %02X\n",v);
                switch (v&0xF0)
                {
                        case 0x00: /*Keyboard LEDs*/
                        ledcaps=v&1;
                        lednum=v&2;
                        ledscr=v&4;
                        break;
                        case 0x20: /*Keyboard ID*/
                        sendkey(0x81);
                        break;
                        case 0x30: /*Enable mouse, disable keyboard*/
//                        case 0x30: /*Enable mouse and keyboard*/
                        if (v&2) mouseena=1;
                        break;
                        case 0xF0:
                        switch (v)
                        {
                                case 0xFF:  /*HRST*/
                                sendkey(0xFF); /*HRST*/
                                keystat=0xFF;
                                break;
                        }
                        break;
                }
                break;
                case 1: /*Second half of key down*/
//                printf("stat1 - write %02X\n",v);
                switch (v)
                {
                        case 0x3F: /*BACK*/
                        sendkey(0xC0|keycol);
                        keystat=0;
                        break;
                        case 0xFF: /*HRST*/
                        sendkey(0xFF); /*HRST*/
                        keystat=0xFF;
                        break;
                }
                break;
                case 2: /*Second half of key up*/
//                printf("stat2 - write %02X\n",v);
                switch (v)
                {
                        case 0x3F: /*BACK*/
                        sendkey(0xD0|keycol);
                        keystat=0;
                        break;
                        case 0xFF: /*HRST*/
                        sendkey(0xFF); /*HRST*/
                        keystat=0xFF;
                        break;
                }
                break;
                case 3: /*Second half of mouse*/
                switch (v)
                {
                        case 0x3F: /*BACK*/
                        sendkey(mousey);
                        keystat=0;
                        break;
                        case 0xFF: /*HRST*/
                        sendkey(0xFF); /*HRST*/
                        keystat=0xFF;
                        break;
                }
                break;

                case 0xFF: /*Reset sequence*/
//                printf("Reset sequence - write %02X\n",v);
                switch (v)
                {
                        case 0xFF: /*HRST*/
                        sendkey(0xFF); /*HRST*/
                        break;
                        case 0xFE: /*RAK1*/
                        sendkey(0xFE); /*RAK1*/
                        break;
                        case 0xFD: /*RAK2*/
                        sendkey(0xFD); /*RAK2*/
                        keystat=0;
                        break;
                }
                break;
        }
}

void initkeyboard()
{
        keystat=0xFF;
        sendkey(0xFF); /*HRST*/
}

int keydat[128];

void updatekeys()
{
        int mx,my;
        int c;
        unsigned char dx,dy;
        for (c=1;c<128;c++)
        {
                if (key[c]!=keydat[c])
                {
                        if (key[c])
                        {
//                                printf("Key pressed %i ",c-1);
                                if (keyboardkeydown(keytable[c-1][0],keytable[c-1][1]))
                                {
                                        keydat[c]=key[c];
                                        return;
                                }
                        }
                        else
                        {
                                if (keyboardkeyup(keytable[c-1][0],keytable[c-1][1]))
                                {
                                        keydat[c]=key[c];
                                        return;
                                }
                        }
                }
        }
        if ((mouse_b&1)!=mousedown[0]) /*Left button*/
        {
                if (mouse_b&1)
                {
                        if (keyboardkeydown(7,0))
                        {
                                mousedown[0]=1;
                                return;
                        }
                }
                else
                {
                        if (keyboardkeyup(7,0))
                        {
                                mousedown[0]=0;
                                return;
                        }
                }
        }
        if ((mouse_b&2)!=mousedown[1]) /*Right button*/
        {
                if (mouse_b&2)
                {
                        if (keyboardkeydown(7,2))
                        {
                                mousedown[1]=2;
                                return;
                        }
                }
                else
                {
                        if (keyboardkeyup(7,2))
                        {
                                mousedown[1]=0;
                                return;
                        }
                }
        }
        if ((mouse_b&4)!=mousedown[2]) /*Middle button*/
        {
                if (mouse_b&4)
                {
                        if (keyboardkeydown(7,1))
                        {
                                mousedown[2]=4;
                                return;
                        }
                }
                else
                {
                        if (keyboardkeyup(7,1))
                        {
                                mousedown[2]=0;
                                return;
                        }
                }
        }
//        printf("mouseena %i\n",mouseena);
        if (mouseena)
        {
                get_mouse_mickeys(&mx,&my);
                if (key[KEY_TILDE]) return;
                mx*=4;
                my*=4;
//                printf("Mouse %i %i  ",mx,my);
                if (!mx && !my) return;
                if (mx<0) dx=((-mx)>63)?63:-mx;
                else      dx=(mx>63)?63:mx;
                if (mx<0) dx=((dx^0x7F)+1)&0x7F;
                my=-my;
                if (my<0) dy=((-my)>63)?63:-my;
                else      dy=(my>63)?63:my;
                if (my<0) dy=((dy^0x7F)+1)&0x7F;
                mousex=dx;
                mousey=dy;
//                printf("%02X %02X\n",mousex,mousey);
                sendkey(mousex);
                keystat=3;
        }
}
